/*
 COPYRIGHT 2009 ESRI

 TRADE SECRETS: ESRI PROPRIETARY AND CONFIDENTIAL
 Unpublished material - all rights reserved under the
 Copyright Laws of the United States and applicable international
 laws, treaties, and conventions.

 For additional information, contact:
 Environmental Systems Research Institute, Inc.
 Attn: Contracts and Legal Services Department
 380 New York Street
 Redlands, California, 92373
 USA

 email: contracts@esri.com
 */
//>>built
define("esri/IdentityManagerBase",["dojo/_base/declare","dojo/_base/config","dojo/_base/lang","dojo/_base/array","dojo/_base/Deferred","dojo/_base/json","dojo/_base/url","dojo/has","dojo/cookie","esri/kernel","esri/config","esri/lang","esri/ServerInfo","esri/urlUtils","esri/deferredUtils","esri/request"],function(_1,_2,_3,_4,_5,_6,_7,_8,_9,_a,_b,_c,_d,_e,_f,_10){var _11={};var _12=function(_13,_14){var _15=new _7(_13).host,_16=new _7(_14.server).host,_17=/.+\.arcgis\.com$/i;return (_17.test(_15)&&_17.test(_16));};var _18;var _19=_1(null,{declaredClass:"esri.IdentityManagerBase",constructor:function(){this._portalConfig=_3.getObject("esriGeowConfig");this.serverInfos=[];this.credentials=[];this._soReqs=[];this._xoReqs=[];this._portals=[];},tokenValidity:60,signInPage:null,_busy:null,_gwTokenUrl:"/sharing/generateToken",_agsRest:"/rest/services",_agsAdmin:/https?:\/\/[^\/]+\/[^\/]+\/admin\/?(\/.*)?$/i,_agolSuffix:".arcgis.com",_gwDomains:[{regex:/https?:\/\/www\.arcgis\.com/i,tokenServiceUrl:"https://www.arcgis.com/sharing/generateToken"},{regex:/https?:\/\/dev\.arcgis\.com/i,tokenServiceUrl:"https://dev.arcgis.com/sharing/generateToken"},{regex:/https?:\/\/.*dev[^.]*\.arcgis\.com/i,tokenServiceUrl:"https://devext.arcgis.com/sharing/generateToken"},{regex:/https?:\/\/.*qa[^.]*\.arcgis\.com/i,tokenServiceUrl:"https://qaext.arcgis.com/sharing/generateToken"},{regex:/https?:\/\/.*.arcgis\.com/i,tokenServiceUrl:"https://www.arcgis.com/sharing/generateToken"}],_regexSDirUrl:/http.+\/rest\/services\/?/ig,_regexServerType:/(\/(MapServer|GeocodeServer|GPServer|GeometryServer|ImageServer|NAServer|FeatureServer|GeoDataServer|GlobeServer|MobileServer)).*/ig,_gwUser:/http.+\/users\/([^\/]+)\/?.*/i,_gwItem:/http.+\/items\/([^\/]+)\/?.*/i,_gwGroup:/http.+\/groups\/([^\/]+)\/?.*/i,_errorCodes:[499,498,403,401],_publicUrls:[/\/arcgis\/tokens/i,/\/sharing\/generatetoken/i,/\/rest\/info/i],registerServers:function(_1a){var _1b=this.serverInfos;if(_1b){_1a=_4.filter(_1a,function(_1c){return !this.findServerInfo(_1c.server);},this);this.serverInfos=_1b.concat(_1a);}else{this.serverInfos=_1a;}_4.forEach(_1a,function(_1d){if(_1d.owningSystemUrl){this._portals.push(_1d.owningSystemUrl);}},this);},registerToken:function(_1e){var _1f=this._sanitizeUrl(_1e.server),_20=this.findServerInfo(_1f),_21;if(!_20){_20=new _d();_20.server=this._getOrigin(_1f);_20.tokenServiceUrl=this._getTokenSvcUrl(_1f);this.registerServers([_20]);}_21=this.findCredential(_1f,_1e.userId);if(_21){_3.mixin(_21,_1e);}else{_21=new _18({userId:_1e.userId,server:_20.server,token:_1e.token,expires:_1e.expires,ssl:_1e.ssl});_21.resources=[_1f];this.credentials.push(_21);}_21.onTokenChange(false);},toJson:function(){return _c.fixJson({"serverInfos":_4.map(this.serverInfos,function(_22){return _22.toJson();}),"credentials":_4.map(this.credentials,function(crd){return crd.toJson();})});},initialize:function(_23){if(!_23){return;}if(_3.isString(_23)){_23=_6.fromJson(_23);}var _24=_23.serverInfos,_25=_23.credentials;if(_24){var _26=[];_4.forEach(_24,function(_27){if(_27.server&&_27.tokenServiceUrl){_26.push(_27.declaredClass?_27:new _d(_27));}});if(_26.length){this.registerServers(_26);}}if(_25){_4.forEach(_25,function(crd){if(crd.userId&&crd.server&&crd.token&&crd.expires&&(crd.expires>(new Date()).getTime())){crd=crd.declaredClass?crd:new _18(crd);crd.onTokenChange();this.credentials.push(crd);}},this);}},findServerInfo:function(_28){var _29;_28=this._sanitizeUrl(_28);_4.some(this.serverInfos,function(_2a){if(_e.hasSameOrigin(_2a.server,_28,true)){_29=_2a;}return !!_29;});return _29;},findCredential:function(_2b,_2c){var _2d;_2b=this._sanitizeUrl(_2b);if(_2c){_4.some(this.credentials,function(crd){if(_e.hasSameOrigin(_2b,crd.server,true)&&_2c===crd.userId){_2d=crd;}return !!_2d;},this);}else{_4.some(this.credentials,function(crd){if(_e.hasSameOrigin(_2b,crd.server,true)&&this._getIdenticalSvcIdx(_2b,crd)!==-1){_2d=crd;}return !!_2d;},this);}return _2d;},getCredential:function(_2e,_2f){var _30,_31;if(_c.isDefined(_2f)){if(_3.isObject(_2f)){_30=!!_2f.token;_31=_2f.error;}else{_30=_2f;}}_2e=this._sanitizeUrl(_2e);var dfd=new _5(_f._dfdCanceller),err,_32=this._isAdminResource(_2e),_33=(_30&&this._doPortalSignIn(_2e))?_9("esri_auth"):null;if(_33){_33=_6.fromJson(_33);err=new Error("You are currently signed in as: '"+_33.email+"'. You do not have access to this resource: "+_2e);err.code="IdentityManagerBase."+1;err.messageCode=_31?_31.messageCode:null;err.subcode=_31?_31.subcode:null;err.log=_2.isDebug;dfd.errback(err);return dfd;}var _34=this._findCredential(_2e,_2f);if(_34){dfd.callback(_34);return dfd;}var _35=this.findServerInfo(_2e);if(!_35){var _36=this._getTokenSvcUrl(_2e);if(!_36){err=new Error("Unknown resource - could not find token service endpoint.");err.code="IdentityManagerBase."+2;err.log=_2.isDebug;dfd.errback(err);return dfd;}_35=new _d();_35.server=this._getOrigin(_2e);if(_3.isString(_36)){_35.tokenServiceUrl=_36;}else{_35._restInfoDfd=_36;}this.registerServers([_35]);}return this._enqueue(_2e,_35,_2f,dfd,_32);},getResourceName:function(_37){if(this._isRESTService(_37)){return _37.replace(this._regexSDirUrl,"").replace(this._regexServerType,"")||"";}else{return (this._gwUser.test(_37)&&_37.replace(this._gwUser,"$1"))||(this._gwItem.test(_37)&&_37.replace(this._gwItem,"$1"))||(this._gwGroup.test(_37)&&_37.replace(this._gwGroup,"$1"))||"";}},generateToken:function(_38,_39,_3a){var _3b,_3c,_3d;if(_3a){_3b=_3a.isAdmin;_3c=_3a.serverUrl;_3d=_3a.token;}var _3e=_10({url:_3b?_38.adminTokenServiceUrl:_38.tokenServiceUrl,content:{request:"getToken",username:_39&&_39.username,password:_39&&_39.password,serverUrl:_3c,token:_3d,expiration:_a.id.tokenValidity,referer:(_3b||_38.tokenServiceUrl.toLowerCase().indexOf("/sharing/generatetoken")!==-1)?window.location.host:null,client:_3b?"referer":null,f:"json"},handleAs:"json"},{usePost:true,disableIdentityLookup:true,useProxy:this._useProxy(_38,_3a)});_3e.addCallback(function(_3f){if(!_3f||!_3f.token){var err=new Error("Unable to generate token");err.code="IdentityManagerBase."+3;err.log=_2.isDebug;return err;}var _40=_38.server;if(!_11[_40]){_11[_40]={};}if(_39){_11[_40][_39.username]=_39.password;}return _3f;});_3e.addErrback(function(_41){});return _3e;},isBusy:function(){return !!this._busy;},setRedirectionHandler:function(_42){this._redirectFunc=_42;},setProtocolErrorHandler:function(_43){this._protocolFunc=_43;},signIn:function(){},_findCredential:function(_44,_45){var idx=-1,_46,_47,_48,_49,_4a=_45&&_45.token,_4b=_45&&_45.resource,_4c=_4.filter(this.credentials,function(crd){return _e.hasSameOrigin(crd.server,_44,true);});_44=_4b||_44;if(_4c.length){if(_4c.length===1){_46=_4c[0];_49=this.findServerInfo(_46.server);_47=_49&&_49.owningSystemUrl;_48=_47&&!_12(_47,_49)&&this.findCredential(_47,_46.userId);idx=this._getIdenticalSvcIdx(_44,_46);if(_4a){if(idx!==-1){_46.resources.splice(idx,1);this._removeResource(_44,_48);}}else{if(idx===-1){_46.resources.push(_44);}this._addResource(_44,_48);return _46;}}else{var _4d,i;_4.some(_4c,function(crd){i=this._getIdenticalSvcIdx(_44,crd);if(i!==-1){_4d=crd;_49=this.findServerInfo(_4d.server);_47=_49&&_49.owningSystemUrl;_48=_47&&!_12(_47,_49)&&this.findCredential(_47,_4d.userId);idx=i;return true;}return false;},this);if(_4a){if(_4d){_4d.resources.splice(idx,1);this._removeResource(_44,_48);}}else{if(_4d){this._addResource(_44,_48);return _4d;}}}}},_addResource:function(_4e,_4f){if(_4f){if(this._getIdenticalSvcIdx(_4e,_4f)===-1){_4f.resources.push(_4e);}}},_removeResource:function(_50,_51){var idx=-1;if(_51){idx=this._getIdenticalSvcIdx(_50,_51);if(idx>-1){_51.resources.splice(idx,1);}}},_useProxy:function(_52,_53){return (_53&&_53.isAdmin)||(!this._isPortalDomain(_52.tokenServiceUrl)&&_52.currentVersion==10.1&&!_e.hasSameOrigin(_52.tokenServiceUrl,window.location.href));},_getOrigin:function(_54){var uri=new _7(_54);return uri.scheme+"://"+uri.host+(_c.isDefined(uri.port)?(":"+uri.port):"");},_sanitizeUrl:function(url){url=_3.trim(url);var _55=(_b.defaults.io.proxyUrl||"").toLowerCase(),_56=_55?url.toLowerCase().indexOf(_55+"?"):-1;if(_56!==-1){url=url.substring(_56+_55.length+1);}return _e.urlToObject(url).path;},_isRESTService:function(_57){return (_57.indexOf(this._agsRest)>-1);},_isAdminResource:function(_58){return this._agsAdmin.test(_58);},_isIdenticalService:function(_59,_5a){var _5b;if(this._isRESTService(_59)&&this._isRESTService(_5a)){var _5c=this._getSuffix(_59).toLowerCase(),_5d=this._getSuffix(_5a).toLowerCase();_5b=(_5c===_5d);if(!_5b){var _5e=/(.*)\/(MapServer|FeatureServer).*/ig;_5b=(_5c.replace(_5e,"$1")===_5d.replace(_5e,"$1"));}}else{if(this._isPortalDomain(_59)){_5b=true;}else{if(this._isAdminResource(_59)&&this._isAdminResource(_5a)){return true;}}}return _5b;},_isPortalDomain:function(_5f){_5f=_5f.toLowerCase();var _60=(new _7(_5f)).authority,_61=this._portalConfig,_62=(_60.indexOf(this._agolSuffix)!==-1);if(!_62&&_61){_62=_e.hasSameOrigin(_61.restBaseUrl,_5f,true);}if(!_62){if(!this._arcgisUrl){var _63=_3.getObject("esri.arcgis.utils.arcgisUrl");if(_63){this._arcgisUrl=(new _7(_63)).authority;}}if(this._arcgisUrl){_62=(this._arcgisUrl.toLowerCase()===_60);}}if(!_62){_62=_4.some(this._portals,function(_64){return _e.hasSameOrigin(_64,_5f,true);});}return _62;},_isIdProvider:function(_65,_66){var i=-1,j=-1;_4.forEach(this._gwDomains,function(_67,idx){if(i===-1&&_67.regex.test(_65)){i=idx;}if(j===-1&&_67.regex.test(_66)){j=idx;}});var _68=false;if(i>-1&&j>-1){if(i===0||i===4){if(j===0||j===4){_68=true;}}else{if(i===1){if(j===1||j===2){_68=true;}}else{if(i===2){if(j===2){_68=true;}}else{if(i===3){if(j===3){_68=true;}}}}}}if(!_68){var _69=this.findServerInfo(_66),_6a=_69&&_69.owningSystemUrl;if(_6a&&_12(_6a,_69)&&this._isPortalDomain(_6a)&&this._isIdProvider(_65,_6a)){_68=true;}}return _68;},_isPublic:function(_6b){_6b=this._sanitizeUrl(_6b);return _4.some(this._publicUrls,function(_6c){return _6c.test(_6b);});},_getIdenticalSvcIdx:function(_6d,_6e){var idx=-1;_4.some(_6e.resources,function(_6f,i){if(this._isIdenticalService(_6d,_6f)){idx=i;return true;}return false;},this);return idx;},_getSuffix:function(_70){return _70.replace(this._regexSDirUrl,"").replace(this._regexServerType,"$1");},_getTokenSvcUrl:function(_71){var _72,dfd,idx;if(this._isRESTService(_71)){idx=_71.toLowerCase().indexOf(this._agsRest);_72=_71.substring(0,idx)+"/admin/generateToken";_71=_71.substring(0,idx+"/rest/".length)+"info";if(this._isPortalDomain(_71)){_71=_71.replace(/http:/i,"https:");}dfd=_10({url:_71,content:{f:"json"},handleAs:"json",callbackParamName:"callback"});dfd.adminUrl_=_72;return dfd;}else{if(this._isPortalDomain(_71)){var url="";_4.some(this._gwDomains,function(_73){if(_73.regex.test(_71)){url=_73.tokenServiceUrl;}return !!url;});if(!url){_4.some(this._portals,function(_74){if(_e.hasSameOrigin(_74,_71,true)){url=_74+this._gwTokenUrl;}return !!url;},this);}if(!url){idx=_71.toLowerCase().indexOf("/sharing");if(idx!==-1){url=_71.substring(0,idx)+this._gwTokenUrl;}}if(!url){url=this._getOrigin(_71)+this._gwTokenUrl;}if(url){url=url.replace(/http:/i,"https:");}return url;}else{if(_71.toLowerCase().indexOf("premium.arcgisonline.com")!==-1){return "https://premium.arcgisonline.com/server/tokens";}else{if(this._isAdminResource(_71)){idx=_71.toLowerCase().indexOf("/admin/");_72=_71.substring(0,idx+"/admin/".length)+"generateToken";_71=_71.substring(0,idx)+"/rest/info";dfd=_10({url:_71,content:{f:"json"},handleAs:"json",callbackParamName:"callback"});dfd.adminUrl_=_72;return dfd;}}}}},_hasPortalSession:function(){return _9.isSupported()?!!_9("esri_auth"):false;},_doPortalSignIn:function(_75){if(_9.isSupported()){var _76=_9("esri_auth"),_77=this._portalConfig,_78=window.location.href,_79=this.findServerInfo(_75);if((_77||this._isPortalDomain(_78)||_76)&&(this._isPortalDomain(_75)||(_79&&_79.owningSystemUrl&&this._isPortalDomain(_79.owningSystemUrl)))&&(this._isIdProvider(_78,_75)||(_77&&(_e.hasSameOrigin(_77.restBaseUrl,_75,true)||this._isIdProvider(_77.restBaseUrl,_75)))||_e.hasSameOrigin(_78,_75,true))){return true;}}return false;},_checkProtocol:function(_7a,_7b,_7c){var _7d=true,_7e=_7b.tokenServiceUrl;if(_3.trim(_7e).toLowerCase().indexOf("https:")===0&&window.location.href.toLowerCase().indexOf("https:")!==0&&!_e.canUseXhr(_7e)&&!_e.canUseXhr(_e.getProxyUrl(true).path)){_7d=this._protocolFunc?!!this._protocolFunc({resourceUrl:_7a,serverInfo:_7b}):false;if(!_7d){var err=new Error("Aborted the Sign-In process to avoid sending password over insecure connection.");err.code="IdentityManagerBase."+4;err.log=_2.isDebug;console.log(err.message);_7c(err);}}return _7d;},_enqueue:function(_7f,_80,_81,dfd,_82){if(!dfd){dfd=new _5(_f._dfdCanceller);}dfd.resUrl_=_7f;dfd.sinfo_=_80;dfd.options_=_81;dfd.admin_=_82;if(this._busy){if(_e.hasSameOrigin(_7f,this._busy.resUrl_,true)){this._soReqs.push(dfd);}else{this._xoReqs.push(dfd);}}else{this._doSignIn(dfd);}return dfd;},_doSignIn:function(dfd){this._busy=dfd;var _83=this;var _84=function(_85){var _86=dfd.options_&&dfd.options_.resource;if(!_85.resources){_85.resources=[];}_85.resources.push(_86||dfd.resUrl_);_85.onTokenChange();if(_4.indexOf(_83.credentials,_85)===-1){_83.credentials.push(_85);}var _87=_83._soReqs,_88={};_83._soReqs=[];_4.forEach(_87,function(_89){if(!this._isIdenticalService(dfd.resUrl_,_89.resUrl_)){var _8a=this._getSuffix(_89.resUrl_);if(!_88[_8a]){_88[_8a]=true;_85.resources.push(_89.resUrl_);}}},_83);dfd.callback(_85);_4.forEach(_87,function(_8b){_8b.callback(_85);});_83._busy=dfd.resUrl_=dfd.sinfo_=null;if(_83._xoReqs.length){_83._doSignIn(_83._xoReqs.shift());}},_8c=function(_8d){dfd.errback(_8d);_83._busy=dfd.resUrl_=dfd.sinfo_=null;if(_83._soReqs.length){_83._doSignIn(_83._soReqs.shift());}if(_83._xoReqs.length){_83._doSignIn(_83._xoReqs.shift());}},_8e=function(){var _8f=dfd.sinfo_;if(_83._doPortalSignIn(dfd.resUrl_)){var _90=_9("esri_auth"),_91=_83._portalConfig;if(_90){_90=_6.fromJson(_90);_84(new _18({userId:_90.email,server:_8f.server,token:_90.token,expires:null}));return;}else{var _92="",_93=window.location.href;if(_83.signInPage){_92=_83.signInPage;}else{if(_91){_92=_91.baseUrl+_91.signin;}else{if(_83._isIdProvider(_93,dfd.resUrl_)){_92=_83._getOrigin(_93)+"/home/signin.html";}else{_92=_8f.server+"/home/signin.html";}}}_92=_92.replace(/http:/i,"https:");if(_91&&_91.useSSL===false){_92=_92.replace(/https:/i,"http:");}if(_93.toLowerCase().replace("https","http").indexOf(_92.toLowerCase().replace("https","http"))===0){var err=new Error("Cannot redirect to Sign-In page from within Sign-In page. URL of the resource that triggered this workflow: "+dfd.resUrl_);err.code="IdentityManagerBase."+5;err.log=_2.isDebug;_8c(err);}else{if(_83._redirectFunc){_83._redirectFunc({signInPage:_92,returnUrlParamName:"returnUrl",returnUrl:_93,resourceUrl:dfd.resUrl_,serverInfo:_8f});}else{window.location=_92+"?returnUrl="+window.escape(_93);}}return;}}else{if(_83._checkProtocol(dfd.resUrl_,_8f,_8c)){var _94=dfd.options_;if(dfd.admin_){_94=_94||{};_94.isAdmin=true;}dfd._pendingDfd=_83.signIn(dfd.resUrl_,_8f,_94).addCallbacks(_84,_8c);}}},_95=function(){var _96=dfd.sinfo_,_97=_96.owningSystemUrl,_98=dfd.options_,_99,_9a,_9b;if(_98){_99=_98.token;_9a=_98.error;}_9b=_83._findCredential(_97,{token:_99,resource:dfd.resUrl_});if(_9b){var _9c=_83.findCredential(dfd.resUrl_,_9b.userId);if(_9c){_84(_9c);return;}var _9d=(dfd._pendingDfd=_83.generateToken(_83.findServerInfo(_9b.server),null,{serverUrl:dfd.resUrl_,token:_9b.token}));_9d.addCallbacks(function(_9e){_84(new _18({userId:_9b.userId,server:_96.server,token:_9e.token,expires:_c.isDefined(_9e.expires)?Number(_9e.expires):null,ssl:!!_9e.ssl,isAdmin:dfd.admin_,validity:_96.shortLivedTokenValidity}));},_8c);}else{_83._busy=null;if(_99){dfd.options_.token=null;}var _9f=(dfd._pendingDfd=_83.getCredential(_97,{resource:dfd.resUrl_,token:_99,error:_9a}));_9f.addCallbacks(function(_a0){_83._enqueue(dfd.resUrl_,dfd.sinfo_,dfd.options_,dfd,dfd.admin_);},function(_a1){_8c(_a1);});}};var _a2=dfd.sinfo_.tokenServiceUrl,_a3=dfd.sinfo_.owningSystemUrl;if(_a2){if(_a3&&!_12(_a3,dfd.sinfo_)){_95();}else{_8e();}}else{dfd.sinfo_._restInfoDfd.addCallbacks(function(_a4){var _a5=dfd.sinfo_;_a5.adminTokenServiceUrl=_a5._restInfoDfd.adminUrl_;_a5._restInfoDfd=null;_a5.tokenServiceUrl=_3.getObject("authInfo.tokenServicesUrl",false,_a4)||_3.getObject("authInfo.tokenServiceUrl",false,_a4)||_3.getObject("tokenServiceUrl",false,_a4);_a5.shortLivedTokenValidity=_3.getObject("authInfo.shortLivedTokenValidity",false,_a4);_a5.currentVersion=_a4.currentVersion;_a5.owningTenant=_a4.owningTenant;var _a6=(_a5.owningSystemUrl=_a4.owningSystemUrl);if(_a6){_83._portals.push(_a6);if(_12(_a6,_a5)){var _a7=_83.findCredential(_a6);if(!_a7){_4.some(_83.credentials,function(_a8){if(this._isIdProvider(_a6,_a8.server)){_a7=_a8;}return !!_a7;},_83);}if(_a7){_a7=_a7.toJson();_a7.resources=null;_a7.server=_a5.server;_84(new _18(_a7));return;}_8e();}else{_95();}}else{_8e();}},function(){dfd.sinfo_._restInfoDfd=null;var err=new Error("Unknown resource - could not find token service endpoint.");err.code="IdentityManagerBase."+2;err.log=_2.isDebug;_8c(err);});}}});_18=_1(null,{declaredClass:"esri.Credential",tokenRefreshBuffer:2,constructor:function(_a9){_3.mixin(this,_a9);this.resources=this.resources||[];if(!_c.isDefined(this.creationTime)){this.creationTime=(new Date()).getTime();}},refreshToken:function(){var _aa=this,_ab=_a.id.findServerInfo(this.server),_ac=_ab&&_ab.owningSystemUrl,_ad=_ac&&!_12(_ac,_ab),_ae=this.resources&&this.resources[0],_af=_11[this.server],_b0=_af&&_af[this.userId];if(!_b0&&!_ad){var dfd;if(_ae){_ae=_a.id._sanitizeUrl(_ae);this._enqueued=1;dfd=_a.id._enqueue(_ae,_ab,null,null,this.isAdmin);dfd.addBoth(function(){_aa._enqueued=0;});}return dfd;}var _b1,_b2,_b3;if(_ad){_b2=_a.id.findServerInfo(_ac);_b3=_b2&&_a.id.findCredential(_b2.server,_aa.userId);if(!_b3){return;}_b1={serverUrl:_ae,token:_b3&&_b3.token};}else{if(_aa.isAdmin){_b1={isAdmin:true};}}return _a.id.generateToken(_ad?_b2:_ab,_ad?null:{username:_aa.userId,password:_b0},_b1).addCallback(function(_b4){_aa.token=_b4.token;_aa.expires=_c.isDefined(_b4.expires)?Number(_b4.expires):null;_aa.creationTime=(new Date()).getTime();_aa.onTokenChange();var _b5=_4.filter(_a.id.credentials,function(_b6){var _b7=_a.id.findServerInfo(_b6.server),_ac=_b7&&_b7.owningSystemUrl;return (_b6.userId===_aa.userId&&_ac&&!_12(_ac,_b7)&&_e.hasSameOrigin(_aa.server,_ac,true))?true:false;});_4.forEach(_b5,function(_b8){_b8.refreshToken();});}).addErrback(function(){});},onTokenChange:function(_b9){clearTimeout(this._refreshTimer);var _ba=this.server&&_a.id.findServerInfo(this.server),_bb=_ba&&_ba.owningSystemUrl;if((_b9!==false)&&(!_bb||_12(_bb,_ba))&&(_c.isDefined(this.expires)||_c.isDefined(this.validity))){this._startRefreshTimer();}},onDestroy:function(){},destroy:function(){this.userId=this.server=this.token=this.expires=this.validity=this.resources=this.creationTime=null;var _bc=_4.indexOf(_a.id.credentials,this);if(_bc>-1){_a.id.credentials.splice(_bc,1);}this.onTokenChange();this.onDestroy();},toJson:function(){return this._toJson();},_toJson:function(){var _bd=_c.fixJson({userId:this.userId,server:this.server,token:this.token,expires:this.expires,validity:this.validity,ssl:this.ssl,isAdmin:this.isAdmin,creationTime:this.creationTime});var _be=this.resources;if(_be&&_be.length>0){_bd.resources=_be;}return _bd;},_startRefreshTimer:function(){clearTimeout(this._refreshTimer);var _bf=this.tokenRefreshBuffer*60000,_c0=this.validity?(this.creationTime+(this.validity*60000)):this.expires,_c1=(_c0-(new Date()).getTime());if(_c1<0){_c1=0;}this._refreshTimer=setTimeout(_3.hitch(this,this.refreshToken),(_c1>_bf)?(_c1-_bf):_c1);}});_19.Credential=_18;if(_8("extend-esri")){_a.IdentityManagerBase=_19;_a.Credential=_18;}return _19;});