/*
	Copyright (c) 2004-2012, The Dojo Foundation All Rights Reserved.
	Available via Academic Free License >= 2.1 OR the modified BSD license.
	see: http://dojotoolkit.org/license for details
*/

/*
	This is an optimized version of Dojo, built for deployment and not for
	development. To get sources and documentation, please visit:

		http://dojotoolkit.org
*/

//>>built
require({cache:{"dojox/gfx/shape":function(){define(["./_base","dojo/_base/lang","dojo/_base/declare","dojo/_base/kernel","dojo/_base/sniff","dojo/_base/connect","dojo/_base/array","dojo/dom-construct","dojo/_base/Color","./matrix"],function(g,_1,_2,_3,_4,_5,_6,_7,_8,_9){var _a=g.shape={};var _b={};var _c={};_a.register=function(s){var t=s.declaredClass.split(".").pop();var i=t in _b?++_b[t]:((_b[t]=0));var _d=t+i;_c[_d]=s;return _d;};_a.byId=function(id){return _c[id];};_a.dispose=function(s,_e){if(_e&&s.children){for(var i=0;i<s.children.length;++i){_a.dispose(s.children[i],true);}}delete _c[s.getUID()];};_a.Shape=_2("dojox.gfx.shape.Shape",null,{constructor:function(){this.rawNode=null;this.shape=null;this.matrix=null;this.fillStyle=null;this.strokeStyle=null;this.bbox=null;this.parent=null;this.parentMatrix=null;var _f=_a.register(this);this.getUID=function(){return _f;};},destroy:function(){_a.dispose(this);},getNode:function(){return this.rawNode;},getShape:function(){return this.shape;},getTransform:function(){return this.matrix;},getFill:function(){return this.fillStyle;},getStroke:function(){return this.strokeStyle;},getParent:function(){return this.parent;},getBoundingBox:function(){return this.bbox;},getTransformedBoundingBox:function(){var b=this.getBoundingBox();if(!b){return null;}var m=this._getRealMatrix(),gm=_9;return [gm.multiplyPoint(m,b.x,b.y),gm.multiplyPoint(m,b.x+b.width,b.y),gm.multiplyPoint(m,b.x+b.width,b.y+b.height),gm.multiplyPoint(m,b.x,b.y+b.height)];},getEventSource:function(){return this.rawNode;},setClip:function(_10){this.clip=_10;},getClip:function(){return this.clip;},setShape:function(_11){this.shape=g.makeParameters(this.shape,_11);this.bbox=null;return this;},setFill:function(_12){if(!_12){this.fillStyle=null;return this;}var f=null;if(typeof (_12)=="object"&&"type" in _12){switch(_12.type){case "linear":f=g.makeParameters(g.defaultLinearGradient,_12);break;case "radial":f=g.makeParameters(g.defaultRadialGradient,_12);break;case "pattern":f=g.makeParameters(g.defaultPattern,_12);break;}}else{f=g.normalizeColor(_12);}this.fillStyle=f;return this;},setStroke:function(_13){if(!_13){this.strokeStyle=null;return this;}if(typeof _13=="string"||_1.isArray(_13)||_13 instanceof _8){_13={color:_13};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_13);s.color=g.normalizeColor(s.color);return this;},setTransform:function(_14){this.matrix=_9.clone(_14?_9.normalize(_14):_9.identity);return this._applyTransform();},_applyTransform:function(){return this;},moveToFront:function(){var p=this.getParent();if(p){p._moveChildToFront(this);this._moveToFront();}return this;},moveToBack:function(){var p=this.getParent();if(p){p._moveChildToBack(this);this._moveToBack();}return this;},_moveToFront:function(){},_moveToBack:function(){},applyRightTransform:function(_15){return _15?this.setTransform([this.matrix,_15]):this;},applyLeftTransform:function(_16){return _16?this.setTransform([_16,this.matrix]):this;},applyTransform:function(_17){return _17?this.setTransform([this.matrix,_17]):this;},removeShape:function(_18){if(this.parent){this.parent.remove(this,_18);}return this;},_setParent:function(_19,_1a){this.parent=_19;return this._updateParentMatrix(_1a);},_updateParentMatrix:function(_1b){this.parentMatrix=_1b?_9.clone(_1b):null;return this._applyTransform();},_getRealMatrix:function(){var m=this.matrix;var p=this.parent;while(p){if(p.matrix){m=_9.multiply(p.matrix,m);}p=p.parent;}return m;}});_a._eventsProcessing={connect:function(_1c,_1d,_1e){return _5.connect(this.getEventSource(),_1c,_a.fixCallback(this,g.fixTarget,_1d,_1e));},disconnect:function(_1f){_5.disconnect(_1f);}};_a.fixCallback=function(_20,_21,_22,_23){if(!_23){_23=_22;_22=null;}if(_1.isString(_23)){_22=_22||_3.global;if(!_22[_23]){throw (["dojox.gfx.shape.fixCallback: scope[\"",_23,"\"] is null (scope=\"",_22,"\")"].join(""));}return function(e){return _21(e,_20)?_22[_23].apply(_22,arguments||[]):undefined;};}return !_22?function(e){return _21(e,_20)?_23.apply(_22,arguments):undefined;}:function(e){return _21(e,_20)?_23.apply(_22,arguments||[]):undefined;};};_1.extend(_a.Shape,_a._eventsProcessing);_a.Container={_init:function(){this.children=[];},openBatch:function(){},closeBatch:function(){},add:function(_24){var _25=_24.getParent();if(_25){_25.remove(_24,true);}this.children.push(_24);return _24._setParent(this,this._getRealMatrix());},remove:function(_26,_27){for(var i=0;i<this.children.length;++i){if(this.children[i]==_26){if(_27){}else{_26.parent=null;_26.parentMatrix=null;}this.children.splice(i,1);break;}}return this;},clear:function(_28){var _29;for(var i=0;i<this.children.length;++i){_29=this.children[i];_29.parent=null;_29.parentMatrix=null;if(_28){_29.destroy();}}this.children=[];return this;},getBoundingBox:function(){if(this.children){var _2a=null;_6.forEach(this.children,function(_2b){var bb=_2b.getBoundingBox();if(bb){var ct=_2b.getTransform();if(ct){bb=_9.multiplyRectangle(ct,bb);}if(_2a){_2a.x=Math.min(_2a.x,bb.x);_2a.y=Math.min(_2a.y,bb.y);_2a.endX=Math.max(_2a.endX,bb.x+bb.width);_2a.endY=Math.max(_2a.endY,bb.y+bb.height);}else{_2a={x:bb.x,y:bb.y,endX:bb.x+bb.width,endY:bb.y+bb.height};}}});if(_2a){_2a.width=_2a.endX-_2a.x;_2a.height=_2a.endY-_2a.y;}return _2a;}return null;},_moveChildToFront:function(_2c){for(var i=0;i<this.children.length;++i){if(this.children[i]==_2c){this.children.splice(i,1);this.children.push(_2c);break;}}return this;},_moveChildToBack:function(_2d){for(var i=0;i<this.children.length;++i){if(this.children[i]==_2d){this.children.splice(i,1);this.children.unshift(_2d);break;}}return this;}};_a.Surface=_2("dojox.gfx.shape.Surface",null,{constructor:function(){this.rawNode=null;this._parent=null;this._nodes=[];this._events=[];},destroy:function(){_6.forEach(this._nodes,_7.destroy);this._nodes=[];_6.forEach(this._events,_5.disconnect);this._events=[];this.rawNode=null;if(_4("ie")){while(this._parent.lastChild){_7.destroy(this._parent.lastChild);}}else{this._parent.innerHTML="";}this._parent=null;},getEventSource:function(){return this.rawNode;},_getRealMatrix:function(){return null;},isLoaded:true,onLoad:function(_2e){},whenLoaded:function(_2f,_30){var f=_1.hitch(_2f,_30);if(this.isLoaded){f(this);}else{var h=_5.connect(this,"onLoad",function(_31){_5.disconnect(h);f(_31);});}}});_1.extend(_a.Surface,_a._eventsProcessing);_a.Rect=_2("dojox.gfx.shape.Rect",_a.Shape,{constructor:function(_32){this.shape=g.getDefault("Rect");this.rawNode=_32;},getBoundingBox:function(){return this.shape;}});_a.Ellipse=_2("dojox.gfx.shape.Ellipse",_a.Shape,{constructor:function(_33){this.shape=g.getDefault("Ellipse");this.rawNode=_33;},getBoundingBox:function(){if(!this.bbox){var _34=this.shape;this.bbox={x:_34.cx-_34.rx,y:_34.cy-_34.ry,width:2*_34.rx,height:2*_34.ry};}return this.bbox;}});_a.Circle=_2("dojox.gfx.shape.Circle",_a.Shape,{constructor:function(_35){this.shape=g.getDefault("Circle");this.rawNode=_35;},getBoundingBox:function(){if(!this.bbox){var _36=this.shape;this.bbox={x:_36.cx-_36.r,y:_36.cy-_36.r,width:2*_36.r,height:2*_36.r};}return this.bbox;}});_a.Line=_2("dojox.gfx.shape.Line",_a.Shape,{constructor:function(_37){this.shape=g.getDefault("Line");this.rawNode=_37;},getBoundingBox:function(){if(!this.bbox){var _38=this.shape;this.bbox={x:Math.min(_38.x1,_38.x2),y:Math.min(_38.y1,_38.y2),width:Math.abs(_38.x2-_38.x1),height:Math.abs(_38.y2-_38.y1)};}return this.bbox;}});_a.Polyline=_2("dojox.gfx.shape.Polyline",_a.Shape,{constructor:function(_39){this.shape=g.getDefault("Polyline");this.rawNode=_39;},setShape:function(_3a,_3b){if(_3a&&_3a instanceof Array){this.inherited(arguments,[{points:_3a}]);if(_3b&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.inherited(arguments,[_3a]);}return this;},_normalizePoints:function(){var p=this.shape.points,l=p&&p.length;if(l&&typeof p[0]=="number"){var _3c=[];for(var i=0;i<l;i+=2){_3c.push({x:p[i],y:p[i+1]});}this.shape.points=_3c;}},getBoundingBox:function(){if(!this.bbox&&this.shape.points.length){var p=this.shape.points;var l=p.length;var t=p[0];var _3d={l:t.x,t:t.y,r:t.x,b:t.y};for(var i=1;i<l;++i){t=p[i];if(_3d.l>t.x){_3d.l=t.x;}if(_3d.r<t.x){_3d.r=t.x;}if(_3d.t>t.y){_3d.t=t.y;}if(_3d.b<t.y){_3d.b=t.y;}}this.bbox={x:_3d.l,y:_3d.t,width:_3d.r-_3d.l,height:_3d.b-_3d.t};}return this.bbox;}});_a.Image=_2("dojox.gfx.shape.Image",_a.Shape,{constructor:function(_3e){this.shape=g.getDefault("Image");this.rawNode=_3e;},getBoundingBox:function(){return this.shape;},setStroke:function(){return this;},setFill:function(){return this;}});_a.Text=_2(_a.Shape,{constructor:function(_3f){this.fontStyle=null;this.shape=g.getDefault("Text");this.rawNode=_3f;},getFont:function(){return this.fontStyle;},setFont:function(_40){this.fontStyle=typeof _40=="string"?g.splitFontString(_40):g.makeParameters(g.defaultFont,_40);this._setFont();return this;}});_a.Creator={createShape:function(_41){switch(_41.type){case g.defaultPath.type:return this.createPath(_41);case g.defaultRect.type:return this.createRect(_41);case g.defaultCircle.type:return this.createCircle(_41);case g.defaultEllipse.type:return this.createEllipse(_41);case g.defaultLine.type:return this.createLine(_41);case g.defaultPolyline.type:return this.createPolyline(_41);case g.defaultImage.type:return this.createImage(_41);case g.defaultText.type:return this.createText(_41);case g.defaultTextPath.type:return this.createTextPath(_41);}return null;},createGroup:function(){return this.createObject(g.Group);},createRect:function(_42){return this.createObject(g.Rect,_42);},createEllipse:function(_43){return this.createObject(g.Ellipse,_43);},createCircle:function(_44){return this.createObject(g.Circle,_44);},createLine:function(_45){return this.createObject(g.Line,_45);},createPolyline:function(_46){return this.createObject(g.Polyline,_46);},createImage:function(_47){return this.createObject(g.Image,_47);},createText:function(_48){return this.createObject(g.Text,_48);},createPath:function(_49){return this.createObject(g.Path,_49);},createTextPath:function(_4a){return this.createObject(g.TextPath,{}).setText(_4a);},createObject:function(_4b,_4c){return null;}};return _a;});},"dojox/gfx/arc":function(){define(["./_base","dojo/_base/lang","./matrix"],function(g,_4d,m){var _4e=2*Math.PI,pi4=Math.PI/4,pi8=Math.PI/8,_4f=pi4+pi8,_50=_51(pi8);function _51(_52){var _53=Math.cos(_52),_54=Math.sin(_52),p2={x:_53+(4/3)*(1-_53),y:_54-(4/3)*_53*(1-_53)/_54};return {s:{x:_53,y:-_54},c1:{x:p2.x,y:-p2.y},c2:p2,e:{x:_53,y:_54}};};var arc=g.arc={unitArcAsBezier:_51,curvePI4:_50,arcAsBezier:function(_55,rx,ry,_56,_57,_58,x,y){_57=Boolean(_57);_58=Boolean(_58);var _59=m._degToRad(_56),rx2=rx*rx,ry2=ry*ry,pa=m.multiplyPoint(m.rotate(-_59),{x:(_55.x-x)/2,y:(_55.y-y)/2}),_5a=pa.x*pa.x,_5b=pa.y*pa.y,c1=Math.sqrt((rx2*ry2-rx2*_5b-ry2*_5a)/(rx2*_5b+ry2*_5a));if(isNaN(c1)){c1=0;}var ca={x:c1*rx*pa.y/ry,y:-c1*ry*pa.x/rx};if(_57==_58){ca={x:-ca.x,y:-ca.y};}var c=m.multiplyPoint([m.translate((_55.x+x)/2,(_55.y+y)/2),m.rotate(_59)],ca);var _5c=m.normalize([m.translate(c.x,c.y),m.rotate(_59),m.scale(rx,ry)]);var _5d=m.invert(_5c),sp=m.multiplyPoint(_5d,_55),ep=m.multiplyPoint(_5d,x,y),_5e=Math.atan2(sp.y,sp.x),_5f=Math.atan2(ep.y,ep.x),_60=_5e-_5f;if(_58){_60=-_60;}if(_60<0){_60+=_4e;}else{if(_60>_4e){_60-=_4e;}}var _61=pi8,_62=_50,_63=_58?_61:-_61,_64=[];for(var _65=_60;_65>0;_65-=pi4){if(_65<_4f){_61=_65/2;_62=_51(_61);_63=_58?_61:-_61;_65=0;}var c2,e,M=m.normalize([_5c,m.rotate(_5e+_63)]);if(_58){c1=m.multiplyPoint(M,_62.c1);c2=m.multiplyPoint(M,_62.c2);e=m.multiplyPoint(M,_62.e);}else{c1=m.multiplyPoint(M,_62.c2);c2=m.multiplyPoint(M,_62.c1);e=m.multiplyPoint(M,_62.s);}_64.push([c1.x,c1.y,c2.x,c2.y,e.x,e.y]);_5e+=2*_63;}return _64;}};return arc;});},"dojox/gfx/gradient":function(){define(["dojo/_base/lang","./matrix","dojo/_base/Color"],function(_66,m,_67){var _68=_66.getObject("dojox.gfx.gradient",true);var C=_67;_68.rescale=function(_69,_6a,to){var len=_69.length,_6b=(to<_6a),_6c;if(_6b){var tmp=_6a;_6a=to;to=tmp;}if(!len){return [];}if(to<=_69[0].offset){_6c=[{offset:0,color:_69[0].color},{offset:1,color:_69[0].color}];}else{if(_6a>=_69[len-1].offset){_6c=[{offset:0,color:_69[len-1].color},{offset:1,color:_69[len-1].color}];}else{var _6d=to-_6a,_6e,_6f,i;_6c=[];if(_6a<0){_6c.push({offset:0,color:new C(_69[0].color)});}for(i=0;i<len;++i){_6e=_69[i];if(_6e.offset>=_6a){break;}}if(i){_6f=_69[i-1];_6c.push({offset:0,color:_67.blendColors(new C(_6f.color),new C(_6e.color),(_6a-_6f.offset)/(_6e.offset-_6f.offset))});}else{_6c.push({offset:0,color:new C(_6e.color)});}for(;i<len;++i){_6e=_69[i];if(_6e.offset>=to){break;}_6c.push({offset:(_6e.offset-_6a)/_6d,color:new C(_6e.color)});}if(i<len){_6f=_69[i-1];_6c.push({offset:1,color:_67.blendColors(new C(_6f.color),new C(_6e.color),(to-_6f.offset)/(_6e.offset-_6f.offset))});}else{_6c.push({offset:1,color:new C(_69[len-1].color)});}}}if(_6b){_6c.reverse();for(i=0,len=_6c.length;i<len;++i){_6e=_6c[i];_6e.offset=1-_6e.offset;}}return _6c;};function _70(x,y,_71,_72,_73,_74){var r=m.multiplyPoint(_71,x,y),p=m.multiplyPoint(_72,r);return {r:r,p:p,o:m.multiplyPoint(_73,p).x/_74};};function _75(a,b){return a.o-b.o;};_68.project=function(_76,_77,tl,rb,ttl,trb){_76=_76||m.identity;var f1=m.multiplyPoint(_76,_77.x1,_77.y1),f2=m.multiplyPoint(_76,_77.x2,_77.y2),_78=Math.atan2(f2.y-f1.y,f2.x-f1.x),_79=m.project(f2.x-f1.x,f2.y-f1.y),pf1=m.multiplyPoint(_79,f1),pf2=m.multiplyPoint(_79,f2),_7a=new m.Matrix2D([m.rotate(-_78),{dx:-pf1.x,dy:-pf1.y}]),_7b=m.multiplyPoint(_7a,pf2).x,_7c=[_70(tl.x,tl.y,_76,_79,_7a,_7b),_70(rb.x,rb.y,_76,_79,_7a,_7b),_70(tl.x,rb.y,_76,_79,_7a,_7b),_70(rb.x,tl.y,_76,_79,_7a,_7b)].sort(_75),_7d=_7c[0].o,to=_7c[3].o,_7e=_68.rescale(_77.colors,_7d,to),_7f=Math.atan2(_7c[3].r.y-_7c[0].r.y,_7c[3].r.x-_7c[0].r.x);return {type:"linear",x1:_7c[0].p.x,y1:_7c[0].p.y,x2:_7c[3].p.x,y2:_7c[3].p.y,colors:_7e,angle:_78};};return _68;});},"dojox/gfx/path":function(){define("dojox/gfx/path",["./_base","dojo/_base/lang","dojo/_base/declare","./matrix","./shape"],function(g,_80,_81,_82,_83){var _84=_81("dojox.gfx.path.Path",_83.Shape,{constructor:function(_85){this.shape=_80.clone(g.defaultPath);this.segments=[];this.tbbox=null;this.absolute=true;this.last={};this.rawNode=_85;this.segmented=false;},setAbsoluteMode:function(_86){this._confirmSegmented();this.absolute=typeof _86=="string"?(_86=="absolute"):_86;return this;},getAbsoluteMode:function(){this._confirmSegmented();return this.absolute;},getBoundingBox:function(){this._confirmSegmented();return (this.bbox&&("l" in this.bbox))?{x:this.bbox.l,y:this.bbox.t,width:this.bbox.r-this.bbox.l,height:this.bbox.b-this.bbox.t}:null;},_getRealBBox:function(){this._confirmSegmented();if(this.tbbox){return this.tbbox;}var _87=this.bbox,_82=this._getRealMatrix();this.bbox=null;for(var i=0,len=this.segments.length;i<len;++i){this._updateWithSegment(this.segments[i],_82);}var t=this.bbox;this.bbox=_87;this.tbbox=t?[{x:t.l,y:t.t},{x:t.r,y:t.t},{x:t.r,y:t.b},{x:t.l,y:t.b}]:null;return this.tbbox;},getLastPosition:function(){this._confirmSegmented();return "x" in this.last?this.last:null;},_applyTransform:function(){this.tbbox=null;return this.inherited(arguments);},_updateBBox:function(x,y,m){if(m){var t=_82.multiplyPoint(m,x,y);x=t.x;y=t.y;}if(this.bbox&&("l" in this.bbox)){if(this.bbox.l>x){this.bbox.l=x;}if(this.bbox.r<x){this.bbox.r=x;}if(this.bbox.t>y){this.bbox.t=y;}if(this.bbox.b<y){this.bbox.b=y;}}else{this.bbox={l:x,b:y,r:x,t:y};}},_updateWithSegment:function(_88,_89){var n=_88.args,l=n.length,i;switch(_88.action){case "M":case "L":case "C":case "S":case "Q":case "T":for(i=0;i<l;i+=2){this._updateBBox(n[i],n[i+1],_89);}this.last.x=n[l-2];this.last.y=n[l-1];this.absolute=true;break;case "H":for(i=0;i<l;++i){this._updateBBox(n[i],this.last.y,_89);}this.last.x=n[l-1];this.absolute=true;break;case "V":for(i=0;i<l;++i){this._updateBBox(this.last.x,n[i],_89);}this.last.y=n[l-1];this.absolute=true;break;case "m":var _8a=0;if(!("x" in this.last)){this._updateBBox(this.last.x=n[0],this.last.y=n[1],_89);_8a=2;}for(i=_8a;i<l;i+=2){this._updateBBox(this.last.x+=n[i],this.last.y+=n[i+1],_89);}this.absolute=false;break;case "l":case "t":for(i=0;i<l;i+=2){this._updateBBox(this.last.x+=n[i],this.last.y+=n[i+1],_89);}this.absolute=false;break;case "h":for(i=0;i<l;++i){this._updateBBox(this.last.x+=n[i],this.last.y,_89);}this.absolute=false;break;case "v":for(i=0;i<l;++i){this._updateBBox(this.last.x,this.last.y+=n[i],_89);}this.absolute=false;break;case "c":for(i=0;i<l;i+=6){this._updateBBox(this.last.x+n[i],this.last.y+n[i+1],_89);this._updateBBox(this.last.x+n[i+2],this.last.y+n[i+3],_89);this._updateBBox(this.last.x+=n[i+4],this.last.y+=n[i+5],_89);}this.absolute=false;break;case "s":case "q":for(i=0;i<l;i+=4){this._updateBBox(this.last.x+n[i],this.last.y+n[i+1],_89);this._updateBBox(this.last.x+=n[i+2],this.last.y+=n[i+3],_89);}this.absolute=false;break;case "A":for(i=0;i<l;i+=7){this._updateBBox(n[i+5],n[i+6],_89);}this.last.x=n[l-2];this.last.y=n[l-1];this.absolute=true;break;case "a":for(i=0;i<l;i+=7){this._updateBBox(this.last.x+=n[i+5],this.last.y+=n[i+6],_89);}this.absolute=false;break;}var _8b=[_88.action];for(i=0;i<l;++i){_8b.push(g.formatNumber(n[i],true));}if(typeof this.shape.path=="string"){this.shape.path+=_8b.join("");}else{Array.prototype.push.apply(this.shape.path,_8b);}},_validSegments:{m:2,l:2,h:1,v:1,c:6,s:4,q:4,t:2,a:7,z:0},_pushSegment:function(_8c,_8d){this.tbbox=null;var _8e=this._validSegments[_8c.toLowerCase()],_8f;if(typeof _8e=="number"){if(_8e){if(_8d.length>=_8e){_8f={action:_8c,args:_8d.slice(0,_8d.length-_8d.length%_8e)};this.segments.push(_8f);this._updateWithSegment(_8f);}}else{_8f={action:_8c,args:[]};this.segments.push(_8f);this._updateWithSegment(_8f);}}},_collectArgs:function(_90,_91){for(var i=0;i<_91.length;++i){var t=_91[i];if(typeof t=="boolean"){_90.push(t?1:0);}else{if(typeof t=="number"){_90.push(t);}else{if(t instanceof Array){this._collectArgs(_90,t);}else{if("x" in t&&"y" in t){_90.push(t.x,t.y);}}}}}},moveTo:function(){this._confirmSegmented();var _92=[];this._collectArgs(_92,arguments);this._pushSegment(this.absolute?"M":"m",_92);return this;},lineTo:function(){this._confirmSegmented();var _93=[];this._collectArgs(_93,arguments);this._pushSegment(this.absolute?"L":"l",_93);return this;},hLineTo:function(){this._confirmSegmented();var _94=[];this._collectArgs(_94,arguments);this._pushSegment(this.absolute?"H":"h",_94);return this;},vLineTo:function(){this._confirmSegmented();var _95=[];this._collectArgs(_95,arguments);this._pushSegment(this.absolute?"V":"v",_95);return this;},curveTo:function(){this._confirmSegmented();var _96=[];this._collectArgs(_96,arguments);this._pushSegment(this.absolute?"C":"c",_96);return this;},smoothCurveTo:function(){this._confirmSegmented();var _97=[];this._collectArgs(_97,arguments);this._pushSegment(this.absolute?"S":"s",_97);return this;},qCurveTo:function(){this._confirmSegmented();var _98=[];this._collectArgs(_98,arguments);this._pushSegment(this.absolute?"Q":"q",_98);return this;},qSmoothCurveTo:function(){this._confirmSegmented();var _99=[];this._collectArgs(_99,arguments);this._pushSegment(this.absolute?"T":"t",_99);return this;},arcTo:function(){this._confirmSegmented();var _9a=[];this._collectArgs(_9a,arguments);this._pushSegment(this.absolute?"A":"a",_9a);return this;},closePath:function(){this._confirmSegmented();this._pushSegment("Z",[]);return this;},_confirmSegmented:function(){if(!this.segmented){var _9b=this.shape.path;this.shape.path=[];this._setPath(_9b);this.shape.path=this.shape.path.join("");this.segmented=true;}},_setPath:function(_9c){var p=_80.isArray(_9c)?_9c:_9c.match(g.pathSvgRegExp);this.segments=[];this.absolute=true;this.bbox={};this.last={};if(!p){return;}var _9d="",_9e=[],l=p.length;for(var i=0;i<l;++i){var t=p[i],x=parseFloat(t);if(isNaN(x)){if(_9d){this._pushSegment(_9d,_9e);}_9e=[];_9d=t;}else{_9e.push(x);}}this._pushSegment(_9d,_9e);},setShape:function(_9f){this.inherited(arguments,[typeof _9f=="string"?{path:_9f}:_9f]);this.segmented=false;this.segments=[];if(!g.lazyPathSegmentation){this._confirmSegmented();}return this;},_2PI:Math.PI*2});var _a0=_81("dojox.gfx.path.TextPath",_84,{constructor:function(_a1){if(!("text" in this)){this.text=_80.clone(g.defaultTextPath);}if(!("fontStyle" in this)){this.fontStyle=_80.clone(g.defaultFont);}},getText:function(){return this.text;},setText:function(_a2){this.text=g.makeParameters(this.text,typeof _a2=="string"?{text:_a2}:_a2);this._setText();return this;},getFont:function(){return this.fontStyle;},setFont:function(_a3){this.fontStyle=typeof _a3=="string"?g.splitFontString(_a3):g.makeParameters(g.defaultFont,_a3);this._setFont();return this;}});return g.path={Path:_84,TextPath:_a0};});},"*noref":1}});define("dojox/gfx/vml",["dojo/_base/lang","dojo/_base/declare","dojo/_base/array","dojo/_base/Color","dojo/_base/sniff","dojo/_base/config","dojo/dom","dojo/dom-geometry","dojo/dom-style","dojo/_base/kernel","./_base","./shape","./path","./arc","./gradient","./matrix"],function(_a4,_a5,arr,_a6,has,_a7,dom,_a8,_a9,_aa,g,gs,_ab,_ac,_ad,m){var vml=g.vml={};var _ae=function(){vml.xmlns="urn:schemas-microsoft-com:vml";try{document.namespaces.add("v",vml.xmlns);var _af=["*","group","roundrect","oval","shape","rect","imagedata","path","textpath","text"],i=0,l=1,s=document.createStyleSheet();if(has("ie")>=8){i=1;l=_af.length;}for(;i<l;++i){s.addRule("v\\:"+_af[i],"behavior:url(#default#VML); display:inline-block");}}catch(e){setTimeout(_ae,10);}};_ae();vml.text_alignment={start:"left",middle:"center",end:"right"};vml._parseFloat=function(str){return str.match(/^\d+f$/i)?parseInt(str)/65536:parseFloat(str);};vml._bool={"t":1,"true":1};vml._reparentEvents=function(dst,src){for(var _b0 in src){if(_b0.substr(0,2).toLowerCase()=="on"){dst[_b0]=src[_b0];src[_b0]=null;}}};vml.Shape=_a5("dojox.gfx.vml.Shape",gs.Shape,{destroy:function(){this.rawNode=null;gs.Shape.prototype.destroy.apply(this,arguments);},setFill:function(_b1){if(!_b1){this.fillStyle=null;this.rawNode.filled="f";return this;}var i,f,fo,a,s;if(typeof _b1=="object"&&"type" in _b1){switch(_b1.type){case "linear":var _b2=this._getRealMatrix(),_b3=this.getBoundingBox(),_b4=this._getRealBBox?this._getRealBBox():this.getTransformedBoundingBox();s=[];if(this.fillStyle!==_b1){this.fillStyle=g.makeParameters(g.defaultLinearGradient,_b1);}f=g.gradient.project(_b2,this.fillStyle,{x:_b3.x,y:_b3.y},{x:_b3.x+_b3.width,y:_b3.y+_b3.height},_b4[0],_b4[2]);a=f.colors;if(a[0].offset.toFixed(5)!="0.00000"){s.push("0 "+g.normalizeColor(a[0].color).toHex());}for(i=0;i<a.length;++i){s.push(a[i].offset.toFixed(5)+" "+g.normalizeColor(a[i].color).toHex());}i=a.length-1;if(a[i].offset.toFixed(5)!="1.00000"){s.push("1 "+g.normalizeColor(a[i].color).toHex());}fo=this.rawNode.fill;fo.colors.value=s.join(";");fo.method="sigma";fo.type="gradient";fo.angle=(270-m._radToDeg(f.angle))%360;fo.on=true;break;case "radial":f=g.makeParameters(g.defaultRadialGradient,_b1);this.fillStyle=f;var l=parseFloat(this.rawNode.style.left),t=parseFloat(this.rawNode.style.top),w=parseFloat(this.rawNode.style.width),h=parseFloat(this.rawNode.style.height),c=isNaN(w)?1:2*f.r/w;a=[];if(f.colors[0].offset>0){a.push({offset:1,color:g.normalizeColor(f.colors[0].color)});}arr.forEach(f.colors,function(v,i){a.push({offset:1-v.offset*c,color:g.normalizeColor(v.color)});});i=a.length-1;while(i>=0&&a[i].offset<0){--i;}if(i<a.length-1){var q=a[i],p=a[i+1];p.color=_a6.blendColors(q.color,p.color,q.offset/(q.offset-p.offset));p.offset=0;while(a.length-i>2){a.pop();}}i=a.length-1,s=[];if(a[i].offset>0){s.push("0 "+a[i].color.toHex());}for(;i>=0;--i){s.push(a[i].offset.toFixed(5)+" "+a[i].color.toHex());}fo=this.rawNode.fill;fo.colors.value=s.join(";");fo.method="sigma";fo.type="gradientradial";if(isNaN(w)||isNaN(h)||isNaN(l)||isNaN(t)){fo.focusposition="0.5 0.5";}else{fo.focusposition=((f.cx-l)/w).toFixed(5)+" "+((f.cy-t)/h).toFixed(5);}fo.focussize="0 0";fo.on=true;break;case "pattern":f=g.makeParameters(g.defaultPattern,_b1);this.fillStyle=f;fo=this.rawNode.fill;fo.type="tile";fo.src=f.src;if(f.width&&f.height){fo.size.x=g.px2pt(f.width);fo.size.y=g.px2pt(f.height);}fo.alignShape="f";fo.position.x=0;fo.position.y=0;fo.origin.x=f.width?f.x/f.width:0;fo.origin.y=f.height?f.y/f.height:0;fo.on=true;break;}this.rawNode.fill.opacity=1;return this;}this.fillStyle=g.normalizeColor(_b1);fo=this.rawNode.fill;if(!fo){fo=this.rawNode.ownerDocument.createElement("v:fill");}fo.method="any";fo.type="solid";fo.opacity=this.fillStyle.a;var _b5=this.rawNode.filters["DXImageTransform.Microsoft.Alpha"];if(_b5){_b5.opacity=Math.round(this.fillStyle.a*100);}this.rawNode.fillcolor=this.fillStyle.toHex();this.rawNode.filled=true;return this;},setStroke:function(_b6){if(!_b6){this.strokeStyle=null;this.rawNode.stroked="f";return this;}if(typeof _b6=="string"||_a4.isArray(_b6)||_b6 instanceof _a6){_b6={color:_b6};}var s=this.strokeStyle=g.makeParameters(g.defaultStroke,_b6);s.color=g.normalizeColor(s.color);var rn=this.rawNode;rn.stroked=true;rn.strokecolor=s.color.toCss();rn.strokeweight=s.width+"px";if(rn.stroke){rn.stroke.opacity=s.color.a;rn.stroke.endcap=this._translate(this._capMap,s.cap);if(typeof s.join=="number"){rn.stroke.joinstyle="miter";rn.stroke.miterlimit=s.join;}else{rn.stroke.joinstyle=s.join;}rn.stroke.dashstyle=s.style=="none"?"Solid":s.style;}return this;},_capMap:{butt:"flat"},_capMapReversed:{flat:"butt"},_translate:function(_b7,_b8){return (_b8 in _b7)?_b7[_b8]:_b8;},_applyTransform:function(){var _b9=this._getRealMatrix();if(_b9){var _ba=this.rawNode.skew;if(typeof _ba=="undefined"){for(var i=0;i<this.rawNode.childNodes.length;++i){if(this.rawNode.childNodes[i].tagName=="skew"){_ba=this.rawNode.childNodes[i];break;}}}if(_ba){_ba.on="f";var mt=_b9.xx.toFixed(8)+" "+_b9.xy.toFixed(8)+" "+_b9.yx.toFixed(8)+" "+_b9.yy.toFixed(8)+" 0 0",_bb=Math.floor(_b9.dx).toFixed()+"px "+Math.floor(_b9.dy).toFixed()+"px",s=this.rawNode.style,l=parseFloat(s.left),t=parseFloat(s.top),w=parseFloat(s.width),h=parseFloat(s.height);if(isNaN(l)){l=0;}if(isNaN(t)){t=0;}if(isNaN(w)||!w){w=1;}if(isNaN(h)||!h){h=1;}var _bc=(-l/w-0.5).toFixed(8)+" "+(-t/h-0.5).toFixed(8);_ba.matrix=mt;_ba.origin=_bc;_ba.offset=_bb;_ba.on=true;}}if(this.fillStyle&&this.fillStyle.type=="linear"){this.setFill(this.fillStyle);}if(this.clip){this.setClip(this.clip);}return this;},_setDimensions:function(_bd,_be){return this;},setRawNode:function(_bf){_bf.stroked="f";_bf.filled="f";this.rawNode=_bf;this.rawNode.__gfxObject__=this.getUID();},_moveToFront:function(){this.rawNode.parentNode.appendChild(this.rawNode);return this;},_moveToBack:function(){var r=this.rawNode,p=r.parentNode,n=p.firstChild;p.insertBefore(r,n);if(n.tagName=="rect"){n.swapNode(r);}return this;},_getRealMatrix:function(){return this.parentMatrix?new m.Matrix2D([this.parentMatrix,this.matrix]):this.matrix;},setClip:function(_c0){this.inherited(arguments);var _c1=this.rawNode.style;if(!_c0){_c1.position="absolute";_c1.clip="rect(0px "+_c1.width+" "+_c1.height+" 0px)";}else{if("width" in _c0){var _c2=this._getRealMatrix(),l=parseFloat(_c1.left),t=parseFloat(_c1.top);if(isNaN(l)){l=0;}if(isNaN(t)){t=0;}var _c3=m.multiplyRectangle(_c2,_c0);var pt=m.multiplyPoint(_c2,{x:l,y:t});_c1.clip="rect("+Math.round(_c3.y-pt.y)+"px "+Math.round(_c3.x-pt.x+_c3.width)+"px "+Math.round(_c3.y-pt.y+_c3.height)+"px "+Math.round(_c3.x-pt.x)+"px)";}}return this;}});(function(){var _c4=vml.Shape,_c5=_c4.prototype.setStroke,_c6=_c4.prototype.setFill;_c4.prototype.setStroke=function(){var _c7=_c5.apply(this,arguments);var _c8=this.rawNode,_c9=_c8&&_c8.stroke,_ca=this.getParent();if(_c9&&_ca){var op=((_ca._esriIeOpacity!==undefined)&&(_ca._esriIeOpacity!==null))?_ca._esriIeOpacity:1;_c9.opacity*=op;}return _c7;};_c4.prototype.setFill=function(){var _cb=_c6.apply(this,arguments);var _cc=this.rawNode,_cd=_cc&&_cc.fill,_ce=this.getParent();if(_cd&&_ce){var op=((_ce._esriIeOpacity!==undefined)&&(_ce._esriIeOpacity!==null))?_ce._esriIeOpacity:1;if(_cd.type==="tile"){_a9.set(_cc,"opacity",op);}else{_cd.opacity*=op;}}return _cb;};}());vml.Group=_a5("dojox.gfx.vml.Group",vml.Shape,{constructor:function(){gs.Container._init.call(this);},_applyTransform:function(){var _cf=this._getRealMatrix();for(var i=0;i<this.children.length;++i){this.children[i]._updateParentMatrix(_cf);}if(this.clip){this.setClip(this.clip);}return this;},_setDimensions:function(_d0,_d1){var r=this.rawNode,rs=r.style,bs=this.bgNode.style;rs.width=_d0;rs.height=_d1;r.coordsize=_d0+" "+_d1;bs.width=_d0;bs.height=_d1;for(var i=0;i<this.children.length;++i){this.children[i]._setDimensions(_d0,_d1);}return this;},setClip:function(_d2){this.clip=_d2;var _d3=this.rawNode.style;if(!_d2){_d3.position="absolute";_d3.clip="rect(0px "+_d3.width+" "+_d3.height+" 0px)";}else{if("width" in _d2){var _d4=this._getRealMatrix();var _d5=m.multiplyRectangle(_d4,_d2);var _d6=this.getBoundingBox();_d6=_d6?m.multiplyRectangle(_d4,_d6):null;var _d7=_d6&&_d6.x<0?_d6.x:0,_d8=_d6&&_d6.y<0?_d6.y:0;_d3.position="absolute";_d3.clip="rect("+Math.round(_d5.y-_d8)+"px "+Math.round(_d5.x+_d5.width-_d7)+"px "+Math.round(_d5.y+_d5.height-_d8)+"px "+Math.round(_d5.x-_d7)+"px)";}}return this;},destroy:function(){this.clear(true);vml.Shape.prototype.destroy.apply(this,arguments);}});vml.Group.nodeType="group";vml.Rect=_a5("dojox.gfx.vml.Rect",[vml.Shape,gs.Rect],{setShape:function(_d9){var _da=this.shape=g.makeParameters(this.shape,_d9);this.bbox=null;var r=Math.min(1,(_da.r/Math.min(parseFloat(_da.width),parseFloat(_da.height)))).toFixed(8);var _db=this.rawNode.parentNode,_dc=null;if(_db){if(_db.lastChild!==this.rawNode){for(var i=0;i<_db.childNodes.length;++i){if(_db.childNodes[i]===this.rawNode){_dc=_db.childNodes[i+1];break;}}}_db.removeChild(this.rawNode);}if(has("ie")>7){var _dd=this.rawNode.ownerDocument.createElement("v:roundrect");_dd.arcsize=r;_dd.style.display="inline-block";vml._reparentEvents(_dd,this.rawNode);this.rawNode=_dd;this.rawNode.__gfxObject__=this.getUID();}else{this.rawNode.arcsize=r;}if(_db){if(_dc){_db.insertBefore(this.rawNode,_dc);}else{_db.appendChild(this.rawNode);}}var _de=this.rawNode.style;_de.left=_da.x.toFixed();_de.top=_da.y.toFixed();_de.width=(typeof _da.width=="string"&&_da.width.indexOf("%")>=0)?_da.width:Math.max(_da.width.toFixed(),0);_de.height=(typeof _da.height=="string"&&_da.height.indexOf("%")>=0)?_da.height:Math.max(_da.height.toFixed(),0);return this.setTransform(this.matrix).setFill(this.fillStyle).setStroke(this.strokeStyle);}});vml.Rect.nodeType="roundrect";vml.Ellipse=_a5("dojox.gfx.vml.Ellipse",[vml.Shape,gs.Ellipse],{setShape:function(_df){var _e0=this.shape=g.makeParameters(this.shape,_df);this.bbox=null;var _e1=this.rawNode.style;_e1.left=(_e0.cx-_e0.rx).toFixed();_e1.top=(_e0.cy-_e0.ry).toFixed();_e1.width=(_e0.rx*2).toFixed();_e1.height=(_e0.ry*2).toFixed();return this.setTransform(this.matrix);}});vml.Ellipse.nodeType="oval";vml.Circle=_a5("dojox.gfx.vml.Circle",[vml.Shape,gs.Circle],{setShape:function(_e2){var _e3=this.shape=g.makeParameters(this.shape,_e2);this.bbox=null;var _e4=this.rawNode.style;_e4.left=(_e3.cx-_e3.r).toFixed();_e4.top=(_e3.cy-_e3.r).toFixed();_e4.width=(_e3.r*2).toFixed();_e4.height=(_e3.r*2).toFixed();return this;}});vml.Circle.nodeType="oval";vml.Line=_a5("dojox.gfx.vml.Line",[vml.Shape,gs.Line],{constructor:function(_e5){if(_e5){_e5.setAttribute("dojoGfxType","line");}},setShape:function(_e6){var _e7=this.shape=g.makeParameters(this.shape,_e6);this.bbox=null;this.rawNode.path.v="m"+_e7.x1.toFixed()+" "+_e7.y1.toFixed()+"l"+_e7.x2.toFixed()+" "+_e7.y2.toFixed()+"e";return this.setTransform(this.matrix);}});vml.Line.nodeType="shape";vml.Polyline=_a5("dojox.gfx.vml.Polyline",[vml.Shape,gs.Polyline],{constructor:function(_e8){if(_e8){_e8.setAttribute("dojoGfxType","polyline");}},setShape:function(_e9,_ea){if(_e9&&_e9 instanceof Array){this.shape=g.makeParameters(this.shape,{points:_e9});if(_ea&&this.shape.points.length){this.shape.points.push(this.shape.points[0]);}}else{this.shape=g.makeParameters(this.shape,_e9);}this.bbox=null;this._normalizePoints();var _eb=[],p=this.shape.points;if(p.length>0){_eb.push("m");_eb.push(p[0].x.toFixed(),p[0].y.toFixed());if(p.length>1){_eb.push("l");for(var i=1;i<p.length;++i){_eb.push(p[i].x.toFixed(),p[i].y.toFixed());}}}_eb.push("e");this.rawNode.path.v=_eb.join(" ");return this.setTransform(this.matrix);}});vml.Polyline.nodeType="shape";vml.Image=_a5("dojox.gfx.vml.Image",[vml.Shape,gs.Image],{setShape:function(_ec){var _ed=this.shape=g.makeParameters(this.shape,_ec);this.bbox=null;this.rawNode.firstChild.src=_ed.src;return this.setTransform(this.matrix);},_applyTransform:function(){var _ee=this._getRealMatrix(),_ef=this.rawNode,s=_ef.style,_f0=this.shape;if(_ee){_ee=m.multiply(_ee,{dx:_f0.x,dy:_f0.y});}else{_ee=m.normalize({dx:_f0.x,dy:_f0.y});}if(_ee.xy==0&&_ee.yx==0&&_ee.xx>0&&_ee.yy>0){s.filter="";s.width=Math.floor(_ee.xx*_f0.width);s.height=Math.floor(_ee.yy*_f0.height);s.left=Math.floor(_ee.dx);s.top=Math.floor(_ee.dy);}else{var ps=_ef.parentNode.style;s.left="0px";s.top="0px";s.width=ps.width;s.height=ps.height;_ee=m.multiply(_ee,{xx:_f0.width/parseInt(s.width),yy:_f0.height/parseInt(s.height)});var f=_ef.filters["DXImageTransform.Microsoft.Matrix"];if(f){f.M11=_ee.xx;f.M12=_ee.xy;f.M21=_ee.yx;f.M22=_ee.yy;f.Dx=_ee.dx;f.Dy=_ee.dy;}else{s.filter="progid:DXImageTransform.Microsoft.Matrix(M11="+_ee.xx+", M12="+_ee.xy+", M21="+_ee.yx+", M22="+_ee.yy+", Dx="+_ee.dx+", Dy="+_ee.dy+")";}}return this;},_setDimensions:function(_f1,_f2){var r=this.rawNode,f=r.filters["DXImageTransform.Microsoft.Matrix"];if(f){var s=r.style;s.width=_f1;s.height=_f2;return this._applyTransform();}return this;}});vml.Image.nodeType="rect";vml.Text=_a5("dojox.gfx.vml.Text",[vml.Shape,gs.Text],{constructor:function(_f3){if(_f3){_f3.setAttribute("dojoGfxType","text");}this.fontStyle=null;},_alignment:{start:"left",middle:"center",end:"right"},setShape:function(_f4){this.shape=g.makeParameters(this.shape,_f4);this.bbox=null;var r=this.rawNode,s=this.shape,x=s.x,y=s.y.toFixed(),_f5;switch(s.align){case "middle":x-=5;break;case "end":x-=10;break;}_f5="m"+x.toFixed()+","+y+"l"+(x+10).toFixed()+","+y+"e";var p=null,t=null,c=r.childNodes;for(var i=0;i<c.length;++i){var tag=c[i].tagName;if(tag=="path"){p=c[i];if(t){break;}}else{if(tag=="textpath"){t=c[i];if(p){break;}}}}if(!p){p=r.ownerDocument.createElement("v:path");r.appendChild(p);}if(!t){t=r.ownerDocument.createElement("v:textpath");r.appendChild(t);}p.v=_f5;p.textPathOk=true;t.on=true;var a=vml.text_alignment[s.align];t.style["v-text-align"]=a?a:"left";t.style["text-decoration"]=s.decoration;t.style["v-rotate-letters"]=s.rotated;t.style["v-text-kern"]=s.kerning;t.string=s.text;return this.setTransform(this.matrix);},_setFont:function(){var f=this.fontStyle,c=this.rawNode.childNodes;for(var i=0;i<c.length;++i){if(c[i].tagName=="textpath"){c[i].style.font=g.makeFontString(f);break;}}this.setTransform(this.matrix);},_getRealMatrix:function(){var _f6=this.inherited(arguments);if(_f6){_f6=m.multiply(_f6,{dy:-g.normalizedLength(this.fontStyle?this.fontStyle.size:"10pt")*0.35});}return _f6;},getTextWidth:function(){var _f7=this.rawNode,_f8=_f7.style.display;_f7.style.display="inline";var _f9=g.pt2px(parseFloat(_f7.currentStyle.width));_f7.style.display=_f8;return _f9;}});vml.Text.nodeType="shape";vml.Path=_a5("dojox.gfx.vml.Path",[vml.Shape,_ab.Path],{constructor:function(_fa){if(_fa&&!_fa.getAttribute("dojoGfxType")){_fa.setAttribute("dojoGfxType","path");}this.vmlPath="";this.lastControl={};},_updateWithSegment:function(_fb){var _fc=_a4.clone(this.last);this.inherited(arguments);if(arguments.length>1){return;}var _fd=this[this.renderers[_fb.action]](_fb,_fc);if(typeof this.vmlPath=="string"){this.vmlPath+=_fd.join("");this.rawNode.path.v=this.vmlPath+" r0,0 e";}else{Array.prototype.push.apply(this.vmlPath,_fd);}},setShape:function(_fe){this.vmlPath=[];this.lastControl.type="";this.inherited(arguments);this.vmlPath=this.vmlPath.join("");this.rawNode.path.v=this.vmlPath+" r0,0 e";return this;},_pathVmlToSvgMap:{m:"M",l:"L",t:"m",r:"l",c:"C",v:"c",qb:"Q",x:"z",e:""},renderers:{M:"_moveToA",m:"_moveToR",L:"_lineToA",l:"_lineToR",H:"_hLineToA",h:"_hLineToR",V:"_vLineToA",v:"_vLineToR",C:"_curveToA",c:"_curveToR",S:"_smoothCurveToA",s:"_smoothCurveToR",Q:"_qCurveToA",q:"_qCurveToR",T:"_qSmoothCurveToA",t:"_qSmoothCurveToR",A:"_arcTo",a:"_arcTo",Z:"_closePath",z:"_closePath"},_addArgs:function(_ff,_100,from,upto){var n=_100 instanceof Array?_100:_100.args;for(var i=from;i<upto;++i){_ff.push(" ",n[i].toFixed());}},_adjustRelCrd:function(last,_101,step){var n=_101 instanceof Array?_101:_101.args,l=n.length,_102=new Array(l),i=0,x=last.x,y=last.y;if(typeof x!="number"){_102[0]=x=n[0];_102[1]=y=n[1];i=2;}if(typeof step=="number"&&step!=2){var j=step;while(j<=l){for(;i<j;i+=2){_102[i]=x+n[i];_102[i+1]=y+n[i+1];}x=_102[j-2];y=_102[j-1];j+=step;}}else{for(;i<l;i+=2){_102[i]=(x+=n[i]);_102[i+1]=(y+=n[i+1]);}}return _102;},_adjustRelPos:function(last,_103){var n=_103 instanceof Array?_103:_103.args,l=n.length,_104=new Array(l);for(var i=0;i<l;++i){_104[i]=(last+=n[i]);}return _104;},_moveToA:function(_105){var p=[" m"],n=_105 instanceof Array?_105:_105.args,l=n.length;this._addArgs(p,n,0,2);if(l>2){p.push(" l");this._addArgs(p,n,2,l);}this.lastControl.type="";return p;},_moveToR:function(_106,last){return this._moveToA(this._adjustRelCrd(last,_106));},_lineToA:function(_107){var p=[" l"],n=_107 instanceof Array?_107:_107.args;this._addArgs(p,n,0,n.length);this.lastControl.type="";return p;},_lineToR:function(_108,last){return this._lineToA(this._adjustRelCrd(last,_108));},_hLineToA:function(_109,last){var p=[" l"],y=" "+last.y.toFixed(),n=_109 instanceof Array?_109:_109.args,l=n.length;for(var i=0;i<l;++i){p.push(" ",n[i].toFixed(),y);}this.lastControl.type="";return p;},_hLineToR:function(_10a,last){return this._hLineToA(this._adjustRelPos(last.x,_10a),last);},_vLineToA:function(_10b,last){var p=[" l"],x=" "+last.x.toFixed(),n=_10b instanceof Array?_10b:_10b.args,l=n.length;for(var i=0;i<l;++i){p.push(x," ",n[i].toFixed());}this.lastControl.type="";return p;},_vLineToR:function(_10c,last){return this._vLineToA(this._adjustRelPos(last.y,_10c),last);},_curveToA:function(_10d){var p=[],n=_10d instanceof Array?_10d:_10d.args,l=n.length,lc=this.lastControl;for(var i=0;i<l;i+=6){p.push(" c");this._addArgs(p,n,i,i+6);}lc.x=n[l-4];lc.y=n[l-3];lc.type="C";return p;},_curveToR:function(_10e,last){return this._curveToA(this._adjustRelCrd(last,_10e,6));},_smoothCurveToA:function(_10f,last){var p=[],n=_10f instanceof Array?_10f:_10f.args,l=n.length,lc=this.lastControl,i=0;if(lc.type!="C"){p.push(" c");this._addArgs(p,[last.x,last.y],0,2);this._addArgs(p,n,0,4);lc.x=n[0];lc.y=n[1];lc.type="C";i=4;}for(;i<l;i+=4){p.push(" c");this._addArgs(p,[2*last.x-lc.x,2*last.y-lc.y],0,2);this._addArgs(p,n,i,i+4);lc.x=n[i];lc.y=n[i+1];}return p;},_smoothCurveToR:function(_110,last){return this._smoothCurveToA(this._adjustRelCrd(last,_110,4),last);},_qCurveToA:function(_111){var p=[],n=_111 instanceof Array?_111:_111.args,l=n.length,lc=this.lastControl;for(var i=0;i<l;i+=4){p.push(" qb");this._addArgs(p,n,i,i+4);}lc.x=n[l-4];lc.y=n[l-3];lc.type="Q";return p;},_qCurveToR:function(_112,last){return this._qCurveToA(this._adjustRelCrd(last,_112,4));},_qSmoothCurveToA:function(_113,last){var p=[],n=_113 instanceof Array?_113:_113.args,l=n.length,lc=this.lastControl,i=0;if(lc.type!="Q"){p.push(" qb");this._addArgs(p,[lc.x=last.x,lc.y=last.y],0,2);lc.type="Q";this._addArgs(p,n,0,2);i=2;}for(;i<l;i+=2){p.push(" qb");this._addArgs(p,[lc.x=2*last.x-lc.x,lc.y=2*last.y-lc.y],0,2);this._addArgs(p,n,i,i+2);}return p;},_qSmoothCurveToR:function(_114,last){return this._qSmoothCurveToA(this._adjustRelCrd(last,_114,2),last);},_arcTo:function(_115,last){var p=[],n=_115.args,l=n.length,_116=_115.action=="a";for(var i=0;i<l;i+=7){var x1=n[i+5],y1=n[i+6];if(_116){x1+=last.x;y1+=last.y;}var _117=_ac.arcAsBezier(last,n[i],n[i+1],n[i+2],n[i+3]?1:0,n[i+4]?1:0,x1,y1);for(var j=0;j<_117.length;++j){p.push(" c");var t=_117[j];this._addArgs(p,t,0,t.length);this._updateBBox(t[0],t[1]);this._updateBBox(t[2],t[3]);this._updateBBox(t[4],t[5]);}last.x=x1;last.y=y1;}this.lastControl.type="";return p;},_closePath:function(){this.lastControl.type="";return ["x"];}});vml.Path.nodeType="shape";vml.EsriPath=_a5("dojox.gfx.vml.EsriPath",vml.Path,{setShape:function(_118){this.rawNode.path.v=(this.vmlPath=_118);return this;}});vml.EsriPath.nodeType="shape";vml.TextPath=_a5("dojox.gfx.vml.TextPath",[vml.Path,_ab.TextPath],{constructor:function(_119){if(_119){_119.setAttribute("dojoGfxType","textpath");}this.fontStyle=null;if(!("text" in this)){this.text=_a4.clone(g.defaultTextPath);}if(!("fontStyle" in this)){this.fontStyle=_a4.clone(g.defaultFont);}},setText:function(_11a){this.text=g.makeParameters(this.text,typeof _11a=="string"?{text:_11a}:_11a);this._setText();return this;},setFont:function(_11b){this.fontStyle=typeof _11b=="string"?g.splitFontString(_11b):g.makeParameters(g.defaultFont,_11b);this._setFont();return this;},_setText:function(){this.bbox=null;var r=this.rawNode,s=this.text,p=null,t=null,c=r.childNodes;for(var i=0;i<c.length;++i){var tag=c[i].tagName;if(tag=="path"){p=c[i];if(t){break;}}else{if(tag=="textpath"){t=c[i];if(p){break;}}}}if(!p){p=this.rawNode.ownerDocument.createElement("v:path");r.appendChild(p);}if(!t){t=this.rawNode.ownerDocument.createElement("v:textpath");r.appendChild(t);}p.textPathOk=true;t.on=true;var a=vml.text_alignment[s.align];t.style["v-text-align"]=a?a:"left";t.style["text-decoration"]=s.decoration;t.style["v-rotate-letters"]=s.rotated;t.style["v-text-kern"]=s.kerning;t.string=s.text;},_setFont:function(){var f=this.fontStyle,c=this.rawNode.childNodes;for(var i=0;i<c.length;++i){if(c[i].tagName=="textpath"){c[i].style.font=g.makeFontString(f);break;}}}});vml.TextPath.nodeType="shape";vml.Surface=_a5("dojox.gfx.vml.Surface",gs.Surface,{constructor:function(){gs.Container._init.call(this);},destroy:function(){this.clear(true);this.inherited(arguments);},setDimensions:function(_11c,_11d){this.width=g.normalizedLength(_11c);this.height=g.normalizedLength(_11d);if(!this.rawNode){return this;}var cs=this.clipNode.style,r=this.rawNode,rs=r.style,bs=this.bgNode.style,ps=this._parent.style,i;ps.width=_11c;ps.height=_11d;cs.width=_11c;cs.height=_11d;cs.clip="rect(0px "+_11c+"px "+_11d+"px 0px)";rs.width=_11c;rs.height=_11d;r.coordsize=_11c+" "+_11d;bs.width=_11c;bs.height=_11d;for(i=0;i<this.children.length;++i){this.children[i]._setDimensions(_11c,_11d);}return this;},getDimensions:function(){var t=this.rawNode?{width:g.normalizedLength(this.rawNode.style.width),height:g.normalizedLength(this.rawNode.style.height)}:null;if(t.width<=0){t.width=this.width;}if(t.height<=0){t.height=this.height;}return t;}});vml.createSurface=function(_11e,_11f,_120){if(!_11f&&!_120){var pos=_a8.position(_11e);_11f=_11f||pos.w;_120=_120||pos.h;}if(typeof _11f=="number"){_11f=_11f+"px";}if(typeof _120=="number"){_120=_120+"px";}var s=new vml.Surface(),p=dom.byId(_11e),c=s.clipNode=p.ownerDocument.createElement("div"),r=s.rawNode=p.ownerDocument.createElement("v:group"),cs=c.style,rs=r.style;if(has("ie")>7){rs.display="inline-block";}s._parent=p;s._nodes.push(c);p.style.width=_11f;p.style.height=_120;cs.position="absolute";cs.width=_11f;cs.height=_120;cs.clip="rect(0px "+_11f+" "+_120+" 0px)";rs.position="absolute";rs.width=_11f;rs.height=_120;r.coordsize=(_11f==="100%"?_11f:parseFloat(_11f))+" "+(_120==="100%"?_120:parseFloat(_120));r.coordorigin="0 0";var b=s.bgNode=r.ownerDocument.createElement("v:rect"),bs=b.style;bs.left=bs.top=0;bs.width=rs.width;bs.height=rs.height;b.filled=b.stroked="f";r.appendChild(b);c.appendChild(r);p.appendChild(c);s.width=g.normalizedLength(_11f);s.height=g.normalizedLength(_120);return s;};function _121(_122,f,o){o=o||_aa.global;f.call(o,_122);if(_122 instanceof g.Surface||_122 instanceof g.Group){arr.forEach(_122.children,function(_123){_121(_123,f,o);});}};var _124=function(_125){if(this!=_125.getParent()){var _126=_125.getParent();if(_126){_126.remove(_125);}this.rawNode.appendChild(_125.rawNode);C.add.apply(this,arguments);_121(this,function(s){if(typeof (s.getFont)=="function"){s.setShape(s.getShape());s.setFont(s.getFont());}if(typeof (s.setFill)=="function"){s.setFill(s.getFill());s.setStroke(s.getStroke());}});}return this;};var _127=function(_128){if(this!=_128.getParent()){this.rawNode.appendChild(_128.rawNode);if(!_128.getParent()){_128.setFill(_128.getFill());_128.setStroke(_128.getStroke());}C.add.apply(this,arguments);}return this;};var C=gs.Container,_129={add:_a7.fixVmlAdd===true?_124:_127,remove:function(_12a,_12b){if(this==_12a.getParent()){if(this.rawNode==_12a.rawNode.parentNode){this.rawNode.removeChild(_12a.rawNode);}C.remove.apply(this,arguments);}return this;},clear:function(){var r=this.rawNode;while(r.firstChild!=r.lastChild){if(r.firstChild!=this.bgNode){r.removeChild(r.firstChild);}if(r.lastChild!=this.bgNode){r.removeChild(r.lastChild);}}return C.clear.apply(this,arguments);},getBoundingBox:C.getBoundingBox,_moveChildToFront:C._moveChildToFront,_moveChildToBack:C._moveChildToBack};var _12c={createGroup:function(){var node=this.createObject(vml.Group,null);var r=node.rawNode.ownerDocument.createElement("v:rect");r.style.left=r.style.top=0;r.style.width=node.rawNode.style.width;r.style.height=node.rawNode.style.height;r.filled=r.stroked="f";node.rawNode.appendChild(r);node.bgNode=r;return node;},createImage:function(_12d){if(!this.rawNode){return null;}var _12e=new vml.Image(),doc=this.rawNode.ownerDocument,node=doc.createElement("v:rect");node.stroked="f";node.style.width=this.rawNode.style.width;node.style.height=this.rawNode.style.height;var img=doc.createElement("v:imagedata");node.appendChild(img);_12e.setRawNode(node);this.rawNode.appendChild(node);_12e.setShape(_12d);this.add(_12e);return _12e;},createRect:function(rect){if(!this.rawNode){return null;}var _12f=new vml.Rect,node=this.rawNode.ownerDocument.createElement("v:roundrect");if(has("ie")>7){node.style.display="inline-block";}_12f.setRawNode(node);this.rawNode.appendChild(node);_12f.setShape(rect);this.add(_12f);return _12f;},createObject:function(_130,_131){if(!this.rawNode){return null;}var _132=new _130(),node=this.rawNode.ownerDocument.createElement("v:"+_130.nodeType);_132.setRawNode(node);this.rawNode.appendChild(node);switch(_130){case vml.Group:case vml.Line:case vml.Polyline:case vml.Image:case vml.Text:case vml.Path:case vml.TextPath:this._overrideSize(node);}_132.setShape(_131);this.add(_132);return _132;},_overrideSize:function(node){var s=this.rawNode.style,w=s.width,h=s.height;node.style.width=w;node.style.height=h;node.coordsize=parseInt(w)+" "+parseInt(h);}};_a4.extend(vml.Group,_129);_a4.extend(vml.Group,gs.Creator);_a4.extend(vml.Group,_12c);_a4.extend(vml.Surface,_129);_a4.extend(vml.Surface,gs.Creator);_a4.extend(vml.Surface,_12c);vml.fixTarget=function(_133,_134){if(!_133.gfxTarget){_133.gfxTarget=gs.byId(_133.target.__gfxObject__);}return true;};return vml;});