<#macro funcMacro>

    <@com.htmlWithTitle title="${env.getEnv('local.title')}国土资源 一张图运维管理" import="jquery,portal,fullscreen" >

    <div class="container">

        <div id="ctn" class="clearfix">

            <div class="toolbar">

                <ul class="breadcrumb">
                    <li>
                        <a href="<@com.rootPath/>/portal/tpls"> <i class="icon icon-list icon-black"></i> 模板列表</a><span class="divider">/</span>
                    </li>
                    <li>
                        <a href="<@com.rootPath/>/portal/${tpl}/services">服务列表</a><span class="divider">/</span>
                    </li>
                    <li class="active">
                        功能配置
                    </li>
                </ul>

            </div>
            <!-- /.toolbar -->

            <div style="width: 100%;float: left;">
                
                <#include "../../left-panel.ftl"/><!-- /#leftBar -->
                
                <div id="main" style="width: 88%;float: left;">

                    <div class="J_auto_high main-ctn">

                        <div id="functionContainer">

                            <div class="row-fluid section-top">

                                <div class="span3 section-header-wrap">
                                    <a href="<@com.rootPath/>/portal/${tpl}/services" class="func-ico-back">&nbsp;</a>
                                    <h2 class="title"><#if service.alias??>${service.alias!}<#else>${service.name!}</#if></h2>
                                </div>

                                <div class="span9 section-nav-wrap">
                                    <ul id="functionNav" class="nav nav-pills">
                                        <li <#if (type==1)>class="active"</#if> >
                                            <a href="<@com.rootPath/>/portal/${tpl}/function/search/${service.id}"><i
                                                    class="func-ico func-ico-query"></i>

                                                <h4>查询功能</h4></a>
                                        </li>
                                        <li <#if (type==2)>class="active"</#if>>
                                            <a href="<@com.rootPath/>/portal/${tpl}/function/identify/${service.id}"><i
                                                    class="func-ico func-ico-eye"></i>

                                                <h4>属性识别</h4></a>
                                        </li>
                                        <li <#if (type==3)>class="active"</#if>>
                                            <a href="<@com.rootPath/>/portal/${tpl}/function/location/${service.id}"><i
                                                    class="func-ico func-ico-location"></i>

                                                <h4>定位功能</h4></a>
                                        </li>
                                        <li <#if (type==4)>class="active"</#if>>
                                            <a href="<@com.rootPath/>/portal/${tpl}/function/edit/${service.id}"><i
                                                    class="func-ico func-ico-edit"></i>

                                                <h4>编辑功能</h4></a>
                                        </li>
                                        <li <#if (type==5)>class="active"</#if>>
                                            <a href="<@com.rootPath/>/portal/${tpl}/function/analysis/${service.id}"><i
                                                    class="func-ico func-ico-analysis"></i>

                                                <h4>分析功能</h4></a>
                                        </li>
                                    </ul>
                                </div>

                            </div><!-- /.row-fluid -->
                            <#include "../../alert.ftl"/>

                            <div id="J_ALERT_2" class="alert alert-success hide" style="margin-top:10px">
                                <button type="button" class="close" data-dismiss="alert">&times;</button>
                                <strong>操作成功</strong>
                            </div>

                            <div id="J_DRAG_CTN" class="row-fluid">

                                <div class="span3">
                                    <h4 class="title">所有图层</h4>

                                    <div id="J_ACCORDION" class="accordion">

                                        <#list layers as layer>

                                            <div class="accordion-group">
                                                <div class="accordion-heading">
                                                    <a id="J_TOGGLE_${layer.id}"
                                                       class="accordion-toggle"
                                                       data-toggle="collapse"
                                                       data-parent="#J_ACCORDION"
                                                       href="#layer_${layer.id}"
                                                       data-alias="${layer.alias!}"
                                                       data-layerIndex="${layer.index!}"
                                                       name="${layer.name!}">
                                                    ${layer.name}
                                                    </a>
                                                </div>
                                                <div id="layer_${layer.id}" class="accordion-body clearfix collapse">
                                                    <div class="accordion-inner">
                                                        <ul class="nav j_sortable_start">
                                                            <#if fieldsMap[layer.id]??>
                                                            <#list fieldsMap[layer.id] as field>
                                                                <li data-self="${field.id}"
                                                                    data-parent="J_TOGGLE_${layer.id}"
                                                                    data-name="${field.name!}"
                                                                    data-alias="${field.alias!}"><a
                                                                        href="#"><#if field.alias??>${field.alias!}<#else>${field.name!}</#if></a>
                                                                </li>
                                                            </#list>
                                                            </#if>
                                                        </ul>
                                                    </div>
                                                </div>
                                            </div>

                                        </#list>

                                    </div>

                                </div>
                                <!-- span -->
                                <div class="span9">
                                	<div id="J_FIX">
                                    	<#nested/>
                                    </div>
                                </div>
                                <!-- span -->

                            </div>
                            <!-- /.row-fluid -->

                        </div>
                        <!-- /#functionContainer -->

                    </div>
                    <!-- /.main-ctn -->

                </div>
                <!-- /#main -->

            </div>

        </div>
        <!-- /#ctn -->

    </div><!-- /.container -->
    <form id="J_FUNCTION" action="<@com.rootPath/>/portal/${tpl}/${service.id}/savefunction" method="post">
        <input type="hidden" name="id" value="${function.id!}"/>
        <input type="hidden" name="name" value="${service.name!}${view!}"/>
        <input type="hidden" name="type" value="${type!}"/>
        <input type="hidden" name="config" value=""/>
    </form>
    <script>
        window.func = {};
        window.func['type'] = ${type!};
        window.func['id'] = "${function.id!}";
        window.func['name'] = "${function.name!}";
        window.func['config'] = $.parseJSON(<#if function.config??>'${function.config}'<#else>'{"layers":[]}'</#if>);
    </script>
    <script src="<@com.rootPath/>/js/portal/func_config.js"></script>
    <script>
        $(document).ready(function () {
            selectNavGuide(0);
        });
    </script>
    </@com.htmlWithTitle>
</#macro>