/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.support.fm;

import cn.gtmap.onemap.model.Operation;
import cn.gtmap.onemap.model.Privilege;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.security.AuthorizationService;
import cn.gtmap.onemap.security.SecHelper;
import cn.gtmap.onemap.security.User;
import freemarker.template.TemplateMethodModel;
import freemarker.template.TemplateModelException;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public final class TplSelector
extends BaseLogger
implements TemplateMethodModel {
    private static final String DEFAULT_TPL = "YZT";
    private static final String TPL_RESOURCE = "omp-functions:tpl";
    @Autowired
    private AuthorizationService authorizationService;

    public Object exec(List list) throws TemplateModelException {
        User user = SecHelper.getUser();
        try {
            if (user != null) {
                Set privileges = this.authorizationService.getPermittedPrivileges(user.getId(), TPL_RESOURCE);
                for (Privilege privilege : privileges) {
                    for (Operation operation : privilege.getOperations()) {
                        if (!"view".equals(operation.getName())) continue;
                        return privilege.getResource();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("tpl.om.selector.error", new Object[]{e.getLocalizedMessage()}));
        }
        return DEFAULT_TPL;
    }
}

