/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.dao.impl;

import cn.gtmap.onemap.platform.dao.ThematicMapDao;
import cn.gtmap.onemap.platform.entity.ThematicMap;
import cn.gtmap.onemap.platform.service.TemplateService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import com.alibaba.fastjson.JSON;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ThematicMapDaoImpl
extends BaseLogger
implements ThematicMapDao {
    private final String CONFIG = "thematic.json";
    @Autowired
    private TemplateService templateService;

    private List<ThematicMap> getConfig() {
        try {
            return JSON.parseArray((String)this.templateService.getTemplate("thematic.json"), ThematicMap.class);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("thematic.config.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public List<ThematicMap> getAll() {
        return this.getConfig();
    }

    private List<ThematicMap> saveAll(List<ThematicMap> maps) {
        try {
            Collections.sort(maps);
            this.templateService.modify("thematic.json", JSON.toJSONString(maps, (boolean)true));
            return maps;
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("thematic.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public ThematicMap getOne(String id) {
        for (ThematicMap item : this.getConfig()) {
            if (!item.getId().equals(id)) continue;
            return item;
        }
        throw new RuntimeException(this.getMessage("thematic.not.found", new Object[]{id}));
    }

    public ThematicMap saveOrUpdate(ThematicMap entity) {
        List maps = this.getAll();
        Iterator iterator = maps.iterator();
        while (iterator.hasNext()) {
            ThematicMap item = (ThematicMap)iterator.next();
            if (!item.getId().equals(entity.getId())) continue;
            iterator.remove();
        }
        maps.add(entity);
        this.saveAll(maps);
        return entity;
    }

    public void delete(String id) {
        List maps = this.getAll();
        Iterator iterator = maps.iterator();
        while (iterator.hasNext()) {
            ThematicMap item = (ThematicMap)iterator.next();
            if (!item.getId().equals(id)) continue;
            iterator.remove();
        }
        this.saveAll(maps);
    }
}

