/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.platform.entity.Document;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.BMarkService;
import cn.gtmap.onemap.platform.service.DictService;
import cn.gtmap.onemap.platform.service.DocumentService;
import cn.gtmap.onemap.platform.service.GISManager;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import com.alibaba.fastjson.JSON;
import com.vividsolutions.jts.geom.Geometry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.FeatureCollection;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/geometryService"})
public class GeometryController
extends BaseController {
    @Autowired
    private GISManager gisManager;
    @Autowired
    private BMarkService bMarkService;
    @Autowired
    private DictService dictService;
    @Autowired
    private GeometryService geometryService;
    @Autowired
    private DocumentService documentService;

    @RequestMapping(value={"/intersect"})
    @ResponseBody
    public List intersect(@RequestParam(value="layerName") String layerName, @RequestParam(value="wkt") String wkt, @RequestParam(value="returnFields") String returnFields, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource) {
        try {
            return this.gisManager.getGISService().intersect(layerName, wkt, returnFields.split(","), dataSource);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/query"})
    @ResponseBody
    public Map query(@RequestParam(value="layerName") String layerName, @RequestParam(value="where", required=false) String where, @RequestParam(value="geometry", required=false) String geometry, @RequestParam(value="outFields", defaultValue="*") String outFields, @RequestParam(value="returnGeometry", defaultValue="true") boolean returnGeometry, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            String[] fields = "*".equals(outFields) ? null : outFields.split(",");
            List result = null;
            if (StringUtils.isNotBlank((String)where)) {
                result = this.gisManager.getGISService().query(layerName, where, fields, returnGeometry, dataSource);
            } else if (StringUtils.isNotBlank((String)geometry)) {
                result = this.gisManager.getGISService().query(layerName, this.gisManager.getGeoService().readGeoJSON(geometry), fields, dataSource);
            } else {
                throw new RuntimeException(this.getMessage("query.condition.missing", new Object[0]));
            }
            FeatureCollection collection = this.gisManager.getGeoService().list2FeatureCollection(result, null, null);
            return this.result((Object)this.gisManager.getGeoService().toFeatureJSON((Object)collection));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/insert"})
    @ResponseBody
    public Map insert(@RequestParam(value="layerName") String layerName, @RequestParam(value="geometry", required=false) String geometry, @RequestParam(value="check", required=false) Boolean check, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            return this.result((Object)this.gisManager.getGISService().insert2(layerName, geometry, check.booleanValue(), dataSource));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/update"})
    @ResponseBody
    public Map update(@RequestParam(value="layerName") String layerName, @RequestParam(value="primaryKey", required=true) String primaryKey, @RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            return this.result((Object)this.gisManager.getGISService().update(layerName, primaryKey, geometry, dataSource));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/delete"})
    @ResponseBody
    public Map delete(@RequestParam(value="layerName") String layerName, @RequestParam(value="primaryKey", required=true) String primaryKey, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            return this.result((Object)this.gisManager.getGISService().delete(layerName, primaryKey, dataSource));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/intersect"})
    @ResponseBody
    public Map intersect2(@RequestParam(value="layerName") String layerName, @RequestParam(value="geometry") String geometry, @RequestParam(value="outFields", defaultValue="*") String outFields, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource) {
        try {
            String[] fields = "*".equals(outFields) ? null : outFields.split(",");
            List results = this.gisManager.getGISService().intersect2(layerName, geometry, fields, dataSource);
            FeatureCollection collection = this.geometryService.list2FeatureCollection(results, null, null);
            return this.result((Object)this.geometryService.toFeatureJSON((Object)collection));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/analysis/tdlyxz"})
    @ResponseBody
    public Map tdlyxzAnalysis(@RequestParam(value="dltb", required=false) String dltb, @RequestParam(value="xzdw", required=false) String xzdw, @RequestParam(value="regionCode", required=false) String regionCode, @RequestParam(value="year", defaultValue="2011") String year, @RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource) {
        try {
            if (StringUtils.isNotBlank((String)year)) {
                regionCode = year;
            }
            if (StringUtils.isNotBlank((String)regionCode)) {
                return this.result((Object)this.gisManager.getGISService().tdlyxzAnalysis(regionCode, geometry, dataSource));
            }
            if (StringUtils.isNotBlank((String)dltb) && StringUtils.isNotBlank((String)xzdw)) {
                return this.result((Object)this.gisManager.getGISService().tdlyxzAnalysis2(dltb, xzdw, geometry, dataSource));
            }
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.param.error", new Object[0]));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/analysis/tdghsc"})
    @ResponseBody
    public Map tdghscAnalysis(@RequestParam(value="layerType", defaultValue="") String layerType, @RequestParam(value="regionCode", required=false) String regionCode, @RequestParam(value="year", defaultValue="2020") String year, @RequestParam(value="geometry") String geometry, @RequestParam(value="outFields", defaultValue="*") String outFields, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource) {
        try {
            String[] fields;
            String[] stringArray = fields = "*".equals(outFields) ? null : outFields.split(",");
            if (StringUtils.isNotBlank((String)year)) {
                regionCode = year;
            }
            if (StringUtils.isNotBlank((String)layerType)) {
                return this.result((Object)this.gisManager.getGISService().tdghscAnalysis2(layerType, regionCode, geometry, fields, dataSource));
            }
            return this.result((Object)this.gisManager.getGISService().tdghscAnalysis2(regionCode, geometry, fields, dataSource));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/project"})
    @ResponseBody
    public Map project(@RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="inSR", required=true) String inSR, @RequestParam(value="outSR", required=true) String outSR) {
        try {
            Object geo = this.gisManager.getGeoService().readUnTypeGeoJSON(geometry);
            if (geo instanceof Geometry) {
                CoordinateReferenceSystem in = this.gisManager.getGeoService().parseUndefineSR(inSR);
                CoordinateReferenceSystem out = this.gisManager.getGeoService().parseUndefineSR(outSR);
                Geometry g = this.gisManager.getGeoService().project((Geometry)geo, in, out);
                return this.result((Object)this.gisManager.getGeoService().toGeoJSON(g));
            }
            throw new RuntimeException("geometry don't support");
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/analysis/tdghsc"})
    public String tdghscAnalysis(@RequestParam(value="layerType", defaultValue="") String layerType, @RequestParam(value="regionCode") String regionCode, @RequestParam(value="year", defaultValue="2020") String year, @RequestParam(value="geometry") String geometry, @RequestParam(value="outFields", defaultValue="*") String outFields, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource, Model model) {
        try {
            String[] fields;
            String[] stringArray = fields = "*".equals(outFields) ? null : outFields.split(",");
            if (StringUtils.isNotBlank((String)year)) {
                regionCode = year;
            }
            Map result = new HashMap();
            if (StringUtils.isNotBlank((String)layerType)) {
                String analysisResult = this.gisManager.getGISService().tdghscAnalysis2(layerType, regionCode, geometry, fields, dataSource);
                result = this.gisManager.getGISService().tdghscResult(layerType, analysisResult);
            } else {
                Map analysisMap = this.gisManager.getGISService().tdghscAnalysis2(regionCode, geometry, fields, dataSource);
                result = this.gisManager.getGISService().tdghscResult(analysisMap);
            }
            model.addAttribute("result", result);
            model.addAttribute("excelData", (Object)JSON.toJSONString((Object)this.gisManager.getGISService().tdghscExcelData(result)));
            return "analysis/tdghsc";
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/analysis/tdlyxz"})
    public String tdlyxzAnalysis(@RequestParam(value="dltb", required=false) String dltb, @RequestParam(value="xzdw", required=false) String xzdw, @RequestParam(value="regionCode", required=false) String regionCode, @RequestParam(value="year", required=false) String year, @RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource, @RequestParam(value="tpl", required=true) String tpl, Model model) {
        try {
            Map map = new HashMap();
            if (StringUtils.isNotBlank((String)year)) {
                regionCode = year;
            }
            if (StringUtils.isNotBlank((String)regionCode)) {
                map = this.result((Object)this.gisManager.getGISService().tdlyxzAnalysis(regionCode, geometry, dataSource));
            } else if (StringUtils.isNotBlank((String)dltb) && StringUtils.isNotBlank((String)xzdw)) {
                map = this.result((Object)this.gisManager.getGISService().tdlyxzAnalysis2(dltb, xzdw, geometry, dataSource));
            } else {
                throw new RuntimeException(this.getMessage("analysis.tdlyxz.param.error", new Object[0]));
            }
            List result = this.gisManager.getGISService().tdlyxzResult((Map)map.get("result"), tpl);
            LinkedHashMap excelData = this.gisManager.getGISService().tdlyxzExcelData(result);
            model.addAttribute("result", (Object)result);
            model.addAttribute("resultStr", (Object)JSON.toJSONString((Object)excelData));
            return "analysis/tdlyxz";
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/analysis/result/common"}, method={RequestMethod.POST})
    public String groupedAnalysisResult(@RequestParam(value="data") String data, Model model) {
        if (StringUtils.isNotBlank((String)data)) {
            List result = (List)JSON.parseObject((String)data, List.class);
            model.addAttribute("info", (Object)result);
            model.addAttribute("excelData", (Object)JSON.toJSONString((Object)this.gisManager.getGISService().analysisExcelData(result)));
        }
        return "analysis/result-grouped";
    }

    @RequestMapping(value={"/analysis/result/gzqyd"}, method={RequestMethod.POST})
    public String commonAnalysisResult(@RequestParam(value="data") String data, Model model) {
        if (StringUtils.isNotBlank((String)data)) {
            List result = (List)JSON.parseObject((String)data, List.class);
            model.addAttribute("result", (Object)result);
            model.addAttribute("excelData", (Object)JSON.toJSONString((Object)this.gisManager.getGISService().gzqydExcelData(result)));
        }
        return "analysis/result-gzqyd";
    }

    @RequestMapping(value={"/bmark"})
    public String boundaryMark(@RequestParam(value="id", required=false) String id, @RequestParam(value="type", required=false) String type, @RequestParam(value="btype", defaultValue="bmi") String btype, Model model) {
        model.addAttribute("id", (Object)id);
        model.addAttribute("btype", (Object)btype);
        model.addAttribute("type", (Object)type);
        return "geo/bmark";
    }

    @RequestMapping(value={"/bmark/coords"})
    @ResponseBody
    public List bMarkUpload(@RequestParam(value="fileData", required=true) MultipartFile file, @RequestParam(value="fileType", defaultValue="xls") String fileType) {
        try {
            return this.bMarkService.getCoordsByFile(file.getInputStream(), BMarkService.Type.getType((String)fileType));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/bmark/gen"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean generateShape(@RequestParam(value="id", required=false) String id, @RequestParam(value="coords", required=false) String coords, @RequestParam(value="type", required=false) String type) {
        try {
            return this.bMarkService.insert(id, (List)JSON.parseObject((String)coords, List.class), type);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/bmark/dks"})
    @ResponseBody
    public List getBMarkDKById(@RequestParam(value="key", required=false) String key, @RequestParam(value="type", required=true) String type) {
        try {
            return this.bMarkService.query(key, type);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/analysis/dict"})
    @ResponseBody
    public List getAnalysisDict(@RequestParam(value="tpl", required=true) String tpl, @RequestParam(value="groupName", required=true) String groupName) {
        return this.dictService.getAnalysisDict(tpl, groupName);
    }

    @RequestMapping(value={"/export/excel"})
    public void export2Excel(@RequestParam(value="data") String data, @RequestParam(value="fileName", required=false) String fileName, HttpServletResponse response) {
        try {
            Document document = null;
            if (this.isNull((Object)fileName)) {
                document = this.documentService.writeExcel((List)JSON.parseObject((String)data, List.class));
                this.sendFile((InputStream)new ByteArrayInputStream(document.getContent()), response, document.getFileName());
            } else {
                document = this.documentService.writeExcel((Map)JSON.parseObject((String)data, Map.class), fileName);
                this.sendFile((InputStream)new ByteArrayInputStream(document.getContent()), response, document.getFileName());
            }
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("doc.excel.export.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/export/excel/gzqyd"})
    public void export2ExcelGZQ(@RequestParam(value="data") String data, @RequestParam(value="fileName", required=true) String fileName, HttpServletResponse response) {
        try {
            Document document = null;
            document = this.documentService.writeExcelGZQFX((List)JSON.parseObject((String)data, List.class), fileName);
            this.sendFile((InputStream)new ByteArrayInputStream(document.getContent()), response, document.getFileName());
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("doc.excel.export.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/rest/export"})
    @ResponseBody
    public void exportMap(@RequestParam(value="where", required=true) String where, @RequestParam(value="scale", required=false) String scale, @RequestParam(value="width", defaultValue="800") int width, @RequestParam(value="height", defaultValue="600") int height, @RequestParam(value="type", required=true) String type, HttpServletResponse response) {
        try {
            InputStream inputStream = this.gisManager.getGISService().exportMap(where, scale, width, height, type);
            this.sendFile(inputStream, response, String.valueOf(System.currentTimeMillis()));
        }
        catch (IOException e) {
            throw new JSONMessageException(this.getMessage("map.export.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/bj/upload"})
    @ResponseBody
    public void bjUpload(@RequestParam(value="file") MultipartFile file, HttpServletResponse response) {
        try {
            this.result((Object)this.gisManager.getGeoService().getBJCoordinates(file.getInputStream()), response);
        }
        catch (Exception e) {
            this.error(this.getMessage("bj.upload.error", new Object[]{file.getOriginalFilename(), e.getLocalizedMessage()}), response);
        }
    }

    @RequestMapping(value={"/excel/upload"})
    @ResponseBody
    public void xlsUpload(@RequestParam(value="file") MultipartFile file, HttpServletResponse response) {
        try {
            this.result((Object)this.gisManager.getGeoService().getExcelCoordinates(file.getInputStream()), response);
        }
        catch (Exception e) {
            this.error(this.getMessage("bj.upload.error", new Object[]{file.getOriginalFilename(), e.getLocalizedMessage()}), response);
        }
    }

    @RequestMapping(value={"/shp/upload"})
    @ResponseBody
    public Map shpUpload(@RequestParam(value="file", required=false) MultipartFile file, @RequestParam(value="layerName") String layerName, @RequestParam(value="check", required=false, defaultValue="true") Boolean check, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            String geometry = this.gisManager.getGeoService().getShpCoordinates(file.getInputStream());
            return this.result((Object)this.gisManager.getGISService().insert2(layerName, geometry, check.booleanValue(), dataSource));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/shp/file/upload"})
    @ResponseBody
    public Map shpfileUpload(@RequestParam(value="file", required=true) String filePath, @RequestParam(value="layerName") String layerName, @RequestParam(value="check", required=false, defaultValue="true") Boolean check, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            File zipFile = new File(filePath);
            if (zipFile.exists()) {
                String geometry = this.gisManager.getGeoService().getShpCoordinates2(zipFile);
                return this.result((Object)this.gisManager.getGISService().insert2(layerName, geometry, check.booleanValue(), dataSource));
            }
            throw new JSONMessageException(this.getMessage("file.exist.error", new Object[0]));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/json/format"})
    @ResponseBody
    public String formatJSON(@RequestParam(value="json") String json, @RequestParam(value="pretty", defaultValue="true") boolean pretty) {
        try {
            return JSON.toJSONString((Object)JSON.parseObject((String)json), (boolean)pretty);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("json.format.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/jsoneditor"})
    public String jsonEditor() {
        return "jsoneditor";
    }
}

