/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.support.arcsde.impl;

import cn.gtmap.onemap.platform.event.GISDaoException;
import cn.gtmap.onemap.platform.support.arcsde.ArcSDEPoolableConnectionFactory;
import cn.gtmap.onemap.platform.support.arcsde.SDEDataSource;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeError;
import com.esri.sde.sdk.client.SeException;
import java.sql.SQLException;
import javax.annotation.PostConstruct;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ArcSDEDataSource
extends BasicDataSource
implements SDEDataSource {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private String server;
    private String instance;
    private ArcSDEPoolableConnectionFactory factory;
    private volatile GenericObjectPool pool;

    @PostConstruct
    private void createSdeDataSource() {
        this.createSdePoolFactory();
        this.createSeConnectionPool();
        try {
            for (int i = 0; i < this.initialSize; ++i) {
                this.pool.addObject();
            }
        }
        catch (SeException ex) {
            this.logger.error("ArcSDE\u8fde\u63a5\u5f02\u5e38\u3010{}\u3011", (Object)GISDaoException.formateSeError((SeError)ex.getSeError()));
        }
        catch (Exception e) {
            this.logger.error("\u521b\u5efaArcSDE\u6570\u636e\u6e90\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
    }

    private void createSdePoolFactory() {
        this.factory = new ArcSDEPoolableConnectionFactory(this);
    }

    public SeConnection getSeConnection() throws Exception {
        SeConnection seConnection = null;
        try {
            this.logger.info(" pool : num active [{}], num idle [{}]", (Object)this.pool.getNumActive(), (Object)this.pool.getNumIdle());
            seConnection = (SeConnection)this.pool.borrowObject();
            return seConnection;
        }
        catch (SeException e) {
            throw new RuntimeException(GISDaoException.formateSeError((SeError)e.getSeError()));
        }
        catch (Exception e) {
            Assert.notNull(seConnection, (String)"\u672a\u6b63\u5e38\u83b7\u53d6ArcSDE\u8fde\u63a5\uff01".concat(this.toString()));
            if (seConnection != null) {
                this.pool.invalidateObject(seConnection);
            }
            this.logger.error("\u83b7\u53d6ArcSDE\u6570\u636e\u8fde\u63a5\u51fa\u73b0\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
            throw new RuntimeException("ArcSDE DataSource get SeConnection error");
        }
    }

    public void returnSeConnection(SeConnection connection) {
        if (connection != null) {
            try {
                this.pool.returnObject((Object)connection);
            }
            catch (Exception e) {
                this.logger.error(" return SeConnection error :[{}]", (Object)e.getLocalizedMessage());
            }
        }
    }

    private void createSeConnectionPool() {
        GenericObjectPool gop = null;
        gop = new GenericObjectPool((PoolableObjectFactory)this.factory);
        gop.setLifo(true);
        gop.setMaxActive(this.maxActive);
        gop.setMaxIdle(this.maxIdle);
        gop.setMinIdle(this.minIdle);
        gop.setMaxWait(this.maxWait);
        if (!this.testOnBorrow) {
            // empty if block
        }
        gop.setTestOnBorrow(true);
        gop.setTestOnReturn(false);
        gop.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis > 0L ? this.timeBetweenEvictionRunsMillis : 30000L);
        gop.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        gop.setMinEvictableIdleTimeMillis(this.minEvictableIdleTimeMillis > 0L ? this.minEvictableIdleTimeMillis : 300000L);
        gop.setTestWhileIdle(false);
        if (this.maxWait > 0L) {
            gop.setWhenExhaustedAction((byte)1);
        } else {
            gop.setWhenExhaustedAction((byte)0);
        }
        this.pool = gop;
    }

    public synchronized void close() throws SQLException {
        try {
            this.pool.clear();
            this.pool.close();
        }
        catch (Exception e) {
            this.logger.error("\u5173\u95ed\u8fde\u63a5\u6c60\u5f02\u5e38\u3010{}\u3011", (Object)e.getLocalizedMessage());
        }
        super.close();
    }

    public String toString() {
        return "ArcSDE " + this.getServer().concat(":").concat(String.valueOf(this.getInstance())).concat("/" + this.getUsername());
    }

    public String getServer() {
        return this.server;
    }

    public void setServer(String server) {
        this.server = server;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }
}

