<#---->
<#assign _btype = btype>
<#assign _type = type!>
<#assign _id= id!>
<#assign _title = "界址点导入">
<#if _btype=="bmc"><#assign _title="勘测定界地块关联"></#if>
<@core.simple title=_title>

<div class="navbar navbar-default navbar-fixed-top">
    <div class="navbar-inner">
        <div class="container">
            <a class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
                <span class="icon-bar"></span>
            </a>
            <a class="brand" href="#">${_title}</a>

            <div class="nav-collapse collapse navbar-responsive-collapse">
                <ul class="nav pull-right">
                    <li <#if _btype=="bmi"> class="active"</#if>><a
                            href="${springMacroRequestContext.requestUri}?btype=bmi">界址点</a></li>
                    <li <#if _btype=="bmc"> class="active"</#if>><a
                            href="${springMacroRequestContext.requestUri}?btype=bmc">勘测定界</a></li>
                </ul>
            </div>

        </div>
    </div>
</div>

<div class="hero-unit">

    <p class="text-center">
        <a id="_import" class="btn btn-primary btn-large btn-danger" data-rel="tooltip"
           title="支持Excel坐标格式 及 文本坐标格式">导入坐标</a>
    </p>

    <form id="uploadForm" class="text-center" enctype="multipart/form-data" method="post"
          action="${springMacroRequestContext.requestUri}/coords" accept-charset="[UTF-8]">
        <input name="fileType" type="hidden">
        <input name="fileData" id="_file" type="file"
               accept="application/vnd.ms-excel,text/plain,application/vnd.openxmlformats-officedocument.spreadsheetml.sheet"
               style="display: none">
    </form>

    <div class="row">
        <div class="page-header">
            <h3>坐标串</h3>
        </div>
        <div>
            <table class="table table-striped table-bordered table-hover">
                <thead>
                <tr>
                    <th>多边形号</th>
                    <th>点号</th>
                    <th>地块圈号</th>
                    <th>X</th>
                    <th>Y</th>
                </tr>
                </thead>
                <tbody id="coords_content">
                </tbody>
            </table>
        </div>
    </div>

    <#if _btype=="bmi">
        <p class="text-center" style="margin-top:20px">
            <a id="_generate" class="btn btn-primary btn-large" data-rel="tooltip"
               title="将图形生成至指定图层中">生成图形</a>
        </p>
    </#if>

</div>

    <#if _btype=="bmc">
    <div class="row">
        <div class="span6">
            <h2>待选地块</h2>

            <div class="well">
                <form id="searchForm" class="form-search">
                    <input class="input-medium search-query" placeholder="检索地块" type="text">
                    <a id="dkSearch" class="btn btn-warning" style="margin-left: 10px">检索</a>
                </form>
                <table class="table table-striped table-bordered table-hover">
                    <tr class="success">
                        <th style="width: 100px">#</th>
                        <th>地块名称</th>
                    </tr>
                    <tbody id="_dk_content"/>
                    <tfoot>
                    <tr>
                        <td colspan="3">
                            <div class="pagination text-center" id="_pagination"/>
                        </td>
                    </tr>
                    </tfoot>
                </table>
            </div>

        </div>

        <div class="span6">
            <h2>已选地块</h2>

            <div class="well">
                <table>

                </table>
            </div>

            <p class=" text-center"><a class="btn btn-primary btn-large" href="#">关联已选地块</a></p>
        </div>


        <br/>
        <br/>

    <#-- <footer>
         <p>&copy; Company 2012</p>
     </footer>-->

    </div>
    </#if>
<hr>
<div data-alerts="alerts" data-fade="10000" data-ids="_alert" data-titles="{'warning':'<strong>异常警告！</strong>'}"/>
<ul class="scroll-to">
    <li><a href="#" class="scroll-arrow-up" data-rel="tooltip" title="滚动至顶部"></a></li>
    <li><a href="#" class="scroll-arrow-down" data-rel="tooltip" title="滚动至底部"></a></li>
</ul>
    <@core.script name="resources/js/plugins/jquery.form.js"/>
<script type="text/javascript">

    var coords = [], dks = [];

    $(function () {

        $('p a[data-rel=tooltip]').tooltip({placement: "bottom"});
        $('li a[data-rel=tooltip]').tooltip({placement: "top"});

        $('#_import').click(function () {
            $('#_file').click();
        });

        $('#_file').change(function () {
            //var _m = /(?<=\.)\w+$/.exec($('#_file').val()); // not support by js
            var _m = $('#_file').val().split('.').reverse();
            $('#uploadForm input[name="fileType"]').val(_m.length > 0 ? _m[0] : null);
            $('#uploadForm').submit();
        });

        $('#uploadForm').submit(function () {
            $.info("正在上传并解析坐标串");
            $(this).ajaxSubmit({
                success: function (_r) {
                    debugger;
                    if (_r.constructor == Array) {
                        if (_r.length == 0)
                            $.warning('文档未能解析出具体坐标，请核查坐标文件格式是否正确！');
                        coords = _r;
                        $('#coords_content').html('');
                        $.each(_r, function (_i, _v) {
                            $('#coords_content').append('<tr class="success"><td style="text-align: center!important;" colspan="5">#' + (_i + 1) + '<br/></td></tr>')
                            $.each(_v, function (__i, __v) {
                                $('#coords_content').append('<tr><td><a>' + (_i + 1) + '</a></td><td>' + __v.no + '</td><td>' + __v.rno + '</td><td>' + __v.y + '</td><td>' + __v.x + '</td></tr>');
                            });
                        });
                    } else if (_r.success == false) {
                        $.warning(_r.msg);
                    }
                    return false;
                },
                type: 'post',
                dataType: 'json'
            });
            return false;
        });

        <#if _btype=="bmi">

            $('#_generate').click(function () {
                $.info("正在将图斑生成至图层中");
                $.ajax({
                    url: "${springMacroRequestContext.requestUri}/gen",
                    type: "POST",
                    data: {id: '${_id!}', type: '${_type!}', coords: JSON.stringify(coords)}
                }).done(function (_r) {
                            //
                            debugger;
                            if (_r && _r.success == false)
                                $.warning(_r.msg);
                            else
                                $.info("界址点上传成功！");
                            $.scrollToBottom();
                        }).fail(function () {
                            $.warning(arguments[2]);
                        })

            });

        </#if>

        <#if _btype=="bmc">

            $.getDK = function () {
                $.ajax({
                    url: "${springMacroRequestContext.requestUri}/dks",
                    type: "POST",
                    data: {key: arguments[0], type: '${_type}'}
                }).done(function (_r) {
                            debugger;
                            if (_r.constructor == Array) {
                                dks = _r;
                                $.bindPagination();
                            } else {
                                $.warning(_r.msg);
                            }
                        })
                        .fail(function () {
                            debugger;
                            alert(arguments[2]);
                        });
            };

            $('#searchForm').submit(function () {
                $.getDK($('#searchForm input').val());
                return false;
            });

            $('#dkSearch').click(function () {
                $.getDK($('#searchForm input').val());
            });

            $.bindPagination = function () {
                $('#_pagination').pagination(dks.length, {
                    current_page: 0,
                    items_per_page: 10,
                    num_display_entries: 3,
                    load_first_page: true,
                    callback: function (_pid) {
                        $('#_dk_content').html('');
                        for (var i = 0; i < 10; i++) {
                            if (dks[_pid * 10 + i])
                                $('#_dk_content').append('<tr><td>' + (_pid * 10 + i) + '</td><td>' + dks[_pid * 10 + i].name + '</td><input type="hidden" value="222"></tr>');
                        }
                    },
                    prev_text: "上一页",
                    next_text: "下一页"
                });
            };
            $.getDK();

        </#if>

        $.warning = function (msg) {
            $.globalMessenger().post({
                message: msg,
                type: 'error'
            });
        };
        $.info = function (msg) {
            $.globalMessenger().post({
                message: msg,
                scrollTo: true,
                hideAfter: 2
            });
        };

    })
    ;
</script>
</@core.simple>