/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.model.MapGroup;
import cn.gtmap.onemap.model.Region;
import cn.gtmap.onemap.platform.dao.TplDao;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.service.WebMapService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.service.MetadataService;
import cn.gtmap.onemap.service.RegionService;
import com.google.common.collect.Lists;
import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class WebMapServiceImpl
extends BaseLogger
implements WebMapService {
    @Autowired
    private TplDao tplDao;
    @Autowired
    private GeometryService geometryService;
    @Autowired
    private RegionService regionService;
    @Autowired
    private MetadataService metadataService;

    public Configuration getConfig(String tplName) {
        return this.tplDao.getConfiguration(tplName);
    }

    @Cacheable(value={"regionCache"}, key="#regionCode + #crs")
    public Map<String, Object> getRegionInfo(String regionCode, String crs) {
        Region region = this.regionService.getRegion(regionCode);
        if (this.isNull((Object)region)) {
            throw new RuntimeException(this.getMessage("region.code.not.set", new Object[0]));
        }
        Map result = this.regionToMap(region, crs);
        ArrayList child = Lists.newArrayList();
        List regions = this.regionService.getChildrenRegions(regionCode, false);
        for (Region item : regions) {
            child.add(this.regionToMap(item, crs));
        }
        result.put("children", child);
        return result;
    }

    private Map<String, Object> regionToMap(Region region, String sr) {
        String geometry = "";
        try {
            if (StringUtils.isNotBlank((String)sr)) {
                Object geoFeature;
                CoordinateReferenceSystem toCrs = this.geometryService.parseUndefineSR(sr);
                if (StringUtils.isNotBlank((String)region.getGeometry()) && (geoFeature = this.geometryService.readUnTypeGeoJSON(region.getGeometry())) instanceof SimpleFeature) {
                    SimpleFeature feature = (SimpleFeature)geoFeature;
                    CoordinateReferenceSystem crs = feature.getFeatureType().getCoordinateReferenceSystem();
                    Geometry geo = this.geometryService.project((Geometry)feature.getDefaultGeometry(), crs, toCrs);
                    geometry = geo.toText();
                }
            } else {
                geometry = region.getGeometry();
            }
        }
        catch (Exception e) {
            this.logger.warn(this.getMessage("parse.coords.error", new Object[]{e.getLocalizedMessage()}));
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("id", region.getId());
        map.put("name", region.getId());
        map.put("title", region.getName());
        map.put("value", geometry);
        map.put("children", null);
        return map;
    }

    public List<cn.gtmap.onemap.platform.entity.Service> getAllServices(String tplName) {
        return this.tplDao.getAllServices(tplName);
    }

    @Cacheable(value={"serviceCache"}, key="#tplName + #mode.name()")
    public List getServicesWithClassify(String tplName, WebMapService.SC_MODE mode) {
        List groups = this.metadataService.getChildrenMapGroups(null, true);
        List serviceList = this.getAllServices(tplName);
        Collections.sort(serviceList);
        return this.attachService2Group(groups, serviceList, mode);
    }

    private List<Map<String, Object>> attachService2Group(List<MapGroup> groups, List<cn.gtmap.onemap.platform.entity.Service> services, WebMapService.SC_MODE mode) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (MapGroup group : groups) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("id", group.getId());
            item.put("name", group.getName());
            item.put("visible", false);
            ArrayList children = new ArrayList();
            List service = this.getServiceByGroup(group.getId(), services);
            if (service.size() > 0) {
                children.addAll(service);
            } else if (group.getChildren().size() == 0 && WebMapService.SC_MODE.SIMPLIFY.equals((Object)mode)) continue;
            if (group.getChildren() != null && group.getChildren().size() > 0) {
                children.addAll(this.attachService2Group(group.getChildren(), services, mode));
            }
            if (WebMapService.SC_MODE.SIMPLIFY.equals((Object)mode) && children.size() == 0) continue;
            item.put("children", children.size() > 0 ? children : null);
            list.add(item);
        }
        return list;
    }

    private List<cn.gtmap.onemap.platform.entity.Service> getServiceByGroup(String groupId, List<cn.gtmap.onemap.platform.entity.Service> services) {
        ArrayList<cn.gtmap.onemap.platform.entity.Service> serviceList = new ArrayList<cn.gtmap.onemap.platform.entity.Service>();
        for (cn.gtmap.onemap.platform.entity.Service service : services) {
            if (!groupId.equals(service.getGroup())) continue;
            serviceList.add(service.clearFunction());
        }
        return serviceList;
    }

    @CacheEvict(value={"serviceCache"}, allEntries=true)
    public boolean clearServiceCache(String tpl) {
        return true;
    }

    @CacheEvict(value={"regionCache"}, allEntries=true)
    public boolean clearRegionCache() {
        return true;
    }
}

