/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.event.SearchException;
import cn.gtmap.onemap.platform.service.GISManager;
import cn.gtmap.onemap.platform.service.SearchService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.service.impl.SearchServiceImpl;
import com.alibaba.fastjson.JSON;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NRTCachingDirectory;
import org.apache.lucene.util.Version;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;

public class SearchServiceImpl
extends BaseLogger
implements SearchService {
    private static final String SHAPE = "SHAPE";
    private static final int LIMIT = 100;
    @Autowired
    private GISManager gisManager;
    private Directory directory = null;
    private Analyzer analyzer = null;
    private IndexReader reader = null;
    private IndexSearcher searcher = null;
    private Resource indexDir;
    private Resource stopWord;
    private int maxCacheSize = 128;
    private Map config;
    private boolean update = true;
    private boolean useRamDir = false;
    private String[] fields = new String[]{S.title.name(), S.subtitle.name(), S.group.name()};

    @PostConstruct
    private void init() {
        try {
            this.analyzer = new StandardAnalyzer(Version.LUCENE_44, (Reader)new FileReader(this.stopWord.getFile()));
        }
        catch (IOException e) {
            this.analyzer = new StandardAnalyzer(Version.LUCENE_44);
            this.logger.trace(" stopword.txt not found ");
        }
        if (this.update) {
            this.createIndex();
        }
    }

    public boolean createIndex() {
        this.logger.info("start create search index -- time : [{}]", (Object)new Date().toString());
        try {
            FSDirectory fsDirectory = FSDirectory.open((File)this.indexDir.getFile());
            this.directory = this.useRamDir ? new NRTCachingDirectory((Directory)fsDirectory, 10.0, (double)this.maxCacheSize) : fsDirectory;
            IndexWriterConfig config = new IndexWriterConfig(Version.LUCENE_44, this.analyzer);
            config.setMaxThreadStates(20);
            config.setRAMBufferSizeMB((double)this.maxCacheSize);
            config.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
            IndexWriter writer = new IndexWriter(this.directory, config);
            this.inportLayers(writer);
            writer.close();
            this.logger.info("create index success -- time : [{}]", (Object)new Date().toString());
            return true;
        }
        catch (Exception e) {
            this.logger.error("create index error [{}]", (Object)e.getLocalizedMessage());
            return false;
        }
    }

    private void inportLayers(IndexWriter writer) {
        if (this.config == null) {
            this.logger.info("\u65e0\u5feb\u901f\u68c0\u7d22\u914d\u7f6e\u4fe1\u606f");
            return;
        }
        List layers = (List)this.config.get("layers");
        for (Map layer : layers) {
            String layerName = (String)layer.get("layer");
            String[] fields = ((String)layer.get("fields")).split(",");
            String id = (String)layer.get(S.id.name());
            String title = (String)layer.get(S.title.name());
            String subtitle = (String)layer.get(S.subtitle.name());
            String group = (String)layer.get(S.group.name());
            String link = (String)layer.get(S.link.name());
            String ds = (String)layer.get("dataSource");
            this.logger.info("start create index by layer :[{}]", (Object)layerName);
            try {
                List results = this.gisManager.getGISService().query(layerName, "OBJECTID > 0", fields, true, ds);
                Document doc = null;
                for (Map result : results) {
                    doc = new Document();
                    doc.add((IndexableField)new TextField(S.id.name(), this.entityValue2String(result.get(id)), Field.Store.YES));
                    doc.add((IndexableField)new TextField(S.title.name(), this.entityValue2String(result.get(title)), Field.Store.YES));
                    doc.add((IndexableField)new TextField(S.subtitle.name(), this.entityValue2String(result.get(subtitle)), Field.Store.YES));
                    doc.add((IndexableField)new TextField(S.shape.name(), this.entityShapeValue(result.get(SHAPE)), Field.Store.YES));
                    ArrayList<String> content = new ArrayList<String>();
                    for (Map.Entry e : result.entrySet()) {
                        Map.Entry entry = e;
                        if (entry.getKey().equals(id) || entry.getKey().equals(title) || entry.getKey().equals(subtitle) || entry.getKey().equals(SHAPE)) continue;
                        content.add(this.entityValue2String(entry.getValue()));
                    }
                    doc.add((IndexableField)new TextField(S.content.name(), StringUtils.join((Object[])content.toArray(new String[0]), (String)" "), Field.Store.YES));
                    doc.add((IndexableField)new TextField(S.group.name(), group, Field.Store.YES));
                    doc.add((IndexableField)new StringField(S.link.name(), link, Field.Store.YES));
                    try {
                        writer.addDocument((Iterable)doc, this.analyzer);
                    }
                    catch (IOException e1) {
                        this.logger.error("document write error [{}]", (Object)e1.getLocalizedMessage());
                    }
                }
                writer.commit();
                this.logger.info(" [{}] records has added to index", (Object)writer.numDocs());
            }
            catch (Exception e) {
                this.logger.error("layer [{}] create index error, error detail [{}] ", (Object)layerName, (Object)e.getLocalizedMessage());
            }
        }
        System.gc();
    }

    private Field entry2Field(Map.Entry entry) {
        Object value = entry.getValue();
        if (value instanceof Integer) {
            return new IntField((String)entry.getKey(), Integer.valueOf((String)value).intValue(), Field.Store.YES);
        }
        if (value instanceof Float) {
            return new FloatField((String)entry.getKey(), Float.valueOf(String.valueOf(value)).floatValue(), Field.Store.YES);
        }
        if (value instanceof Double) {
            return new DoubleField((String)entry.getKey(), Double.valueOf(String.valueOf(value)).doubleValue(), Field.Store.YES);
        }
        if (value instanceof Calendar) {
            return new LongField((String)entry.getKey(), ((Calendar)value).getTimeInMillis(), Field.Store.YES);
        }
        if (entry.getKey().equals(SHAPE)) {
            return new StringField((String)entry.getKey(), String.valueOf(value), Field.Store.YES);
        }
        return new TextField((String)entry.getKey(), String.valueOf(value), Field.Store.YES);
    }

    private String entityValue2String(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return String.valueOf(value);
    }

    private String entityShapeValue(Object value) {
        if (value instanceof String) {
            Geometry geometry = this.gisManager.getGeoService().forceSimplify(this.gisManager.getGeoService().readWKT((String)value), this.gisManager.getGeoService().getSimplifyTolerance());
            return this.gisManager.getGeoService().toGeoJSON(geometry);
        }
        return String.valueOf(value);
    }

    public List search(String value, int limit, boolean simple) throws SearchException {
        if (limit < 1) {
            limit = 100;
        }
        ArrayList<Map> results = new ArrayList<Map>();
        MultiFieldQueryParser parser = new MultiFieldQueryParser(Version.LUCENE_44, this.fields, this.analyzer);
        parser.setDefaultOperator(QueryParser.AND_OPERATOR);
        Query query = null;
        try {
            query = parser.parse(value);
        }
        catch (ParseException e) {
            throw new SearchException(SearchException.Type.PARSE_QUERY, e.getLocalizedMessage());
        }
        try {
            ScoreDoc[] hits;
            if (this.reader == null) {
                this.reader = DirectoryReader.open((Directory)(this.directory != null ? this.directory : FSDirectory.open((File)this.indexDir.getFile())));
            }
            if (this.searcher == null) {
                this.searcher = new IndexSearcher(this.reader);
            }
            TopDocs docs = this.searcher.search(query, limit);
            for (ScoreDoc hit : hits = docs.scoreDocs) {
                results.add(this.doc2Map(this.searcher.doc(hit.doc), simple));
            }
        }
        catch (IOException e) {
            throw new SearchException(SearchException.Type.INDEX_DIR, e.getLocalizedMessage());
        }
        return results;
    }

    public String[] groups() {
        List layers = (List)this.config.get("layers");
        ArrayList<String> groups = new ArrayList<String>();
        for (Map item : layers) {
            groups.add((String)item.get("group"));
        }
        return groups.toArray(new String[0]);
    }

    private Map doc2Map(Document doc, boolean simple) {
        HashMap<String, String> map = new HashMap<String, String>();
        String name = null;
        for (IndexableField field : doc.getFields()) {
            name = field.name();
            if (simple && (name.equals(S.content.name()) || name.equals(S.group.name()) || name.equals(S.shape.name()) || name.equals(S.link.name()))) continue;
            map.put(field.name(), field.stringValue());
        }
        return map;
    }

    public void setIndexDir(Resource indexDir) {
        this.indexDir = indexDir;
        try {
            if (!indexDir.exists()) {
                indexDir.getFile().mkdirs();
            }
        }
        catch (IOException e) {
            this.logger.error("create index directory error [{}]", (Object)e.getLocalizedMessage());
        }
    }

    public void setMaxCacheSize(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void setConfig(Resource path) {
        try {
            this.config = (Map)JSON.parseObject((String)IOUtils.toString((URI)path.getURI(), (String)"utf-8"), Map.class);
        }
        catch (IOException e) {
            this.logger.error(" search config can't found ");
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("search.config.file.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public void setStopWord(Resource stopWord) {
        this.stopWord = stopWord;
    }

    @PreDestroy
    private void destory() {
        try {
            if (this.reader != null) {
                this.reader.close();
            }
            if (this.directory != null) {
                this.directory.close();
            }
        }
        catch (IOException e) {
            this.logger.error("close index reader error [{}]", (Object)e.getLocalizedMessage());
        }
        System.gc();
    }

    public void setUpdate(boolean enable) {
        this.update = enable;
    }

    public void setUseRamDir(boolean useRamDir) {
        this.useRamDir = useRamDir;
    }
}

