/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.event.GeometryServiceException;
import cn.gtmap.onemap.platform.service.GISManager;
import cn.gtmap.onemap.platform.utils.GeometryUtils;
import cn.gtmap.onemap.platform.utils.SRTransformations;
import cn.gtmap.onemap.service.GeoService;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.util.List;
import java.util.Map;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;

public class GeoServiceImpl
implements GeoService {
    protected static final String SE_OBJECTID_FIELD = "OBJECTID";
    @Autowired
    private GISManager gisManager;

    public List query(String layerName, String where, String[] outFields, boolean returnGeometry, String dataSource) {
        try {
            return this.gisManager.getGISService().query(layerName, where, outFields, returnGeometry, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(" query error , detail : " + e.getLocalizedMessage());
        }
    }

    public List query(String layerName, Geometry geometry, String[] outFields, String dataSource) {
        try {
            return this.gisManager.getGISService().query(layerName, geometry, outFields, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(" query error , detail : " + e.getLocalizedMessage());
        }
    }

    public List query(String layerName, String geometry, String[] outFields, String dataSource) {
        try {
            return this.gisManager.getGISService().query(layerName, this.gisManager.getGeoService().readGeoJSON(geometry), outFields, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(" query error , detail : " + e.getLocalizedMessage());
        }
    }

    public String insert(String layerName, String feature, String dataSource) {
        try {
            return this.gisManager.getGISService().insert(layerName, feature, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(" insert error , detail : " + e.getLocalizedMessage());
        }
    }

    public boolean update(String layerName, String where, String feature, String dataSource) {
        List list = this.query(layerName, where, null, true, dataSource);
        for (int i = 0; i < list.size(); ++i) {
            Map item = (Map)list.get(i);
            String primaryKey = String.valueOf(item.get(SE_OBJECTID_FIELD));
            if (this.gisManager.getGISService().update(layerName, primaryKey, feature, dataSource)) continue;
            return false;
        }
        return true;
    }

    public boolean delete(String layerName, String where, String dataSource) {
        List list = this.query(layerName, where, null, true, dataSource);
        for (int i = 0; i < list.size(); ++i) {
            Map item = (Map)list.get(i);
            String primaryKey = String.valueOf(item.get(SE_OBJECTID_FIELD));
            if (this.gisManager.getGISService().delete(layerName, primaryKey, dataSource)) continue;
            return false;
        }
        return true;
    }

    public String intersect(String layerName, String geometry, String outFields, String dataSource) {
        String[] fields = "*".equals(outFields) ? null : outFields.split(",");
        List results = this.gisManager.getGISService().intersect2(layerName, geometry, fields, dataSource);
        FeatureCollection collection = this.gisManager.getGeoService().list2FeatureCollection(results, null, null);
        return this.toFeatureJSON((Object)collection);
    }

    public List intersect(String layerName, Geometry geometry, String[] outFields, String dataSource) {
        try {
            return this.gisManager.getGISService().intersect(layerName, geometry, outFields, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public Map tdghsc(String year, String geometry, String outFields, String dataSource) {
        String[] fields = "*".equals(outFields) ? null : outFields.split(",");
        return this.gisManager.getGISService().tdghscResult(this.gisManager.getGISService().tdghscAnalysis2(year, geometry, fields, dataSource));
    }

    public Map tdlyxz(String dltbLayerName, String xzdwLayerName, String geometry, String dataSource) {
        return this.gisManager.getGISService().tdlyxzAnalysis2(dltbLayerName, xzdwLayerName, geometry, dataSource);
    }

    public Object readGeoJSON(String geoJSON) {
        return GeometryUtils.parseGeoJSON((String)geoJSON);
    }

    public Geometry readWKT(String wkt) {
        try {
            return this.gisManager.getGeoService().readWKT(wkt);
        }
        catch (Exception e) {
            throw new RuntimeException(" readWKT error , detail : " + e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem readCRS(String crs) {
        return this.gisManager.getGeoService().readFeatureJSONCRS(crs);
    }

    public CoordinateReferenceSystem parseUndefineSR(String sr) {
        return this.gisManager.getGeoService().parseUndefineSR(sr);
    }

    public String toFeatureJSON(Object feature) {
        return this.gisManager.getGeoService().toFeatureJSON(feature);
    }

    public String toGeoJSON(Object geometry) {
        if (geometry instanceof Geometry) {
            return this.gisManager.getGeoService().toGeoJSON((Geometry)geometry);
        }
        if (geometry instanceof SimpleFeature) {
            return this.toFeatureJSON(geometry);
        }
        if (geometry instanceof FeatureCollection) {
            return this.toFeatureJSON(geometry);
        }
        throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOMETRY_TO_JSON_EXCEPTION, "geometry not be supported");
    }

    public Geometry project(Geometry geometry, String sourceCrs, String targetCrs) {
        try {
            return SRTransformations.project((Geometry)geometry, (String)sourceCrs, (String)targetCrs);
        }
        catch (PeProjectionException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.PROJECT_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Geometry project(Geometry geometry, int inSR, int outSR) {
        return this.gisManager.getGeoService().project(geometry, this.readCRS(String.valueOf(inSR)), this.readCRS(String.valueOf(outSR)));
    }

    public Geometry simplify(Geometry geometry, double tolerance) {
        return geometry.isValid() && geometry.isSimple() ? geometry : DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)tolerance);
    }

    public TopologyValidationError validGeometry(Geometry geometry) {
        IsValidOp isValidOp = new IsValidOp(geometry);
        return isValidOp.getValidationError();
    }

    public String map2SimpleFeature(Map<String, Object> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        return this.toFeatureJSON((Object)this.gisManager.getGeoService().map2SimpleFeature(value, srcCRS, destCRS));
    }

    public String list2FeatureCollection(List<Map<String, Object>> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        try {
            return this.toFeatureJSON((Object)this.gisManager.getGeoService().list2FeatureCollection(value, srcCRS, destCRS));
        }
        catch (Exception e) {
            throw new RuntimeException(" list values to featureCollection error , detail : " + e.getLocalizedMessage());
        }
    }

    public Map<String, Object> simpleFeature2Map(SimpleFeature feature) {
        return this.gisManager.getGeoService().simpleFeature2Map(feature);
    }

    public CoordinateReferenceSystem getCrsByCoordXD(double x) {
        return this.gisManager.getGeoService().getCrsByCoordXD(x);
    }
}

