/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.service.AgsGeoemtryService;
import com.esri.core.geometry.Geometry;
import com.esri.core.geometry.GeometryEngine;
import com.esri.core.geometry.Operator;
import com.esri.core.geometry.OperatorExportToGeoJson;
import com.esri.core.geometry.OperatorFactoryLocal;
import com.esri.core.geometry.OperatorImportFromESRIShape;
import com.esri.core.geometry.OperatorSimplify;
import com.esri.core.geometry.SpatialReference;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.commons.io.IOUtils;
import org.springframework.stereotype.Service;

@Service
public class AgsGeometryServiceImpl
implements AgsGeoemtryService {
    public String intersection(String inputGeometry, String intersector, String sr) {
        Geometry resultGeoemtry;
        Geometry tmpGeo1 = GeometryEngine.geometryFromWkt((String)inputGeometry, (int)0, (Geometry.Type)Geometry.Type.Unknown);
        Geometry tmpGeo2 = GeometryEngine.geometryFromWkt((String)intersector, (int)0, (Geometry.Type)Geometry.Type.Unknown);
        SpatialReference spatialReference = SpatialReference.create((String)sr);
        OperatorFactoryLocal factory = OperatorFactoryLocal.getInstance();
        OperatorSimplify operatorSimplify = (OperatorSimplify)factory.getOperator(Operator.Type.Simplify);
        if (!operatorSimplify.isSimpleAsFeature(tmpGeo1, spatialReference, null)) {
            // empty if block
        }
        tmpGeo1 = GeometryEngine.simplify((Geometry)tmpGeo1, (SpatialReference)spatialReference);
        if (!operatorSimplify.isSimpleAsFeature(tmpGeo2, spatialReference, null)) {
            tmpGeo2 = GeometryEngine.simplify((Geometry)tmpGeo2, (SpatialReference)spatialReference);
        }
        return (resultGeoemtry = GeometryEngine.intersect((Geometry)tmpGeo1, (Geometry)tmpGeo2, (SpatialReference)spatialReference)) != null ? GeometryEngine.geometryToWkt((Geometry)resultGeoemtry, (int)0) : "";
    }

    public Double getGeometryArea(String wkt) {
        Geometry geometry = GeometryEngine.geometryFromWkt((String)wkt, (int)0, (Geometry.Type)Geometry.Type.Unknown);
        if (geometry != null) {
            if (geometry.getType().compareTo((Enum)Geometry.Type.Polygon) == 0) {
                return geometry.calculateArea2D();
            }
            return geometry.calculateLength2D();
        }
        return 0.0;
    }

    public boolean validGeometry(String wktGeometry, String sr) {
        try {
            Geometry geo = GeometryEngine.geometryFromWkt((String)wktGeometry, (int)0, (Geometry.Type)Geometry.Type.Unknown);
            OperatorFactoryLocal factory = OperatorFactoryLocal.getInstance();
            OperatorSimplify operatorSimplify = (OperatorSimplify)factory.getOperator(Operator.Type.Simplify);
            return operatorSimplify.isSimpleAsFeature(geo, SpatialReference.create((String)sr), null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public String importShape(File shpFile) {
        FileInputStream fileInputStream = null;
        Object shapeBuffer = null;
        OperatorFactoryLocal factory = OperatorFactoryLocal.getInstance();
        OperatorExportToGeoJson operatorExportToGeoJson = (OperatorExportToGeoJson)factory.getOperator(Operator.Type.ExportToGeoJson);
        try {
            fileInputStream = new FileInputStream(shpFile);
            byte[] bytes = IOUtils.toByteArray((URI)shpFile.toURI());
            OperatorImportFromESRIShape operatorImportFromESRIShape = (OperatorImportFromESRIShape)factory.getOperator(Operator.Type.ImportFromESRIShape);
            Geometry geometry = operatorImportFromESRIShape.execute(0, Geometry.Type.Unknown, ByteBuffer.wrap(bytes).order(ByteOrder.BIG_ENDIAN));
            return geometry == null ? null : operatorExportToGeoJson.execute(geometry);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

