/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.Service;
import cn.gtmap.onemap.platform.entity.ThematicMap;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.ConfigService;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.TplTypeService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/config"})
public class ConfigController
extends BaseController {
    @Autowired
    private TplTypeService tplTypeService;
    @Autowired
    private MapService mapService;
    @Autowired
    private ConfigService configService;

    @RequestMapping
    public String execute() {
        return "config";
    }

    @RequestMapping(value={"/tpls"})
    @ResponseBody
    public List tpls() {
        try {
            return this.configService.getThumbTplInfos();
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("tpl.list.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/thematicmaps"})
    @ResponseBody
    public List<ThematicMap> thematicMaps() {
        try {
            return this.configService.getThematicMaps();
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("thematic.config.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/thematicmaps/delete/{id}"})
    @ResponseBody
    public void deleteThematicMap(@PathVariable(value="id") String id) {
        try {
            Assert.notNull((Object)id);
            this.configService.deleteThematicMap(id);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("thematic.delete.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/thematicmaps/save"}, method={RequestMethod.POST})
    @ResponseBody
    public ThematicMap updateThematicMap(@RequestParam(value="thematicMap") String thematicMap) {
        try {
            return this.configService.updateThematicMap((ThematicMap)JSON.parseObject((String)thematicMap, ThematicMap.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("thematic.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/commonwidgets/all"})
    @ResponseBody
    public List<Configuration.Widget> getCommonWidgets() {
        return this.configService.getCommonWidgets();
    }

    @RequestMapping(value={"/publicwidgets/all"})
    @ResponseBody
    public List<Configuration.Widget> getPublicWidgets() {
        return this.configService.getPublicWidgets();
    }

    @RequestMapping(value={"/publicwidgets/{id}/delete"})
    @ResponseBody
    public void deletePublicWidget(@PathVariable(value="id") String id) {
        try {
            Assert.notNull((Object)id);
            this.configService.deletePublicWidget(id);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("widget.delete.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/publicwidgets/insert"}, method={RequestMethod.POST})
    @ResponseBody
    public void insertPublicWidget(@RequestParam(value="widget") String widget) {
        try {
            this.configService.insertPublicWidget((Configuration.Widget)JSON.parseObject((String)widget, Configuration.Widget.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("widget.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/commonwidgets/{id}/delete"})
    @ResponseBody
    public void deleteCommonWidget(@PathVariable(value="id") String id) {
        try {
            Assert.notNull((Object)id);
            this.configService.deleteCommonWidget(id);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("widget.delete.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/commonwidgets/insert"}, method={RequestMethod.POST})
    @ResponseBody
    public void insertCommonWidget(@RequestParam(value="widget") String widget) {
        try {
            this.configService.insertCommonWidget((Configuration.Widget)JSON.parseObject((String)widget, Configuration.Widget.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("widget.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/create/{tpl}"})
    @ResponseBody
    public Configuration createTpl(@PathVariable(value="tpl") String tpl, @RequestParam(value="name", required=false) String name, @RequestParam(value="description", required=false) String description, @RequestParam(value="thematicMap", required=false) String thematicMap, @RequestParam(value="parentTpl", required=false) String parentTpl) {
        try {
            return this.configService.createTpl(tpl, name, description, thematicMap, parentTpl);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("tpl.new.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/remove/{tpl}"})
    @ResponseBody
    public Object removeTpl(@PathVariable(value="tpl") String tplName) {
        try {
            this.configService.deleteTpl(tplName);
            return this.result((Object)this.getMessage("tpl.remove.ok", new Object[]{tplName}));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("tpl.remove.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/services"})
    @ResponseBody
    public Map servicesList(@PathVariable(value="tpl") String tplName) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("services", this.configService.getAllService(tplName));
            map.put("tpl", tplName);
            return map;
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("services.get.error", new Object[]{tplName}));
        }
    }

    @RequestMapping(value={"/services/all"})
    @ResponseBody
    public Map getAllService() {
        try {
            return this.configService.getAllSevices();
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("config.get.allServices.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/services"})
    @ResponseBody
    public Object getServicesByGroup(@RequestParam(value="groupId", required=false) String groupId) {
        try {
            if (!this.isNull((Object)groupId)) {
                return this.configService.getServicesByGroupId(groupId);
            }
            return this.configService.getAllSevices();
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("config.get.groupService.error", new Object[]{groupId, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/services/groups"})
    @ResponseBody
    public Object getServicesWithClassify(@RequestParam(value="groupId", required=false) String groupId) {
        try {
            if (!this.isNull((Object)groupId)) {
                return this.configService.getServicesByGroupId(groupId);
            }
            return this.configService.getServicesWithClassify();
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("config.get.groupService.error", new Object[]{groupId, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/widgets"})
    @ResponseBody
    public Map getWidgets(@PathVariable(value="tpl") String tplName) {
        try {
            return this.configService.getWidgetCollection(tplName);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("tpl.get.widget.error", new Object[]{tplName, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/service/remove/{ids}"})
    @ResponseBody
    public void deleteService(@PathVariable(value="tpl") String tpl, @PathVariable(value="ids") String ids) {
        Assert.notNull((Object)ids, (String)this.getMessage("id.notnull", new Object[0]));
        try {
            this.configService.deleteServices(tpl, ids.split(","));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("tpl.service.delete.error", new Object[]{tpl, ids}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/service/save"}, method={RequestMethod.POST})
    @ResponseBody
    public void saveService(@PathVariable(value="tpl") String tpl, @RequestParam(value="service") String service) {
        try {
            this.configService.updateService(tpl, (Service)JSON.parseObject((String)service, Service.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("service.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/dict/save"}, method={RequestMethod.POST})
    @ResponseBody
    public Dict saveDict(@PathVariable(value="tpl") String tpl, @RequestParam(value="dict") String dict) {
        try {
            return this.configService.saveDict(tpl, (Dict)JSON.parseObject((String)dict, Dict.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("insert.dict.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/dict/{id}/delete"})
    @ResponseBody
    public void deleteDict(@PathVariable(value="tpl") String tpl, @PathVariable(value="id") String id) {
        try {
            this.configService.deleteDict(tpl, id);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("delete.dictItem.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/services/save"}, method={RequestMethod.POST})
    @ResponseBody
    public void saveServices(@PathVariable(value="tpl") String tpl, @RequestParam(value="services") String services) {
        try {
            this.configService.saveAllServices(tpl, JSON.parseArray((String)services, Service.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("service.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/dockwidget/save"}, method={RequestMethod.POST})
    @ResponseBody
    public Configuration.Widget updateDockWidget(@PathVariable(value="tpl") String tplName, @RequestParam(value="dockWidget") String dockWidget) {
        try {
            return this.configService.updateDockWidget(tplName, (Configuration.Widget)JSON.parseObject((String)dockWidget, Configuration.Widget.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("widget.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/dockwidget/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public void deleteDockWidget(@PathVariable(value="tpl") String tplName, @RequestParam(value="dockWidget") String dockWidget) {
        try {
            this.configService.deleteDockWidget(tplName, (Configuration.Widget)JSON.parseObject((String)dockWidget, Configuration.Widget.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("widget.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/widget/save"}, method={RequestMethod.POST})
    @ResponseBody
    public void updateWidget(@PathVariable(value="tpl") String tplName, @RequestParam(value="widget") String widget) {
        try {
            this.configService.updateWidget(tplName, (Configuration.Widget)JSON.parseObject((String)widget, Configuration.Widget.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("widget.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/widget/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public void deleteWidget(@PathVariable(value="tpl") String tplName, @RequestParam(value="widget") String widget) {
        try {
            this.configService.deleteWidget(tplName, (Configuration.Widget)JSON.parseObject((String)widget, Configuration.Widget.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("widget.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/widgetsgroup/save"}, method={RequestMethod.POST})
    @ResponseBody
    public void updateWidgetGroup(@PathVariable(value="tpl") String tplName, @RequestParam(value="widgetsGroup") String widgetsGroup, @RequestParam(value="widget", required=false) String widget) {
        try {
            this.configService.updateWidgetGroup(tplName, (Configuration.WidgetsGroup)JSON.parseObject((String)widgetsGroup, Configuration.WidgetsGroup.class), (Configuration.Widget)JSON.parseObject((String)widget, Configuration.Widget.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("widget.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/widgetsgroup/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public void deleteWidgetGroup(@PathVariable(value="tpl") String tplName, @RequestParam(value="widgetsGroup") String widgetsGroup, @RequestParam(value="widget", required=false) String widget) {
        try {
            this.configService.deleteWidgetsGroup(tplName, (Configuration.WidgetsGroup)JSON.parseObject((String)widgetsGroup, Configuration.WidgetsGroup.class), (Configuration.Widget)JSON.parseObject((String)widget, Configuration.Widget.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("widget.save.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/global"})
    @ResponseBody
    public Configuration updateGlobalConfiguration(@PathVariable(value="tpl") String tplName, @RequestParam(value="global", required=false) String global) {
        try {
            if (this.isNull((Object)global)) {
                return this.configService.getGlobalConfiguration(tplName);
            }
            return this.configService.updateGlobalConfiguration(tplName, (Configuration)JSON.parseObject((String)global, Configuration.class));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("tpl.global.save.error", new Object[]{tplName, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/map/extent"})
    @ResponseBody
    public Map updateMapInitExtent(@PathVariable(value="tpl") String tplName, @RequestParam(value="extent") String extent) {
        try {
            return this.configService.updateMapInitExtent(tplName, (Map)JSON.parseObject((String)extent, Map.class));
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("tpl.map.extent.error", new Object[]{tplName, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/map/scale"})
    @ResponseBody
    public double updateDefaultScale(@PathVariable(value="tpl") String tplName, @RequestParam(value="scale") double scale) {
        try {
            return this.configService.updateDefaultScale(tplName, scale);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("tpl.map.defaultScale.error", new Object[]{tplName, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/map/lods"})
    @ResponseBody
    public List updateMapLods(@PathVariable(value="tpl") String tplName, @RequestParam(value="lods") String lods) {
        try {
            return this.configService.updateMapLods(tplName, JSON.parseArray((String)lods, Map.class));
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("tpl.map.lods.error", new Object[]{tplName, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/getFields"}, method={RequestMethod.POST})
    @ResponseBody
    public List<Map> getFields(@RequestParam(value="id") String mapId, @RequestParam(value="layerName") String layerName) {
        try {
            return this.configService.getLayerFields(mapId, layerName);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("fields.get.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/tpl/{tpl}/service/layers"})
    @ResponseBody
    public List<Map> getLayers(@PathVariable(value="tpl") String tplName) {
        try {
            return this.configService.getLayers(tplName);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("layers.get.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/fullsearch/config"})
    @ResponseBody
    public Map getFullSearchConfig() {
        try {
            return this.configService.getSearchConfig();
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("layers.get.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/fullsearch/update"})
    @ResponseBody
    public void updateFullSearchConfig(@RequestParam(value="config") String config) {
        try {
            this.configService.updateSearchConfig(config);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("layers.get.error", new Object[]{e.getLocalizedMessage()}));
        }
    }
}

