package cn.gtmap.onemap.platform.utils;

import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 13-6-3 下午1:49
 */
public final class Utils {

    public static final int REGION_CODE_MAX_LENGTH = 6;


    /**
     * formate region code
     *
     * @param value
     * @return
     */
    public static final String formatRegionCode(String value) {
        Assert.notNull(value, "region code can't be null");
        final int maxLength = REGION_CODE_MAX_LENGTH;
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        if(StringUtils.startsWith(sb.toString(),"3"))
        {
            while (sb.length() < maxLength) {
                sb.append("0");
            }
        }
        return sb.toString();
    }


}
