package cn.gtmap.onemap.platform.dao;

import cn.gtmap.onemap.platform.entity.MetaData;
import com.alibaba.fastjson.JSONObject;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.HashMap;
import java.util.List;

/**
 * @author: <a href="mailto:yxfacw@live.com">yingxiufeng</a>
 * @date: 2013-07-08 下午5:31
 * @version: 1.0
 */
public interface MetaDataDao extends JpaRepository<MetaData, String> {

    /**
     *
     * @param bkjmc
     * @return
     */
    List<MetaData> findByBkjmc(String bkjmc);

    MetaData findById(String id);

    List<MetaData> findBySjkslbmOrderByYwlxAsc(String skjslbm);

    @Query("select t1 from MetaData t1,YwlxZd t2 where t1.ywlx=t2.dm  and t1.ipbm=?1 order by t2.bz")
    List<MetaData> getByIpbm(String ipbm);

    @Query("select sum(t.bkjyydx) from MetaData as t  where t.userName=?1 ")
    String getCapacityByUserName(String username);

    @Query("select distinct(t1.userName),t2.bz from MetaData t1,YwlxZd t2 where t1.ywlx=t2.dm order by t2.bz")
    List<Object> getUsername();

    @Query("select distinct(t.ywlx) from MetaData t where t.userName=?1")
    String getYwlxByUsername(String username);

    @Query("select t1 from MetaData t1,YwlxZd t2 where t1.ywlx=t2.dm order by t2.bz,t1.nd")
    List<MetaData> getAll();

}
