/*
 * Project:  onemap
 * Module:   onemap-platform
 * File:     HTMLMapAppCtrl.java
 * Modifier: Ray Zhang
 * Modified: 2013-8-13 下午5:02:36
 *
 * Copyright (c) 2013 Gtmap Ltd. All Rights Reserved.
 *
 * Copying of this document or code and giving it to others and the
 * use or communication of the contents thereof, are forbidden without
 * expressed authority. Offenders are liable to the payment of damages.
 * All rights reserved in the event of the grant of a invention patent or the
 * registration of a utility model, design or code.
 */
package cn.gtmap.onemap.platform.controller.portal2;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;

import cn.gtmap.onemap.platform.service.MapService;

import com.alibaba.fastjson.JSON;

/**
 * .
 * <p/>
 *
 * @author <a href="mailto:rayzy1991@163.com">zhangyang</a>
 * @version V1.0, 2013-8-13 下午5:02:36
 */
@Controller()
@RequestMapping("/mapapp")
public class HTMLMapAppCtrl {
	
	@Autowired
	MapService mapService;
	
	@RequestMapping("/{tplName}")
	public String app(@PathVariable("tplName") String tplName, Model model){
		model.addAttribute("tpl", tplName);
		model.addAttribute("config", JSON.toJSONString(mapService.getConfig(tplName)));
		return "/mapapp/main";
	}
	
}
