package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.ConfigService;
import cn.gtmap.onemap.platform.service.WebMapService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import cn.gtmap.onemap.security.IdentityService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.util.Map;

/**
 * . support mobile map
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 13-11-11 上午9:17
 */
@Controller
@RequestMapping("/mobile")
public class MobileController extends BaseController {

    @Autowired
    private IdentityService identityService;

    @Autowired
    private WebMapService webMapService;

    @Autowired
    private ConfigService configService;

    /**
     * mobile login , token return
     *
     * @param userName
     * @param passWord
     * @return
     */
    @RequestMapping("/login")
    @ResponseBody
    public Map login(@RequestParam(value = "username") String userName,
                     @RequestParam(value = "password") String passWord) {
        try {
            return result(identityService.login(userName, passWord));
        } catch (cn.gtmap.onemap.security.ex.SecurityException ex) {
            throw new JSONMessageException(getMessage("login.error.code." + ex.getCode(), userName));
        } catch (Exception ex) {
            throw new JSONMessageException(getMessage("login.error", ex.getLocalizedMessage()));
        }
    }

    /**
     * logout
     *
     * @param token
     * @return
     */
    @RequestMapping("/logout")
    @ResponseBody
    public Map logout(@RequestParam("token") String token) {
        try {
            identityService.logout(token);
            return result(true);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("logout.error", e.getLocalizedMessage()));
        }
    }

    /**
     * get map tpls
     *
     * @return
     */
    @RequestMapping("/map/tpls")
    @ResponseBody
    public Map getMapTpls() {
        try {
            return result(configService.getThumbTplInfos());
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("tpl.list.error", e.getLocalizedMessage()));
        }
    }

    /**
     * get tpl config
     *
     * @param tplName
     * @return
     */
    @RequestMapping("/map/{tpl}/config")
    @ResponseBody
    public Map getMapConfig(@PathVariable("tpl") String tplName) {
        try {
            return result(webMapService.getConfig(tplName));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("tpl.config.error", tplName, e.getLocalizedMessage()));
        }
    }

}
