package cn.gtmap.onemap.platform.utils;

import cn.gtmap.onemap.platform.Constant;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpStatus;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;

/**
 * Created with IntelliJ IDEA.
 * User: zhangbixi
 * Date: 13-4-19
 * Time: 下午2:42
 * To change this template use File | Settings | File Templates.
 */
public class HttpRequest {

    private static final int DEFAULT_TIME_OUT = 10000;

    /**
     * 向Web服务器请求数据
     *
     * @param urlString
     * @param postString
     * @return
     * @throws Exception
     */
    public static final String sendRequest(String urlString, String postString) throws Exception {
        HttpURLConnection connection = null;
        try {
            URL url = new URL(urlString);
            connection = (HttpURLConnection) url.openConnection();
            connection.setRequestProperty("Content-Type", Constant.UTF_8);
            connection.setRequestMethod("GET");
            connection.setUseCaches(false);
            connection.setConnectTimeout(DEFAULT_TIME_OUT);
            connection.setDoInput(true);
            connection.setDoOutput(true);
            byte[] postByte = new byte[1];
            int postLength = 0;
            if (StringUtils.isNotBlank(postString)) {
                postByte = postString.getBytes(Constant.UTF_8);  //Constant.UTF_8
                postLength = postByte.length;
            }
            connection.getOutputStream().write(postByte, 0, postLength);
            connection.getOutputStream().flush();
            connection.getOutputStream().close();
            if (connection.getResponseCode() == 200) {
                return getStringFromInputStream(connection.getInputStream(), Constant.UTF_8);
            }
            String statusMsg = "{" + connection.getResponseCode() + " - " + connection.getResponseMessage() + "}";
            throw new Exception("Http请求异常：" + statusMsg);
        } catch (Exception e) {
            throw new Exception("Http请求异常：" + e.getLocalizedMessage());
        } finally {
            if(connection!=null){
                connection.disconnect();
            }
        }
    }

    /**
     * 从输入流中读取内容
     *
     * @param is
     * @param encode
     * @return
     */
    public static final String getStringFromInputStream(InputStream is, String encode) {
        try {
            InputStreamReader isr = new InputStreamReader(is, encode != null ? encode : Constant.UTF_8);
            StringBuffer sb = new StringBuffer("");
            BufferedReader br = new BufferedReader(isr);
            String str = br.readLine();
            while (str != null) {
                sb.append(str);
                str = br.readLine();
            }
            return sb.toString();
        } catch (Exception e) {

        }
        return null;
    }

    /**
     * 请求服务
     *
     * @param urlString
     * @param postString
     * @return
     * @throws Exception
     */
    public static final String sendRequest2(String urlString, String postString) throws Exception {
        String result = "";
        HttpClient http = new HttpClient();
        HttpMethod method = new GetMethod(urlString);
        method.setRequestHeader("Content-Type", Constant.UTF_8);
        if (StringUtils.isNotBlank(postString)) method.setQueryString(postString);
        try {
            int status = http.executeMethod(method);
            result = IOUtils.toString(method.getResponseBodyAsStream(),Constant.UTF_8);
            if (HttpStatus.SC_OK == status) {
                return result;
            }
        } catch (Exception e) {
            result = e.getLocalizedMessage();
        } finally {
            method.releaseConnection();
        }
        throw new Exception("Http请求异常：" + result);
    }
}
