package cn.gtmap.onemap.platform.support.fm;

import cn.gtmap.onemap.model.Operation;
import cn.gtmap.onemap.model.Privilege;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.utils.AppPropertyUtils;
import cn.gtmap.onemap.security.*;
import cn.gtmap.onemap.service.UserService;
import freemarker.template.TemplateModelException;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.Set;

/**
 * .
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 13-11-12 上午8:51
 */
public class EnvContext extends BaseLogger {

    private final static String DEFAULT_TPL = "YZT";
    private final static String BLANK_TPL = "YZT_DEFAULT";
    private final static String TPL_RESOURCE = "omp-functions:tpl";
    private final static String ZT_RESOURCE = "omp-functions:zt";
    private final static String STATISTIC_RESOURCE="omp-functions:statistic";

    @Autowired
    private AuthorizationService authorizationService;

    /**
     * get main tpl
     *
     * @return
     * @throws TemplateModelException
     */
    public Object getMainTpl() throws TemplateModelException {
        if (SecHelper.isAdmin()) return DEFAULT_TPL;
        User user = SecHelper.getUser();
        try {
            if (user != null) {
                Set<Privilege> privileges = authorizationService.getPermittedPrivileges(user.getId(), TPL_RESOURCE);
                for (Privilege privilege : privileges) {
                    for (Operation operation : privilege.getOperations()) {
                        if (Operation.VIEW.equals(operation.getName())) return privilege.getResource();
                    }
                }
            }
        } catch (Exception e) {
            logger.error(getMessage("tpl.om.selector.error", e.getLocalizedMessage()));
        }
        return BLANK_TPL;
    }

    /**
     * get zt authority
     *
     * @param name
     * @return
     */
    public boolean hasZtAuth(String name) {
        if (SecHelper.isAdmin() || SecHelper.isGuest()) return true;
        User user = SecHelper.getUser();
        if (user != null) {
            try {
                Set<Privilege> privileges = authorizationService.getPermittedPrivileges(user.getId(), ZT_RESOURCE);
                for (Privilege privilege : privileges) {
                    if (!privilege.getResource().equals(name)) continue;
                    for (Operation operation : privilege.getOperations()) {
                        if (Operation.VIEW.equals(operation.getName())) return true;
                    }
                }
            } catch (Exception e) {
                logger.error(getMessage("user.zt.error", e.getLocalizedMessage()));
            }
        }
        return false;
    }
    /**
     * get statictic authority
     * @param name
     * @return
     */
    public boolean hasStatisAuth(String name) {
        if (SecHelper.isAdmin() || SecHelper.isGuest()) return true;
        User user = SecHelper.getUser();
        if (user != null) {
            try {
                Set<Privilege> privileges = authorizationService.getPermittedPrivileges(user.getId(), STATISTIC_RESOURCE);
                for (Privilege privilege : privileges) {
                    if (!privilege.getTitle().equals(name)) continue;
                    for (Operation operation : privilege.getOperations()) {
                        if (Operation.VIEW.equals(operation.getName())) return true;
                    }
                }
            } catch (Exception e) {
                logger.error(getMessage("user.zt.error", e.getLocalizedMessage()));
            }
        }
        return false;
    }

    /**
     * get app env value
     *
     * @param key
     * @return
     */
    public Object getEnv(String key) {
        return AppPropertyUtils.getAppEnv(key);
    }

    /**
     *   get regionCode of role
     * @return
     */
    public String getRegionCode(){
        if (SecHelper.isAdmin() || SecHelper.isGuest()) return null;
        User user = SecHelper.getUser();
        if(user==null)return null;
        return user.getRegionCode();
    }

}
