package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.entity.dict.Item;
import cn.gtmap.onemap.platform.service.DictService;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.WebMapService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author: <a href="mailto:yxfacw@live.com">yingxiufeng</a>
 * @date: 2013-09-27 上午10:19
 * @version: 1.0
 */
@Service
public class DictServiceImpl extends BaseLogger implements DictService {
    
    @Autowired
    private WebMapService webMapService;

    private static final String ANLYSIS_PREFIX = "analysis_";

    /**
     * 获取分析时分组字段相对应的字典项配置 ,字典名称:前缀_分组字段名(如,analysis_dlbm)
     * @param tpl   字典项所在模板名
     * @param groupName 分组字段名称
     * @return
     */
    @Override
    public List<Map> getAnalysisDict(String tpl, String groupName) {
        List<Map> list = new ArrayList<Map>();
        String dictName = ANLYSIS_PREFIX + groupName.toLowerCase();
        Configuration configuration = webMapService.getConfig(tpl);
        List<Dict> dicts = configuration.getDicts();
        for (Dict dict : dicts) {
            if(dict.getName().equals(dictName))
            {
                List<Item> dictItems = dict.getDictItems();
                for (Item item : dictItems) {
                    Map temp = new HashMap();
                    temp.put(item.getName(),item.getValue());
                    list.add(temp);
                }
            }

        }
        return list;
    }
}
