package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.dao.*;
import cn.gtmap.onemap.platform.entity.*;
import cn.gtmap.onemap.platform.service.DbResService;
import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.HashMap;
import java.util.List;

/**
 * @author: <a href="mailto:yxfacw@live.com">yingxiufeng</a>
 * @date: 2013-07-08 下午5:45
 * @version: 1.0
 */
@org.springframework.stereotype.Service
public class DbResServiceImpl extends BaseLogger implements DbResService {

    @Autowired
    private MetaDataDao metaDataDao;

    @Autowired
     private FwqInfoDao fwqInfoDao;

    @Autowired
    private DbInfoDao dbInfoDao;

    @Autowired
    private SJGLDao sjglDao;

    @Autowired
    private YSJDao ysjDao;

    @Autowired
    private YGJCDao ygjcDao;

    @Autowired
    private TableSpaceDao tableSpaceDao;

    @Override
    public List<MetaData> getMetaDataByBkjmc(String bkjmc) {
        List<MetaData> list = metaDataDao.findByBkjmc(bkjmc);
        return list;
    }

    @Override
    public List<MetaData> getMetaDataAll() {
        return metaDataDao.getAll();
    }

    @Override
    public MetaData getMetaDataById(String id) {
        return metaDataDao.findById(id);
    }

    @Override
    public List<FwqInfo> getFwqInfoAll() {
        return fwqInfoDao.findAll();
    }

    @Override
    public String getIpdzByID(String id) {
        return fwqInfoDao.findById(id).getIpdz();
    }

    @Override
    public List<TableSpaceInfo> getTableSpaceAll() {
        return tableSpaceDao.findAllOrderByBkjmc();
    }

    @Override
    public List<YGJC> getYgjcAll() {
        return ygjcDao.getAllOrderByLX();
    }

    @Override
    public List<YGJC> getYgjcByNfAndLx(String nf, String lx) {
        return ygjcDao.findByNfAndLx(nf,lx);
    }

    @Override
    public List<FwqInfo> getFwqInfoByLx(String lx) {
        return fwqInfoDao.findByLx(lx);
    }

    @Override
    public List<String> getFwqLx() {
        return fwqInfoDao.getFwqLx();
    }


    @Override
    public List<DbInfo> getDbInfoByFid(String fid) {
        return dbInfoDao.findByFid(fid);
    }

    @Override
    public List<Object> getDbUsername() {
        return metaDataDao.getUsername();
    }

    @Override
    public String getYwlxByUsername(String username) {
        return metaDataDao.getYwlxByUsername(username);
    }

    @Override
    public String getCapacityByUserName(String username) {
        return metaDataDao.getCapacityByUserName(username);
    }

    @Override
    public List<MetaData> getMetaDataBySlbm(String slbm) {
        return metaDataDao.findBySjkslbmOrderByYwlxAsc(slbm);
    }

    @Override
    public List<MetaData> getMetaDataByIpbm(String ipbm) {
        return metaDataDao.getByIpbm(ipbm);
    }

    @Override
    public String getYwlxmc(String ywlx) {
        return sjglDao.getYwlxmcByYwlx(ywlx);
    }

    @Override
    public List<Object> getSjzsByNdAndYwlx(String nd, String ywlx) {
        if(StringUtils.isBlank(nd))
            return sjglDao.getSjzsByYwlx(ywlx);
        return sjglDao.getSjzsByNdAndYwlx(nd, ywlx);
    }

    @Override
    public long getSumByNdAndYwlx(String nd, String ywlx) {
        if(StringUtils.isBlank(nd))
            return sjglDao.getSumByYwlx(ywlx);
        return sjglDao.getSumByNdAndYwlx(nd, ywlx);
    }

    @Override
    public long getXzqByNdAndYwlx(String nd, String ywlx) {
        if(StringUtils.isBlank(nd))
            return sjglDao.getXzqByYwlx(ywlx);
        return sjglDao.getXzqByNdAndYwlx(nd,ywlx);
    }

    @Override
    public int getDataIndex(String ywlx, List<HashMap> list) {
        if(list.size()>0)
        {
            for(int i=0;i<list.size();i++)
            {
                HashMap map = list.get(i);
                if(map.get("ywlx").equals(ywlx))
                    return i;
                else
                    continue;
            }
        }
        return -1;
    }

    @Override
    public List<YSJ> getMetaInfo(String id) {
        return ysjDao.findByFaid(id);
    }

    @Override
    public List<YGJC> getYgjcByFwqbm(String fwqbm) {
        return ygjcDao.findByFwqbm(fwqbm);
    }

    @Override
    public List<YGJC> getYgjcByLxAndFwqbm(String lx, String fwqbm) {
        return ygjcDao.findByLxAndFwqbm(lx, fwqbm);
    }

    @Override
    public List<String> getYgjcNf(String lx, String fwqbm) {
        return ygjcDao.getYgjcNf(lx, fwqbm);
    }

    @Override
    public List<String> getYgjcLxByFwqbm(String fwqbm) {
        return ygjcDao.getYgjcLxByFwqbm(fwqbm);
    }

    @Override
    public String getWjdxByLx(String lx) {
        return ygjcDao.getWjdxByLx(lx);
    }

    @Override
    public String getWjdxBylxAndNf(String lx, String nf) {
        return ygjcDao.getWjdxByLxAndNf(lx, nf);
    }

    @Override
    public List<Object> getDbCapacity() {
        return tableSpaceDao.getDbCapacity();
    }
}
