package cn.gtmap.onemap.platform.service;

import cn.gtmap.onemap.platform.Constant;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/**
 * .GIS 应用服务
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 13-5-20 下午2:49
 */
public interface GISService {

    /**
     * 初始化
     */
    void initialize(Constant.SpatialType type);

    /**
     * 属性查询
     *
     * @param layerName
     * @param where
     * @param columns
     * @param returnGeometry
     * @param dataSource
     * @return
     */
    List<?> query(String layerName, String where, String[] columns, boolean returnGeometry, String dataSource);

    /**
     * 空间查询
     *
     * @param layerName
     * @param wkt
     * @param columns
     * @param dataSource
     * @return
     */
    List<?> query(String layerName, String wkt, String[] columns, String dataSource);

    /**
     * 空间查询
     *
     * @param layerName
     * @param geometry
     * @param columns
     * @param dataSource
     * @return
     */
    List<?> query(String layerName, Geometry geometry, String[] columns, String dataSource);

    /**
     * 空间查询(进行投影转换)
     * @param layerName
     * @param feature
     * @param columns
     * @param dataSource
     * @return
     */
    List<?> query(String layerName, SimpleFeature feature, String[] columns, String dataSource);


    /**
     * 相交分析
     *
     * @param layerName
     * @param wktPlygon
     * @param returnFields
     * @param dataSource
     * @return
     */
    List<?> intersect(String layerName, String wktPlygon, String[] returnFields, String dataSource);

    /**
     * 相交分析
     *
     * @param layerName
     * @param polygon
     * @param returnFields
     * @param dataSource
     * @return
     */
    List<?> intersect(String layerName, Polygon polygon, String[] returnFields, String dataSource);

    /**
     * 相交分析
     *
     * @param layerName
     * @param geometry
     * @param outFields
     * @param dataSource
     * @return
     */
    List<?> intersect(String layerName, Geometry geometry, CoordinateReferenceSystem sourceCRS, String[] outFields, String dataSource);

    /**
     * 相交分析(New)
     *
     * @param layerName
     * @param geometry
     * @param outFields
     * @param dataSource
     * @return
     */
    List<?> intersect(String layerName, Geometry geometry, String[] outFields, String dataSource);

    /**
     * 相交分析
     *
     * @param layerName
     * @param geoJson
     * @param outField
     * @param dataSource
     * @return
     */
    List<?> intersectByGeoJSON(String layerName, String geoJson, String[] outField, String dataSource);


    /**
     * 相交分析
     *
     * @param layerName
     * @param geoJson    GeoJSON 或 FeatureJSON，可包含空间参考
     * @param outField
     * @param dataSource
     * @return GeoJSON 格式要素集 {"type":"FeatureCollection","features":[{"type":"Feature","geometry":{"type":"Polygon","coordinates":[[]]},"properties":{}}}
     */
    List<?> intersect2(String layerName, String geoJson, String[] outField, String dataSource);

    /**
     * 相交分析
     *
     * @param layerName
     * @param geoJson
     * @param outField
     * @param dataSource
     * @return
     */
    List<?> intersect3(String layerName, String geoJson, String[] outField, String dataSource);

    /**
     * 插入数据
     *
     * @param layerName
     * @param columns    包含图形、属性数据
     * @param dataSource
     * @return primaryKey
     */
    String insert(String layerName, Map<String, Object> columns, String dataSource);

    /**
     * 插入数据
     *
     * @param layerName
     * @param geoJSON    GeoJSON 格式
     * @param dataSource
     * @return primaryKey
     */
    String insert(String layerName, String geoJSON, String dataSource);

    /**
     * 插入数据(返回geojson)
     *
     * @param layerName
     * @param geoJSON
     * @param dataSource
     * @return
     */
    String insert2(String layerName, String geoJSON, String dataSource);

    /**
     * 插入数据(返回geojson)
     *
     * @param layerName
     * @param geoJSON
     * @param check      是否执行拓扑检查
     * @param dataSource
     * @return
     */
    String insert2(String layerName, String geoJSON, boolean check, String dataSource);

    /**
     * 更新数据
     *
     * @param layerName
     * @param primaryKey
     * @param columns
     * @param dataSource
     * @return
     */
    boolean update(String layerName, String primaryKey, Map<String, Object> columns, String dataSource);

    /**
     * 更新数据
     *
     * @param layerName
     * @param primaryKey
     * @param geoJSON
     * @param dataSource
     * @return
     */
    boolean update(String layerName, String primaryKey, String geoJSON, String dataSource);


    /**
     * 删除
     *
     * @param layerName
     * @param primaryKey
     * @param dataSource
     * @return
     */
    boolean delete(String layerName, String primaryKey, String dataSource);

    /**
     * 土地利用现状分析，只扣除线物
     *
     * @param dltbLayerName
     * @param xzdwLayerName
     * @param geometry      GeoJSON format
     * @param outFields
     * @param dataSource
     * @return
     */
    Map tdlyxzAnalysis(String dltbLayerName, String xzdwLayerName, String geometry, String[] outFields, String dataSource);

    /**
     * 土地利用现状分析，只扣除线物
     *
     * @param regionCode
     * @param geometry   GeoJSON format
     * @param dataSource
     * @return
     */
    Map tdlyxzAnalysis(String regionCode, String geometry, String dataSource);

    /**
     * 土地利用现状分析2
     *
     * @param dltbLayerName
     * @param xzdwLayerName
     * @param geometry
     * @return
     */
    Map tdlyxzAnalysis2(String dltbLayerName, String xzdwLayerName, String geometry, String dataSource);

    /**
     * 土地利用总体规划审查 , 单一类型分析
     *
     * @param layerType
     * @param regionCode
     * @param geometry
     * @param outFields
     * @param dataSource
     * @return
     */
    List<?> tdghscAnalysis(String layerType, String regionCode, String geometry, String[] outFields, String dataSource);

    /**
     * 土地利用总体规划审查
     *
     * @param regionCode
     * @param geometry
     * @param outFields
     * @param dataSource
     * @return
     */
    Map tdghscAnalysis(String regionCode, String geometry, String[] outFields, String dataSource);


    /**
     * 土地利用总体规划审查 , 单一类型分析
     *
     * @param layerType
     * @param regionCode
     * @param geometry
     * @param outFields
     * @param dataSource
     * @return
     */
    String tdghscAnalysis2(String layerType, String regionCode, String geometry, String[] outFields, String dataSource);

    /**
     * 土地利用总体规划审查
     *
     * @param regionCode
     * @param geometry
     * @param outFields
     * @param dataSource
     * @return
     */
    Map tdghscAnalysis2(String regionCode, String geometry, String[] outFields, String dataSource);

    /**
     * 组织土地规划分析的结果（所有图层类型）
     *
     * @param analysisResult
     * @return
     */
    Map tdghscResult(Map analysisResult);

    /**
     * 组织土地规划分析的结果（单个图层类型）
     *
     * @param layerType
     * @param analysisResult
     * @return
     */
    Map tdghscResult(String layerType, String analysisResult);

    /**
     *excel data of tdghsc
     * @param result
     * @return
     */
    LinkedHashMap tdghscExcelData(Map result);

    /**
     * 组织土地利用现状分析的结果
     *
     * @param analysisResult
     * @return
     */
    List<Map> tdlyxzResult(Map analysisResult, String tpl);

    /**
     *excel data of tdlyxz
     * @param result
     * @return
     */
    LinkedHashMap tdlyxzExcelData(List<Map> result);

    /**
     * excel data of common analysis
     * @param list
     * @return
     */
    List<LinkedHashMap> analysisExcelData(List list);

    /**
     *管制区用地分析结果组织excel数据
     * @param list
     * @return
     */
    List<Map> gzqydExcelData(List list);

    /**
     * 组织当涂分析的excel数据
     * @param data
     * @return
     */
    Map<String,Object> dtExcelData(Map<String,Object> data);

    /**
     * 快速检索
     *
     * @param value
     * @param returnGeometry
     * @return
     */
    List search(String value, boolean returnGeometry);
    /**
     * 根据相关条件输出图片
     * @param where 查询子句
     * @param mapScale 出图的比例尺
     * @param width 图片的width
     * @param height 图片的height
     * @param type 出图类型(xz,gh)
     * @return
     */
    InputStream exportMap(String where,String mapScale,int width,int height,String type);


    /**
     * 当涂 多重，复杂综合性的分析
     * @param geometry
     * @param analysisLayers
     * @param dataSource
     * @return
     */
    Map multipleAnalysis(String geometry,List analysisLayers,String dataSource,String tpl);

    /**
     *
      * @param analysisMap
     * @return
     */
    Map multipleAnalysisExcel(Map analysisMap);

    /**
     * jctb analysis
     * @param geometry
     * @param analysisLayers
     * @return
     */
    List<Map> jctbAnalysis(String geometry,List analysisLayers,String dataSource);

    /**
     * jctb excel
     * @param list
     * @return
     */
    List jctbExcelData(List<Map> list);

    /**
     * 调用cs发布的webservice进行分析
     * @param dltbLayerName 地类图斑图层名称
     * @param xzdwLayerName 现状地物图层名称
     * @param geometry      geojson格式的图形
     * @param wcfUrl        webservice的地址
     * @param wcfMethod     分析的方法名(wcf中)
     * @return
     */
    Map tdlyxzAnalysisByWcf(String dltbLayerName, String xzdwLayerName, String geometry,String wcfUrl,String wcfMethod);


    /**
     * 调用cs发布的webservice进行分析 年份图层
     * @param year
     * @param geometry
     * @param wcfUrl
     * @param wcfMethod
     * @return
     */
    Map tdlyxzAnalysisByWcf(String year, String geometry,String wcfUrl,String wcfMethod);


}
