package cn.gtmap.onemap.platform.service;

import cn.gtmap.onemap.platform.entity.Document;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import java.util.Map;

/**
 * . 文档处理
 *
 * @author <a href="mailto:lanxy88@gmail.com">NelsonXu</a>
 * @version V1.0, 13-9-9 上午9:51
 */
public interface DocumentService {

    /**
     * 读取 Excel <br/>
     * 此处不关闭文件流
     *
     * @param inputStream
     * @return
     */
    List<List> readExcel(InputStream inputStream);

    /**
     * write data to excel
     *
     * @param data    {"Sheet1":[[1234,"yyyyy","zzzzzz"],[3456,"xxxxx","zzzzzz"]],"Sheet2":[[33333,"yyyyy","zzzzzz"],[555555,"xxxxx","zzzzzz"]]}
     * @param tplName excel file name ,such as "test.xlsx"
     * @return
     */
    Document writeExcel(Map<String, List> data, String tplName) throws Exception;

    /**
     * write data to excel
     *
     * @param data [{"header":["column1","column2","column3"],"data":[[1234,"yyyyy","zzzzzz"],[3456,"xxxxx","zzzzzz"]]}]
     * @return
     * @throws Exception
     */
    Document writeExcel(List<Map> data) throws Exception;

    /**
     * 管制区分析结果excel
     * @param data
     * @param tplName
     * @return
     * @throws Exception
     */
    Document writeExcelGZQFX(List<Map> data, String tplName) throws Exception;

    /**
     *
     * @param data
     * @param tplName
     * @param extraParam
     * @return
     * @throws Exception
     */
    Document writeExcelJCTB(List data, String tplName,String extraParam)throws Exception;

    /**
     * read zip file <br/>
     * <p/>
     * 必须为标准Zip流格式
     *
     * @param inputStream
     * @return
     * @throws Exception
     */
    List<Document> readZip(InputStream inputStream) throws Exception;

    /**
     * read zip file
     *
     * @param file
     * @return
     */
    List<Document> readZipFile(File file);

    /**
     * read archive <br/>
     * the archiver formats are 7z, ar, arj, cpio, dump, tar and zip
     *
     * @param inputStream
     * @return
     */
    List<Document> readArchive(InputStream inputStream);

    /**
     *
     * @param file
     * @return
     */
    List<Document> readArchiveFile(File file);


}
