package cn.gtmap.onemap.platform.service;


import java.io.File;

/**
 * Created by shenjian on 2014-05-20.
 */
public interface AgsGeoemtryService {
    /**
     * 相交运算 by arcgis geometry api
     *
     * @param inputGeometry
     * @param intersector
     * @param sr
     * @return
     */
    String intersection(String inputGeometry, String intersector, String sr);


    /**
     * 获取图形面积 by arcgis geometry api
     *
     * @param wkt
     * @return
     */
    Double getGeometryArea(String wkt);

    /**
     * 验证图形是否有效
     * @param geometry wkt
     * @param sr  wkt的crs
     * @return
     */
    boolean validGeometry(String geometry,String sr);

    /**
     *
     * @param inputGeometry
     * @param touchGeometry
     * @param sr
     * @return
     */
    boolean touches(String inputGeometry, String touchGeometry, String sr);

    /**
     *  import shapefile
     * @param shpFile
     * @return
     */
    @Deprecated
    String importShape(File shpFile);
}
