package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.model.Field;
import cn.gtmap.onemap.model.Layer;
import cn.gtmap.onemap.model.MapGroup;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.Service;
import cn.gtmap.onemap.platform.entity.ThematicMap;
import cn.gtmap.onemap.platform.entity.TplType;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.ConfigService;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.TplTypeService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import com.alibaba.fastjson.JSON;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.impl.xb.xsdschema.Public;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author: <a href="mailto:yxfacw@live.com">yingxiufeng</a>
 * @date: 2013-10-14 上午9:43
 * @version: 1.0
 */
@Controller
@RequestMapping("/config")
public class ConfigController extends BaseController {

    @Autowired
    private TplTypeService tplTypeService;

    @Autowired
    private MapService mapService;

    @Autowired
    private ConfigService configService;


    @RequestMapping
    public String execute() {
        return "config";
    }


    /**
     * get config tpls
     *
     * @return
     */
    @RequestMapping(value = "/tpls")
    @ResponseBody
    public List tpls() {

        try {
            return configService.getThumbTplInfos();
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("tpl.list.error", e.getLocalizedMessage()));
        }
    }

    /**
     *  get thematic maps
     * @return
     */
    @RequestMapping(value = "/thematicmaps")
    @ResponseBody
   public List<ThematicMap> thematicMaps(){
        try {
            return configService.getThematicMaps();
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("thematic.config.error", e.getLocalizedMessage()));
        }
    }

    /**
     * delete thematic map
     * @param id
     */
    @RequestMapping(value = "/thematicmaps/delete/{id}")
    @ResponseBody
    public void deleteThematicMap(@PathVariable("id") String id){
        try {
            Assert.notNull(id);
            configService.deleteThematicMap(id);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("thematic.delete.error", e.getLocalizedMessage()));
        }
    }

    /**
     *
     * save or update thematic map
     * @param thematicMap
     * @return
     */
    @RequestMapping(value = "/thematicmaps/save", method = RequestMethod.POST)
    @ResponseBody
    public ThematicMap updateThematicMap(@RequestParam("thematicMap") String thematicMap){

        try {
            return configService.updateThematicMap(JSON.parseObject(thematicMap, ThematicMap.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("thematic.save.error", e.getLocalizedMessage()));
        }
    }

    /**
     * 获取所有的通用的widgets
     *
     * @return
     */
    @RequestMapping(value = "/commonwidgets/all")
    @ResponseBody
    public List<Configuration.Widget> getCommonWidgets() {
        return configService.getCommonWidgets();
    }

    /**
     * 获取所有的共享的widgets
     *
     * @return
     */
    @RequestMapping(value = "/publicwidgets/all")
    @ResponseBody
    public List<Configuration.Widget> getPublicWidgets() {
        return configService.getPublicWidgets();
    }

    /**
     * delete public widget
     *
     * @param id
     */
    @RequestMapping(value = "/publicwidgets/{id}/delete")
    @ResponseBody
    public void deletePublicWidget(@PathVariable("id") String id) {

        try {
            Assert.notNull(id);
            configService.deletePublicWidget(id);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("widget.delete.error", e.getLocalizedMessage()));
        }
    }

    /**
     * insert public widget
     *
     * @param widget
     */
    @RequestMapping(value = "/publicwidgets/insert", method = RequestMethod.POST)
    @ResponseBody
    public void insertPublicWidget(@RequestParam("widget") String widget) {

        try {
            configService.insertPublicWidget(JSON.parseObject(widget, Configuration.Widget.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("widget.save.error", e.getLocalizedMessage()));
        }
    }

    /**
     * delete common widget
     *
     * @param id
     */
    @RequestMapping(value = "/commonwidgets/{id}/delete")
    @ResponseBody
    public void deleteCommonWidget(@PathVariable("id") String id) {

        try {
            Assert.notNull(id);
            configService.deleteCommonWidget(id);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("widget.delete.error", e.getLocalizedMessage()));
        }

    }

    /**
     * insert common widget
     *
     * @param widget
     */
    @RequestMapping(value = "/commonwidgets/insert", method = RequestMethod.POST)
    @ResponseBody
    public void insertCommonWidget(@RequestParam("widget") String widget) {

        try {
            configService.insertCommonWidget(JSON.parseObject(widget, Configuration.Widget.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("widget.save.error", e.getLocalizedMessage()));
        }

    }

    /**
     * 新建模板
     *
     * @param tpl
     * @param name
     * @param description
     * @return
     */
    @RequestMapping(value = "/tpl/create/{tpl}")
    @ResponseBody
    public Configuration createTpl(@PathVariable("tpl") String tpl,
                                   @RequestParam(value = "name", required = false) String name,
                                   @RequestParam(value = "description", required = false) String description,
                                   @RequestParam(value = "thematicMap", required = false) String thematicMap,
                                   @RequestParam(value = "parentTpl",required = false)String parentTpl) {

        try {
            return configService.createTpl(tpl, name, description,thematicMap,parentTpl);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("tpl.new.error", e.getLocalizedMessage()));
        }
    }

    /**
     * 删除模板
     *
     * @param tplName
     * @return
     */
    @RequestMapping(value = "/tpl/remove/{tpl}")
    @ResponseBody
    public Object removeTpl(@PathVariable("tpl") String tplName) {

        try {
            configService.deleteTpl(tplName);
            return result(getMessage("tpl.remove.ok", tplName));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("tpl.remove.error", e.getLocalizedMessage()));
        }
    }

    /**
     * 获取服务
     *
     * @param tplName
     * @return
     */
    @RequestMapping(value = "/tpl/{tpl}/services")
    @ResponseBody
    public Map servicesList(@PathVariable("tpl") String tplName) {
        try {
            Map map = new HashMap();
            map.put("services", configService.getAllService(tplName));
            map.put("tpl", tplName);
            return map;
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("services.get.error", tplName));
        }
    }

    /**
     * get all group info from oms
     *
     * @return
     */
    @RequestMapping(value = "/services/all")
    @ResponseBody
    public Map getAllService() {
        try {
            return configService.getAllSevices();
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("config.get.allServices.error", e.getLocalizedMessage()));
        }
    }

    /**
     * get services by groupId  from oms
     *
     * @return
     */
    @RequestMapping(value = "/services")
    @ResponseBody
    public Object getServicesByGroup(@RequestParam(value = "groupId", required = false) String groupId) {
        try {
            if (!isNull(groupId))
                return configService.getServicesByGroupId(groupId);
            else
                return configService.getAllSevices();
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("config.get.groupService.error", groupId, e.getLocalizedMessage()));
        }
    }

    /**
     * 递归获取所有服务分类
     * @param groupId
     * @return
     */
    @RequestMapping(value = "/services/groups")
    @ResponseBody
    public Object getServicesWithClassify(@RequestParam(value = "groupId", required = false) String groupId) {
        try {
            if (!isNull(groupId))
                return configService.getServicesByGroupId(groupId);
            else
                return configService.getServicesWithClassify();
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("config.get.groupService.error", groupId, e.getLocalizedMessage()));
        }

    }
    /**
     * 获取模板的widget配置内容
     *
     * @param tplName
     * @return
     */
    @RequestMapping(value = "/tpl/{tpl}/widgets")
    @ResponseBody
    public Map getWidgets(@PathVariable("tpl") String tplName) {
        try {
            return configService.getWidgetCollection(tplName);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("tpl.get.widget.error", tplName, e.getLocalizedMessage()));
        }
    }


    /**
     * 删除模板中的服务
     *
     * @param tpl
     * @param ids
     */
    @RequestMapping(value = "/tpl/{tpl}/service/remove/{ids}")
    @ResponseBody
    public void deleteService(@PathVariable(value = "tpl") String tpl,
                              @PathVariable(value = "ids") String ids) {
        Assert.notNull(ids, getMessage("id.notnull"));
        try {
            configService.deleteServices(tpl, ids.split(","));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("tpl.service.delete.error", tpl, ids));
        }
    }

    /**
     * 保存服务，单一服务
     *
     * @param tpl
     */
    @RequestMapping(value = "/tpl/{tpl}/service/save", method = RequestMethod.POST)
    @ResponseBody
    public void saveService(@PathVariable(value = "tpl") String tpl,
                            @RequestParam("service") String service) {

        try {
            configService.updateService(tpl, JSON.parseObject(service, Service.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("service.save.error", e.getLocalizedMessage()));
        }
    }


    /**
     *保存字典
     * @param tpl
     * @param dict
     * @return
     */
    @RequestMapping(value = "/tpl/{tpl}/dict/save", method = RequestMethod.POST)
    @ResponseBody
    public Dict saveDict(@PathVariable(value = "tpl") String tpl,
                         @RequestParam("dict") String dict){
        try {
            return configService.saveDict(tpl,JSON.parseObject(dict,Dict.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("insert.dict.error", e.getLocalizedMessage()));
        }
    }
    /**
     *delete dict
     * @param tpl
     * @param id
     */
    @RequestMapping(value = "/tpl/{tpl}/dict/{id}/delete")
    @ResponseBody
    public void deleteDict(@PathVariable(value = "tpl") String tpl,
                           @PathVariable("id") String id){
        try {
            configService.deleteDict(tpl,id);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("delete.dictItem.error", e.getLocalizedMessage()));
        }

    }

    /**
     * 保存服务，所有服务
     *
     * @param tpl
     */
    @RequestMapping(value = "/tpl/{tpl}/services/save", method = RequestMethod.POST)
    @ResponseBody
    public void saveServices(@PathVariable(value = "tpl") String tpl,
                             @RequestParam("services") String services) {
        try {
            configService.saveAllServices(tpl, JSON.parseArray(services, Service.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("service.save.error", e.getLocalizedMessage()));
        }
    }

    /**
     * 保存dockwidget
     *
     * @param tplName
     * @param dockWidget
     */
    @RequestMapping(value = "/tpl/{tpl}/dockwidget/save", method = RequestMethod.POST)
    @ResponseBody
    public Configuration.Widget updateDockWidget(@PathVariable(value = "tpl") String tplName, @RequestParam("dockWidget") String dockWidget) {
        try {
           return configService.updateDockWidget(tplName, JSON.parseObject(dockWidget, Configuration.Widget.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("widget.save.error", e.getLocalizedMessage()));
        }
    }

    /**
     * delete dock widget
     * @param tplName
     * @param dockWidget
     */
    @RequestMapping(value = "/tpl/{tpl}/dockwidget/delete", method = RequestMethod.POST)
    @ResponseBody
    public void deleteDockWidget(@PathVariable(value = "tpl") String tplName, @RequestParam("dockWidget") String dockWidget){
        try {
             configService.deleteDockWidget(tplName, JSON.parseObject(dockWidget, Configuration.Widget.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("widget.save.error", e.getLocalizedMessage()));
        }
    }


    /**
     * 保存单个widget
     *
     * @param tplName
     * @param widget
     */
    @RequestMapping(value = "/tpl/{tpl}/widget/save", method = RequestMethod.POST)
    @ResponseBody
    public void updateWidget(@PathVariable(value = "tpl") String tplName, @RequestParam("widget") String widget) {
        try {
            configService.updateWidget(tplName, JSON.parseObject(widget, Configuration.Widget.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("widget.save.error", e.getLocalizedMessage()));
        }

    }

    /**
     * delete widget in container
     *
     * @param tplName
     * @param widget
     */
    @RequestMapping(value = "/tpl/{tpl}/widget/delete", method = RequestMethod.POST)
    @ResponseBody
    public void deleteWidget(@PathVariable(value = "tpl") String tplName, @RequestParam("widget") String widget) {
        try {
            configService.deleteWidget(tplName, JSON.parseObject(widget, Configuration.Widget.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("widget.save.error", e.getLocalizedMessage()));
        }
    }

    /**
     * 保存widgetsGroup
     *
     * @param tplName
     * @param widgetsGroup
     * @param widget
     */
    @RequestMapping(value = "/tpl/{tpl}/widgetsgroup/save", method = RequestMethod.POST)
    @ResponseBody
    public void updateWidgetGroup(@PathVariable(value = "tpl") String tplName,
                                  @RequestParam("widgetsGroup") String widgetsGroup, @RequestParam(value = "widget", required = false) String widget) {

        try {
            configService.updateWidgetGroup(tplName, JSON.parseObject(widgetsGroup, Configuration.WidgetsGroup.class), JSON.parseObject(widget, Configuration.Widget.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("widget.save.error", e.getLocalizedMessage()));
        }
    }

    /**
     * delete widgetsGroup
     *
     * @param tplName
     * @param widgetsGroup
     * @param widget
     */
    @RequestMapping(value = "/tpl/{tpl}/widgetsgroup/delete", method = RequestMethod.POST)
    @ResponseBody
    public void deleteWidgetGroup(@PathVariable(value = "tpl") String tplName,
                                  @RequestParam("widgetsGroup") String widgetsGroup, @RequestParam(value = "widget", required = false) String widget) {

        try {
            configService.deleteWidgetsGroup(tplName, JSON.parseObject(widgetsGroup, Configuration.WidgetsGroup.class), JSON.parseObject(widget, Configuration.Widget.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("widget.save.error", e.getLocalizedMessage()));
        }

    }

    /**
     * 获取全局配置
     *
     * @param tplName
     * @param global
     * @return
     */
    @RequestMapping(value = "/tpl/{tpl}/global")
    @ResponseBody
    public Configuration updateGlobalConfiguration(@PathVariable(value = "tpl") String tplName,
                                                   @RequestParam(value = "global", required = false) String global) {
        try {
            if (isNull(global)) return configService.getGlobalConfiguration(tplName);
            else return configService.updateGlobalConfiguration(tplName, JSON.parseObject(global, Configuration.class));
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("tpl.global.save.error", tplName, e.getLocalizedMessage()));
        }
    }

    /**
     * 设置全图范围
     *
     * @param tplName
     * @param extent
     * @return
     */
    @RequestMapping(value = "/tpl/{tpl}/map/extent")
    @ResponseBody
    public Map updateMapInitExtent(@PathVariable(value = "tpl") String tplName,
                                   @RequestParam(value = "extent") String extent) {
        try {
            return configService.updateMapInitExtent(tplName, JSON.parseObject(extent, Map.class));
        } catch (Exception e) {
            throw new RuntimeException(getMessage("tpl.map.extent.error", tplName, e.getLocalizedMessage()));
        }
    }

    /**
     * set defaultScale of map
     * @param tplName
     * @param scale
     * @return
     */
    @RequestMapping(value = "/tpl/{tpl}/map/scale")
    @ResponseBody
    public double updateDefaultScale(@PathVariable(value = "tpl") String tplName,
                                     @RequestParam(value = "scale") double scale){

        try {
            return configService.updateDefaultScale(tplName,scale);
        } catch (Exception e) {
            throw new RuntimeException(getMessage("tpl.map.defaultScale.error", tplName, e.getLocalizedMessage()));
        }
    }

    /**
     * 设置 比例尺层级
     *
     * @param tplName
     * @param lods
     * @return
     */
    @RequestMapping(value = "/tpl/{tpl}/map/lods")
    @ResponseBody
    public List updateMapLods(@PathVariable(value = "tpl") String tplName,
                              @RequestParam(value = "lods") String lods) {
        try {
            return configService.updateMapLods(tplName, JSON.parseArray(lods, Map.class));
        } catch (Exception e) {
            throw new RuntimeException(getMessage("tpl.map.lods.error", tplName, e.getLocalizedMessage()));
        }
    }

    /**
     * 获取图层里的字段集合
     *
     * @param mapId
     * @param layerName
     * @return
     */
    @RequestMapping(value = "/getFields", method = RequestMethod.POST)
    @ResponseBody
    public List<Map> getFields(@RequestParam(value = "id") String mapId, @RequestParam(value = "layerName") String layerName) {
        try {
            return configService.getLayerFields(mapId, layerName);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("fields.get.error", e.getLocalizedMessage()));
        }
    }

    /**
     * 获取服务以及服务的图层信息
     *
     * @param tplName
     * @return
     */
    @RequestMapping(value = "/tpl/{tpl}/service/layers")
    @ResponseBody
    public List<Map> getLayers(@PathVariable(value = "tpl") String tplName) {
        try {
            return configService.getLayers(tplName);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("layers.get.error", e.getLocalizedMessage()));
        }
    }

    /**
     * get full search config
     *
     * @return
     */
    @RequestMapping(value = "/fullsearch/config")
    @ResponseBody
    public Map getFullSearchConfig() {
        try {
            return configService.getSearchConfig();
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("layers.get.error", e.getLocalizedMessage()));
        }
    }

    /**
     * update full search
     *
     * @return
     */
    @RequestMapping(value = "/fullsearch/update")
    @ResponseBody
    public void updateFullSearchConfig(@RequestParam(value = "config") String config) {
        try {
            configService.updateSearchConfig(config);
        } catch (Exception e) {
            throw new JSONMessageException(getMessage("layers.get.error", e.getLocalizedMessage()));
        }
    }



}
