<#--省厅增减挂钩系统订制页面-->

<#assign cssContent>
<style>
    table tr td {
        border: 1px solid #ddd;
        padding: 5px 10px;
        height: 50px;
        text-align: center;
    }

    table tr th {
        border: 1px solid #ddd;
        padding: 10px;
        max-height: 60px;
        min-width: 90px;
        text-align: center;
    }

    table {
        background-color: transparent;
        border: 1px solid #ddd;
        table-layout: auto;
        border-collapse: collapse;
        margin-left: auto;
        margin-right: auto;
        margin-bottom: 15px;
        width: 100%;
    }

    .infoTable {
        background-color: transparent;
        border: 0px solid #DDDDDD;
        table-layout: auto;
        border-collapse: collapse;
        margin-left: auto;
        margin-right: auto;
        margin-bottom: 15px;
        width: 100%;
    }

    .infoTable tr th {
        border: 0px solid #DDDDDD;
        max-height: 60px;
        width: 100px;
        text-align: right;
    }

    .infoTable tr td {
        border: 0px solid #DDDDDD;
        padding: 5px 10px;
        height: 50px;
        text-align: left;
    }

    h5 {
        font-weight: normal;
        color: #188074;
        margin-left: 10px;
    }

</style>
</#assign>
<@aBase.tpl showHeader="false" css=cssContent bootVersion="-v3">
<div class="container" style="margin-top: 30px;width: 80%;">
    <h3 style="font-weight: normal; color:#188074"><span class="icon icon-columns"></span>&nbsp;土地利用现状分析结果展示</h3>

    <div class="pull-right" style="margin-top:-43px;margin-right: auto;"><h5>单位:
        <#switch unit>
            <#case 'SQUARE'>平方米<#break>
            <#case 'ACRES'>亩<#break>
            <#case 'HECTARE'>公顷<#break>
            <#default>平方米
        </#switch></h5></div>
</div>
    <#assign fixed>
        <#switch unit>
            <#case 'SQUARE'>0.##<#break>
            <#case 'ACRES'>0.####<#break>
            <#case 'HECTARE'>0.####<#break>
            <#default>0.##
        </#switch>
    </#assign>

    <#if result?size gt 0>
        <#if result[0]??>
            <#assign firstA=result[0].categoryA>
            <#assign firstB=result[0].categoryB>
        </#if>
    </#if>

<div id="basicContainer" class="container" style="width: 80%;">
<div class="row" style="margin-bottom: 15px;">
<div>
    <ul class="nav nav-tabs">
        <li class="active"><a href="#tab0" data-toggle="tab">合计</a></li>
        <li><a href="#tab1" data-toggle="tab">一级分类</a></li>
        <li><a href="#tab2" data-toggle="tab">二级分类</a></li>
        <#if firstB??>
            <#if firstB?keys?seq_contains('农用地') >
                <li><a href="#tab3" data-toggle="tab">三大类</a></li>
            </#if>
        </#if>
    </ul>
</div>
<div class="tab-content" style="margin-top: 5px;overflow-x: auto;">
<div id="tab0" class="tab-pane fade in active">
    <#if (result?size>0)>
        <#if firstB??>
            <table id="targetTable">
                <tr>
                    <th>类型</th>
                    <th>合计</th>
                    <th>建新规模</th>
                    <th>农用地</th>
                    <th>其中耕地</th>
                    <th>建设用地</th>
                    <th>未利用地</th>
                </tr>
                <#list result as xzq>
                    <#if ((xzq_index+1)=result?size)>
                        <tr>
                            <#assign itemB=xzq.categoryB>
                            <#assign anlysis_total = xzq["sumArea"]!?string(fixed)/>
                            <#assign analysis_jxgm=(itemB["农用地"]+itemB["未利用地"])!?string(fixed)/>
                            <#assign analysis_nyd=itemB["农用地"]!?string(fixed)/>
                            <#assign analysis_wlyd=itemB["未利用地"]!?string(fixed)/>
                            <#assign analysis_jsyd=itemB["建设用地"]!?string(fixed)/>
                            <#assign analysis_gd=itemB["01"]!?string(fixed)/>

                            <th>分析结果</th>
                            <td>${xzq["sumArea"]!?string(fixed)}</td>
                            <td>${(itemB["农用地"]+itemB["未利用地"])!?string(fixed)}</td>
                            <td><#if firstB?keys?seq_contains('农用地') >${itemB["农用地"]!?string(fixed)}</#if></td>
                            <td>${itemB["01"]!?string(fixed)}</td>
                            <td><#if firstB?keys?seq_contains('建设用地') >${itemB["建设用地"]!?string(fixed)}</#if></td>
                            <td><#if firstB?keys?seq_contains('未利用地') >${itemB["未利用地"]!?string(fixed)}</#if></td>
                        </tr>
                    </#if>
                </#list>
            </table>
        </#if>
    </#if>
</div>
<div id="tab1" class="tab-pane fade">
    <#if (result?size>0)>
        <#if firstA??>
            <table>
                <tr>
                    <th>坐落单位</th>
                    <th>合计</th>
                    <#list firstA as infoItem>
                        <#if infoItem["dlbm"]?contains(',')><#else >
                            <th>${infoItem["dlmc"]!}
                                (${infoItem["dlbm"]!})
                            </th></#if>
                    </#list>
                </tr>
                <#list result as xzq>
                    <tr>
                        <td><#if xzq.xzqmc??&&xzq.xzqmc!="null">${xzq["xzqmc"]!}<#else >${xzq["xzqdm"]!}</#if></td>
                        <td>${xzq["sumArea"]!?string(fixed)}</td>
                        <#assign areaInfo=xzq.categoryA>
                        <#list areaInfo as item>
                            <#if item["dlbm"]?contains(',')><#else >
                                <td>${item["area"]!?string(fixed)}</td></#if>
                        </#list>
                    </tr>
                </#list>
            </table>
        <#else >无分析结果 查看后台日志
        </#if>
    <#else ><h5>该分类下无分析结果</h5>
    </#if>
</div>
<div id="tab2" class="tab-pane fade">
    <#if (result?size>0)>
        <#if firstB??>
            <table>
                <tr>
                    <th rowspan="2">坐落单位</th>
                    <th rowspan="2">合计</th>
                    <th rowspan="2">耕地(01)</th>
                    <th colspan="3">其中</th>
                    <th rowspan="2">园地(02)</th>
                    <th colspan="3">其中</th>
                    <th rowspan="2">林地(03)</th>
                    <th colspan="3">其中</th>
                    <th rowspan="2">草地(04)</th>
                    <th colspan="3">其中</th>
                    <th rowspan="2">城镇村及工矿用地(20)</th>
                    <th colspan="5">其中</th>
                    <th rowspan="2">交通运输用地(10)</th>
                    <th colspan="6">其中</th>
                    <th rowspan="2">水域及水利设施用地(11)</th>
                    <th colspan="9">其中</th>
                    <th rowspan="2">其他用地</th>
                    <th colspan="6">其中</th>
                </tr>
                <tr>
                    <th>水田(011)</th>
                    <th>水浇地(012)</th>
                    <th>旱地(013)</th>
                    <th>果园(021)</th>
                    <th>茶园(022)</th>
                    <th>其他园地(023)</th>
                    <th>有林地(031)</th>
                    <th>灌木林地(032)</th>
                    <th>其他林地(033)</th>
                    <th>天然牧草地(041)</th>
                    <th>人工牧草地(042)</th>
                    <th>其他草地(043)</th>
                    <th>城市(201)</th>
                    <th>建制镇(202)</th>
                    <th>村庄(203)</th>
                    <th>采矿用地(204)</th>
                    <th>风景名胜及特殊用地(205)</th>
                    <th>铁路用地(101)</th>
                    <th>公路用地(102)</th>
                    <th>农村道路(104)</th>
                    <th>机场用地(105)</th>
                    <th>港口码头用地(106)</th>
                    <th>管道运输用地(107)</th>
                    <th>河流水面(111)</th>
                    <th>湖泊水面(112)</th>
                    <th>水库水面(113)</th>
                    <th>坑塘水面(114)</th>
                    <th>沿海滩涂(115)</th>
                    <th>内陆滩涂(116)</th>
                    <th>水渠(117)</th>
                    <th>水工建筑用地(118)</th>
                    <th>冰川及永久积雪(119)</th>
                    <th>设施农用地(122)</th>
                    <th>田坎(123)</th>
                    <th>盐碱地(124)</th>
                    <th>沼泽地(125)</th>
                    <th>沙地(126)</th>
                    <th>裸地(127)</th>
                </tr>
                <#list result as xzq>
                    <#assign item=xzq.categoryB>
                    <tr>
                        <td><#if xzq.xzqmc??&&xzq.xzqmc!="null">${xzq["xzqmc"]!}<#else >${xzq["xzqdm"]!}</#if></td>
                        <td>${xzq["sumArea"]!?string(fixed)}</td>
                        <td>${item["01"]!?string(fixed)}</td>
                        <td><#if item["011"]??> ${item["011"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["012"]??>${item["012"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["013"]??>${item["013"]!?string(fixed)}<#else >0</#if></td>
                        <td>${item["02"]!?string(fixed)}</td>
                        <td><#if item["021"]??>${item["021"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["022"]??>${item["022"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["023"]??>${item["023"]!?string(fixed)}<#else >0</#if></td>
                        <td>${item["03"]!?string(fixed)}</td>
                        <td><#if item["031"]??>${item["031"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["032"]??>${item["032"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["033"]??>${item["033"]!?string(fixed)}<#else >0</#if></td>
                        <td>${item["04"]!?string(fixed)}</td>
                        <td><#if item["041"]??>${item["041"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["042"]??>${item["042"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["043"]??>${item["043"]!?string(fixed)}<#else >0</#if></td>
                        <td>${item["20"]!?string(fixed)}</td>
                        <td><#if item["201"]??>${item["201"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["202"]??>${item["202"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["203"]??>${item["203"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["204"]??>${item["204"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["205"]??>${item["205"]!?string(fixed)}<#else >0</#if></td>
                        <td>${item["10"]!?string(fixed)}</td>
                        <td><#if item["101"]??>${item["101"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["102"]??>${item["102"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["104"]??>${item["104"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["105"]??>${item["105"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["106"]??>${item["106"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["107"]??>${item["107"]!?string(fixed)}<#else >0</#if></td>
                        <td>${item["11"]!?string(fixed)}</td>
                        <td><#if item["111"]??>${item["111"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["112"]??>${item["112"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["113"]??>${item["113"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["114"]??>${item["114"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["115"]??>${item["115"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["116"]??>${item["116"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["117"]??>${item["117"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["118"]??>${item["118"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["119"]??>${item["119"]!?string(fixed)}<#else >0</#if></td>
                        <td>${item["12"]!?string(fixed)}</td>
                        <td><#if item["122"]??>${item["122"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["123"]??>${item["123"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["124"]??>${item["124"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["125"]??>${item["125"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["126"]??>${item["126"]!?string(fixed)}<#else >0</#if></td>
                        <td><#if item["127"]??>${item["127"]!?string(fixed)}<#else >0</#if></td>
                    </tr>
                </#list>
            </table>
        <#else >无分析结果 查看后台日志</#if>
    <#else ><h5>该分类下无分析结果</h5></#if>
</div>
    <#if firstB??&&(firstB?keys?seq_contains('农用地')) >
    <div id="tab3" class="tab-pane fade">
        <#if (result?size>0)>
            <#if firstB??>
                <table>
                    <tr>
                        <th>坐落单位</th>
                        <th>合计</th>
                        <th>农用地</th>
                        <th>建设用地</th>
                        <th>未利用地</th>
                    </tr>
                    <#list result as xzq>
                        <tr>
                            <#assign itemB=xzq.categoryB>
                            <td><#if xzq.xzqmc??&&xzq.xzqmc!="null">${xzq["xzqmc"]!}<#else >${xzq["xzqdm"]!}</#if></td>
                            <td>${xzq["sumArea"]!?string(fixed)}</td>
                            <td><#if firstB?keys?seq_contains('农用地') >${itemB["农用地"]!?string(fixed)}</#if></td>
                            <td><#if firstB?keys?seq_contains('建设用地') >${itemB["建设用地"]!?string(fixed)}</#if></td>
                            <td><#if firstB?keys?seq_contains('未利用地') >${itemB["未利用地"]!?string(fixed)}</#if></td>
                        </tr>
                    </#list>
                </table>
            </#if>
        </#if>
    </div>
    </#if>
</div>
</div>
<div style="text-align: center;padding-top: 20px;">
    <a class="btn btn-primary" style="margin-right: 12px;" onclick="exportExcel();">导出excel</a>
    <#if exportable><a class="btn btn-primary" data-toggle="tooltip" data-placement="bottom"
                       style="margin-right: 12px;"
                       title="<div style='float:left;'><button class='btn btn-default' onclick='exportFeatures(0);'> shp</button>&nbsp;&nbsp;&nbsp;<button class='btn btn-default' onclick='exportFeatures(1);'>dwg</button></div>">导出图形</a></#if>
</div>
</div>

<script src="<@com.rootPath/>/static/js/JSONUtil.js"></script>
<script src="<@com.rootPath/>/static/js/mustache.js"></script>
<script type="text/x-mustache" id="template">
   <tr>
      <th>建新地块</th>
      <td>{{total}}</td>
      <td>{{jxgm}}</td>
      <td>{{nyd}}</td>
      <td>{{gd}}</td>
      <td>{{jsyd}}</td>
      <td>{{wlyd}}</td>
   </tr>
   <tr>
      <th>差值</th>
      <td>{{m_total}}</td>
      <td>{{m_jxgm}}</td>
      <td>{{m_nyd}}</td>
      <td>{{m_gd}}</td>
      <td>{{m_jsyd}}</td>
      <td>{{m_wlyd}}</td>
   </tr>

</script>
<script type="text/javascript">

    var idFields = ["id", "dkid", "地块id"];
    var data = '${resultStr!}';
    var geojson = '${ogGeo!}';//分析图形 geojson

    var dkids = getDkidsOfGeo().join(","); //从分析图形的geojson中获取到地块id集合 然后post到增减挂钩系统中进行查询
    $(document).ready(function () {
        debugger;
        var url = location.protocol + "//" + window.location.hostname + ":" + location.port + "/useplan/zjgg/geometryService/jxdk/area";
        $.ajax({
            type: 'POST',
            url: url,
            data: {dkid: dkids},
            dataType: 'json',
            success: function (r) {
                if (r.hasOwnProperty("success") && r.success === false)alert(r.msg);
                var obj = r.result;
                if (!obj.hasOwnProperty("total")) {
                    return;
                }
                var total = obj.total;
                var jsyd = obj.jsyd;
                var nyd = obj.nyd;
                var wlyd = obj.wlyd;
                var gd = obj.gd;
                //渲染模板
                var template = $('#template').html();
                Mustache.parse(template);
                var renderObj = {total: total, jsyd: jsyd, nyd: nyd, wlyd: wlyd, gd: gd,
                    "jxgm": function () {
                        return this.jsyd + this.nyd;
                    },
                    m_total: (${anlysis_total}-total).toFixed(2),
                    m_jxgm: (${analysis_jxgm}-nyd - wlyd).toFixed(2),
                    m_jsyd: (${analysis_jsyd}-jsyd).toFixed(2),
                    m_wlyd: (${analysis_wlyd}-wlyd).toFixed(2),
                    m_nyd: (${analysis_nyd}-nyd).toFixed(2),
                    m_gd: (${analysis_gd}-gd).toFixed(2)
                };
                var rendered = Mustache.render(template, renderObj);
                $('#targetTable').append(rendered);
            },
            error: function (r) {
                alert("--error--");
            }
        });

    });
    /***
     * 取出分析图形的properties中的地块id 组织成array
     * */
    function getDkidsOfGeo() {
        var _arr = [];
        var geo = JSONUtil.decode(geojson);
        if (geo && geo.hasOwnProperty("type")) {
            switch (geo["type"]) {
                case "Feature":
                {
                    var _property = geo["properties"];
                    for (var _k in _property) {
                        for (var i = 0; i < idFields.length; i++) {
                            if (idFields[i].toLocaleLowerCase() === _k) {
                                _arr.push(_property[_k]);
                            }
                        }
                    }
                    break;
                }
                case "FeatureCollection":
                {
                    var features= geo["features"];
                    for(var i=0;i<features.length;i++){
                        var item=features[i];
                        if (item.hasOwnProperty("properties")) {
                            var _property=item.properties;
                            _arr.push(_property["地块id"]);
                        }
                    }
                    break;
                }
            }
        }
        return _arr;
    }

    /**
     * 导出分析结果至excel
     */
    function exportExcel() {
        openPostWindow("<@com.rootPath/>/geometryService/export/analysis", data, "tdlyxz.xml");
    }

    function openPostWindow(url, data, fileName) {
        if (data == "") {
            alert("无导出数据!");
            return;
        }
        var tempForm = document.createElement("form");
        tempForm.method = "post";
        tempForm.action = url;
        var hideInput1 = document.createElement("input");
        hideInput1.type = "hidden";
        hideInput1.name = "data"
        hideInput1.value = data;
        var hideInput2 = document.createElement("input");
        hideInput2.type = "hidden";
        hideInput2.name = "fileName"
        hideInput2.value = fileName;
        tempForm.appendChild(hideInput1);
        if (fileName != null && fileName != "null" && fileName != "")
            tempForm.appendChild(hideInput2);
        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);
    }

</script>
</@aBase.tpl>
