<#--省厅增减挂钩系统订制页面-->

<#macro tdghsc key="">
    <#if result[key]??>
        <#assign info=result["${key}"].info>
    <table style="margin-top: 20px;">
        <tr>
            <th>类别</th>
            <th>所占面积(m<sup>2</sup>)</th>
        </tr>
        <#list info[1..] as item>
            <tr>
                <td style="text-align: center;">${item["LXMC"]!}</td>
                <td>${item["AREA"]!?string("####")}</td>
            </tr>
        </#list>
    </table>
    <#else ><h5>该分类下无分析结果</h5>
    </#if>
</#macro>
<#macro detailArea detail lxdm="" lxmc="">
    <#assign dm=detail["类型代码"]/>
    <#assign mc=detail["类型名称"]/>
    <#if dm==lxdm>
        <#if mc==lxmc>
        ${detail["面积"]!?string("####")}
        <#else >0
        </#if>
    <#else >0
    </#if>
</#macro>
<#assign cssContent>
<style>
    table tr td {
        border: 1px solid #bbbbbb;
        padding: 5px 10px;

    }

    table tr th {
        border: 1px solid #bbbbbb;
        padding: 10px;
        background-color: #cccccc;
    }

    table {
        background-color: transparent;
        border: 1px solid #bbbbbb;
        table-layout: auto;
        border-collapse: collapse;
        width: 90%;
        margin-left: auto;
        margin-right: auto;
    }

    .large {
        min-height: 572px;
        border: 1px solid #ddd;
        border-radius: 4px;
        overflow: hidden;
        word-break: break-all;
    }

    h5 {
        font-weight: normal;
        color: #000;
        margin-left: 10px;
    }

    .tree {
        min-height:20px;
        padding:10px 5px;
        margin-bottom:20px;
        background-color:#fbfbfb;
        border:1px solid #999;
        -webkit-border-radius:4px;
        -moz-border-radius:4px;
        border-radius:4px;
        -webkit-box-shadow:inset 0 1px 1px rgba(0, 0, 0, 0.05);
        -moz-box-shadow:inset 0 1px 1px rgba(0, 0, 0, 0.05);
        box-shadow:inset 0 1px 1px rgba(0, 0, 0, 0.05)
    }
    .tree li {
        list-style-type:none;
        margin:0;
        padding:10px 5px 0 5px;
        position:relative;
        width:200px;
    }
    .tree li::before, .tree li::after {
        content:'';
        left:-20px;
        position:absolute;
        right:auto
    }
    .tree li::before {
        border-left:1px solid #999;
        bottom:50px;
        height:100%;
        top:0;
        width:1px
    }
    .tree li::after {
        border-top:1px solid #999;
        height:20px;
        top:25px;
        width:25px
    }
    .tree li span {
        -moz-border-radius:5px;
        -webkit-border-radius:5px;
        border:1px solid #999;
        border-radius:5px;
        display:inline-block;
        padding:3px 8px;
        text-decoration:none
    }
    .tree li.parent_li>span {
        cursor:pointer
    }
    .tree>ul>li::before, .tree>ul>li::after {
        border:0
    }
    .tree li:last-child::before {
        height:30px
    }
    .tree li.parent_li>span:hover, .tree li.parent_li>span:hover+ul li span {
        background:#eee;
        border:1px solid #94a0b4;
        color:#000
    }
    .tree i{
        color: #0b69ac;;
    }

</style>
</#assign>
<@aBase.tpl showHeader="true" css=cssContent>
<div class="container">
    <div>
        <h3 style="font-weight: normal; color:#188074"><span class="icon icon-columns"></span>&nbsp;土地规划分析结果展示</h3>
    </div>
    <div style="float:right;margin-bottom: 10px;margin-top: -40px;margin-right: 20px;">
        <input type="button" value="导出excel" onclick="exportExcel()" style="color:#188074;"/></div>
    <div class="row">
        <div style="width:220px;float:left;">
            <ul class="nav nav-pills nav-stacked">
                <li class="active"><a href="#TDYTQInfo" data-toggle="tab">土地用途分区</a></li>
                <li><a href="#JSYDGZQInfo" data-toggle="tab">建设用地管制区</a></li>
                <li><a href="#GHJBNTTZInfo" data-toggle="tab">规划基本农田调整</a></li>
                <li><a href="#MZZDJSXMInfo" data-toggle="tab">重点建设项目</a></li>
                <li><a href="#DetailInfo" data-toggle="tab">详细数据</a></li>
            </ul>
        </div>
        <div class="span9">
            <div class="tab-content large">
                <div id="TDYTQInfo" class="tab-pane fade in active"><@tdghsc key="土地用途分区"></@tdghsc></div>
                <div id="JSYDGZQInfo" class="tab-pane fade"><@tdghsc key="建设用地管制区"></@tdghsc></div>
                <div id="GHJBNTTZInfo" class="tab-pane fade"><@tdghsc key="规划基本农田调整"></@tdghsc></div>
                <div id="MZZDJSXMInfo" class="tab-pane fade"><@tdghsc key="重点建设项目"></@tdghsc></div>
                <div id="DetailInfo" class="tab-pane fade" style="max-height: 600px;overflow-y: auto;">
                <#--<#if result["detail"]??>-->
                        <#--<#assign detail=result.detail/>-->
                        <#--<table>-->
                            <#--<tr>-->
                                <#--<th rowspan="2">地块编号</th>-->
                                <#--<th colspan="4">建设用地管制区</th>-->
                                <#--<th colspan="3">基本农田</th>-->
                            <#--</tr>-->
                            <#--<tr>-->
                                <#--<th>允许建设用地区</th>-->
                                <#--<th>有条件建设用地区</th>-->
                                <#--<th>限制建设用地区</th>-->
                                <#--<th>禁止建设用地区</th>-->
                                <#--<th>保留基本农田</th>-->
                                <#--<th>调入基本农田</th>-->
                                <#--<th>调出基本农田</th>-->
                            <#--</tr>-->
                            <#--<#list detail as item>-->
                                <#--<tr>-->
                                    <#--<td>${item_index +1}</td>-->
                                    <#--<td><@detailArea detail=item lxdm="010" lxmc="允许建设用地区"></@detailArea></td>-->
                                    <#--<td><@detailArea detail=item lxdm="020" lxmc="有条件建设用地区"></@detailArea></td>-->
                                    <#--<td><@detailArea detail=item lxdm="030" lxmc="限制建设用地区"></@detailArea></td>-->
                                    <#--<td><@detailArea detail=item lxdm="040" lxmc="禁止建设用地区"></@detailArea></td>-->
                                    <#--<td><@detailArea detail=item lxdm="00" lxmc="保留基本农田"></@detailArea></td>-->
                                    <#--<td><@detailArea detail=item lxdm="01" lxmc="调入基本农田"></@detailArea></td>-->
                                    <#--<td><@detailArea detail=item lxdm="02" lxmc="调出基本农田"></@detailArea></td>-->
                                <#--</tr>-->
                            <#--</#list>-->
                        <#--</table>-->
                    <#--</#if>-->

                </div>
            </div>
        </div>
    </div>
</div>
<script src="<@com.rootPath/>/js/jquery/jquery.tools.min.js"></script>
<script src="<@com.rootPath/>/static/js/JSONUtil.js"></script>
<script src="<@com.rootPath/>/static/js/mustache.js"></script>
<script type="text/x-mustache" id="tdghscTpl">
    <table>
        <tr>
            <th rowspan="2">地块编号</th>
            <th colspan="4">建设用地管制区</th>
            <th colspan="3">基本农田</th>
        </tr>
        <tr>
            <th>允许建设用地区</th>
            <th>有条件建设用地区</th>
            <th>限制建设用地区</th>
            <th>禁止建设用地区</th>
            <th>保留基本农田</th>
            <th>调入基本农田</th>
            <th>调出基本农田</th>
        </tr>
        {{#detail}}
            <tr>
                <td>{{xh}}</td>
                <td>{{010}}</td>
                <td>{{020}}</td>
                <td>{{030}}</td>
                <td>{{040}}</td>
                <td>{{00}}</td>
                <td>{{01}}</td>
                <td>{{02}}</td>
            </tr>
        {{/detail}}
    </table>
</script>
<script type="text/javascript">

    var detail='${result["detail"]!}';

    //分组字段集合
    var groupFields=["og_pro_dkbh","og_pro_bh","og_pro_地块序号"];//,"og_pro_xmmc"

    $(document).ready(function () {
        if(detail!=undefined){
            var arr=JSONUtil.decode(detail);
            var data={};  //template data
            var _deatil=groupAndMerge(arr);
            if(_deatil!=undefined)
            {
                data.detail=_deatil;
                var template = $('#tdghscTpl').html();
                var tpl = Mustache.render(template,data);
                $("#DetailInfo").append(tpl);
            }
        }

    });

    /***
     * 对一个object数组进行 分组合并
     * 返回新的数组
     * @param arr
     * */
    function groupAndMerge(arr) {
        if (arr != undefined && arr.length > 0) {
            var groupMap = {};                //分组map
            var gk=findGroupField(arr[0]);    //找出分组的key
            if(gk===undefined)return;
            for (var i = 0; i < arr.length; i++) {
                var item = arr[i];
                var gv=item[gk];  //分组值
                if(groupMap[gv] === undefined){
                    var list = [];
                    list.push(item);
                    groupMap[gv] = list;
                }else{
                    groupMap[gv].push(item);
                }
            }

            var detail=[];      //结果数组
            for(var _key in groupMap){
                var _d={};
                var _arr=groupMap[_key];
                _d.xh= _key;
                if (_arr != undefined && _arr.length > 0) {
                    _d["010"]=sumArea(_arr,"010","允许建设用地区");
                    _d["020"]=sumArea(_arr,"020","有条件建设用地区");
                    _d["030"]=sumArea(_arr,"030","限制建设用地区");
                    _d["040"]=sumArea(_arr,"040","禁止建设用地区");
                    _d["00"]=sumArea(_arr,"010","保留基本农田");
                    _d["01"]=sumArea(_arr,"010","调入基本农田");
                    _d["02"]=sumArea(_arr,"010","调出基本农田");
                    detail.push(_d);
                }
            }
            return detail;
        }
    }

    /***
     * 找出分组的key
     * */
    function findGroupField(obj){
        for(var k in obj){
            for (var i = 0; i < groupFields.length; i++) {
                if (groupFields[i] === k.toLocaleLowerCase())
                    return k;
            }
        }
        return undefined;
    }

    /***
     * 统计分组后的各项面积值
     * @param arr    该分类下的数组
     * @param lxdm   类型代码
     * @param lxmc   类型名称
     * */
    function sumArea(arr,lxdm,lxmc){
        var sum=0;
        for (var i = 0; i < arr.length; i++) {
            var _item = arr[i];
            if (_item["类型代码"] === lxdm && _item["类型名称"] === lxmc)
                sum = sum + _item["面积"];
        }
        return sum.toFixed(0);
    }

    /**
     *
     * 导出excel
     */
    function exportExcel() {
        var fileName = "ghscfx_analysis.xlsx";
        var officeVersion = '${env.getEnv("office.plugin.version")!}';
        if (officeVersion == 'old')
            fileName = "ghscfx_analysis.xls";
        openPostWindow("<@com.rootPath/>/geometryService/export/excel", '${excelData}', fileName);
    }

    function openPostWindow(url, data, fileName) {
        if (data == "") {
            alert("无导出数据!");
            return;
        }
        var tempForm = document.createElement("form");
        tempForm.method = "post";
        tempForm.action = url;
        var hideInput1 = document.createElement("input");
        hideInput1.type = "hidden";
        hideInput1.name = "data"
        hideInput1.value = data;
        var hideInput2 = document.createElement("input");
        hideInput2.type = "hidden";
        hideInput2.name = "fileName"
        hideInput2.value = fileName;
        tempForm.appendChild(hideInput1);
        if (fileName != null && fileName != "null" && fileName != "")
            tempForm.appendChild(hideInput2);
        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);
    }
</script>
</@aBase.tpl>