<#assign cssContent>
<style>
    table tr td {
        border: 1px solid #bbbbbb;
        padding: 5px 10px;

    }

    table tr th {
        border: 1px solid #bbbbbb;
        padding: 10px;
        background-color: #cccccc;
    }

    table {
        background-color: transparent;
        border: 1px solid #bbbbbb;
        table-layout: auto;
        border-collapse: collapse;
        width: 90%;
        margin-left: auto;
        margin-right: auto;
        /*margin-top: 20px;*/
        /*margin-bottom: 10px;*/
    }

    .large {
        min-height: 572px;
        border: 1px solid #ddd;
        border-radius: 4px;
        overflow: hidden;
        word-break: break-all;
    }

    .detailPanel {
        display: none;

        z-index: 10000;

        background-color: #fafafa;

        width: 675px;
        min-height: 200px;
        max-height: 630px;
        /*overflow-y: auto;*/
        border: 1px solid #666;

        /* CSS3 styling for latest browsers */
        -moz-box-shadow: 0 0 90px 5px #000;
        -webkit-box-shadow: 0 0 90px #000;
    }

    .close {

        background-image: url("<@com.rootPath/>/img/overlay_close.png");
        position: absolute;
        right: 0px;
        top: -5px;
        cursor: pointer;
        height: 32px;
        width: 32px;
    }

    h5 {
        font-weight: normal;
        color: #000;
        margin-left: 10px;
    }

</style>
</#assign>
<@aBase.tpl showHeader="true" css=cssContent>
<div class="container">
    <div>
        <h3 style="font-weight: normal; color:#188074"><span class="icon icon-columns"></span>&nbsp;土地规划分析结果展示</h3>
    </div>
    <div style="float:right;margin-bottom: 10px;margin-top: -40px;margin-right: 20px;">
        <input type="button" value="导出excel" onclick="exportExcel()" style="color:#188074;"/></div>
    <div class="row">
        <div style="width:220px;float:left;">
            <ul class="nav nav-pills nav-stacked">
                <li class="active"><a href="#TDYTQInfo" data-toggle="tab">土地用途分区</a></li>
                <li><a href="#JSYDGZQInfo" data-toggle="tab">建设用地管制区</a></li>
                <li><a href="#GHJBNTTZInfo" data-toggle="tab">规划基本农田调整</a></li>
                <li><a href="#MZZDJSXMInfo" data-toggle="tab">重点建设项目</a></li>
            </ul>
        </div>
        <div class="span9">
            <div class="tab-content large">
                <div id="TDYTQInfo" class="tab-pane fade in active"><@com.tdghsc1 key="土地用途分区"></@com.tdghsc1></div>
                <div id="JSYDGZQInfo" class="tab-pane fade"><@com.tdghsc1 key="建设用地管制区"></@com.tdghsc1></div>
                <div id="GHJBNTTZInfo" class="tab-pane fade"><@com.tdghsc1 key="规划基本农田调整"></@com.tdghsc1></div>
                <div id="MZZDJSXMInfo" class="tab-pane fade"><@com.tdghsc1 key="重点建设项目"></@com.tdghsc1></div>
            </div>
        </div>
    </div>
</div>
<script src="<@com.rootPath/>/js/jquery/jquery.tools.min.js"></script>
<script type="text/javascript">
    $(document).ready(function () {
        $('.toggle').click(function () {
            var selected = $(this);
            var id = selected.parent()[0].id;
            $('.toggle').each(function () {

                if ($(this).hasClass('icon-double-angle-up')) {

                    $(this).addClass('icon-double-angle-down').removeClass('icon-double-angle-up');
                    $("#detailPanel" + $(this).parent()[0].id.substring(6)).slideToggle("slow");
                }

                else {
                    if ($(this).parent()[0].id == id) {

                        $(this).addClass('icon-double-angle-up').removeClass('icon-double-angle-down');
                        var index = id.substring(6);
                        $("#detailPanel" + index).slideToggle("slow");
                    }

                }

            });


        });
    });
    function detailInfo(index) {

        $("td[rel]").overlay({
            closeOnClick: true
//              close:null

        });
    }

    /**
     *
     * 导出excel
     */
    function exportExcel() {
        var fileName = "ghscfx_analysis.xlsx";
        var officeVersion = '${env.getEnv("office.plugin.version")!}';
        if (officeVersion == 'old')
            fileName = "ghscfx_analysis.xls";
        openPostWindow("<@com.rootPath/>/geometryService/export/excel", '${excelData}', fileName);
    }

    function openPostWindow(url, data, fileName) {
        if (data == "") {
            alert("无导出数据!");
            return;
        }
        var tempForm = document.createElement("form");
        tempForm.method = "post";
        tempForm.action = url;
        var hideInput1 = document.createElement("input");
        hideInput1.type = "hidden";
        hideInput1.name = "data"
        hideInput1.value = data;
        var hideInput2 = document.createElement("input");
        hideInput2.type = "hidden";
        hideInput2.name = "fileName"
        hideInput2.value = fileName;
        tempForm.appendChild(hideInput1);
        if (fileName != null && fileName != "null" && fileName != "")
            tempForm.appendChild(hideInput2);
        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);
    }
</script>
</@aBase.tpl>