<#--
文件用途：马鞍山综合分析订制页面
版本:    v2.1.4+
-->

<#--根据分析的fid以及组织好的value对象 返回要显示的报告内容-->
<#macro generateSummaryText fid value>
    <#if value.total &gt;0>
        <#switch fid>
            <#case "xz">
            本地块与${value.alias!}图层叠加，压盖农用地<span class="number">${value.nyd!0}</span>m<sup>2</sup>,
            压盖建设用地<span class="number">${value.jsyd!0}</span>m<sup>2</sup>,压盖未利用地<span class="number">${value.wlyd!0}</span>m<sup>2</sup>,
            合计<span class="number">${value.total!0}</span>m<sup>2</sup>.
                <#break/>
            <#case "gh">
                <#break/>
            <#case "bp">
            本地块与${value.alias!}图层叠加，压盖已报<span class="number">${value.yb!0}</span>m<sup>2</sup>,
            压盖未报<span class="number">${value.wb!0}</span>m<sup>2</sup>,合计<span class="number">${value.total!0}</span>m<sup>2</sup>.
                <#break/>
            <#case "gd">
            本地块与${value.alias!}图层叠加，压盖已供<span class="number">${value.yg!0}</span>m<sup>2</sup>,
            压盖未供<span class="number">${value.wg!0}</span>m<sup>2</sup>,合计<span class="number">${value.total!0}</span>m<sup>2</sup>.
                <#break/>
            <#case "cl">
            本地块与${value.alias!}图层叠加,压盖<span class="number">${value.total!0}</span>个.
                <#break/>
            <#case "sp">
            本地块与${value.alias!}图层叠加,压盖<span class="number">${value.total!0}</span>个.
                <#break/>
            <#case "tdlygh">
            本地块与${value.alias!}相关图层叠加,符合规划面积<span class="number">${value.fhgh!0}</span>m<sup>2</sup>,
            不符合规划面积<span class="number">${value.bfhgh!0}</span>m<sup>2</sup>,属于有条件建设区面积<span class="number">${value.ytj!0}</span>m<sup>2</sup>
                <#break/>
            <#default>
            本地块与${value.alias!}图层叠加,压盖<span class="number">${value.total!0}</span>m<sup>2</sup>.
                <#break/>
        </#switch>
    <#else >
    本地块与${value.alias!}图层无压盖.
    </#if>
</#macro>

<#assign cssContent>
<style>
    table tr td {
        border: 1px solid #ddd;
        padding: 5px 10px;
        height: 50px;
        text-align: center;
    }

    table tr th {
        border: 1px solid #ddd;
        padding: 10px;
        max-height: 60px;
        min-width: 80px;
        text-align: center;
    }

    table {
        background-color: transparent;
        border: 1px solid #ddd;
        table-layout: auto;
        border-collapse: collapse;
        margin-left: auto;
        margin-right: auto;
        margin-bottom: 18px;
        width: 100%;
    }
    .large {
        min-height: 572px;
        border:0px !important;
        border-radius: 4px;
        overflow: hidden;
        word-break: break-all;
    }
    .tab-content{
        padding:20px;
        border: 1px solid #ddd;
        border-top: none;
        border-radius: 0 0 5px 5px;
    }
    .nav-tabs{
        margin-bottom: 0px;
    }
    h5{
        font-weight: normal;
        color:#000;
        margin-left: 10px;
    }

    a:hover {
        color: purple;
    }

    .number {
        font-size: 23px;
        color: #1c50b0;
        padding: 0 5px;
    }

    .summary {
        font-size: 16px;
    }

    .row {
        margin-left: 2px;
    }
    li{
        padding: 4px 0;
    }

    .mediumWidth {
        min-width: 95px !important;
    }

    .longWidth {
        min-width: 105px !important;
    }

    .xlongWidth {
        min-width: 120px !important;
    }

</style>
</#assign>
<@aBase.tpl showHeader="false" css=cssContent>
<div class="container" style="width: 90%;">
    <div class="row">
        <div style="float:left;">
            <h3 style="font-weight: normal; color:#188074"><span class="icon icon-columns"></span>&nbsp;综合分析结果展示</h3>
        </div>
        <div style="float:right;margin-top: 20px;margin-right: 83px;">
            <input type="button" value="导出excel" onclick="exportExcel()" style="color:#188074;"/>
        </div>
    </div>

    <div class="row">
        <div style="width:220px;float:left;">
            <ul class="nav nav-pills nav-stacked">
                <#list result?keys as key>
                    <#assign value=result[key]!/>
                    <li <#if key_index==0>class="active"</#if>><a href="#${key}"
                                                                  data-toggle="tab">${value["alias"]!}</a>
                    </li>
                </#list>
                <#if result??>
                    <li><a href="#Summary" data-toggle="tab">分析报告</a></li>
                </#if>
            </ul>
        </div>
        <div>
            <div class="tab-content large">
                <#list result?keys as key>
                    <#assign item=result[key]!/>
                    <div id="${key!}" class="tab-pane fade in <#if key_index==0>active</#if>">
                    ${item.tpl!}
                    </div>
                </#list>

                <div id="Summary" class="tab-pane fade in">
                    <div class="well well-lg summary">
                        <#if result??>
                            <ol>
                                <#if ogArea??>
                                    <li>本地块面积 <span class="number">${ogArea!}</span>m<sup>2</sup></li>
                                </#if>
                                <#list result?keys as key>
                                    <#assign obj=result[key]!/>
                                    <li><@generateSummaryText fid=key value=obj["summary"] /></li>
                                </#list>
                            </ol>
                        <#else >无分析报告
                        </#if>
                    </div>
                    <#if result??>
                        <div style="text-align: center;padding-top: 20px;">
                            <a class="btn btn-primary" onclick="exportWord();">导出报告</a>
                        </div>
                    </#if>
                </div>
            </div>
        </div>
    </div>
</div>
<script src="<@com.rootPath/>/static/js/JSONUtil.js"></script>
<script type="text/javascript">

    $(document).ready(function () {
        $("[data-toggle='tooltip']").tooltip({
            html: true,
            trigger: 'click'
        });
    });

    /**
     * 导出shp/dwg
     * @param type
     * */
    function exportFeatures(shpId,type) {
        $("[data-toggle='tooltip']").tooltip('hide');
        if (shpId == null && shpId == '') {
            alert("shpId为空 无法执行导出操作");
            return;
        }
        var shpUrl = '${path_omp!'/omp'}/file/download/'.concat(shpId);
        var gpUrl = '${env.getEnv('dwg.gp.url')!}';
        switch (type) {
            case 0:
                window.location.target = '_blank';
                window.location.href = shpUrl;
                break;
            case 1:
                if (gpUrl == '') {
                    alert("导出dwg所需的GP服务地址为空，请检查配置!");
                    return;
                }
                $.ajax({
                    type: 'post',
                    sync: true,
                    url: '${path_omp!'/omp'}/geometryService/rest/export/dwg',
                    data: {shpUrl: shpUrl, gpUrl: gpUrl},
                    success: function (_r) {
                        debugger;
                        if (_r && _r.success == false)
                            alert(_r.msg);
                        else {
                            window.location.target = '_blank';
                            window.location.href = _r.result;
                        }
                    },
                    fail: function () {
                        alert(arguments[2]);
                    }
                });
                break;
        }
    }

    /***
     * 相交图形定位
     * @param geometry geojson 格式坐标串
     * */
    function gotoLocation(geo,key){
        var tpl = getMapTplByKey(key);
        var url = '<@com.rootPath/>/map/' + tpl + '?hideLeftPanel=true&hideTopBar=true&action=location&params=';
        var params = {};
        var locParam = {};
        locParam.geometry = geo;
        params.type = "coordsLocation";
        params.params = locParam;
        url = url.concat(JSONUtil.encode(params));
        var ogGeo='${geometry!}';
        url=url.concat("&ogGeo=".concat(ogGeo));
        window.open(url, '_blank');
    }

    /***
     * 根据分析id的不同 获得不同的地图定位模板名称
     * 后期若有增加 请现场实施人员自行增加
     * eg.
     * <pre>
     *    case 'key':
     *      retrun 'tplName';
     *      break;
     * </pre>
     * @param k
     * @since v2.1.4
     * */
    function getMapTplByKey(k) {
        switch (k) {
            case 'bp':
                return 'loc_bp';
                break;
            case 'gd':
                break;
            case 'cl':
                break;
            default:
                return '${tpl!}';
                break;
        }
    }

    /**
     * 导出word(分析报告)
     * */
    function exportWord(){
        openPostWindow("<@com.rootPath/>/geometryService/export/analysis", '${summaryData!}', "multi_report.xml","doc");

    }
    /**
     * 导出excel
     */
    function exportExcel() {
        openPostWindow("<@com.rootPath/>/geometryService/export/analysis", '${xlsData!}', "multi_mas.xml");
    }

    /***
     * export excel
     * @param url
     * @param data
     * @param fileName
     */
    function openPostWindow(url, data, fileName,fileType) {
        if (data == null || data == 'null')
            alert("无分析数据可导出!");
        else {
            var tempForm = document.createElement("form");
            tempForm.method = "post";
            tempForm.action = url;
            var hideInput1 = document.createElement("input");
            hideInput1.type = "hidden";
            hideInput1.name = "data"
            hideInput1.value = data;

            var hideInput2 = document.createElement("input");
            hideInput2.type = "hidden";
            hideInput2.name = "fileName"
            hideInput2.value = fileName;

            var hideInput3 = document.createElement("input");
            hideInput3.type = "hidden";
            hideInput3.name = "fileType"
            hideInput3.value = fileType;

            tempForm.appendChild(hideInput1);
            if (fileName != null && fileName != "null" && fileName != "")
                tempForm.appendChild(hideInput2);

            if (fileType != null && fileType != "null" && fileType != "")
                tempForm.appendChild(hideInput3);

            document.body.appendChild(tempForm);
            tempForm.submit();
            document.body.removeChild(tempForm);
        }
    }
    /***
     * for tdlyxz
     * @param url
     * @param data
     * @param fileName
     */
    function openPostWindowXZ(url, data, fileName) {
        if (data == "") {
            alert("无导出数据!");
            return;
        }
        var tempForm = document.createElement("form");
        tempForm.method = "post";
        tempForm.action = url;
        var hideInput1 = document.createElement("input");
        hideInput1.type = "hidden";
        hideInput1.name = "data"
        hideInput1.value = data;
        var hideInput2 = document.createElement("input");
        hideInput2.type = "hidden";
        hideInput2.name = "fileName"
        hideInput2.value = fileName;
        tempForm.appendChild(hideInput1);
        if (fileName != null && fileName != "null" && fileName != "")
            tempForm.appendChild(hideInput2);
        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);
    }
</script>
</@aBase.tpl>

