<#assign cssContent>
<style>
    table tr td {
        border: 1px solid #ddd;
        padding: 5px 10px;
    }

    table tr th {
        border: 1px solid #ddd;
        padding: 10px;
    }

    table {
        background-color: transparent;
        border: 1px solid #ddd;
        table-layout: auto;
        border-collapse: collapse;
    }

    .tab-content {
        padding: 20px;
        border: 1px solid #ddd;
        border-top: none;
        border-radius: 0 0 5px 5px;
    }

    .nav-tabs {
        margin-bottom: 0px;
    }

    .detailPanel {
        display: none;
        padding: 10px;
    }
</style>
</#assign>
<@aBase.tpl showHeader="false" css=cssContent>
<div class="container">
    <div>
        <h3 style="font-weight: normal; color:#188074"><span class="icon icon-columns"></span>&nbsp;分析结果展示</h3>
    </div>
    <#if general??>
        <div class="well" style="color: #188074;font-size: 15px;">图形面积:&nbsp;${general.geoArea!?string('0.####')}&nbsp;m<sup>2</sup>&nbsp;&nbsp;未覆盖面积:&nbsp;${general.unCoverArea!?string('0.####')}
            &nbsp;m<sup>2</sup></div></#if>
    <div style="margin: 20px auto;">
        <ul class="nav nav-tabs">
            <#list info as parent>
                <li <#if parent_index==0>class="active"</#if> ><a href="#info${parent_index}"
                                                                  data-toggle="tab">${parent["alias"]!}</a></li>
            </#list>
        </ul>
        <div class="tab-content">
            <#list info as parent>
                <div id="info${parent_index}" class="tab-pane fade <#if parent_index==0> in active</#if>">
                    <h4 style="font-weight: normal; color:#188074"><span class="icon icon-double-angle-right"></span>
                        分类面积 ${parent["value"]!?string("0.####")}&nbsp;m<sup>2</sup></a></h4>
                    <h4 style="font-weight: normal; color:#188074"><span class="icon icon-double-angle-right toggle"
                                                                         style="cursor:pointer;"></span> 详细信息</h4>

                    <div class="detailPanel">
                        <#assign children=parent.children>
                        <table>
                            <tr>
                                <#assign firstChild=children[0]>
                                <th>序号</th>
                                <#list firstChild as field>
                                    <th>${field.alias}</th>
                                </#list>
                            </tr>
                            <#list children as child>
                                <tr>
                                    <td>${child_index+1}</td>
                                    <#list child as f>
                                        <td>${f.value!}</td>
                                    </#list>
                                </tr>
                            </#list>
                        </table>
                    </div>
                </div>
            </#list>
        </div>
    </div>
    <div style="text-align: center;padding-top: 20px;">
        <button id="exportBtn" type="button" class="btn btn-primary" data-toggle="tooltip" data-placement="bottom"
                title="<div style='float:left;'><button class='btn btn-default' onclick='exportExcel(0);'>分组</button>&nbsp;&nbsp;&nbsp;<button class='btn btn-default' onclick='exportExcel(1);'>列表</button></div>">
            导&nbsp;出Excel
        </button>
    </div>
</div>
<script type="text/javascript">
    $(document).ready(function () {
        $('.toggle').click(function () {

            $("[data-toggle='tooltip']").tooltip('hide');

            if ($('.toggle').hasClass('icon-double-angle-down'))
                $('.toggle').addClass('icon-double-angle-right').removeClass('icon-double-angle-down');
            else
                $('.toggle').addClass('icon-double-angle-down').removeClass('icon-double-angle-right');
            $('.detailPanel').slideToggle("slow");
        });

        $("[data-toggle='tooltip']").tooltip({
            html: true,
            trigger: 'click'
        });

    });
    /**
     * 导出excel
     */
    function exportExcel(type) {
        switch (type) {
            case 0:
                openPostWindow("<@com.rootPath/>/geometryService/export/excel", '${excelData}', null);
                break;
            case 1:
                openPostWindow("<@com.rootPath/>/geometryService/export/excel", '${excelList}', null);
                break;
        }
        $("[data-toggle='tooltip']").tooltip('hide');
    }
    function openPostWindow(url, data, fileName) {
        if (data == "") {
            alert("无导出数据!");
            return;
        }
        var tempForm = document.createElement("form");
        tempForm.method = "post";
        tempForm.action = url;
        var hideInput1 = document.createElement("input");
        hideInput1.type = "hidden";
        hideInput1.name = "data"
        hideInput1.value = data;
        var hideInput2 = document.createElement("input");
        hideInput2.type = "hidden";
        hideInput2.name = "fileName"
        hideInput2.value = fileName;
        tempForm.appendChild(hideInput1);
        if (fileName != null && fileName != "null" && fileName != "")
            tempForm.appendChild(hideInput2);
        document.body.appendChild(tempForm);
        tempForm.submit();
        document.body.removeChild(tempForm);
    }
</script>
</@aBase.tpl>
