/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.utils;

import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public final class Utils {
    public static final int REGION_CODE_MAX_LENGTH = 6;
    private static final Map<String, String> wellKnownSimplePrefixes = new HashMap(4);
    private static final Map<String, String> wellKnownSimpleRegexs = new HashMap(4);
    static String regExOfchinese = "[\\u4e00-\\u9fa5]";
    static Pattern pattern = Pattern.compile(regExOfchinese);

    public static final String formatRegionCode(String value) {
        Assert.notNull((Object)value, (String)"region code can't be null");
        int maxLength = 6;
        StringBuilder sb = new StringBuilder();
        sb.append(value);
        if (StringUtils.startsWith((String)sb.toString(), (String)"3")) {
            while (sb.length() < 6) {
                sb.append("0");
            }
        }
        return sb.toString();
    }

    public static String replaceHolder(String data, Map<String, Object> params) throws Exception {
        String result = data;
        String[] values = data.split("\\$\\{+|\\}");
        for (int i = 0; i < values.length; ++i) {
            if (!params.containsKey(values[i])) continue;
            result = result.replaceAll("\\$\\{" + values[i] + "\\}", String.valueOf(params.get(values[i])));
        }
        return result;
    }

    public static String replaceHolder(String data, Object ... params) throws Exception {
        String result = data;
        String[] values = data.split("\\$\\{+|\\}");
        for (int i = 0; i < values.length; ++i) {
            if (params[i] == null) continue;
            result = result.replaceAll("\\$\\{" + values[i] + "\\}", String.valueOf(params[i]));
        }
        return result;
    }

    public static String replaceHolder(String placeholderPrefix, String placeholderSuffix, String data, Map<String, Object> params) throws Exception {
        String result = data;
        String simplePrefixForSuffix = (String)wellKnownSimplePrefixes.get(placeholderSuffix);
        if (simplePrefixForSuffix != null && placeholderPrefix.endsWith(simplePrefixForSuffix)) {
            placeholderPrefix = simplePrefixForSuffix;
        }
        String[] values = data.split(wellKnownSimpleRegexs.get(placeholderPrefix) == null ? "\\$\\{+|\\}" : (String)wellKnownSimpleRegexs.get(placeholderPrefix));
        for (int i = 0; i < values.length; ++i) {
            if (!params.containsKey(values[i])) continue;
            result = result.replaceAll("\\{" + values[i] + "\\}", String.valueOf(params.get(values[i])));
        }
        return result;
    }

    public static String urlReplaceHolder(String data, Map<String, Object> params) throws Exception {
        String result = data;
        String[] values = data.split("\\$\\{+|\\}");
        for (int i = 0; i < values.length; ++i) {
            if (!params.containsKey(values[i])) continue;
            result = result.replaceAll("\\$\\{" + values[i] + "\\}", URLEncoder.encode(MapUtils.getString(params, (Object)values[i]), "utf-8"));
        }
        return result;
    }

    public static Map updateMap(Object key, Object value, Map map) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        result.put(key, value);
        if (map != null && !map.isEmpty()) {
            result.putAll(map);
        }
        return result;
    }

    public static boolean isContainChinese(String value) {
        Matcher matcher = pattern.matcher(value);
        boolean flg = false;
        if (matcher.find()) {
            flg = true;
        }
        return flg;
    }

    static {
        wellKnownSimplePrefixes.put("}", "{");
        wellKnownSimplePrefixes.put("]", "[");
        wellKnownSimplePrefixes.put(")", "(");
        wellKnownSimpleRegexs.put("${", "\\$\\{+|\\}");
        wellKnownSimpleRegexs.put("{", "\\{+|\\}");
    }
}

