/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.utils;

import cn.gtmap.onemap.platform.utils.GeometryUtils;
import cn.gtmap.onemap.platform.utils.SRTransformations;
import cn.gtmap.onemap.platform.utils.UUIDGenerator;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public final class GeometryUtils {
    private static final String TYPE = "type";
    private static final String EPSG = "EPSG:";
    private static GeometryFactory factory = JTSFactoryFinder.getGeometryFactory();

    public static final Object parseGeoJSON(String value) {
        if (StringUtils.isBlank((String)value)) {
            throw new RuntimeException("GeoJSON can't be blank");
        }
        try {
            Map geo = (Map)JSON.parseObject((String)value, Map.class);
            if (!geo.containsKey(GeoTag.type.name())) {
                throw new RuntimeException("GeoJSON must have type key");
            }
            GeoTag tag = GeoTag.getTag((String)((String)geo.get(GeoTag.type.name())));
            switch (1.$SwitchMap$cn$gtmap$onemap$platform$utils$GeometryUtils$GeoTag[tag.ordinal()]) {
                case 1: {
                    return GeometryUtils.createPolygon((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
                case 2: {
                    return GeometryUtils.createGeometryCollection((JSONArray)((JSONArray)geo.get(GeoTag.geometries.name())));
                }
                case 3: {
                    return GeometryUtils.createMultiPolygon((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
                case 4: {
                    return GeometryUtils.createFeature((Map)geo);
                }
                case 5: {
                    return GeometryUtils.createFeatureCollection((JSONArray)((JSONArray)geo.get(GeoTag.features.name())));
                }
                case 6: {
                    return GeometryUtils.createPoint((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
                case 7: {
                    return GeometryUtils.createLine((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
                case 8: {
                    return GeometryUtils.createMultiPoint((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
                case 9: {
                    return GeometryUtils.createMultiLine((JSONArray)((JSONArray)geo.get(GeoTag.coordinates.name())));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(" Value isn't well-know format GeoJSON. detail error : [ " + e.getLocalizedMessage() + " ] ");
        }
        return null;
    }

    public static final Geometry convertSeShape(SeShape seShape) {
        Point geometry = null;
        try {
            double[][][] coordinates = seShape.getAllCoords(Integer.MAX_VALUE);
            JSONArray polygons = new JSONArray();
            JSONArray lineString = new JSONArray();
            JSONArray points = new JSONArray();
            switch (seShape.getType()) {
                case 1: {
                    for (int i = 0; i < coordinates.length; ++i) {
                        double[][] temp = coordinates[i];
                        for (int j = 0; j < temp.length; ++j) {
                            for (int m = 0; m < temp[j].length; ++m) {
                                points = new JSONArray();
                                points.add((Object)temp[j][m]);
                                points.add((Object)temp[j][++m]);
                            }
                        }
                    }
                    if (points.size() <= 0) break;
                    geometry = GeometryUtils.createPoint((JSONArray)points);
                    break;
                }
                case 4: {
                    for (int i = 0; i < coordinates.length; ++i) {
                        double[][] temp = coordinates[i];
                        for (int j = 0; j < temp.length; ++j) {
                            lineString = new JSONArray();
                            for (int m = 0; m < temp[j].length; ++m) {
                                points = new JSONArray();
                                points.add((Object)temp[j][m]);
                                points.add((Object)temp[j][++m]);
                                lineString.add((Object)points);
                            }
                        }
                    }
                    if (lineString.size() <= 0) break;
                    geometry = GeometryUtils.createLine((JSONArray)lineString);
                    break;
                }
                case 8: {
                    for (int i = 0; i < coordinates.length; ++i) {
                        double[][] temp = coordinates[i];
                        JSONArray polygon = new JSONArray();
                        for (int j = 0; j < temp.length; ++j) {
                            lineString = new JSONArray();
                            for (int m = 0; m < temp[j].length; ++m) {
                                points = new JSONArray();
                                points.add((Object)temp[j][m]);
                                points.add((Object)temp[j][++m]);
                                lineString.add((Object)points);
                            }
                            polygon.add((Object)lineString);
                        }
                        polygons.addAll((Collection)polygon);
                    }
                    if (polygons.size() <= 0) break;
                    geometry = GeometryUtils.createPolygon((JSONArray)polygons);
                }
            }
        }
        catch (SeException e) {
            throw new RuntimeException(e.getMessage());
        }
        return geometry;
    }

    private static SimpleFeature createFeature(Map value) {
        Geometry geometry = null;
        CoordinateReferenceSystem crs = null;
        Map properties = null;
        if (value.containsKey(GeoTag.geometry.name())) {
            geometry = GeometryUtils.createGeometry((JSONObject)((JSONObject)value.get(GeoTag.geometry.name())));
        }
        if (value.containsKey(GeoTag.crs.name())) {
            crs = GeometryUtils.createCRS((JSONObject)((JSONObject)value.get(GeoTag.crs.name())));
        }
        if (value.containsKey(GeoTag.properties.name())) {
            properties = GeometryUtils.createPros((JSONObject)((JSONObject)value.get(GeoTag.properties.name())));
        }
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(GeoTag.Feature.name());
        if (GeometryUtils.notNull((Object)geometry)) {
            typeBuilder.add(GeoTag.geometry.name(), Geometry.class);
        }
        if (GeometryUtils.notNull((Object)properties)) {
            Iterator i$ = properties.keySet().iterator();
            while (i$.hasNext()) {
                String key;
                typeBuilder.add(key, properties.get(key = (String)i$.next()) != null ? properties.get(key).getClass() : String.class);
            }
        }
        if (GeometryUtils.notNull((Object)crs)) {
            typeBuilder.add(GeoTag.crs.name(), String.class, crs);
        }
        SimpleFeatureType featureType = typeBuilder.buildFeatureType();
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        if (GeometryUtils.notNull((Object)geometry)) {
            featureBuilder.add((Object)geometry);
        }
        if (GeometryUtils.notNull((Object)properties)) {
            for (String key : properties.keySet()) {
                featureBuilder.add(properties.get(key));
            }
        }
        return featureBuilder.buildFeature(GeoTag.Feature.name().concat(UUIDGenerator.generate()));
    }

    private static FeatureCollection createFeatureCollection(JSONArray array) {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        for (Object o : array) {
            collection.add(GeometryUtils.createFeature((Map)((Map)o)));
        }
        return collection;
    }

    private static Geometry createGeometry(JSONObject value) {
        GeoTag tag = GeoTag.getTag((String)((String)value.get((Object)GeoTag.type.name())));
        switch (1.$SwitchMap$cn$gtmap$onemap$platform$utils$GeometryUtils$GeoTag[tag.ordinal()]) {
            case 1: {
                return GeometryUtils.createPolygon((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
            case 2: {
                return GeometryUtils.createGeometryCollection((JSONArray)((JSONArray)value.get((Object)GeoTag.geometries.name())));
            }
            case 3: {
                return GeometryUtils.createMultiPolygon((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
            case 6: {
                return GeometryUtils.createPoint((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
            case 7: {
                return GeometryUtils.createLine((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
            case 8: {
                return GeometryUtils.createMultiPoint((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
            case 9: {
                return GeometryUtils.createMultiLine((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name())));
            }
        }
        throw new RuntimeException("unsupport geometry type : [ " + tag.name() + " ]");
    }

    public static GeometryCollection createGeometryCollection(JSONArray array) {
        ArrayList<Object> geometries = new ArrayList<Object>();
        for (Object o : array) {
            JSONObject value = (JSONObject)o;
            GeoTag tag = GeoTag.getTag((String)((String)value.get((Object)GeoTag.type.name())));
            switch (1.$SwitchMap$cn$gtmap$onemap$platform$utils$GeometryUtils$GeoTag[tag.ordinal()]) {
                case 1: {
                    geometries.add(GeometryUtils.createPolygon((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                    break;
                }
                case 3: {
                    geometries.add(GeometryUtils.createMultiPolygon((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                    break;
                }
                case 6: {
                    geometries.add(GeometryUtils.createPoint((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                    break;
                }
                case 7: {
                    geometries.add(GeometryUtils.createLine((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                    break;
                }
                case 8: {
                    geometries.add(GeometryUtils.createMultiPoint((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                    break;
                }
                case 9: {
                    geometries.add(GeometryUtils.createMultiLine((JSONArray)((JSONArray)value.get((Object)GeoTag.coordinates.name()))));
                }
            }
        }
        return factory.createGeometryCollection(geometries.toArray(new Geometry[0]));
    }

    public static Polygon createPolygon(JSONArray array) {
        if (array.size() == 0) {
            throw new RuntimeException("Polygon specified with no rings");
        }
        try {
            LinearRing shell = GeometryUtils.createLinearRing((JSONArray)array.getJSONArray(0));
            LinearRing[] holes = null;
            if (array.size() > 1) {
                holes = new LinearRing[array.size() - 1];
                for (int i = 1; i < array.size(); ++i) {
                    holes[i - 1] = GeometryUtils.createLinearRing((JSONArray)array.getJSONArray(i));
                }
            }
            return factory.createPolygon(shell, holes);
        }
        catch (Exception e) {
            throw new RuntimeException("Polygon coordinates format error");
        }
    }

    public static MultiPolygon createMultiPolygon(JSONArray array) {
        if (array.size() == 0) {
            throw new RuntimeException(" no coordinates in MultiPolygon");
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Object o : array) {
            polygons.add(GeometryUtils.createPolygon((JSONArray)((JSONArray)o)));
        }
        return factory.createMultiPolygon(polygons.toArray(new Polygon[0]));
    }

    private static LinearRing createLinearRing(JSONArray array) {
        return factory.createLinearRing(GeometryUtils.coordinates((JSONArray)array));
    }

    public static Point createPoint(JSONArray array) {
        return factory.createPoint(GeometryUtils.coordinate((JSONArray)array));
    }

    private static MultiPoint createMultiPoint(JSONArray array) {
        return factory.createMultiPoint(GeometryUtils.coordinates((JSONArray)array));
    }

    public static LineString createLine(JSONArray array) {
        Assert.notNull((Object)array, (String)" line coordinates can't be null ");
        return factory.createLineString(GeometryUtils.coordinates((JSONArray)array));
    }

    private static MultiLineString createMultiLine(JSONArray array) {
        return factory.createMultiLineString(GeometryUtils.lineStrings((JSONArray)array));
    }

    private static CoordinateReferenceSystem createCRS(JSONObject value) {
        try {
            GeoTag tag = GeoTag.getTag((String)((String)value.get((Object)GeoTag.type.name())));
            JSONObject pros = (JSONObject)value.get((Object)GeoTag.properties.name());
            switch (1.$SwitchMap$cn$gtmap$onemap$platform$utils$GeometryUtils$GeoTag[tag.ordinal()]) {
                case 10: {
                    String code = (String)pros.get((Object)GeoTag.name.name());
                    try {
                        if (code == null) {
                            return null;
                        }
                        int c = Integer.parseInt(code);
                        return CRS.parseWKT((String)SRTransformations.getCoordinateSystem((int)c).toString());
                    }
                    catch (NumberFormatException e) {
                        if (code.contains("EPSG:")) {
                            return CRS.parseWKT((String)SRTransformations.getCoordinateSystem((int)Integer.valueOf(code.substring("EPSG:".length(), code.length()))).toString());
                        }
                        return CRS.decode((String)code, (boolean)true);
                    }
                }
                case 11: {
                    String wkt = (String)pros.get((Object)GeoTag.value.name());
                    wkt = SRTransformations.getCoordinateSystem((String)wkt).toString();
                    return CRS.parseWKT((String)wkt);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException("parse crs exception : [ " + e.getLocalizedMessage() + " ]");
        }
        catch (PeProjectionException e) {
            throw new RuntimeException("parse crs exception : [ " + e.getLocalizedMessage() + " ]");
        }
        return null;
    }

    private static Map<String, Object> createPros(JSONObject value) {
        HashMap<String, Object> pros = new HashMap<String, Object>();
        for (String key : value.keySet()) {
            pros.put(key, value.get((Object)key));
        }
        return pros;
    }

    private static Coordinate coordinate(JSONArray array) {
        Assert.notNull((Object)array, (String)" coordinates can't be null ");
        Coordinate c = new Coordinate();
        c.x = array.getDoubleValue(0);
        c.y = array.getDoubleValue(1);
        return c;
    }

    private static Coordinate[] coordinates(JSONArray array) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (Object o : array) {
            coordinates.add(GeometryUtils.coordinate((JSONArray)((JSONArray)o)));
        }
        return coordinates.toArray(new Coordinate[0]);
    }

    private static LineString[] lineStrings(JSONArray array) {
        ArrayList<LineString> lines = new ArrayList<LineString>();
        for (Object o : array) {
            lines.add(GeometryUtils.createLine((JSONArray)((JSONArray)o)));
        }
        return lines.toArray(new LineString[0]);
    }

    private static boolean notNull(Object value) {
        return value != null;
    }
}

