/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.utils;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.Assert;

public final class FilesUtils {
    public static final String IMAGE_PNG = "png";
    public static final String IMAGE_JPG = "jpg";
    public static final String IMAGE_BMP = "bmp";
    public static final String IMAGE_GIF = "gif";
    public static final String IMAGE_TIF = "tif";
    static List<String> images = new ArrayList();

    public static final boolean isImage(File file) {
        Assert.notNull((Object)file, (String)"\u6587\u4ef6\u4e0d\u53ef\u4e3a\u7a7a");
        String suffix = file.getPath().substring(file.getPath().lastIndexOf(".") + 1, file.getPath().length());
        if (StringUtils.isBlank((String)suffix)) {
            return false;
        }
        return images.contains(suffix.toLowerCase());
    }

    public static final boolean delFileOrDirectory(String path) throws IOException {
        boolean result = false;
        try {
            File file = new File(path);
            if (file.exists()) {
                if (file.isDirectory()) {
                    File[] files = file.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        files[i].delete();
                    }
                    result = file.delete();
                    return result;
                }
                result = file.delete();
                return result;
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generateFile(byte[] bytes, String filePath, String fileName) {
        FilterOutputStream bos = null;
        FileOutputStream fos = null;
        File file = null;
        try {
            File dir = new File(filePath);
            if (!dir.exists() && !dir.isDirectory()) {
                dir.mkdirs();
            }
            file = new File(filePath + "\\" + fileName);
            fos = new FileOutputStream(file);
            bos = new BufferedOutputStream(fos);
            bos.write(bytes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    static {
        images.add(IMAGE_PNG);
        images.add(IMAGE_JPG);
        images.add(IMAGE_BMP);
        images.add(IMAGE_GIF);
        images.add(IMAGE_TIF);
    }
}

