/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.utils;

import cn.gtmap.onemap.platform.utils.CoordinateConversion;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.geotools.geometry.jts.JTSFactoryFinder;

/*
 * Exception performing whole class analysis ignored.
 */
public final class CoordinateConversion {
    public static final int bj54ToXian80 = 0;
    public static final int nt94ToXian80 = 1;
    public static final int xian80ToNt94 = 2;
    private static List<Point> ptsNeedConvert = new ArrayList();
    private static GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();

    public double[] convert(int type) {
        ArrayList<Double> coords = new ArrayList<Double>();
        Bj54ToXian80 bj54ToXian = new Bj54ToXian80(this, null);
        Nt94ToXian80 nt94ToXian = new Nt94ToXian80(this, null);
        Xian80ToNt94 xian80ToNt = new Xian80ToNt94(this, null);
        for (Point point : ptsNeedConvert) {
            double[] coord;
            switch (type) {
                case 0: {
                    coord = bj54ToXian.convert(point.getX(), point.getY());
                    break;
                }
                case 1: {
                    coord = nt94ToXian.convert(point.getX(), point.getY());
                    break;
                }
                case 2: {
                    coord = xian80ToNt.convert(point.getX(), point.getY());
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.valueOf(type) + " is not supported!");
                }
            }
            coords.add(coord[0]);
            coords.add(coord[1]);
        }
        return ArrayUtils.toPrimitive((Double[])coords.toArray(new Double[0]));
    }

    public double[] convert(double A, double B, double T, double K) {
        ArrayList<Double> coords = new ArrayList<Double>();
        CustomConversion customConversion = new CustomConversion(this, null);
        customConversion.setParams(A, B, T, K);
        for (Point point : ptsNeedConvert) {
            double[] coord = customConversion.convert(point.getX(), point.getY());
            coords.add(coord[0]);
            coords.add(coord[1]);
        }
        return ArrayUtils.toPrimitive((Double[])coords.toArray(new Double[0]));
    }

    public Geometry convertGeometry(Geometry geometry, int type) {
        ptsNeedConvert.clear();
        if (geometry instanceof com.vividsolutions.jts.geom.Point) {
            this.addPoint(((com.vividsolutions.jts.geom.Point)geometry).getX(), ((com.vividsolutions.jts.geom.Point)geometry).getY());
            double[] coords = this.convert(type);
            return geometryFactory.createPoint(new Coordinate(coords[0], coords[1]));
        }
        if (geometry instanceof MultiPoint) {
            double[] coords = CoordinateConversion.getCoordinates((Coordinate[])geometry.getCoordinates());
            this.addPoints(coords);
            Coordinate[] coordinates = CoordinateConversion.array2Coords((double[])this.convert(type));
            return geometryFactory.createMultiPoint(coordinates);
        }
        if (geometry instanceof LineString) {
            this.addPoints(CoordinateConversion.getCoordinates((Coordinate[])geometry.getCoordinates()));
            return geometryFactory.createLineString(CoordinateConversion.array2Coords((double[])this.convert(type)));
        }
        if (geometry instanceof MultiLineString) {
            MultiLineString multiLineString = (MultiLineString)geometry;
            LineString[] lineStrings = new LineString[multiLineString.getNumGeometries()];
            for (int i = 0; i < lineStrings.length; ++i) {
                lineStrings[i] = (LineString)this.convertGeometry(multiLineString.getGeometryN(i), type);
            }
            return geometryFactory.createMultiLineString(lineStrings);
        }
        if (geometry instanceof Polygon) {
            Polygon polygon = (Polygon)geometry;
            LinearRing shell = CoordinateConversion.createLinearRing((Coordinate[])this.convertGeometry((Geometry)polygon.getExteriorRing(), type).getCoordinates());
            LinearRing[] holes = new LinearRing[polygon.getNumInteriorRing()];
            if (holes.length > 0) {
                for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                    holes[i] = CoordinateConversion.createLinearRing((Coordinate[])this.convertGeometry((Geometry)polygon.getInteriorRingN(i), type).getCoordinates());
                }
            }
            return geometryFactory.createPolygon(shell, holes);
        }
        if (geometry instanceof MultiPolygon || geometry instanceof GeometryCollection) {
            // empty if block
        }
        throw new RuntimeException("current geometry don't supported");
    }

    private static LinearRing createLinearRing(Coordinate[] coordinates) {
        return geometryFactory.createLinearRing(coordinates);
    }

    private static double[] getCoordinates(Coordinate[] coordinates) {
        ArrayList<Double> coords = new ArrayList<Double>();
        for (Coordinate c : coordinates) {
            coords.add(c.x);
            coords.add(c.y);
        }
        return ArrayUtils.toPrimitive((Double[])coords.toArray(new Double[0]));
    }

    private static Coordinate[] array2Coords(double[] coords) {
        ArrayList<Coordinate> coordinates = new ArrayList<Coordinate>();
        for (int i = 0; i < coords.length; i += 2) {
            Coordinate coordinate = new Coordinate(coords[i], coords[i + 1]);
            coordinates.add(coordinate);
        }
        return coordinates.toArray(new Coordinate[0]);
    }

    public void addPoint(double x, double y) {
        ptsNeedConvert.add(new Point(this, x, y));
    }

    public void addPoints(double[] coords) {
        for (int i = 0; i < coords.length; i += 2) {
            Point pnt = new Point(this, coords[i], coords[i + 1]);
            ptsNeedConvert.add(pnt);
        }
    }

    public void clear() {
        ptsNeedConvert = new ArrayList();
    }

    private void validateLatLon(double latitude, double longitude) {
        if (latitude < -90.0 || latitude > 90.0 || longitude < -180.0 || longitude >= 180.0) {
            throw new IllegalArgumentException("Legal ranges: latitude [-90,90], longitude [-180,180).");
        }
    }

    private double degreeToRadian(double degree) {
        return degree * Math.PI / 180.0;
    }

    private double radianToDegree(double radian) {
        return radian * 180.0 / Math.PI;
    }

    private double SIN(double value) {
        return Math.sin(value);
    }

    private double COS(double value) {
        return Math.cos(value);
    }

    static /* synthetic */ double access$400(CoordinateConversion x0, double x1) {
        return x0.COS(x1);
    }

    static /* synthetic */ double access$500(CoordinateConversion x0, double x1) {
        return x0.SIN(x1);
    }

    static /* synthetic */ double access$600(CoordinateConversion x0, double x1) {
        return x0.degreeToRadian(x1);
    }
}

