/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.utils;

import cn.gtmap.onemap.platform.utils.ArrayUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

public final class ArrayUtils {
    public static final String DEFAULT_SEPARATOR = ",";

    public static final boolean empty(String[] values) {
        if (values == null) {
            return true;
        }
        for (String value : values) {
            if (!StringUtils.isNotBlank((String)value)) continue;
            return false;
        }
        return true;
    }

    public static final boolean contains(String[] src, String des, boolean ignoreCase) {
        for (String item : src) {
            if (!StringUtils.isNotBlank((String)item) || !StringUtils.isNotBlank((String)des) || !(ignoreCase ? item.equalsIgnoreCase(des) : item.equals(des))) continue;
            return true;
        }
        return false;
    }

    public static final String[] add2Arrays(String[] des, String src) {
        if (des == null) {
            return new String[]{src};
        }
        String[] tmp = new String[des.length + 1];
        System.arraycopy(des, 0, tmp, 0, des.length);
        tmp[des.length] = src;
        return tmp;
    }

    public static final String[] add2Arrays(String[] des, String[] src) {
        if (des == null) {
            return src;
        }
        if (src == null) {
            return des;
        }
        String[] tmp = new String[des.length + src.length];
        System.arraycopy(src, 0, tmp, 0, src.length);
        System.arraycopy(des, 0, tmp, src.length, des.length);
        return tmp;
    }

    public static String arrayToString(String[] ig, String separator) {
        String str = "";
        if (ig != null && ig.length > 0) {
            for (int i = 0; i < ig.length; ++i) {
                str = str + (ig[i] + separator == null ? separator : DEFAULT_SEPARATOR);
            }
        }
        str = str.substring(0, str.length() - separator.length());
        return str;
    }

    public static String listToString(List list, String separator) {
        StringBuilder sb = new StringBuilder();
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (i < list.size() - 1) {
                    sb.append(list.get(i) + separator == null ? separator : DEFAULT_SEPARATOR);
                    continue;
                }
                sb.append(list.get(i));
            }
        }
        return sb.toString();
    }

    public static Map listConvertMap(List<Map> list, String groupKey) {
        assert (list != null);
        assert (groupKey != null);
        HashMap<String, List> map = new HashMap<String, List>();
        if (list.size() > 0) {
            for (Map item : list) {
                if (!item.containsKey(groupKey)) continue;
                String key = MapUtils.getString((Map)item, (Object)groupKey);
                if (map.containsKey(key)) {
                    List list1 = (List)map.get(key);
                    list1.add(item);
                    map.put(key, list1);
                    continue;
                }
                ArrayList<Map> list2 = new ArrayList<Map>();
                list2.add(item);
                map.put(key, list2);
            }
            return map;
        }
        return null;
    }

    public static LinkedHashMap listConvertLinkedMap(List<Map> list, String groupKey) {
        assert (list != null);
        assert (groupKey != null);
        LinkedHashMap<String, List> map = new LinkedHashMap<String, List>();
        if (list.size() > 0) {
            for (Map item : list) {
                String key = MapUtils.getString((Map)item, (Object)groupKey);
                if (map.containsKey(key)) {
                    List list1 = (List)map.get(key);
                    list1.add(item);
                    map.put(key, list1);
                    continue;
                }
                ArrayList<Map> list2 = new ArrayList<Map>();
                list2.add(item);
                map.put(key, list2);
            }
            return map;
        }
        return null;
    }

    public static List mapConvertList(Map map, TYPE type) {
        assert (map != null);
        assert (type != null);
        ArrayList<Object> list = new ArrayList<Object>();
        if (type.equals((Object)TYPE.key)) {
            for (Object key : map.keySet()) {
                list.add(key);
            }
        } else {
            for (Map.Entry entry : map.entrySet()) {
                Object val = entry.getValue();
                list.add(val == null ? "" : val);
            }
        }
        return list;
    }
}

