/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.support.spring;

import cn.gtmap.onemap.core.util.RequestUtils;
import cn.gtmap.onemap.platform.support.spring.AnalysisHubInterceptor;
import com.alibaba.fastjson.JSON;
import com.gtis.config.AppConfig;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.util.PathMatcher;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.UrlPathHelper;

/*
 * Exception performing whole class analysis ignored.
 */
public class AnalysisHubInterceptor
implements HandlerInterceptor {
    private final String CACHE_KEY = "ai_" + this.hashCode() + "_";
    private String[] includes;
    protected UrlPathHelper urlPathHelper = RequestUtils.URL_PATH_HELPER;
    protected PathMatcher pathMatcher = RequestUtils.PATH_MATCHER;
    private String redirectUrl;

    public void setIncludes(String[] includes) {
        this.includes = includes;
    }

    public void setRedirectUrl(String redirectUrl) {
        this.redirectUrl = redirectUrl;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) throws Exception {
        if (this.needProcess(request) && AppConfig.getBooleanProperty((String)"analysis.useHub")) {
            if (this.redirectUrl == null) {
                throw new RuntimeException("analysis redirect url is null");
            }
            HttpSession session = request.getSession();
            ANALYSIS_TYPE analysis_type = this.getAnalysisType(request);
            session.setAttribute("type", (Object)analysis_type.name());
            session.setAttribute("title", (Object)ANALYSIS_TYPE.access$000((ANALYSIS_TYPE)analysis_type));
            session.setAttribute("geometry", (Object)request.getParameter("geometry"));
            session.setAttribute("params", (Object)JSON.toJSONString((Object)this.createParamsMap(request)));
            response.sendRedirect(this.redirectUrl);
            return false;
        }
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) throws Exception {
        request.removeAttribute(this.getCacheKey(request));
    }

    private boolean needProcess(HttpServletRequest request) {
        String key = this.getCacheKey(request);
        Boolean need = (Boolean)request.getAttribute(key);
        if (need != null) {
            return need;
        }
        need = this.includes == null || RequestUtils.matchAny((HttpServletRequest)request, (UrlPathHelper)this.urlPathHelper, (PathMatcher)this.pathMatcher, (String[])this.includes);
        need = need != false && !this.getHubPassed(request);
        request.setAttribute(key, (Object)need);
        return need;
    }

    private ANALYSIS_TYPE getAnalysisType(HttpServletRequest request) {
        String[] urlParams = request.getRequestURI().split("\\/");
        if (urlParams != null && urlParams.length > 0) {
            String type = urlParams[urlParams.length - 1];
            for (int i = 0; i < ANALYSIS_TYPE.values().length; ++i) {
                if (!type.equalsIgnoreCase(ANALYSIS_TYPE.values()[i].name())) continue;
                return ANALYSIS_TYPE.values()[i];
            }
        }
        return ANALYSIS_TYPE.common;
    }

    private Map createParamsMap(HttpServletRequest request) {
        HashMap map = new HashMap();
        Map requestMap = request.getParameterMap();
        if (requestMap != null && !requestMap.isEmpty()) {
            for (Map.Entry obj : requestMap.entrySet()) {
                Map.Entry entry = obj;
                if ("geometry".equalsIgnoreCase(String.valueOf(entry.getKey()))) continue;
                String[] value = (String[])entry.getValue();
                String paramVal = value[0];
                if (paramVal.startsWith("[{")) {
                    map.put(entry.getKey(), JSON.parseObject((String)paramVal, List.class));
                    continue;
                }
                if (paramVal.startsWith("{")) {
                    map.put(entry.getKey(), JSON.parseObject((String)paramVal, Map.class));
                    continue;
                }
                map.put(entry.getKey(), paramVal);
            }
        }
        return map;
    }

    private String getCacheKey(HttpServletRequest request) {
        return this.CACHE_KEY + request.getRequestURI();
    }

    private boolean getHubPassed(HttpServletRequest request) {
        Map paraMap = request.getParameterMap();
        return paraMap != null && paraMap.containsKey("HubPassed");
    }
}

