/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.support.fm;

import cn.gtmap.onemap.model.Operation;
import cn.gtmap.onemap.model.Privilege;
import cn.gtmap.onemap.platform.service.TemplateService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.utils.AppPropertyUtils;
import cn.gtmap.onemap.security.AuthorizationService;
import cn.gtmap.onemap.security.SecHelper;
import cn.gtmap.onemap.security.User;
import freemarker.template.TemplateModelException;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.MapUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class EnvContext
extends BaseLogger {
    private static final String DEFAULT_TPL = "YZT";
    private static final String BLANK_TPL = "YZT_DEFAULT";
    private static final String TPL_RESOURCE = "omp-functions:tpl";
    private static final String ZT_RESOURCE = "omp-functions:zt";
    private static final String STATISTIC_RESOURCE = "omp-functions:statistic";
    @Autowired
    private AuthorizationService authorizationService;
    @Autowired
    private TemplateService templateService;
    private static final String ANALYSIS_FTL_DIR = "analysis/template/";
    private static final String TPL_SUFFIX = ".ftl";
    private static final String ANALSYIS_DEFAULT_TPL = "default.ftl";

    public Object getMainTpl() throws TemplateModelException {
        if (SecHelper.isAdmin()) {
            return DEFAULT_TPL;
        }
        User user = SecHelper.getUser();
        try {
            if (user != null) {
                Set privileges = this.authorizationService.getPermittedPrivileges(user.getId(), TPL_RESOURCE);
                for (Privilege privilege : privileges) {
                    for (Operation operation : privilege.getOperations()) {
                        if (!"view".equals(operation.getName())) continue;
                        return privilege.getResource();
                    }
                }
            }
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("tpl.om.selector.error", new Object[]{e.getLocalizedMessage()}));
        }
        return BLANK_TPL;
    }

    public boolean hasZtAuth(String name) {
        if (SecHelper.isAdmin() || SecHelper.isGuest()) {
            return true;
        }
        User user = SecHelper.getUser();
        if (user != null) {
            try {
                Set privileges = this.authorizationService.getPermittedPrivileges(user.getId(), ZT_RESOURCE);
                for (Privilege privilege : privileges) {
                    if (!privilege.getResource().equals(name)) continue;
                    for (Operation operation : privilege.getOperations()) {
                        if (!"view".equals(operation.getName())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(this.getMessage("user.zt.error", new Object[]{e.getLocalizedMessage()}));
            }
        }
        return false;
    }

    public boolean hasStatisAuth(String name) {
        if (SecHelper.isAdmin() || SecHelper.isGuest()) {
            return true;
        }
        User user = SecHelper.getUser();
        if (user != null) {
            try {
                Set privileges = this.authorizationService.getPermittedPrivileges(user.getId(), STATISTIC_RESOURCE);
                for (Privilege privilege : privileges) {
                    if (!privilege.getTitle().equals(name)) continue;
                    for (Operation operation : privilege.getOperations()) {
                        if (!"view".equals(operation.getName())) continue;
                        return true;
                    }
                }
            }
            catch (Exception e) {
                this.logger.error(this.getMessage("user.zt.error", new Object[]{e.getLocalizedMessage()}));
            }
        }
        return false;
    }

    public Object getEnv(String key) {
        return this.isNull((Object)key) ? null : AppPropertyUtils.getAppEnv((String)key);
    }

    public String getRegionCode() {
        if (SecHelper.isAdmin() || SecHelper.isGuest()) {
            return null;
        }
        User user = SecHelper.getUser();
        if (user == null) {
            return null;
        }
        return user.getRegionCode();
    }

    public double absDouble(double value) {
        return Math.abs(value);
    }

    public Object sumSequence(List<Map> list, String key) {
        assert (list != null);
        Object tVal = MapUtils.getObject((Map)list.get(0), (Object)key);
        if (tVal instanceof Double) {
            Double sum = 0.0;
            for (Map map : list) {
                sum = sum + MapUtils.getDouble((Map)map, (Object)key);
            }
            return sum;
        }
        if (tVal instanceof String) {
            String sum = "";
            for (Map map : list) {
                sum = sum + MapUtils.getString((Map)map, (Object)key);
            }
            return sum;
        }
        if (tVal instanceof Integer) {
            int sum = 0;
            for (Map map : list) {
                sum += MapUtils.getIntValue((Map)map, (Object)key);
            }
            return sum;
        }
        if (tVal instanceof BigDecimal) {
            BigDecimal sum = new BigDecimal(0.0);
            for (Map map : list) {
                sum = sum.add((BigDecimal)map.get(key));
            }
            return sum.doubleValue();
        }
        return null;
    }

    public String getAnalysisTpl(Map data, String tplName) {
        try {
            List tpls = this.templateService.listTplNames(ANALYSIS_FTL_DIR);
            if (!this.isNull((Object)tpls) && tpls.size() > 0) {
                if (tpls.contains(tplName.concat(TPL_SUFFIX))) {
                    return this.templateService.getTemplate((Object)data, ANALYSIS_FTL_DIR.concat(tplName.concat(TPL_SUFFIX)));
                }
                if (tpls.contains(ANALSYIS_DEFAULT_TPL)) {
                    return this.templateService.getTemplate((Object)data, ANALYSIS_FTL_DIR.concat(ANALSYIS_DEFAULT_TPL));
                }
            }
            return this.getMessage("template.not.exist", new Object[]{tplName.concat(TPL_SUFFIX)});
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }
}

