/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.entity.Document;
import cn.gtmap.onemap.platform.service.DocumentService;
import cn.gtmap.onemap.platform.service.GISManager;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.service.TransitService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.service.impl.TransitServiceImpl;
import cn.gtmap.onemap.platform.utils.ArrayUtils;
import cn.gtmap.onemap.platform.utils.FilesUtils;
import cn.gtmap.onemap.platform.utils.ZipUtils;
import com.vividsolutions.jts.geom.Geometry;
import java.io.File;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class TransitServiceImpl
extends BaseLogger
implements TransitService {
    private SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private GISManager gisManager;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private GeometryService geometryService;

    public Map generateReportDataFromSde(int rId, String layerName, String queryCondition, String ds, boolean isXls) {
        assert (queryCondition != null);
        try {
            LinkedHashMap<String, Object> reportData = new LinkedHashMap<String, Object>();
            LinkedHashMap data = new HashMap();
            if (rId == 6) {
                String folderPath = System.getProperty("java.io.tmpdir").concat("\\TMP_" + System.currentTimeMillis());
                List<String> conditions = Arrays.asList(queryCondition.split(","));
                for (int i = 0; i < conditions.size(); ++i) {
                    String condition = conditions.get(i);
                    try {
                        Map xlsData = this.generateReportDataFromSde(i, layerName, condition, ds, true);
                        String fileName = this.getXlsName(i);
                        this.logger.info("rID: " + String.valueOf(i) + "  name:" + fileName + "   condition:" + condition);
                        Document document = this.documentService.renderAnalysisExcel((Object)xlsData, fileName.concat(".".concat(Document.Type.xml.name())), Document.Type.xls);
                        FilesUtils.generateFile((byte[])document.getContent(), (String)folderPath, (String)fileName.concat(".".concat(Document.Type.xls.name())));
                        continue;
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e.getLocalizedMessage());
                    }
                }
                File zipFile = ZipUtils.doZip((String)folderPath, null);
                reportData.put("file", zipFile);
            } else {
                ArrayList queryResult = (ArrayList)this.gisManager.getGISService().query(layerName, queryCondition, null, true, ds);
                if (queryResult != null && queryResult.size() > 0) {
                    if (rId != 0 && !isXls) {
                        for (Map _r : queryResult) {
                            Geometry geometry = this.geometryService.readWKT(MapUtils.getString((Map)_r, (Object)"SHAPE"));
                            if (!geometry.isSimple()) {
                                geometry = this.geometryService.simplify(geometry, this.geometryService.getSimplifyTolerance());
                            }
                            _r.put("GEOJSON", this.geometryService.toGeoJSON(geometry));
                        }
                    }
                    reportData.put("count", queryResult.size() > 0 ? queryResult.size() + 1 : queryResult.size());
                    switch (rId) {
                        case 0: {
                            Map ejxzqMap = ArrayUtils.listConvertMap((List)queryResult, (String)FIELD.EJXZQ.name());
                            for (Object k : ejxzqMap.keySet()) {
                                List list = (List)ejxzqMap.get(k);
                                ArrayList nList = new ArrayList();
                                HashMap<String, Object> sum = new HashMap<String, Object>();
                                Map ytdlMap = ArrayUtils.listConvertMap((List)list, (String)FIELD.YTDL.name());
                                for (int i = 0; i < YTDL.values().length; ++i) {
                                    String ytdl = YTDL.values()[i].name();
                                    HashMap<String, Object> tmp = new HashMap<String, Object>();
                                    tmp.put("tdyt", ytdl);
                                    if (ytdlMap.containsKey(ytdl)) {
                                        List ytList = (List)ytdlMap.get(ytdl);
                                        for (Map _y : ytList) {
                                            Date now = new Date();
                                            Date sjkgsj = null;
                                            Date sjjgsj = null;
                                            Date xykgsj = null;
                                            Date xyjgsj = null;
                                            double mj = MapUtils.getDoubleValue((Map)_y, (Object)FIELD.NGZMJ.name(), (double)0.0);
                                            if (StringUtils.isNotBlank((String)MapUtils.getString((Map)_y, (Object)"XYJGS"))) {
                                                xyjgsj = this.sdf.parse(MapUtils.getString((Map)_y, (Object)"XYJGS"));
                                            }
                                            if (StringUtils.isNotBlank((String)MapUtils.getString((Map)_y, (Object)"XYKGS"))) {
                                                xykgsj = this.sdf.parse(MapUtils.getString((Map)_y, (Object)"XYKGS"));
                                            }
                                            if (StringUtils.isNotBlank((String)MapUtils.getString((Map)_y, (Object)"SJKGS"))) {
                                                sjkgsj = this.sdf.parse(MapUtils.getString((Map)_y, (Object)"SJKGS"));
                                            }
                                            if (StringUtils.isNotBlank((String)MapUtils.getString((Map)_y, (Object)"SJJGS"))) {
                                                sjjgsj = this.sdf.parse(MapUtils.getString((Map)_y, (Object)"SJJGS"));
                                            }
                                            if (sjkgsj != null && sjjgsj == null) {
                                                _y.put("TAG", TAG.kg);
                                                _y.put("AREA", mj);
                                                continue;
                                            }
                                            if (xykgsj != null && now.compareTo(xykgsj) > 0 && sjkgsj == null) {
                                                _y.put("TAG", TAG.wkg);
                                                _y.put("AREA", mj);
                                                continue;
                                            }
                                            if (xyjgsj != null && now.compareTo(xyjgsj) > 0 && sjjgsj != null) {
                                                _y.put("TAG", TAG.jg);
                                                _y.put("AREA", mj);
                                                continue;
                                            }
                                            if (xyjgsj != null && now.compareTo(xyjgsj) > 0 && sjjgsj == null) {
                                                _y.put("TAG", TAG.wjg);
                                                _y.put("AREA", mj);
                                                continue;
                                            }
                                            if (xyjgsj == null || now.compareTo(xyjgsj) >= 0) continue;
                                            _y.put("TAG", TAG.wdkg);
                                            _y.put("AREA", mj);
                                        }
                                        Map tagMap = ArrayUtils.listConvertMap((List)ytList, (String)"TAG");
                                        for (Object key : tagMap.keySet()) {
                                            List tagList = (List)tagMap.get(key);
                                            switch (2.$SwitchMap$cn$gtmap$onemap$platform$service$impl$TransitServiceImpl$TAG[TAG.valueOf((String)String.valueOf(key)).ordinal()]) {
                                                case 1: {
                                                    tmp.put(TAG.kg.name(), this.getCount(tagList));
                                                    tmp.put(TAG.kgmj.name(), this.getDoubleSumByField(tagList, "AREA"));
                                                    break;
                                                }
                                                case 2: {
                                                    tmp.put(TAG.wkg.name(), this.getCount(tagList));
                                                    tmp.put(TAG.wkgmj.name(), this.getDoubleSumByField(tagList, "AREA"));
                                                    break;
                                                }
                                                case 3: {
                                                    tmp.put(TAG.jg.name(), this.getCount(tagList));
                                                    tmp.put(TAG.jgmj.name(), this.getDoubleSumByField(list, "AREA"));
                                                    break;
                                                }
                                                case 4: {
                                                    tmp.put(TAG.wjg.name(), this.getCount(tagList));
                                                    tmp.put(TAG.wjgmj.name(), this.getDoubleSumByField(list, "AREA"));
                                                    break;
                                                }
                                                case 5: {
                                                    tmp.put(TAG.wdkg.name(), this.getCount(tagList));
                                                    tmp.put(TAG.wdkgmj.name(), this.getDoubleSumByField(list, "AREA"));
                                                }
                                            }
                                        }
                                    }
                                    tmp.put(TAG.count.name(), this.getIntSumByField(tmp, new String[]{TAG.kg.name(), TAG.jg.name(), TAG.wkg.name(), TAG.wjg.name(), TAG.wdkg.name()}));
                                    tmp.put(TAG.sumArea.name(), this.getDoubleSumByField2(tmp, new String[]{TAG.kgmj.name(), TAG.jgmj.name(), TAG.wkgmj.name(), TAG.wjgmj.name(), TAG.wdkgmj.name()}));
                                    nList.add(tmp);
                                }
                                sum.put(TAG.tdyt.name(), "\u5c0f\u8ba1");
                                sum.put(TAG.kg.name(), this.getIntSumByField(nList, TAG.kg.name()));
                                sum.put(TAG.jg.name(), this.getIntSumByField(nList, TAG.jg.name()));
                                sum.put(TAG.wkg.name(), this.getIntSumByField(nList, TAG.wkg.name()));
                                sum.put(TAG.wjg.name(), this.getIntSumByField(nList, TAG.wjg.name()));
                                sum.put(TAG.wdkg.name(), this.getIntSumByField(nList, TAG.wdkg.name()));
                                sum.put(TAG.kgmj.name(), this.getDoubleSumByField(nList, TAG.kgmj.name()));
                                sum.put(TAG.jgmj.name(), this.getDoubleSumByField(nList, TAG.jgmj.name()));
                                sum.put(TAG.wkgmj.name(), this.getDoubleSumByField(nList, TAG.wkgmj.name()));
                                sum.put(TAG.wjgmj.name(), this.getDoubleSumByField(nList, TAG.wjgmj.name()));
                                sum.put(TAG.wdkgmj.name(), this.getDoubleSumByField(nList, TAG.wdkgmj.name()));
                                sum.put(TAG.count.name(), this.getIntSumByField(nList, TAG.count.name()));
                                sum.put(TAG.sumArea.name(), this.getDoubleSumByField(nList, TAG.sumArea.name()));
                                nList.add(sum);
                                data.put(k, nList);
                            }
                            reportData.put("data", data);
                            break;
                        }
                        case 1: {
                            Calendar now = Calendar.getInstance();
                            reportData.put("year", String.valueOf(now.get(1)));
                            Map speciesMap = ArrayUtils.listConvertMap((List)queryResult, (String)FIELD.YTDL.name());
                            for (Object key : speciesMap.keySet()) {
                                int count = 0;
                                List list = (List)speciesMap.get(key);
                                LinkedHashMap xzqMap = ArrayUtils.listConvertLinkedMap((List)list, (String)FIELD.EJXZQ.name());
                                for (Object _k : xzqMap.keySet()) {
                                    List xzqList = (List)xzqMap.get(_k);
                                    xzqList.add(this.getSumMap(xzqList));
                                    count += xzqList.size();
                                }
                                xzqMap.put("\u603b\u8ba1", this.getSumList(list, FIELD.WJCMJ_FJ.name()));
                                HashMap<String, Serializable> categoryData = new HashMap<String, Serializable>();
                                categoryData.put("data", xzqMap);
                                categoryData.put("count", Integer.valueOf(count + 1));
                                data.put(key, categoryData);
                            }
                            reportData.put("data", data);
                            break;
                        }
                        case 2: {
                            queryResult.add(this.getSumMap((List)queryResult));
                            reportData.put("data", queryResult);
                            break;
                        }
                        case 3: 
                        case 4: 
                        case 5: {
                            data = ArrayUtils.listConvertLinkedMap((List)queryResult, (String)FIELD.EJXZQ.name());
                            data.put("\u5408\u8ba1", this.getSumList((List)queryResult, rId == 4 ? FIELD.WJCMJ_FJ.name() : FIELD.WKGMJ_FJ.name()));
                            reportData.put("data", data);
                            break;
                        }
                        case 7: {
                            LinkedHashMap groupMap = ArrayUtils.listConvertLinkedMap((List)queryResult, (String)FIELD.JSZT.name());
                            for (Object key : groupMap.keySet()) {
                                List list = (List)groupMap.get(key);
                                Collections.sort(list, new /* Unavailable Anonymous Inner Class!! */);
                                HashMap<String, Object> totalMap = new HashMap<String, Object>();
                                totalMap.put("XZQ", "\u5408\u8ba1");
                                totalMap.put("ZDMJ", this.getSumByField(list, "ZDMJ"));
                                totalMap.put("CFMJ", this.getSumByField(list, "CFMJ"));
                                totalMap.put("YSYMJ", this.getSumByField(list, "YSYMJ"));
                                list.add(totalMap);
                            }
                            reportData.put("data", groupMap);
                        }
                    }
                }
            }
            return reportData;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private String getXlsName(int id) {
        String fileName = "";
        switch (id) {
            case 0: {
                fileName = "\u5168\u5e02\u9879\u76ee\u7528\u5730\u5f00\u7ae3\u5de5\u60c5\u51b5\u6c47\u603b\u8868";
                break;
            }
            case 1: {
                fileName = "2015\u5e74\u5168\u5e02\u9879\u76ee\u7528\u5730\u5f00\u7ae3\u5de5\u60c5\u51b5\u5468\u62a5\u8868";
                break;
            }
            case 2: {
                fileName = "\u6148\u6e56\u9ad8\u65b0\u533a\u5df2\u6279\u5728\u5efa(\u672a\u4f9b)\u9879\u76ee";
                break;
            }
            case 3: {
                fileName = "\u5e02\u672c\u7ea7\u6d89\u5acc\u571f\u5730\u95f2\u7f6e\u5f00\u53d1\u5efa\u8bbe\u9879\u76ee\u4e00\u89c8\u8868";
                break;
            }
            case 4: {
                fileName = "\u91cd\u70b9\u76d1\u7ba1\u5efa\u8bbe\u9879\u76ee\u4e00\u89c8\u8868";
                break;
            }
            case 5: {
                fileName = "\u5e02\u672c\u7ea7\u7528\u800c\u672a\u5c3d\u5f00\u53d1\u5efa\u8bbe\u9879\u76ee\u4e00\u89c8\u8868";
                break;
            }
            case 7: {
                fileName = "\u6807\u51c6\u5316\u5382\u623f\u5efa\u8bbe\u60c5\u51b5\u6c47\u603b\u8868";
            }
        }
        return fileName;
    }

    public double getDoubleSumByField(List<Map> list, String sumField) {
        double sum = 0.0;
        ArrayList<String> crbhList = new ArrayList<String>();
        for (Map map : list) {
            if (map.containsKey("CRBH")) {
                String crbh = MapUtils.getString((Map)map, (Object)"CRBH");
                if (crbhList.contains(crbh)) continue;
                crbhList.add(crbh);
            }
            double area = MapUtils.getDoubleValue((Map)map, (Object)sumField, (double)0.0);
            sum += area;
        }
        return sum;
    }

    public double getSumByField(List<Map> list, String sumField) {
        double sum = 0.0;
        for (Map map : list) {
            double area = MapUtils.getDoubleValue((Map)map, (Object)sumField, (double)0.0);
            sum += area;
        }
        return sum;
    }

    public int getCount(List<Map> list) {
        int count = 0;
        ArrayList<String> crbhList = new ArrayList<String>();
        for (Map map : list) {
            String crbh = MapUtils.getString((Map)map, (Object)"CRBH");
            if (crbhList.contains(crbh)) continue;
            crbhList.add(crbh);
            ++count;
        }
        return count;
    }

    public int getIntSumByField(List<Map> list, String sumField) {
        int count = 0;
        for (Map map : list) {
            if (!(map.get(sumField) instanceof Integer)) continue;
            count += MapUtils.getIntValue((Map)map, (Object)sumField);
        }
        return count;
    }

    public int getIntSumByField(Object srcObj, String ... sumField) {
        int count;
        block4: {
            List list;
            block3: {
                count = 0;
                Map map = new HashMap();
                list = new ArrayList();
                if (!(srcObj instanceof Map)) break block3;
                map = (Map)srcObj;
                for (String f : sumField) {
                    count += MapUtils.getIntValue(map, (Object)f);
                }
                break block4;
            }
            if (!(srcObj instanceof ArrayList)) break block4;
            list = (List)srcObj;
            for (Map item : list) {
                for (String f : sumField) {
                    count += MapUtils.getIntValue((Map)item, (Object)f);
                }
            }
        }
        return count;
    }

    public double getDoubleSumByField2(Object srcObj, String ... sumField) {
        double sum;
        block4: {
            ArrayList<String> crbhList;
            block3: {
                sum = 0.0;
                crbhList = new ArrayList<String>();
                if (!(srcObj instanceof Map)) break block3;
                Map map = (Map)srcObj;
                for (String f : sumField) {
                    sum += MapUtils.getDoubleValue((Map)map, (Object)f, (double)0.0);
                }
                break block4;
            }
            if (!(srcObj instanceof ArrayList)) break block4;
            List list = (List)srcObj;
            for (Map item : list) {
                String crbh = MapUtils.getString((Map)item, (Object)"CRBH");
                if (crbhList.contains(crbh)) continue;
                crbhList.add(crbh);
                for (String f : sumField) {
                    sum += MapUtils.getDoubleValue((Map)item, (Object)f, (double)0.0);
                }
            }
        }
        return sum;
    }

    private Map getSumMap(List<Map> list) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        double sumMj = 0.0;
        double sumWjcmj = 0.0;
        double sumJsydmj = 0.0;
        ArrayList<String> crbhList = new ArrayList<String>();
        for (Map item : list) {
            double mj = MapUtils.getDoubleValue((Map)item, (Object)FIELD.NGZMJ.name(), (double)0.0);
            double wjcmj = MapUtils.getDoubleValue((Map)item, (Object)FIELD.WJCMJ_FJ.name(), (double)0.0);
            double jsydmj = MapUtils.getDoubleValue((Map)item, (Object)FIELD.JSYDMJ_FJ.name(), (double)0.0);
            String crbh = MapUtils.getString((Map)item, (Object)"CRBH");
            if (crbhList.contains(crbh)) continue;
            crbhList.add(crbh);
            sumMj += mj;
            sumWjcmj += wjcmj;
            sumJsydmj += jsydmj;
        }
        result.put(FIELD.NGZMJ.name(), sumMj);
        result.put(FIELD.WJCMJ_FJ.name(), sumWjcmj);
        result.put(FIELD.JSYDMJ_FJ.name(), sumJsydmj);
        result.put(FIELD.EJXZQ.name(), "\u5408\u8ba1");
        return result;
    }

    private List<Map> getSumList(List<Map> list, String areaField) {
        ArrayList<Map> arrayList = new ArrayList<Map>();
        HashMap<String, Object> result = new HashMap<String, Object>();
        double sumMj = 0.0;
        double sumWjcmj = 0.0;
        ArrayList<String> crbhList = new ArrayList<String>();
        for (Map item : list) {
            double mj = MapUtils.getDoubleValue((Map)item, (Object)FIELD.NGZMJ.name(), (double)0.0);
            double wjcmj = MapUtils.getDoubleValue((Map)item, (Object)areaField, (double)0.0);
            String crbh = MapUtils.getString((Map)item, (Object)"CRBH");
            if (crbhList.contains(crbh)) continue;
            crbhList.add(crbh);
            sumMj += mj;
            sumWjcmj += wjcmj;
        }
        result.put(FIELD.NGZMJ.name(), sumMj);
        result.put(areaField, sumWjcmj);
        result.put(FIELD.EJXZQ.name(), "\u5408\u8ba1");
        arrayList.add(result);
        return arrayList;
    }
}

