/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.entity.Document;
import cn.gtmap.onemap.platform.entity.LayerRegion;
import cn.gtmap.onemap.platform.event.GeometryServiceException;
import cn.gtmap.onemap.platform.service.AgsGeoemtryService;
import cn.gtmap.onemap.platform.service.DocumentService;
import cn.gtmap.onemap.platform.service.GISService;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.service.TemplateService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.service.impl.GeometryServiceImpl;
import cn.gtmap.onemap.platform.utils.ArrayUtils;
import cn.gtmap.onemap.platform.utils.EnumUtils;
import cn.gtmap.onemap.platform.utils.FilesUtils;
import cn.gtmap.onemap.platform.utils.GeometryUtils;
import cn.gtmap.onemap.platform.utils.SRTransformations;
import cn.gtmap.onemap.platform.utils.UUIDGenerator;
import cn.gtmap.onemap.platform.utils.Utils;
import cn.gtmap.onemap.platform.utils.ZipUtils;
import com.alibaba.fastjson.JSON;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.vividsolutions.jts.densify.Densifier;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.io.WKTReader;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import freemarker.template.TemplateException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.SAXReader;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.shapefile.ShapefileDataStoreFactory;
import org.geotools.data.shapefile.ShpFiles;
import org.geotools.data.shapefile.dbf.DbaseFileHeader;
import org.geotools.data.shapefile.dbf.DbaseFileReader;
import org.geotools.data.shapefile.prj.PrjFileReader;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geojson.feature.FeatureJSON;
import org.geotools.geojson.geom.GeometryJSON;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

public class GeometryServiceImpl
extends BaseLogger
implements GeometryService {
    public static final String TYPE = "type";
    public static final String FEATURE = "Feature";
    public static final String FEATURE_COLLECTION = "FeatureCollection";
    public static final String GEOMETRY_COLLECTION = "GeometryCollection";
    private static final String WKID = "wkid";
    private static final String WKT = "wkt";
    private static final String REGION_FIELD = "regionLayers";
    private static final String REGION_MAP = "regionMap";
    private static final String DEFAULT_CRS = "defaultCrs";
    private static final String COORDINATE_DM = "coordinatesDM";
    private static final String UNDEFINE = "UNDEFINE";
    private static final String EPSG_PERFIX = "EPSG:";
    private static final String BJ_FILE_NAME = "gt.xml";
    private static final String DEFAULT_LAYER_REGION_FIELD = "DEFAULTLAYER";
    private static final String TEMP_PIX = "\\TMP_";
    private static final String BJ_TITLE = "title";
    private static final String BJ_FEATURE = "feature";
    private static final String BJ_AREA = "area";
    private static final String BJ_AREA_NYD = "nydArea";
    private static final String BJ_AREA_GD = "gdArea";
    private static final String BJ_AREA_JSYD = "jsydArea";
    private static final String BJ_AREA_WLYD = "wlydArea";
    private static final String XLS_COORD_TAG = "@";
    private static final String PROJCS = "PROJCS";
    private static final String GEOGCS = "GEOGCS";
    private static final String SHP_FILE_SUFFIX = "shp";
    private static final String SHX_FILE_SUFFIX = "shx";
    private static final String DBF_FILE_SUFFIX = "dbf";
    private static final String PRJ_FILE_SUFFIX = "prj";
    private static final String DOTS = ".";
    private static final String TPL_FOLDER = "analysis/";
    private static final String TPL_SUFFIX = ".ftl";
    private GeometryFactory geometryFactory = JTSFactoryFinder.getGeometryFactory();
    private WKTReader wktReader;
    private double simplifyTolerance;
    private Map<String, String> regionLayers;
    private Map regionSet;
    private CoordinateReferenceSystem defaultCrs;
    private Map<String, Object> coordinateDM;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private AgsGeoemtryService agsGeometryService;
    @Autowired
    private TemplateService templateService;
    @Autowired
    private GISService gisService;

    public Geometry readWKT(String wkt) throws GeometryServiceException {
        try {
            return new WKTReader(this.geometryFactory).read(wkt);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.WKT_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Geometry readGeoJSON(String geoJSON) throws GeometryServiceException {
        try {
            GeometryJSON geometryJSON = new GeometryJSON();
            return geometryJSON.read((Object)geoJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public GeometryCollection readGeoCollectionJSON(String geoJSON) throws GeometryServiceException {
        try {
            GeometryJSON geometryJSON = new GeometryJSON();
            return geometryJSON.readGeometryCollection((Object)geoJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public SimpleFeature readFeatureJSON(String featureJSON) throws GeometryServiceException {
        try {
            FeatureJSON fJson = new FeatureJSON();
            return fJson.readFeature((Object)featureJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public FeatureCollection readFeatureCollectionJSON(String featureJSON) throws GeometryServiceException {
        try {
            FeatureJSON fJson = new FeatureJSON();
            return fJson.readFeatureCollection((Object)featureJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Object readUnTypeGeoJSON(String geoJSON) throws GeometryServiceException {
        try {
            return GeometryUtils.parseGeoJSON((String)geoJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem readFeatureJSONCRS(String featureJSON) {
        try {
            FeatureJSON fJson = new FeatureJSON();
            return fJson.readCRS((Object)featureJSON);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Geometry project(Geometry geometry, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws GeometryServiceException {
        return this.projectByAGS(geometry, sourceCRS, targetCRS);
    }

    public Object project(Object feature, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws GeometryServiceException {
        if (feature instanceof SimpleFeature) {
            String[] keys;
            Map map = this.simpleFeature2Map((SimpleFeature)feature);
            Geometry geometry = this.project((Geometry)map.get("geometry"), sourceCRS, targetCRS);
            if (!geometry.isSimple() || this.validGeometry(geometry) != null && geometry.isValid()) {
                geometry = this.gisService.createValidGeometry(geometry);
            }
            SimpleFeatureType featureType = this.getFeatureType(map);
            SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
            for (String key : keys = map.keySet().toArray(new String[0])) {
                if ("geometry".equals(key)) {
                    featureBuilder.add((Object)geometry);
                    continue;
                }
                if ("crs".equals(key)) continue;
                featureBuilder.add(map.get(key) != null ? map.get(key) : "");
            }
            return featureBuilder.buildFeature(FEATURE.concat(UUIDGenerator.generate()));
        }
        if (feature instanceof FeatureCollection) {
            DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
            FeatureCollection featureCollection = (FeatureCollection)feature;
            FeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature temp = (SimpleFeature)featureIterator.next();
                collection.add((SimpleFeature)this.project((Object)temp, sourceCRS, targetCRS));
            }
            return collection;
        }
        return null;
    }

    public Geometry projectByAGS(Geometry geometry, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) {
        try {
            return SRTransformations.project((Geometry)geometry, (String)sourceCRS.toWKT(), (String)targetCRS.toWKT());
        }
        catch (PeProjectionException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.PROJECT_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Geometry simplify(Geometry geometry, double tolerance) {
        return geometry.isValid() && geometry.isSimple() ? geometry : DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)tolerance);
    }

    public Geometry forceSimplify(Geometry geometry, double tolerance) {
        return DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)tolerance);
    }

    public Geometry densify(Geometry geometry, double tolerance) {
        return Densifier.densify((Geometry)geometry, (double)tolerance);
    }

    public CoordinateReferenceSystem getCRSByWKTString(String wktCRS) {
        try {
            return CRS.parseWKT((String)SRTransformations.getCoordinateSystem((String)wktCRS).toString());
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
        catch (PeProjectionException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem getCRSByCommnonString(String crs) {
        try {
            return CRS.decode((String)crs, (boolean)true);
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem getCRSBySRID(String srid) {
        try {
            return this.getCRSByWKTString(SRTransformations.getCoordinateSystem((int)Integer.valueOf(srid)).toString());
        }
        catch (PeProjectionException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem getSeLayerCRS(SeLayer layer) {
        return this.getCRSByWKTString(layer.getCoordRef().getCoordSysDescription());
    }

    public CoordinateReferenceSystem getLayerCRS(String layerName, String dataSource) {
        try {
            return this.gisService.getLayerCRS(layerName, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public SimpleFeatureType getFeatureType(Map<String, Object> value) {
        String[] keys;
        SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
        typeBuilder.setName(FEATURE);
        for (String key : keys = value.keySet().toArray(new String[0])) {
            if ("SHAPE".equals(key)) {
                typeBuilder.add("geometry", Geometry.class);
                continue;
            }
            if ("crs".equals(key)) {
                typeBuilder.add("crs", String.class, (CoordinateReferenceSystem)value.get(key));
                continue;
            }
            typeBuilder.add(key, value.get(key) != null ? value.get(key).getClass() : String.class);
        }
        return typeBuilder.buildFeatureType();
    }

    public SimpleFeature map2SimpleFeature(Map<String, Object> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        String[] keys;
        Geometry geometry;
        Geometry geometry2 = geometry = value.containsKey("SHAPE") ? this.readWKT((String)value.get("SHAPE")) : null;
        if (geometry != null && srcCRS != null && destCRS != null && srcCRS != destCRS) {
            geometry = this.project(geometry, srcCRS, destCRS);
        }
        SimpleFeatureType featureType = this.getFeatureType(value);
        SimpleFeatureBuilder featureBuilder = new SimpleFeatureBuilder(featureType);
        for (String key : keys = value.keySet().toArray(new String[0])) {
            if ("SHAPE".equals(key)) {
                featureBuilder.add((Object)geometry);
                continue;
            }
            if ("crs".equals(key)) continue;
            featureBuilder.add(value.get(key) != null ? value.get(key) : "");
        }
        return featureBuilder.buildFeature(FEATURE.concat(UUIDGenerator.generate()));
    }

    public FeatureCollection list2FeatureCollection(List<Map<String, Object>> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        DefaultFeatureCollection collection = new DefaultFeatureCollection(null, null);
        if (value != null && value.size() > 0) {
            for (Map<String, Object> item : value) {
                try {
                    collection.add(this.map2SimpleFeature(item, srcCRS, destCRS));
                }
                catch (Exception e) {
                    this.logger.info(this.getMessage("list.2featureCollection.false", new Object[]{e.getLocalizedMessage()}));
                }
            }
        }
        return collection;
    }

    public String toFeatureJSON(Object feature) {
        try {
            FeatureJSON featureJSON = new FeatureJSON(new GeometryJSON(14));
            StringWriter out = new StringWriter();
            if (feature instanceof SimpleFeature) {
                featureJSON.setEncodeFeatureBounds(((SimpleFeature)feature).getBounds() != null);
                featureJSON.setEncodeFeatureCRS(((SimpleFeature)feature).getFeatureType().getCoordinateReferenceSystem() != null);
                featureJSON.writeFeature((SimpleFeature)feature, (Object)out);
            } else if (feature instanceof FeatureCollection) {
                if (((FeatureCollection)feature).size() > 0) {
                    featureJSON.setEncodeFeatureCollectionBounds(((SimpleFeature)((FeatureCollection)feature).toArray()[0]).getBounds() != null);
                    featureJSON.setEncodeFeatureCollectionCRS(((SimpleFeature)((FeatureCollection)feature).toArray()[0]).getFeatureType().getCoordinateReferenceSystem() != null);
                }
                featureJSON.writeFeatureCollection((FeatureCollection)feature, (Object)out);
            }
            return out.toString();
        }
        catch (Exception e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.FEATURE_TO_JSON_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public String toGeoJSON(Geometry geometry) {
        try {
            GeometryJSON geometryJSON = new GeometryJSON(14);
            StringWriter out = new StringWriter();
            geometryJSON.write(geometry, (Object)out);
            return out.toString();
        }
        catch (IOException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOMETRY_TO_JSON_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Map<String, Object> simpleFeature2Map(SimpleFeature feature) {
        Assert.notNull((Object)feature, (String)"feature can't be null");
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Property property : feature.getProperties()) {
            if (property.getValue() == null || !StringUtils.isNotBlank((String)String.valueOf(property.getValue()))) continue;
            result.put(property.getName().getLocalPart(), property.getValue());
        }
        return result;
    }

    public CoordinateReferenceSystem parseUndefineSR(String value) {
        try {
            int srid = Integer.parseInt(value);
            if (srid != 0) {
                return this.getCRSBySRID(value);
            }
        }
        catch (NumberFormatException e) {
            if (value.indexOf("EPSG") == 0) {
                return this.getCRSBySRID(value.substring("EPSG".length() + 1, value.length()));
            }
            return this.getCRSByWKTString(value);
        }
        throw new GeometryServiceException(GeometryServiceException.ExceptionType.CRS_PARSE_EXCEPTION, value);
    }

    public TopologyValidationError validGeometry(Geometry geometry) {
        IsValidOp isValidOp = new IsValidOp(geometry);
        return isValidOp.getValidationError();
    }

    public CoordinateReferenceSystem getCRSByRegionCode(String regionCode) {
        if (StringUtils.isBlank((String)regionCode)) {
            this.logger.warn(this.getMessage("region.code.not.found", new Object[]{regionCode}));
            if (this.regionSet.containsKey("default")) {
                return this.parseUndefineSR(String.valueOf(this.regionSet.get("default")));
            }
            return this.parseUndefineSR("2364");
        }
        if (!this.regionSet.containsKey(regionCode)) {
            this.logger.warn(this.getMessage("region.code.not.found", new Object[]{regionCode}));
            if (this.regionSet.containsKey("default")) {
                return this.parseUndefineSR(String.valueOf(this.regionSet.get("default")));
            }
            return this.parseUndefineSR("2364");
        }
        return this.parseUndefineSR(String.valueOf(this.regionSet.get(regionCode)));
    }

    public LayerRegion getLayerRegion(String layerName) {
        for (Map.Entry entry : this.regionLayers.entrySet()) {
            if (!Pattern.compile((String)entry.getKey()).matcher(layerName.toUpperCase()).matches()) continue;
            String value = (String)entry.getValue();
            try {
                return new LayerRegion(layerName, this.parseUndefineSR(value));
            }
            catch (Exception e) {
                return new LayerRegion(layerName, value);
            }
        }
        if (this.regionLayers.containsKey(DEFAULT_LAYER_REGION_FIELD)) {
            String defaultField = (String)this.regionLayers.get(DEFAULT_LAYER_REGION_FIELD);
            if (defaultField.startsWith(EPSG_PERFIX)) {
                this.logger.info(this.getMessage("layer.regioncode.crs.default", new Object[]{layerName, defaultField}));
                return new LayerRegion(layerName, this.parseUndefineSR(defaultField));
            }
            this.logger.info(this.getMessage("layer.regioncode.default", new Object[]{layerName, defaultField}));
            return new LayerRegion(layerName, defaultField);
        }
        throw new RuntimeException(this.getMessage("layer.regioncode.not.set", new Object[]{layerName}));
    }

    public boolean containsRegionValue(String regionCode) {
        return this.regionSet.containsKey(regionCode);
    }

    public double readGeometryAera(String geoJSON) {
        try {
            Object geo = this.readUnTypeGeoJSON(geoJSON);
            if (geo instanceof Geometry) {
                return ((Geometry)geo).getArea();
            }
            if (geo instanceof SimpleFeature) {
                return ((Geometry)((SimpleFeature)geo).getDefaultGeometry()).getArea();
            }
            if (geo instanceof FeatureCollection) {
                double area = 0.0;
                FeatureIterator iterator = ((FeatureCollection)geo).features();
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Geometry geometry = (Geometry)feature.getDefaultGeometry();
                    area += geometry.getArea();
                }
                return area;
            }
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return 0.0;
    }

    public double getGeoArea(Object geo, CoordinateReferenceSystem sourceCrs) {
        double area = 0.0;
        try {
            SimpleFeature feature = null;
            CoordinateReferenceSystem targetCrs = this.parseUndefineSR("2364");
            if (geo instanceof SimpleFeature) {
                feature = (SimpleFeature)geo;
                if (this.isNull((Object)sourceCrs)) {
                    sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem();
                }
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (sourceCrs != null && sourceCrs instanceof GeographicCRS) {
                    geometry = this.project((Geometry)feature.getDefaultGeometry(), sourceCrs, targetCrs);
                }
                area = geometry.getGeometryType().equals(Geometries.POLYGON.getName()) || geometry.getGeometryType().equals(Geometries.MULTIPOLYGON.getName()) ? this.agsGeometryService.getGeometryArea(geometry.toText()).doubleValue() : geometry.getLength();
            } else if (geo instanceof FeatureCollection) {
                FeatureIterator iterator = ((FeatureCollection)geo).features();
                while (iterator.hasNext()) {
                    feature = (SimpleFeature)iterator.next();
                    area += this.getGeoArea((Object)feature, sourceCrs);
                }
            } else if (geo instanceof Geometry) {
                Geometry geometry;
                Geometry temp = (Geometry)geo;
                if (this.isNull((Object)sourceCrs)) {
                    sourceCrs = this.getCrsByCoordXD(temp.getCentroid().getX());
                }
                area = (geometry = sourceCrs != null && sourceCrs instanceof GeographicCRS ? this.project(temp, sourceCrs, targetCrs) : temp).getGeometryType().equals(Geometries.POLYGON.getName()) || geometry.getGeometryType().equals(Geometries.MULTIPOLYGON.getName()) ? this.agsGeometryService.getGeometryArea(geometry.toText()).doubleValue() : geometry.getLength();
            } else if (geo instanceof GeometryCollection) {
                GeometryCollection geometryCollection = (GeometryCollection)geo;
                for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                    Geometry geometry = geometryCollection.getGeometryN(i);
                    if (!geometry.getGeometryType().equals(Geometries.POLYGON.getName()) && !geometry.getGeometryType().equals(Geometries.MULTIPOLYGON.getName())) continue;
                    area += this.getGeoArea((Object)geometry, sourceCrs);
                }
            }
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return area;
    }

    public Point getGeometryCentre(Geometry geometry) {
        assert (geometry != null);
        if (geometry instanceof Point) {
            return (Point)geometry;
        }
        return geometry.getCentroid();
    }

    public double getSimplifyTolerance() {
        return this.simplifyTolerance;
    }

    public Object getZipCoordinates(InputStream in) throws Exception {
        try {
            int tag = 0;
            HashMap<String, Object> result = new HashMap<String, Object>();
            List documents = this.documentService.readZipIn(in);
            if (documents.size() == 0) {
                throw new RuntimeException(this.getMessage("zip.format.error", new Object[0]));
            }
            for (cn.gtmap.onemap.platform.entity.Document document : documents) {
                if (!document.getFileName().equals(BJ_FILE_NAME)) continue;
                tag = 1;
                break;
            }
            switch (tag) {
                case 0: {
                    result.put(TYPE, SHP_FILE_SUFFIX);
                    result.put("value", this.getShpCoordinates(documents));
                    break;
                }
                case 1: {
                    result.put(TYPE, "bj");
                    result.put("value", this.getBJCoordinates(documents));
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("zip.coord.get.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getShpCoordinates(List<cn.gtmap.onemap.platform.entity.Document> documents) throws Exception {
        String result;
        assert (documents != null);
        String filePath = System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis());
        File folderFile = new File(filePath);
        if (!folderFile.exists()) {
            folderFile.mkdir();
        }
        for (cn.gtmap.onemap.platform.entity.Document document : documents) {
            File tmp = new File(filePath.concat("\\" + document.getName().concat(DOTS.concat(document.getType().name()))));
            FileOutputStream output = new FileOutputStream(tmp);
            try {
                IOUtils.write((byte[])document.getContent(), (OutputStream)output);
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        File[] files = folderFile.listFiles();
        File shpFile = null;
        File dbfFile = null;
        File prjFile = null;
        try {
            if (files.length > 0) {
                for (File tempFile : files) {
                    if (!tempFile.isFile()) continue;
                    if (tempFile.getName().endsWith(SHP_FILE_SUFFIX)) {
                        shpFile = tempFile;
                    }
                    if (tempFile.getName().endsWith(DBF_FILE_SUFFIX)) {
                        dbfFile = tempFile;
                    }
                    if (!tempFile.getName().endsWith(PRJ_FILE_SUFFIX)) continue;
                    prjFile = tempFile;
                }
            }
            result = this.parseShapefile(shpFile, dbfFile, prjFile, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            folderFile.delete();
        }
        return result;
    }

    private Map getBJCoordinates(List<cn.gtmap.onemap.platform.entity.Document> documents) throws Exception {
        assert (documents != null);
        for (cn.gtmap.onemap.platform.entity.Document document : documents) {
            if (!document.getFileName().equals(BJ_FILE_NAME)) continue;
            return this.parseBjXmlAdv(document.getContent());
        }
        throw new RuntimeException(this.getMessage("bj.gt.xml.not.found", new Object[0]));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getBJCoordinates(InputStream in) throws Exception {
        List documents = this.documentService.readZip(in);
        if (documents.size() == 0) {
            File tmp = new File(System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis()));
            try {
                FileOutputStream output = new FileOutputStream(tmp);
                try {
                    IOUtils.copyLarge((InputStream)in, (OutputStream)output, (long)0L, (long)in.available(), (byte[])new byte[in.available()]);
                    output.close();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
                documents = this.documentService.readZipFile(tmp);
                if (documents.size() == 0) {
                    throw new RuntimeException(this.getMessage("bj.zip.format.error", new Object[0]));
                }
            }
            finally {
                FileUtils.deleteQuietly((File)tmp);
            }
        }
        for (cn.gtmap.onemap.platform.entity.Document document : documents) {
            if (!document.getFileName().equals(BJ_FILE_NAME)) continue;
            return this.parseBjXmlAdv(document.getContent());
        }
        throw new RuntimeException(this.getMessage("bj.gt.xml.not.found", new Object[0]));
    }

    public String getExcelCoordinates(InputStream in) throws Exception {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)in);
            Sheet sheet = workbook.getSheetAt(0);
            List features = new ArrayList();
            CoordinateReferenceSystem sourceCrs = null;
            for (Row row : sheet) {
                String crs;
                String info = row.getCell(0).getStringCellValue();
                this.logger.debug("excel upload row info:" + info);
                if (row.getCell(7) != null && row.getCell(7).getCellType() == 1 && ((crs = row.getCell(7).getStringCellValue()).startsWith(PROJCS) || crs.startsWith(GEOGCS))) {
                    sourceCrs = this.getCRSByWKTString(crs);
                }
                if (!info.endsWith(XLS_COORD_TAG)) continue;
                features = this.excel2List(row.getRowNum() + 1, sheet, sourceCrs);
                break;
            }
            if (features.size() > 0) {
                this.logger.debug("excel upload features number:" + features.size());
                for (Map feature : features) {
                    if (sourceCrs == null) {
                        sourceCrs = (CoordinateReferenceSystem)feature.get("crs");
                    }
                    feature.remove("crs");
                }
            } else {
                this.logger.error(this.getMessage("excel.coords.not.found", new Object[0]));
                throw new RuntimeException(this.getMessage("excel.coords.not.found", new Object[0]));
            }
            return this.toFeatureJSON((Object)this.list2FeatureCollection(features, sourceCrs, this.defaultCrs));
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("excel.parse.error", new Object[]{e.getLocalizedMessage()}));
            throw new RuntimeException(this.getMessage("excel.parse.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShpCoordinates(InputStream in) throws Exception {
        String result;
        String filePath;
        File folderFile;
        List documents = this.documentService.readZip(in);
        if (documents.size() == 0) {
            File tmp = new File(System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis()));
            try {
                FileOutputStream output = new FileOutputStream(tmp);
                try {
                    IOUtils.copyLarge((InputStream)in, (OutputStream)output, (long)0L, (long)in.available(), (byte[])new byte[in.available()]);
                    output.close();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
                documents = this.documentService.readZipFile(tmp);
                if (documents.size() == 0) {
                    throw new RuntimeException(this.getMessage("bj.zip.format.error", new Object[0]));
                }
            }
            finally {
                FileUtils.deleteQuietly((File)tmp);
            }
        }
        if (!(folderFile = new File(filePath = System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis()))).exists()) {
            folderFile.mkdir();
        }
        for (cn.gtmap.onemap.platform.entity.Document document : documents) {
            File tmp = new File(filePath.concat("\\" + document.getName().concat(DOTS.concat(document.getType().name()))));
            FileOutputStream output = new FileOutputStream(tmp);
            try {
                IOUtils.write((byte[])document.getContent(), (OutputStream)output);
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        File[] files = folderFile.listFiles();
        File shpFile = null;
        File dbfFile = null;
        File prjFile = null;
        try {
            if (files.length > 0) {
                for (File tempFile : files) {
                    if (!tempFile.isFile()) continue;
                    if (tempFile.getName().endsWith(SHP_FILE_SUFFIX)) {
                        shpFile = tempFile;
                    }
                    if (tempFile.getName().endsWith(DBF_FILE_SUFFIX)) {
                        dbfFile = tempFile;
                    }
                    if (!tempFile.getName().endsWith(PRJ_FILE_SUFFIX)) continue;
                    prjFile = tempFile;
                }
            }
            result = this.parseShapefile(shpFile, dbfFile, prjFile, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            folderFile.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShpCoordinates(File file) throws Exception {
        String result;
        List documents = this.documentService.readZipFile(file);
        String filePath = System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis());
        File folderFile = new File(filePath);
        if (!folderFile.exists()) {
            folderFile.mkdir();
        }
        for (cn.gtmap.onemap.platform.entity.Document document : documents) {
            File tmp = new File(filePath.concat("\\" + document.getName().concat(DOTS.concat(document.getType().name()))));
            FileOutputStream output = new FileOutputStream(tmp);
            try {
                IOUtils.write((byte[])document.getContent(), (OutputStream)output);
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        File[] files = folderFile.listFiles();
        File shpFile = null;
        File dbfFile = null;
        File prjFile = null;
        try {
            if (files.length > 0) {
                for (File tempFile : files) {
                    if (!tempFile.isFile()) continue;
                    if (tempFile.getName().endsWith(SHP_FILE_SUFFIX)) {
                        shpFile = tempFile;
                    }
                    if (tempFile.getName().endsWith(DBF_FILE_SUFFIX)) {
                        dbfFile = tempFile;
                    }
                    if (!tempFile.getName().endsWith(PRJ_FILE_SUFFIX)) continue;
                    prjFile = tempFile;
                }
            }
            result = this.parseShapefile(shpFile, dbfFile, prjFile, null);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            folderFile.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShpCoordinates(File file, boolean tolerateExp) throws Exception {
        String result;
        List documents = this.documentService.readZipFile(file);
        String filePath = System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis());
        File folderFile = new File(filePath);
        if (!folderFile.exists()) {
            folderFile.mkdir();
        }
        for (cn.gtmap.onemap.platform.entity.Document document : documents) {
            File tmp = new File(filePath.concat("\\" + document.getName().concat(DOTS.concat(document.getType().name()))));
            FileOutputStream output = new FileOutputStream(tmp);
            try {
                IOUtils.write((byte[])document.getContent(), (OutputStream)output);
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        File[] files = folderFile.listFiles();
        File shpFile = null;
        File dbfFile = null;
        File prjFile = null;
        try {
            if (files.length > 0) {
                for (File tempFile : files) {
                    if (!tempFile.isFile()) continue;
                    if (tempFile.getName().endsWith(SHP_FILE_SUFFIX)) {
                        shpFile = tempFile;
                    }
                    if (tempFile.getName().endsWith(DBF_FILE_SUFFIX)) {
                        dbfFile = tempFile;
                    }
                    if (!tempFile.getName().endsWith(PRJ_FILE_SUFFIX)) continue;
                    prjFile = tempFile;
                }
            }
            result = this.parseShapefile(shpFile, dbfFile, prjFile, null, tolerateExp);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            folderFile.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShpCoordinates(File file, String properties) throws Exception {
        String result;
        List documents = this.documentService.readZipFile(file);
        Map propertyMap = (Map)JSON.parseObject((String)properties, Map.class);
        if (this.isNull((Object)propertyMap)) {
            this.logger.info("properties is null");
            return this.getShpCoordinates(file);
        }
        String filePath = System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis());
        File folderFile = new File(filePath);
        if (!folderFile.exists()) {
            folderFile.mkdir();
        }
        for (cn.gtmap.onemap.platform.entity.Document document : documents) {
            File tmp = new File(filePath.concat("\\" + document.getName().concat(DOTS.concat(document.getType().name()))));
            FileOutputStream output = new FileOutputStream(tmp);
            try {
                IOUtils.write((byte[])document.getContent(), (OutputStream)output);
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        File[] files = folderFile.listFiles();
        File shpFile = null;
        File dbfFile = null;
        File prjFile = null;
        try {
            if (files.length > 0) {
                for (File tempFile : files) {
                    if (!tempFile.isFile()) continue;
                    if (tempFile.getName().endsWith(SHP_FILE_SUFFIX)) {
                        shpFile = tempFile;
                    }
                    if (tempFile.getName().endsWith(DBF_FILE_SUFFIX)) {
                        dbfFile = tempFile;
                    }
                    if (!tempFile.getName().endsWith(PRJ_FILE_SUFFIX)) continue;
                    prjFile = tempFile;
                }
            }
            result = this.parseShapefile(shpFile, dbfFile, prjFile, propertyMap);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            folderFile.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShpCoordinates(File file, String properties, boolean tolerateExp) throws Exception {
        String result;
        List documents = this.documentService.readZipFile(file);
        Map propertyMap = (Map)JSON.parseObject((String)properties, Map.class);
        if (this.isNull((Object)propertyMap)) {
            this.logger.info("properties is null");
            return this.getShpCoordinates(file);
        }
        String filePath = System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis());
        File folderFile = new File(filePath);
        if (!folderFile.exists()) {
            folderFile.mkdir();
        }
        for (cn.gtmap.onemap.platform.entity.Document document : documents) {
            File tmp = new File(filePath.concat("\\" + document.getName().concat(DOTS.concat(document.getType().name()))));
            FileOutputStream output = new FileOutputStream(tmp);
            try {
                IOUtils.write((byte[])document.getContent(), (OutputStream)output);
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        File[] files = folderFile.listFiles();
        File shpFile = null;
        File dbfFile = null;
        File prjFile = null;
        try {
            if (files.length > 0) {
                for (File tempFile : files) {
                    if (!tempFile.isFile()) continue;
                    if (tempFile.getName().endsWith(SHP_FILE_SUFFIX)) {
                        shpFile = tempFile;
                    }
                    if (tempFile.getName().endsWith(DBF_FILE_SUFFIX)) {
                        dbfFile = tempFile;
                    }
                    if (!tempFile.getName().endsWith(PRJ_FILE_SUFFIX)) continue;
                    prjFile = tempFile;
                }
            }
            result = this.parseShapefile(shpFile, dbfFile, prjFile, propertyMap, tolerateExp);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            folderFile.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShpCoordinatesSingle(InputStream in) throws Exception {
        File shpFile = new File(System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis()).concat(DOTS.concat(Document.Type.shp.name())));
        try {
            FileOutputStream output = new FileOutputStream(shpFile);
            try {
                IOUtils.copyLarge((InputStream)in, (OutputStream)output, (long)0L, (long)in.available(), (byte[])new byte[in.available()]);
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
            try {
                if (!this.isNull((Object)shpFile)) {
                    String string = this.parseShapefile(shpFile, null, null, null);
                    return string;
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
        }
        finally {
            FileUtils.deleteQuietly((File)shpFile);
        }
        return null;
    }

    public Map insertShpCoordinates(File file, String properties, String layerName, String dataSource, boolean tolerateExp) {
        String result = "";
        List rows = null;
        long date = System.currentTimeMillis();
        try {
            rows = this.getShpContent(file, properties, tolerateExp);
        }
        catch (Exception e) {
            1 map = new /* Unavailable Anonymous Inner Class!! */;
            map.put("result", e.getLocalizedMessage());
            return map;
        }
        if (!this.isNull((Object)rows) && this.gisService.insertRows(layerName, rows, dataSource) > 0) {
            2 map = new /* Unavailable Anonymous Inner Class!! */;
            for (Object row : rows) {
                Map cols = (Map)row;
                try {
                    ((Map)row).put("SHAPE_AREA", ((SeShape)cols.get("SHAPE")).getArea());
                }
                catch (SeException e) {
                    ((Map)row).put("SHAPE_AREA", 0);
                }
                if (((Map)row).containsKey("SHAPE_LENG")) {
                    ((Map)row).remove("SHAPE_LENG");
                }
                ((Map)row).remove("SHAPE");
            }
            map.put("result", JSON.toJSONString((Object)rows));
            this.logger.info("\u63d2\u5165\u6210\u529f\uff0c\u8017\u65f6\uff1a" + (System.currentTimeMillis() - date) + "ms");
            return map;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getShpContent(File file, String properties, boolean tolerateExp) throws Exception {
        List documents = this.documentService.readZipFile(file);
        if (this.isNull((Object)properties)) {
            properties = "{}";
        }
        Map propertyMap = (Map)JSON.parseObject((String)properties, Map.class);
        String filePath = System.getProperty("java.io.tmpdir").concat(TEMP_PIX + System.currentTimeMillis());
        File folderFile = new File(filePath);
        if (!folderFile.exists()) {
            folderFile.mkdir();
        }
        List rows = null;
        for (cn.gtmap.onemap.platform.entity.Document document : documents) {
            File tmp = new File(filePath.concat("\\" + document.getName().concat(DOTS.concat(document.getType().name()))));
            FileOutputStream output = new FileOutputStream(tmp);
            try {
                IOUtils.write((byte[])document.getContent(), (OutputStream)output);
                output.close();
            }
            finally {
                IOUtils.closeQuietly((OutputStream)output);
            }
        }
        File[] files = folderFile.listFiles();
        File shpFile = null;
        File dbfFile = null;
        File prjFile = null;
        String result = "";
        try {
            if (files.length > 0) {
                for (File tempFile : files) {
                    if (!tempFile.isFile()) continue;
                    if (tempFile.getName().endsWith(SHP_FILE_SUFFIX)) {
                        shpFile = tempFile;
                    }
                    if (tempFile.getName().endsWith(DBF_FILE_SUFFIX)) {
                        dbfFile = tempFile;
                    }
                    if (!tempFile.getName().endsWith(PRJ_FILE_SUFFIX)) continue;
                    prjFile = tempFile;
                }
            }
            rows = this.parseShapefile2MapList(shpFile, dbfFile, prjFile, propertyMap, tolerateExp);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        finally {
            folderFile.delete();
        }
        return rows;
    }

    public File exportToShp(String geoJson) throws Exception {
        Assert.notNull((Object)geoJson, (String)this.getMessage("shp.export.geo.null", new Object[0]));
        ArrayList records = new ArrayList();
        CoordinateReferenceSystem sourceCrs = null;
        Object geo = this.readUnTypeGeoJSON(geoJson);
        if (geo instanceof FeatureCollection) {
            SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
            SimpleFeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                HashMap<String, Object> record = new HashMap<String, Object>();
                for (Property property : feature.getProperties()) {
                    if (property.getName().getLocalPart().equalsIgnoreCase("crs")) continue;
                    record.put(property.getName().getLocalPart(), property.getValue());
                }
                records.add(record);
                if (this.isNull((Object)sourceCrs)) {
                    sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem();
                }
                if (!this.isNull((Object)sourceCrs)) continue;
                sourceCrs = this.readFeatureJSONCRS(this.toFeatureJSON((Object)feature));
            }
        } else if (geo instanceof SimpleFeature) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            for (Property property : ((SimpleFeature)geo).getProperties()) {
                if (property.getName().getLocalPart().equalsIgnoreCase("crs")) continue;
                record.put(property.getName().getLocalPart(), property.getValue());
            }
            records.add(record);
            if (this.isNull(sourceCrs)) {
                sourceCrs = ((SimpleFeature)geo).getFeatureType().getCoordinateReferenceSystem();
            }
        }
        if (records.size() == 0) {
            throw new RuntimeException(this.getMessage("shp.export.records.null", new Object[0]));
        }
        if (this.isNull(sourceCrs)) {
            this.logger.warn(this.getMessage("shp.export.crs.null", new Object[]{this.defaultCrs == null ? null : this.defaultCrs.toWKT()}));
        }
        try {
            String folderPath = System.getProperty("java.io.tmpdir").concat("\\SHP_" + System.currentTimeMillis());
            return this.createShpZip(folderPath, records, sourceCrs);
        }
        catch (Exception ex) {
            throw new RuntimeException(this.getMessage("shp.export.error", new Object[]{ex.getLocalizedMessage()}));
        }
    }

    public File exportToShp(String geoJson, CoordinateReferenceSystem crs) throws Exception {
        Assert.notNull((Object)geoJson, (String)this.getMessage("shp.export.geo.null", new Object[0]));
        ArrayList records = new ArrayList();
        Object geo = this.readUnTypeGeoJSON(geoJson);
        if (geo instanceof FeatureCollection) {
            SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
            SimpleFeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                HashMap<String, Object> record = new HashMap<String, Object>();
                for (Property property : feature.getProperties()) {
                    if (property.getName().getLocalPart().equalsIgnoreCase("crs")) continue;
                    record.put(property.getName().getLocalPart(), property.getValue());
                }
                records.add(record);
            }
        } else if (geo instanceof SimpleFeature) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            for (Property property : ((SimpleFeature)geo).getProperties()) {
                if (property.getName().getLocalPart().equalsIgnoreCase("crs")) continue;
                record.put(property.getName().getLocalPart(), property.getValue());
            }
            records.add(record);
        }
        if (records.size() == 0) {
            throw new RuntimeException(this.getMessage("shp.export.records.null", new Object[0]));
        }
        try {
            String folderPath = System.getProperty("java.io.tmpdir").concat("\\SHP_" + System.currentTimeMillis());
            return this.createShpZip(folderPath, records, crs);
        }
        catch (Exception ex) {
            throw new RuntimeException(this.getMessage("shp.export.error", new Object[]{ex.getLocalizedMessage()}));
        }
    }

    public File exportToShp(CoordinateReferenceSystem crs, String ... geoJsons) throws Exception {
        Assert.notNull((Object)geoJsons, (String)this.getMessage("shp.export.geo.null", new Object[0]));
        int cursor = 0;
        ArrayList<File> zips = new ArrayList<File>();
        for (String geoJson : geoJsons) {
            HashMap<String, Object> record;
            ArrayList records = new ArrayList();
            Object geo = this.readUnTypeGeoJSON(geoJson);
            if (geo instanceof FeatureCollection) {
                SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureIterator.next();
                    record = new HashMap();
                    for (Property property : feature.getProperties()) {
                        if (property.getName().getLocalPart().equalsIgnoreCase("crs")) continue;
                        record.put(property.getName().getLocalPart(), property.getValue());
                    }
                    records.add(record);
                }
            } else if (geo instanceof SimpleFeature) {
                record = new HashMap<String, Object>();
                for (Property property : ((SimpleFeature)geo).getProperties()) {
                    if (property.getName().getLocalPart().equalsIgnoreCase("crs")) continue;
                    record.put(property.getName().getLocalPart(), property.getValue());
                }
                records.add(record);
            }
            if (records.size() == 0) {
                throw new RuntimeException(this.getMessage("shp.export.records.null", new Object[0]));
            }
            try {
                String folderPath = System.getProperty("java.io.tmpdir").concat((cursor == 0 ? "\\origin_shp_" : "\\SHP_") + System.currentTimeMillis());
                zips.add(this.createShpZip(folderPath, records, crs));
            }
            catch (Exception ex) {
                throw new RuntimeException(this.getMessage("shp.export.error", new Object[]{ex.getLocalizedMessage()}));
            }
            ++cursor;
        }
        ArrayList documents = new ArrayList();
        File fp = new File(System.getProperty("java.io.tmpdir").concat("\\SHP_" + System.currentTimeMillis()));
        try {
            if (!fp.exists()) {
                fp.mkdir();
            }
            if (zips.size() > 0) {
                for (File zip : zips) {
                    documents.addAll(this.documentService.readZipFile(zip));
                }
            }
            for (cn.gtmap.onemap.platform.entity.Document doc : documents) {
                File tmp = new File(fp + "\\" + doc.getFileName());
                if (!tmp.exists()) {
                    tmp.createNewFile();
                }
                IOUtils.write((byte[])doc.getContent(), (OutputStream)new FileOutputStream(tmp));
            }
            if (fp.listFiles().length > 0) {
                return ZipUtils.doZip((String)fp.getPath(), null);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return null;
    }

    public File exportToShp(String layerName, String where, String geometry, String[] outFields, String dataSource) throws Exception {
        Assert.notNull((Object)layerName, (String)this.getMessage("shp.export.layerName.null", new Object[0]));
        CoordinateReferenceSystem sourceCrs = this.getLayerCRS(layerName, dataSource);
        List queryResult = new ArrayList();
        if (StringUtils.isNotBlank((String)where)) {
            queryResult = this.gisService.query(layerName, where, outFields, true, dataSource);
        } else if (StringUtils.isNotBlank((String)geometry)) {
            Object geo = this.readUnTypeGeoJSON(geometry);
            if (geo instanceof FeatureCollection) {
                SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureIterator.next();
                    queryResult.addAll(this.gisService.query(layerName, (Geometry)feature.getDefaultGeometry(), outFields, dataSource));
                }
            } else if (geo instanceof SimpleFeature) {
                queryResult.addAll(this.gisService.query(layerName, (SimpleFeature)geo, outFields, dataSource));
            }
        } else {
            throw new RuntimeException(this.getMessage("query.condition.missing", new Object[0]));
        }
        if (queryResult.size() == 0) {
            throw new RuntimeException(this.getMessage("shp.export.query.null", new Object[0]));
        }
        if (this.isNull((Object)sourceCrs)) {
            throw new RuntimeException(this.getMessage("shp.export.crs.null", new Object[0]));
        }
        try {
            String folderPath = System.getProperty("java.io.tmpdir").concat("\\SHP_" + System.currentTimeMillis());
            return this.createShpZip(folderPath, queryResult, sourceCrs);
        }
        catch (Exception ex) {
            throw new RuntimeException(this.getMessage("shp.export.error", new Object[]{ex.getLocalizedMessage()}));
        }
    }

    public String convertShpToDwg(String zipFile, String gpUrl) {
        assert (zipFile != null);
        assert (gpUrl != null);
        this.logger.debug("[zipfile:]" + zipFile);
        this.logger.debug("[gpUrl]:" + gpUrl);
        if (!gpUrl.endsWith("/execute")) {
            gpUrl = gpUrl.concat("/execute");
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httpRequest = new HttpPost(gpUrl);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("input_shape_file", zipFile));
        params.add(new BasicNameValuePair("f", "json"));
        try {
            UrlEncodedFormEntity httpentity = new UrlEncodedFormEntity(params, "UTF-8");
            httpRequest.setEntity((HttpEntity)httpentity);
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpRequest);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                this.logger.debug("[\u8c03\u7528gp\u670d\u52a1\u8fd4\u56de\u7ed3\u679c:]" + responseBody);
                Map map = (Map)JSON.parseObject((String)responseBody, Map.class);
                List results = (List)map.get("results");
                Map outputMap = (Map)((Map)results.get(0)).get("value");
                return MapUtils.getString((Map)outputMap, (Object)"url");
            }
            this.logger.error("\u8c03\u7528gp\u670d\u52a1\u5f02\u5e38");
            return null;
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public CoordinateReferenceSystem getCrsByCoordXD(double x) {
        String s = String.valueOf(Math.round(x));
        switch (s.length()) {
            case 8: {
                String p = s.substring(0, 2);
                if (this.coordinateDM.containsKey(p)) {
                    return (CoordinateReferenceSystem)this.coordinateDM.get(p);
                }
                throw new RuntimeException(this.getMessage("bj.coords.dm.not.set", new Object[]{p}));
            }
            case 6: {
                return (CoordinateReferenceSystem)this.coordinateDM.get(UNDEFINE);
            }
            case 5: {
                if (this.coordinateDM.containsKey("SUZHOU_WZ")) {
                    return (CoordinateReferenceSystem)this.coordinateDM.get("SUZHOU_WZ");
                }
                throw new RuntimeException(this.getMessage("bj.coords.type.not.support", new Object[]{x}));
            }
        }
        this.logger.error(this.getMessage("bj.coords.type.not.support", new Object[]{x}));
        throw new RuntimeException(this.getMessage("bj.coords.type.not.support", new Object[]{x}));
    }

    public String renderAnalysisContent(Map map, String type) {
        try {
            return this.templateService.getTemplate((Object)map, TPL_FOLDER.concat(type.concat(TPL_SUFFIX)), null);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getLocalizedMessage());
        }
        catch (TemplateException e) {
            e.printStackTrace();
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public File createShpZip(String folderPath, List<Map<String, Object>> values, CoordinateReferenceSystem crs) throws IOException {
        try {
            String[] keys;
            String filePath;
            File shpFile;
            File folderFile = new File(folderPath);
            if (!folderFile.exists()) {
                folderFile.mkdir();
            }
            if (!(shpFile = new File(filePath = folderFile.getPath().concat("\\" + folderFile.getName().concat(DOTS.concat(Document.Type.shp.name()))))).exists()) {
                shpFile.createNewFile();
            }
            HashMap<String, URL> params = new HashMap<String, URL>();
            params.put(ShapefileDataStoreFactory.URLP.key, shpFile.toURI().toURL());
            ShapefileDataStore ds = (ShapefileDataStore)new ShapefileDataStoreFactory().createNewDataStore(params);
            Map<String, Object> value = values.get(0);
            SimpleFeatureTypeBuilder typeBuilder = new SimpleFeatureTypeBuilder();
            typeBuilder.setName("shapefile");
            for (String key : keys = value.keySet().toArray(new String[0])) {
                if ("SHAPE".equals(key) || "geometry".equals(key)) {
                    Object geo = value.get(key);
                    if (geo instanceof String) {
                        geo = this.readWKT(MapUtils.getString(value, (Object)key));
                    }
                    if (geo instanceof Point) {
                        typeBuilder.add("the_geom", Point.class);
                        continue;
                    }
                    if (geo instanceof LineString) {
                        typeBuilder.add("the_geom", LineString.class);
                        continue;
                    }
                    if (geo instanceof Polygon) {
                        typeBuilder.add("the_geom", Polygon.class);
                        continue;
                    }
                    if (geo instanceof MultiPolygon) {
                        typeBuilder.add("the_geom", MultiPolygon.class);
                        continue;
                    }
                    if (!(geo instanceof MultiLineString)) continue;
                    typeBuilder.add("the_geom", MultiLineString.class);
                    continue;
                }
                if (key.length() > 10) {
                    String keyN = key.substring(0, 10);
                    this.logger.warn("\u5b57\u6bb5\u540d \u300e" + key + "\u300f\u957f\u5ea6\u8d85\u8fc710\u4e2a\u5b57\u7b26, \u5c06\u88ab\u622a\u53d6\u4e3a \u300e" + keyN + "\u300f");
                    typeBuilder.add(keyN, value.get(key) != null ? value.get(key).getClass() : String.class);
                    continue;
                }
                typeBuilder.add(key, value.get(key) != null ? value.get(key).getClass() : String.class);
            }
            if (!this.isNull((Object)crs)) {
                typeBuilder.setCRS(crs);
            } else {
                typeBuilder.setCRS((CoordinateReferenceSystem)(this.defaultCrs == null ? DefaultGeographicCRS.WGS84 : this.defaultCrs));
            }
            ds.createSchema(typeBuilder.buildFeatureType());
            ds.forceSchemaCRS(typeBuilder.getCRS());
            ds.setStringCharset(Charset.forName("GBK"));
            this.logger.debug("[\u5bfc\u51fashp\u7a7a\u95f4\u53c2\u8003]:" + typeBuilder.getCRS().toWKT());
            FeatureWriter writer = ds.getFeatureWriter(ds.getTypeNames()[0], Transaction.AUTO_COMMIT);
            SimpleFeature feature = null;
            for (Map<String, Object> item : values) {
                Geometry geometry;
                feature = (SimpleFeature)writer.next();
                Geometry geometry2 = geometry = item.containsKey("SHAPE") ? this.readWKT((String)item.get("SHAPE")) : null;
                if (this.isNull(geometry)) {
                    Object geo = item.get("geometry");
                    if (geo instanceof Geometry) {
                        geometry = (Geometry)geo;
                    } else if (geo instanceof String) {
                        Geometry geometry3 = geometry = item.containsKey("geometry") ? this.readWKT((String)item.get("geometry")) : null;
                    }
                }
                if (this.isNull((Object)geometry)) continue;
                feature.setAttribute("the_geom", (Object)this.geometryFactory.createGeometry(geometry));
                for (Map.Entry<String, Object> entry : item.entrySet()) {
                    String _k;
                    String key = String.valueOf(entry.getKey());
                    Object val = entry.getValue();
                    if (key.equals("SHAPE") || key.equals("crs") || key.equals("geometry") || Utils.isContainChinese((String)(_k = key.length() > 10 ? key.substring(0, 10) : key))) continue;
                    if (val instanceof String) {
                        feature.setAttribute(_k, (Object)String.valueOf(val));
                        continue;
                    }
                    if (val instanceof Double) {
                        feature.setAttribute(_k, (Object)MapUtils.getDoubleValue(item, (Object)key));
                        continue;
                    }
                    feature.setAttribute(_k, val);
                }
            }
            writer.write();
            writer.close();
            ds.dispose();
            File zipFile = ZipUtils.doZip((String)folderPath, null);
            if (zipFile.exists()) {
                return zipFile;
            }
        }
        catch (IOException e) {
            this.logger.error(this.getMessage("shp.export.zip.error", new Object[]{e.getLocalizedMessage()}));
            throw new RuntimeException(this.getMessage("shp.export.zip.error", new Object[]{e.getLocalizedMessage()}));
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("shp.export.error", new Object[]{e.getLocalizedMessage()}));
            FilesUtils.delFileOrDirectory((String)folderPath);
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return null;
    }

    private String parseShapefile(File shpFile, File dbfFile, File prjFile, Map properties) throws Exception {
        assert (shpFile != null) : this.getMessage("shp.shapefile.not.found", new Object[0]);
        ArrayList featureList = new ArrayList();
        ShapefileDataStore shapefileDataStore = null;
        SimpleFeatureSource featureSource = null;
        DbaseFileReader reader = null;
        PrjFileReader prjFileReader = null;
        CoordinateReferenceSystem sourceCrs = null;
        if (!this.isNull((Object)prjFile)) {
            try {
                prjFileReader = new PrjFileReader(new ShpFiles(prjFile));
                CoordinateReferenceSystem crs = prjFileReader.getCoodinateSystem();
                if (!this.isNull((Object)crs)) {
                    sourceCrs = crs;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
            finally {
                prjFileReader.close();
            }
        }
        try {
            shapefileDataStore = new ShapefileDataStore(shpFile.toURI().toURL());
            shapefileDataStore.setStringCharset(Charset.forName("GBK"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        try {
            featureSource = shapefileDataStore.getFeatureSource();
            FeatureCollection featureCollection = featureSource.getFeatures();
            if (featureCollection.size() > 0) {
                FeatureIterator iterator = featureCollection.features();
                while (iterator.hasNext()) {
                    TopologyValidationError validationError;
                    HashMap<String, String> map = new HashMap<String, String>();
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Geometry geo = (Geometry)feature.getDefaultGeometry();
                    boolean valid = true;
                    if (!this.isNull((Object)sourceCrs)) {
                        valid = this.agsGeometryService.validGeometry(geo.toText(), sourceCrs.toWKT());
                    }
                    if (!this.isNull((Object)(validationError = this.validGeometry(geo))) && !valid) {
                        throw new RuntimeException(this.getMessage("shp.tp.check.error", new Object[]{validationError.getMessage()}));
                    }
                    map.put("SHAPE", geo.toText());
                    if (properties != null) {
                        map.putAll(properties);
                    }
                    featureList.add(map);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        if (!this.isNull((Object)dbfFile)) {
            try {
                reader = new DbaseFileReader((ReadableByteChannel)new FileInputStream(dbfFile).getChannel(), false, Charset.forName("GBK"));
                DbaseFileHeader header = reader.getHeader();
                int fieldsNum = header.getNumFields();
                int recordIndex = 0;
                while (reader.hasNext()) {
                    DbaseFileReader.Row row = reader.readRow();
                    for (int i = 0; i < fieldsNum; ++i) {
                        String fieldName = header.getFieldName(i);
                        Object value = row.read(i);
                        Map map = (Map)featureList.get(recordIndex);
                        if (map.containsKey(fieldName.toLowerCase()) || map.containsKey(fieldName.toUpperCase())) continue;
                        map.put(fieldName, value);
                    }
                    ++recordIndex;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
            finally {
                reader.close();
            }
        }
        return this.toFeatureJSON((Object)this.list2FeatureCollection(featureList, sourceCrs, this.defaultCrs));
    }

    private String parseShapefile(File shpFile, File dbfFile, File prjFile, Map properties, boolean tolerateExp) throws Exception {
        assert (shpFile != null) : this.getMessage("shp.shapefile.not.found", new Object[0]);
        ArrayList featureList = new ArrayList();
        ShapefileDataStore shapefileDataStore = null;
        SimpleFeatureSource featureSource = null;
        DbaseFileReader reader = null;
        PrjFileReader prjFileReader = null;
        CoordinateReferenceSystem sourceCrs = null;
        if (!this.isNull((Object)prjFile)) {
            try {
                prjFileReader = new PrjFileReader(new ShpFiles(prjFile));
                CoordinateReferenceSystem crs = prjFileReader.getCoodinateSystem();
                if (!this.isNull((Object)crs)) {
                    sourceCrs = crs;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
            finally {
                prjFileReader.close();
            }
        }
        try {
            shapefileDataStore = new ShapefileDataStore(shpFile.toURI().toURL());
            shapefileDataStore.setStringCharset(Charset.forName("GBK"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        ArrayList<Integer> tolerateList = new ArrayList<Integer>();
        try {
            featureSource = shapefileDataStore.getFeatureSource();
            FeatureCollection featureCollection = featureSource.getFeatures();
            int tolerateIndex = 0;
            if (featureCollection.size() > 0) {
                FeatureIterator iterator = featureCollection.features();
                while (iterator.hasNext()) {
                    TopologyValidationError validationError;
                    ++tolerateIndex;
                    HashMap<String, String> map = new HashMap<String, String>();
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Geometry geo = (Geometry)feature.getDefaultGeometry();
                    boolean valid = true;
                    if (!this.isNull((Object)sourceCrs)) {
                        valid = this.agsGeometryService.validGeometry(geo.toText(), sourceCrs.toWKT());
                    }
                    if (!this.isNull((Object)(validationError = this.validGeometry(geo))) && !valid) {
                        if (tolerateExp) {
                            tolerateList.add(tolerateIndex - 1);
                            this.logger.error(this.getMessage("shp.tp.check.error", new Object[]{"Identifier:" + feature.getID() + "\u88ab\u8df3\u8fc7\uff0c\u56e0\u4e3a" + validationError.getMessage()}));
                            continue;
                        }
                        throw new RuntimeException(this.getMessage("shp.tp.check.error", new Object[]{validationError.getMessage()}));
                    }
                    map.put("SHAPE", geo.toText());
                    if (properties != null) {
                        map.putAll(properties);
                    }
                    featureList.add(map);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        if (!this.isNull((Object)dbfFile)) {
            try {
                reader = new DbaseFileReader((ReadableByteChannel)new FileInputStream(dbfFile).getChannel(), false, Charset.forName("GBK"));
                DbaseFileHeader header = reader.getHeader();
                int fieldsNum = header.getNumFields();
                int recordIndex = 0;
                int tolerateIndex = 0;
                while (reader.hasNext()) {
                    DbaseFileReader.Row row = reader.readRow();
                    if (tolerateList.contains(++tolerateIndex - 1)) continue;
                    for (int i = 0; i < fieldsNum; ++i) {
                        String fieldName = header.getFieldName(i);
                        Object value = row.read(i);
                        Map map = (Map)featureList.get(recordIndex);
                        if (map.containsKey(fieldName.toLowerCase()) || map.containsKey(fieldName.toUpperCase())) continue;
                        map.put(fieldName, value);
                    }
                    ++recordIndex;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
            finally {
                reader.close();
            }
        }
        return this.toFeatureJSON((Object)this.list2FeatureCollection(featureList, sourceCrs, this.defaultCrs));
    }

    private List parseShapefile2MapList(File shpFile, File dbfFile, File prjFile, Map properties, boolean tolerateExp) throws Exception {
        assert (shpFile != null) : this.getMessage("shp.shapefile.not.found", new Object[0]);
        ArrayList featureList = new ArrayList();
        ShapefileDataStore shapefileDataStore = null;
        SimpleFeatureSource featureSource = null;
        DbaseFileReader reader = null;
        PrjFileReader prjFileReader = null;
        CoordinateReferenceSystem sourceCrs = null;
        if (!this.isNull((Object)prjFile)) {
            try {
                prjFileReader = new PrjFileReader(new ShpFiles(prjFile));
                CoordinateReferenceSystem crs = prjFileReader.getCoodinateSystem();
                if (!this.isNull((Object)crs)) {
                    sourceCrs = crs;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
            finally {
                prjFileReader.close();
            }
        }
        try {
            shapefileDataStore = new ShapefileDataStore(shpFile.toURI().toURL());
            shapefileDataStore.setStringCharset(Charset.forName("GBK"));
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        ArrayList<Integer> tolerateList = new ArrayList<Integer>();
        try {
            featureSource = shapefileDataStore.getFeatureSource();
            FeatureCollection featureCollection = featureSource.getFeatures();
            int tolerateIndex = 0;
            if (featureCollection.size() > 0) {
                FeatureIterator iterator = featureCollection.features();
                while (iterator.hasNext()) {
                    TopologyValidationError validationError;
                    ++tolerateIndex;
                    HashMap<String, String> map = new HashMap<String, String>();
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Geometry geo = (Geometry)feature.getDefaultGeometry();
                    boolean valid = true;
                    if (!this.isNull((Object)sourceCrs)) {
                        valid = this.agsGeometryService.validGeometry(geo.toText(), sourceCrs.toWKT());
                    }
                    if (!this.isNull((Object)(validationError = this.validGeometry(geo))) && !valid) {
                        if (tolerateExp) {
                            tolerateList.add(tolerateIndex - 1);
                            this.logger.error(this.getMessage("shp.tp.check.error", new Object[]{"Identifier:" + feature.getID() + "\u88ab\u8df3\u8fc7\uff0c\u56e0\u4e3a" + validationError.getMessage()}));
                            continue;
                        }
                        throw new RuntimeException(this.getMessage("shp.tp.check.error", new Object[]{validationError.getMessage()}));
                    }
                    map.put("SHAPE", geo.toText());
                    if (properties != null) {
                        map.putAll(properties);
                    }
                    featureList.add(map);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        if (!this.isNull((Object)dbfFile)) {
            try {
                reader = new DbaseFileReader((ReadableByteChannel)new FileInputStream(dbfFile).getChannel(), false, Charset.forName("GBK"));
                DbaseFileHeader header = reader.getHeader();
                int fieldsNum = header.getNumFields();
                int recordIndex = 0;
                int tolerateIndex = 0;
                while (reader.hasNext()) {
                    DbaseFileReader.Row row = reader.readRow();
                    if (tolerateList.contains(++tolerateIndex - 1)) continue;
                    for (int i = 0; i < fieldsNum; ++i) {
                        String fieldName = header.getFieldName(i);
                        Object value = row.read(i);
                        Map map = (Map)featureList.get(recordIndex);
                        if (map.containsKey(fieldName.toLowerCase()) || map.containsKey(fieldName.toUpperCase())) continue;
                        map.put(fieldName, value);
                    }
                    ++recordIndex;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getLocalizedMessage());
            }
            finally {
                reader.close();
            }
        }
        return featureList;
    }

    /*
     * WARNING - void declaration
     */
    private List<Map<String, Object>> excel2List(int startRowNum, Sheet sheet, CoordinateReferenceSystem crs) {
        ArrayList<Map<String, Object>> features = new ArrayList<Map<String, Object>>();
        ArrayList coordList = new ArrayList();
        for (int i = startRowNum; i < sheet.getLastRowNum(); ++i) {
            Row row = sheet.getRow(i);
            if (!this.isNotNull((Object)row) || this.isNull((Object)row.getCell(0))) continue;
            if (row.getCell(0).getStringCellValue().endsWith(XLS_COORD_TAG)) {
                features.addAll(this.excel2List(i + 1, sheet, crs));
                break;
            }
            if (this.isNull((Object)row.getCell(0).getStringCellValue())) continue;
            HashMap<String, Object> coordMap = new HashMap<String, Object>();
            coordMap.put(BJ_TAG.PNT_SERIAL.name(), row.getCell(0).getStringCellValue());
            coordMap.put(BJ_TAG.SHAPE_GROUP.name(), row.getCell(1).getCellType() == 0 ? Double.valueOf(row.getCell(1).getNumericCellValue()) : row.getCell(1).getStringCellValue());
            coordMap.put(BJ_TAG.Y_COORD.name(), row.getCell(2).getCellType() == 0 ? Double.valueOf(row.getCell(2).getNumericCellValue()) : row.getCell(2).getStringCellValue());
            coordMap.put(BJ_TAG.X_COORD.name(), row.getCell(3).getCellType() == 0 ? Double.valueOf(row.getCell(3).getNumericCellValue()) : row.getCell(3).getStringCellValue());
            coordList.add(coordMap);
            this.logger.debug(((Object)coordMap).toString());
        }
        LinkedHashMap rings = new LinkedHashMap();
        CoordinateReferenceSystem fearureCrs = crs;
        try {
            for (Map map : coordList) {
                String ringNo = String.valueOf(map.get(BJ_TAG.SHAPE_GROUP.name()));
                double x = Double.parseDouble(String.valueOf(map.get(BJ_TAG.X_COORD.name())));
                double y = Double.parseDouble(String.valueOf(map.get(BJ_TAG.Y_COORD.name())));
                if (rings.containsKey(ringNo)) {
                    ((List)rings.get(ringNo)).add(new Coordinate(x, y));
                } else {
                    this.logger.debug("set ring of [" + ringNo + "]");
                    try {
                        ArrayList<Coordinate> ring = new ArrayList<Coordinate>();
                        ring.add(new Coordinate(x, y));
                        rings.put(ringNo, ring);
                    }
                    catch (Exception e) {
                        this.logger.error(e.getLocalizedMessage());
                        throw new RuntimeException(e.getLocalizedMessage());
                    }
                }
                if (fearureCrs != null) continue;
                fearureCrs = this.getCrsByCoordXD(x);
            }
        }
        catch (NumberFormatException e) {
            this.logger.error(this.getMessage("excel.parse.error", new Object[]{e.getLocalizedMessage()}));
            throw new RuntimeException(this.getMessage("excel.parse.error", new Object[]{e.getLocalizedMessage()}));
        }
        LinearRing shell = null;
        Object var9_12 = null;
        Collection coords = rings.values();
        for (List coordinates : coords) {
            Coordinate first = (Coordinate)coordinates.get(0);
            Coordinate last = (Coordinate)coordinates.get(coordinates.size() - 1);
            if (first.x == last.x && first.y == last.y) continue;
            coordinates.add(new Coordinate(first.x, first.y));
        }
        Polygon polygon = null;
        HashMap<String, String> feature = new HashMap<String, String>();
        try {
            void var9_13;
            for (List coordinates : coords) {
                if (shell == null) {
                    shell = this.geometryFactory.createLinearRing(coordinates.toArray(new Coordinate[0]));
                    continue;
                }
                if (var9_13 == null) {
                    ArrayList arrayList = new ArrayList();
                }
                var9_13.add(this.geometryFactory.createLinearRing(coordinates.toArray(new Coordinate[0])));
            }
            polygon = this.geometryFactory.createPolygon(shell, var9_13 != null ? var9_13.toArray(new LinearRing[0]) : null);
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("excel.parse.error", new Object[]{e.getLocalizedMessage()}));
            throw new RuntimeException(this.getMessage("excel.parse.error", new Object[]{e.getLocalizedMessage()}));
        }
        Row titleRow = sheet.getRow(startRowNum - 1);
        String titleValue = titleRow.getCell(0).getStringCellValue().replaceAll("\\s*", "");
        titleValue = titleValue.replaceAll("\uff0c", ",");
        List<String> infoList = Arrays.asList(titleValue.split(","));
        String plotName = infoList.get(3);
        feature.put("SHAPE", polygon.toText());
        feature.put("crs", (String)fearureCrs);
        feature.put(BJ_TAG.PL_NAME.name(), plotName);
        features.add(feature);
        return features;
    }

    private Map parseBjXmlAdv(byte[] bytes) {
        Document document = null;
        HashMap<String, Object> result = new HashMap<String, Object>();
        SAXReader reader = new SAXReader();
        try {
            document = reader.read((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (DocumentException e) {
            throw new RuntimeException(this.getMessage("doc.read.xml.error", new Object[]{e.getLocalizedMessage()}));
        }
        if (document != null) {
            boolean sFlag = false;
            ArrayList<Map> features = new ArrayList<Map>();
            Element root = document.getRootElement();
            Node projInfo = root.selectSingleNode("DATA[@DATANAME='BL_PROJ_BUILD']").selectSingleNode("ROWDATA/ROW");
            Node blArea = root.selectSingleNode("DATA[@DATANAME='BL_BUILD_PROJ_LAND']").selectSingleNode("ROWDATA/ROW");
            if (projInfo instanceof Element) {
                Element element = (Element)projInfo;
                result.put(BJ_TITLE, element.attributeValue(BJ_TAG.PROJ_NAME.name()));
                String bjType = "\u6279\u6b21\u57ce\u9547\u5efa\u8bbe\u7528\u5730";
                if (this.isNotNull((Object)element.attribute(BJ_TAG.BJTYPE.name()))) {
                    bjType = element.attributeValue(BJ_TAG.BJTYPE.name());
                } else if (this.isNotNull((Object)element.attribute(BJ_TAG.PROJ_TYPE.name()))) {
                    bjType = element.attributeValue(BJ_TAG.PROJ_TYPE.name());
                }
                if ("\u5355\u72ec\u9009\u5740\u9879\u76ee".equals(bjType)) {
                    sFlag = true;
                }
            }
            if (blArea instanceof Element) {
                result.put(BJ_AREA, ((Element)blArea).attributeValue(BJ_TAG.SUM_TOT.name()));
                result.put(BJ_AREA_NYD, ((Element)blArea).attributeValue(BJ_TAG.FARM_TOT.name()));
                result.put(BJ_AREA_GD, ((Element)blArea).attributeValue(BJ_TAG.TILTH_TOT.name()));
                result.put(BJ_AREA_JSYD, ((Element)blArea).attributeValue(BJ_TAG.BUILD_TOT.name()));
                result.put(BJ_AREA_WLYD, ((Element)blArea).attributeValue(BJ_TAG.UNUSED_TOT.name()));
            }
            Node blBound = root.selectSingleNode("DATA[@DATANAME='BL_SURVEY_BOUND']");
            Node blPlotClassArea = root.selectSingleNode("DATA[@DATANAME='BL_LAND_CLASS_AREA_ED']");
            Node blPntCoords = root.selectSingleNode("DATA[@DATANAME='BL_PNT_COORD']");
            List plotRows = blBound.selectNodes("ROWDATA/ROW");
            List actualPls = root.selectSingleNode("DATA[@DATANAME='BL_PLOT']").selectNodes("ROWDATA/ROW");
            result.put("isSeparate", sFlag);
            CoordinateReferenceSystem sourceCrs = null;
            for (Object item : actualPls) {
                if (!(item instanceof Element)) continue;
                Element row = (Element)item;
                String id = row.attributeValue(BJ_TAG.PL_ID.name());
                String name = row.attributeValue(BJ_TAG.PL_NAME.name());
                Map feature = this.getFeature(id, name, blPntCoords, true, null);
                if (sourceCrs == null) {
                    sourceCrs = (CoordinateReferenceSystem)feature.get("crs");
                }
                feature.remove("crs");
                features.add(feature);
            }
            result.put(BJ_FEATURE, this.toFeatureJSON((Object)this.list2FeatureCollection(features, sourceCrs, this.defaultCrs)));
            return result;
        }
        throw new RuntimeException(this.getMessage("bj.parse.error", new Object[0]));
    }

    private Map getPlotClassArea(String id, Node node) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        if (!this.isNull((Object)id) && !this.isNull((Object)node)) {
            ArrayList list = new ArrayList();
            double sumArea = 0.0;
            double buildArea = 0.0;
            double tilthArea = 0.0;
            double unusedArea = 0.0;
            double farmArea = 0.0;
            List rows = node.selectNodes("ROWDATA/ROW");
            for (Object item : rows) {
                Element row;
                String sbId;
                if (!(item instanceof Element) || !id.equals(sbId = (row = (Element)item).attributeValue(BJ_TAG.SB_SB_ID.name()))) continue;
                String dlbm = row.attributeValue(BJ_TAG.DLBM.name());
                Double area = Double.valueOf(row.attributeValue(BJ_TAG.JTMJ.name())) + Double.valueOf(row.attributeValue(BJ_TAG.GYMJ.name()));
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("dlbm", dlbm);
                map.put(BJ_AREA, area);
                list.add(map);
            }
            Map gMap = ArrayUtils.listConvertMap(list, (String)"dlbm");
            if (!this.isNull((Object)gMap)) {
                Iterator i$ = gMap.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry item;
                    Map.Entry entry = item = i$.next();
                    List data = (List)MapUtils.getObject((Map)gMap, entry.getKey());
                    double classArea = 0.0;
                    for (Map tmp : data) {
                        classArea += MapUtils.getDouble((Map)tmp, (Object)BJ_AREA, (Double)0.0).doubleValue();
                    }
                    if (ArrayUtils.contains((String[])EnumUtils.TDLYXZ_THREE_TYPE.TILTH.getDlbms(), (String)String.valueOf(entry.getKey()), (boolean)true)) {
                        tilthArea += classArea;
                    }
                    if (ArrayUtils.contains((String[])EnumUtils.TDLYXZ_THREE_TYPE.FARM.getDlbms(), (String)String.valueOf(entry.getKey()), (boolean)true)) {
                        farmArea += classArea;
                    }
                    if (ArrayUtils.contains((String[])EnumUtils.TDLYXZ_THREE_TYPE.BUILD.getDlbms(), (String)String.valueOf(entry.getKey()), (boolean)true)) {
                        buildArea += classArea;
                    }
                    if (ArrayUtils.contains((String[])EnumUtils.TDLYXZ_THREE_TYPE.UNUSED.getDlbms(), (String)String.valueOf(entry.getKey()), (boolean)true)) {
                        unusedArea += classArea;
                    }
                    sumArea += classArea;
                }
            }
            result.put(BJ_AREA, sumArea * 1.0E-4);
            result.put(BJ_AREA_NYD, farmArea * 1.0E-4);
            result.put(BJ_AREA_GD, tilthArea * 1.0E-4);
            result.put(BJ_AREA_JSYD, buildArea * 1.0E-4);
            result.put(BJ_AREA_WLYD, unusedArea * 1.0E-4);
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private Map getFeature(String id, String name, Node node, boolean isSep, String info) {
        HashMap<String, String> feature = new HashMap<String, String>();
        CoordinateReferenceSystem fearureCrs = null;
        feature.put(BJ_TAG.ID.name(), id);
        feature.put(BJ_TAG.NAME.name(), name);
        if (!this.isNull((Object)info)) {
            feature.put(BJ_TAG.INFO.name(), info);
        }
        LinkedHashMap rings = new LinkedHashMap();
        List rows = new ArrayList();
        rows = !isSep ? node.selectNodes("ROWDATA/ROW[@SB_SB_ID='" + id + "']") : node.selectNodes("ROWDATA/ROW[@PL_PL_ID='" + id + "']");
        ArrayList sortRows = new ArrayList();
        for (Object e : rows) {
            if (!(e instanceof Element)) continue;
            Element row = (Element)e;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(BJ_TAG.SHAPE_GROUP.name(), row.attributeValue(BJ_TAG.SHAPE_GROUP.name()));
            map.put(BJ_TAG.PNT_SERIAL.name(), row.attributeValue(BJ_TAG.PNT_SERIAL.name()));
            map.put(BJ_TAG.Y_COORD.name(), row.attributeValue(BJ_TAG.Y_COORD.name()));
            map.put(BJ_TAG.X_COORD.name(), row.attributeValue(BJ_TAG.X_COORD.name()));
            sortRows.add(map);
        }
        Collections.sort(sortRows, new /* Unavailable Anonymous Inner Class!! */);
        for (HashMap hashMap : sortRows) {
            String ringNo = String.valueOf(hashMap.get(BJ_TAG.SHAPE_GROUP.name()));
            double x = Double.valueOf((String)hashMap.get(BJ_TAG.Y_COORD.name()));
            double y = Double.valueOf((String)hashMap.get(BJ_TAG.X_COORD.name()));
            if (rings.containsKey(ringNo)) {
                ((List)rings.get(ringNo)).add(new Coordinate(x, y));
            } else {
                ArrayList<Coordinate> ring = new ArrayList<Coordinate>();
                ring.add(new Coordinate(x, y));
                rings.put(ringNo, ring);
            }
            if (fearureCrs != null) continue;
            fearureCrs = this.getCrsByCoordXD(x);
        }
        LinearRing shell = null;
        Object var12_15 = null;
        Collection coords = rings.values();
        for (List coordinates2 : coords) {
            Coordinate first = (Coordinate)coordinates2.get(0);
            Coordinate last = (Coordinate)coordinates2.get(coordinates2.size() - 1);
            if (first.x == last.x && first.y == last.y) continue;
            coordinates2.add(new Coordinate(first.x, first.y));
        }
        Polygon polygon = null;
        List coordinates2 = null;
        try {
            void var12_16;
            for (List coordinates2 : coords) {
                if (shell == null) {
                    shell = this.geometryFactory.createLinearRing(coordinates2.toArray(new Coordinate[0]));
                    continue;
                }
                if (var12_16 == null) {
                    ArrayList arrayList = new ArrayList();
                }
                var12_16.add(this.geometryFactory.createLinearRing(coordinates2.toArray(new Coordinate[0])));
            }
            polygon = this.geometryFactory.createPolygon(shell, var12_16 != null ? var12_16.toArray(new LinearRing[0]) : null);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("bj.polygon.coords.error", new Object[]{name, e.getLocalizedMessage(), JSON.toJSONString((Object)coordinates2)}));
        }
        feature.put("SHAPE", polygon.toText());
        feature.put("crs", (String)fearureCrs);
        return feature;
    }

    @Deprecated
    private Map parseBjXml(byte[] bytes) {
        Document document = null;
        HashMap<String, String> result = new HashMap<String, String>();
        SAXReader reader = new SAXReader();
        try {
            document = reader.read((InputStream)new ByteArrayInputStream(bytes));
        }
        catch (DocumentException e) {
            throw new RuntimeException(this.getMessage("doc.read.xml.error", new Object[]{e.getLocalizedMessage()}));
        }
        if (document != null) {
            ArrayList<Map> features = new ArrayList<Map>();
            Element root = document.getRootElement();
            Node blName = root.selectSingleNode("DATA[@DATANAME='BL_PROJ_BUILD']").selectSingleNode("ROWDATA/ROW");
            Node blArea = root.selectSingleNode("DATA[@DATANAME='BL_BUILD_PROJ_LAND']").selectSingleNode("ROWDATA/ROW");
            if (blName instanceof Element) {
                result.put(BJ_TITLE, ((Element)blName).attributeValue(BJ_TAG.PROJ_NAME.name()));
            }
            if (blArea instanceof Element) {
                result.put(BJ_AREA, ((Element)blArea).attributeValue(BJ_TAG.SUM_TOT.name()));
                result.put(BJ_AREA_NYD, ((Element)blArea).attributeValue(BJ_TAG.FARM_TOT.name()));
                result.put(BJ_AREA_GD, ((Element)blArea).attributeValue(BJ_TAG.TILTH_TOT.name()));
                result.put(BJ_AREA_JSYD, ((Element)blArea).attributeValue(BJ_TAG.BUILD_TOT.name()));
                result.put(BJ_AREA_WLYD, ((Element)blArea).attributeValue(BJ_TAG.UNUSED_TOT.name()));
            }
            Node blPlot = root.selectSingleNode("DATA[@DATANAME='BL_PLOT']");
            Node blPntCoords = root.selectSingleNode("DATA[@DATANAME='BL_PNT_COORD']");
            List rows = blPlot.selectNodes("ROWDATA/ROW");
            CoordinateReferenceSystem sourceCrs = null;
            for (Object item : rows) {
                if (!(item instanceof Element)) continue;
                Element row = (Element)item;
                String id = row.attributeValue(BJ_TAG.PL_ID.name());
                String name = row.attributeValue(BJ_TAG.PL_NAME.name());
                Map feature = this.getFeature(id, name, blPntCoords);
                if (sourceCrs == null) {
                    sourceCrs = (CoordinateReferenceSystem)feature.get("crs");
                }
                feature.remove("crs");
                features.add(feature);
            }
            result.put(BJ_FEATURE, this.toFeatureJSON((Object)this.list2FeatureCollection(features, sourceCrs, this.defaultCrs)));
            return result;
        }
        throw new RuntimeException(this.getMessage("bj.parse.error", new Object[0]));
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    private Map getFeature(String id, String name, Node node) {
        HashMap<String, String> feature = new HashMap<String, String>();
        CoordinateReferenceSystem fearureCrs = null;
        feature.put(BJ_TAG.ID.name(), id);
        feature.put(BJ_TAG.NAME.name(), name);
        LinkedHashMap rings = new LinkedHashMap();
        List rows = node.selectNodes("ROWDATA/ROW[@PL_PL_ID='" + id + "']");
        ArrayList sortRows = new ArrayList();
        for (Object e : rows) {
            if (!(e instanceof Element)) continue;
            Element row = (Element)e;
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put(BJ_TAG.SHAPE_GROUP.name(), row.attributeValue(BJ_TAG.SHAPE_GROUP.name()));
            map.put(BJ_TAG.PNT_SERIAL.name(), row.attributeValue(BJ_TAG.PNT_SERIAL.name()));
            map.put(BJ_TAG.Y_COORD.name(), row.attributeValue(BJ_TAG.Y_COORD.name()));
            map.put(BJ_TAG.X_COORD.name(), row.attributeValue(BJ_TAG.X_COORD.name()));
            sortRows.add(map);
        }
        Collections.sort(sortRows, new /* Unavailable Anonymous Inner Class!! */);
        for (HashMap hashMap : sortRows) {
            String ringNo = String.valueOf(hashMap.get(BJ_TAG.SHAPE_GROUP.name()));
            double x = Double.valueOf((String)hashMap.get(BJ_TAG.Y_COORD.name()));
            double y = Double.valueOf((String)hashMap.get(BJ_TAG.X_COORD.name()));
            if (rings.containsKey(ringNo)) {
                ((List)rings.get(ringNo)).add(new Coordinate(x, y));
            } else {
                ArrayList<Coordinate> ring = new ArrayList<Coordinate>();
                ring.add(new Coordinate(x, y));
                rings.put(ringNo, ring);
            }
            if (fearureCrs != null) continue;
            fearureCrs = this.getCrsByCoordXD(x);
        }
        LinearRing shell = null;
        Object var10_13 = null;
        Collection coords = rings.values();
        for (List coordinates : coords) {
            Coordinate first = (Coordinate)coordinates.get(0);
            Coordinate last = (Coordinate)coordinates.get(coordinates.size() - 1);
            if (first.x == last.x && first.y == last.y) continue;
            coordinates.add(new Coordinate(first.x, first.y));
        }
        Polygon polygon = null;
        try {
            void var10_14;
            for (List coordinates : coords) {
                if (shell == null) {
                    shell = this.geometryFactory.createLinearRing(coordinates.toArray(new Coordinate[0]));
                    continue;
                }
                if (var10_14 == null) {
                    ArrayList arrayList = new ArrayList();
                }
                var10_14.add(this.geometryFactory.createLinearRing(coordinates.toArray(new Coordinate[0])));
            }
            polygon = this.geometryFactory.createPolygon(shell, var10_14 != null ? var10_14.toArray(new LinearRing[0]) : null);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("bj.polygon.coords.error", new Object[]{name, e.getLocalizedMessage()}));
        }
        feature.put("SHAPE", polygon.toText());
        feature.put("crs", (String)fearureCrs);
        return feature;
    }

    private synchronized WKTReader getWktReader() {
        if (this.wktReader == null) {
            this.wktReader = new WKTReader(this.geometryFactory);
        }
        return this.wktReader;
    }

    public void setRegionSet(Resource location) {
        try {
            Map values = (Map)JSON.parseObject((String)IOUtils.toString((URI)location.getURI()), Map.class);
            this.simplifyTolerance = Double.valueOf(String.valueOf(values.get("simplifyTolerance")));
            this.regionLayers = (Map)values.get(REGION_FIELD);
            this.regionSet = (Map)values.get(REGION_MAP);
            if (values.containsKey(DEFAULT_CRS)) {
                this.defaultCrs = this.parseUndefineSR(String.valueOf(values.get(DEFAULT_CRS)));
            }
            if (values.containsKey(COORDINATE_DM)) {
                this.coordinateDM = (Map)values.get(COORDINATE_DM);
                for (Map.Entry entry : this.coordinateDM.entrySet()) {
                    entry.setValue(this.parseUndefineSR((String)entry.getValue()));
                }
            }
        }
        catch (IOException e) {
            this.logger.error(" region set file not found ");
        }
    }
}

