/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.event.GeometryServiceException;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.GISManager;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.service.impl.GeoServiceImpl;
import cn.gtmap.onemap.platform.utils.GeometryUtils;
import cn.gtmap.onemap.platform.utils.SRTransformations;
import cn.gtmap.onemap.service.GeoService;
import com.alibaba.fastjson.JSON;
import com.esri.sde.sdk.pe.PeProjectionException;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.operation.valid.IsValidOp;
import com.vividsolutions.jts.operation.valid.TopologyValidationError;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;

public class GeoServiceImpl
extends BaseLogger
implements GeoService {
    protected static final String SE_OBJECTID_FIELD = "OBJECTID";
    protected static final String EPSG = "EPSG";
    protected static final String SHAPE = "SHAPE";
    protected static final String GEOMETRY = "geometry";
    protected static final String FEATURE_CRS = "crs";
    protected static final String FEATURE = "feature";
    @Autowired
    private GISManager gisManager;

    public List query(String layerName, String where, String[] outFields, boolean returnGeometry, String dataSource) {
        try {
            return this.gisManager.getGISService().query(layerName, where, outFields, returnGeometry, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(" query error , detail : " + e.getLocalizedMessage());
        }
    }

    public List query(String layerName, Geometry geometry, String[] outFields, String dataSource) {
        try {
            return this.gisManager.getGISService().query(layerName, geometry, outFields, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(" query error , detail : " + e.getLocalizedMessage());
        }
    }

    public List query(String layerName, String geometry, String[] outFields, String dataSource) {
        try {
            return this.gisManager.getGISService().query(layerName, this.gisManager.getGeoService().readGeoJSON(geometry), outFields, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(" query error , detail : " + e.getLocalizedMessage());
        }
    }

    public String insert(String layerName, String feature, String dataSource) {
        try {
            return this.gisManager.getGISService().insert2(layerName, feature, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(" insert error , detail : " + e.getLocalizedMessage());
        }
    }

    public String insert(String layerName, String geoJSON, boolean check, String dataSource) {
        try {
            return this.gisManager.getGISService().insert2(layerName, geoJSON, check, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(" insert error , detail : " + e.getLocalizedMessage());
        }
    }

    public String insert(String layerName, String geoJSON, boolean check, boolean addCreateTime, String dataSource) {
        try {
            return this.gisManager.getGISService().insert3(layerName, geoJSON, check, addCreateTime, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(" insert error , detail : " + e.getLocalizedMessage());
        }
    }

    public boolean update(String layerName, String where, String feature, String dataSource) {
        try {
            List list = this.query(layerName, where, null, true, dataSource);
            for (int i = 0; i < list.size(); ++i) {
                Map item = (Map)list.get(i);
                String primaryKey = String.valueOf(item.get(SE_OBJECTID_FIELD));
                if (this.gisManager.getGISService().update(layerName, primaryKey, feature, dataSource)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("update error,detail:" + e.getLocalizedMessage());
        }
    }

    public boolean update2(String layerName, String where, String properties, String dataSource) {
        assert (properties != null);
        try {
            List list = this.query(layerName, where, null, true, dataSource);
            Map columns = (Map)JSON.parseObject((String)properties, Map.class);
            if (!this.isNull((Object)list)) {
                for (int i = 0; i < list.size(); ++i) {
                    Map item = (Map)list.get(i);
                    String primaryKey = String.valueOf(item.get(SE_OBJECTID_FIELD));
                    if (this.gisManager.getGISService().update(layerName, primaryKey, columns, dataSource)) continue;
                    return false;
                }
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("update error,detail:" + e.getLocalizedMessage());
        }
    }

    public boolean delete(String layerName, String where, String dataSource) {
        try {
            List list = this.query(layerName, where, null, true, dataSource);
            for (int i = 0; i < list.size(); ++i) {
                Map item = (Map)list.get(i);
                String primaryKey = String.valueOf(item.get(SE_OBJECTID_FIELD));
                if (this.gisManager.getGISService().delete(layerName, primaryKey, dataSource)) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            throw new RuntimeException("delete error,detail:" + e.getLocalizedMessage());
        }
    }

    public String intersect(String layerName, String geometry, String outFields, String dataSource) {
        String[] fields = "*".equals(outFields) ? null : outFields.split(",");
        List results = this.gisManager.getGISService().intersect2(layerName, geometry, fields, dataSource);
        FeatureCollection collection = this.gisManager.getGeoService().list2FeatureCollection(results, null, null);
        return this.toFeatureJSON((Object)collection);
    }

    public List intersect(String layerName, Geometry geometry, String[] outFields, String dataSource) {
        try {
            return this.gisManager.getGISService().intersect(layerName, geometry, outFields, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public String difference(String layerName, String geometry, String outFields, String dataSource) {
        try {
            String[] fields = "*".equals(outFields) ? null : outFields.split(",");
            List result = this.gisManager.getGISService().differenceByGeoJson(layerName, geometry, fields, dataSource);
            FeatureCollection featureCollection = this.gisManager.getGeoService().list2FeatureCollection(result, null, null);
            return this.toFeatureJSON((Object)featureCollection);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public Map tdghsc(String year, String geometry, String outFields, String dataSource) {
        String[] fields = "*".equals(outFields) ? null : outFields.split(",");
        return this.gisManager.getGISService().tdghscResult(this.gisManager.getGISService().tdghscAnalysis2(year, geometry, fields, dataSource));
    }

    public Map tdlyxz(String dltbLayerName, String xzdwLayerName, String geometry, String dataSource) {
        return this.gisManager.getGISService().tdlyxzAnalysis2(dltbLayerName, xzdwLayerName, geometry, dataSource);
    }

    public Map tdlyxzWcf(String dltbLayerName, String xzdwLayerName, String geometry, String dataSource) {
        return this.gisManager.getGISService().tdlyxzAnalysisByWcf(dltbLayerName, xzdwLayerName, geometry);
    }

    public Object readGeoJSON(String geoJSON) {
        return GeometryUtils.parseGeoJSON((String)geoJSON);
    }

    public Geometry readWKT(String wkt) {
        try {
            return this.gisManager.getGeoService().readWKT(wkt);
        }
        catch (Exception e) {
            throw new RuntimeException(" readWKT error , detail : " + e.getLocalizedMessage());
        }
    }

    public CoordinateReferenceSystem readCRS(String geoJson) {
        return this.gisManager.getGeoService().readFeatureJSONCRS(geoJson);
    }

    public CoordinateReferenceSystem parseUndefineSR(String sr) {
        return this.gisManager.getGeoService().parseUndefineSR(sr);
    }

    public String toFeatureJSON(Object feature) {
        return this.gisManager.getGeoService().toFeatureJSON(feature);
    }

    public String toGeoJSON(Object geometry) {
        if (geometry instanceof Geometry) {
            return this.gisManager.getGeoService().toGeoJSON((Geometry)geometry);
        }
        if (geometry instanceof SimpleFeature) {
            return this.toFeatureJSON(geometry);
        }
        if (geometry instanceof FeatureCollection) {
            return this.toFeatureJSON(geometry);
        }
        throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOMETRY_TO_JSON_EXCEPTION, "geometry not be supported");
    }

    public Geometry project(Geometry geometry, String sourceCrs, String targetCrs) {
        try {
            return SRTransformations.project((Geometry)geometry, (String)sourceCrs, (String)targetCrs);
        }
        catch (PeProjectionException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.PROJECT_EXCEPTION, e.getLocalizedMessage());
        }
    }

    public Geometry project(Geometry geometry, int inSR, int outSR) {
        return this.gisManager.getGeoService().project(geometry, this.readCRS(String.valueOf(inSR)), this.readCRS(String.valueOf(outSR)));
    }

    public Geometry simplify(Geometry geometry, double tolerance) {
        return geometry.isValid() && geometry.isSimple() ? geometry : DouglasPeuckerSimplifier.simplify((Geometry)geometry, (double)tolerance);
    }

    public TopologyValidationError validGeometry(Geometry geometry) {
        IsValidOp isValidOp = new IsValidOp(geometry);
        return isValidOp.getValidationError();
    }

    public String map2SimpleFeature(Map<String, Object> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        return this.toFeatureJSON((Object)this.gisManager.getGeoService().map2SimpleFeature(value, srcCRS, destCRS));
    }

    public String list2FeatureCollection(List<Map<String, Object>> value, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem destCRS) {
        try {
            return this.toFeatureJSON((Object)this.gisManager.getGeoService().list2FeatureCollection(value, srcCRS, destCRS));
        }
        catch (Exception e) {
            throw new RuntimeException(" list values to featureCollection error , detail : " + e.getLocalizedMessage());
        }
    }

    public Map<String, Object> simpleFeature2Map(SimpleFeature feature) {
        return this.gisManager.getGeoService().simpleFeature2Map(feature);
    }

    public CoordinateReferenceSystem getCrsByCoordXD(double x) {
        return this.gisManager.getGeoService().getCrsByCoordXD(x);
    }

    public String getShpCoordinates(File file, String properties) {
        try {
            if (properties != null) {
                return this.gisManager.getGeoService().getShpCoordinates(file, properties);
            }
            return this.gisManager.getGeoService().getShpCoordinates(file);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    public String getShpCoordinates(File file, String properties, boolean tolerateExp) {
        try {
            if (properties != null) {
                return this.gisManager.getGeoService().getShpCoordinates(file, properties, tolerateExp);
            }
            return this.gisManager.getGeoService().getShpCoordinates(file, tolerateExp);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShpCoordinates(InputStream stream, String properties) {
        block9: {
            String string;
            if (this.isNull((Object)stream)) {
                throw new RuntimeException("stream is null");
            }
            if (stream.available() <= 0) break block9;
            File tmp = new File(System.getProperty("java.io.tmpdir").concat("TEMP_" + System.currentTimeMillis()));
            try {
                FileOutputStream output = new FileOutputStream(tmp);
                try {
                    IOUtils.copyLarge((InputStream)stream, (OutputStream)output, (long)0L, (long)stream.available(), (byte[])new byte[stream.available()]);
                    output.close();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
                string = this.getShpCoordinates(tmp, properties);
            }
            catch (Throwable throwable) {
                try {
                    FileUtils.deleteQuietly((File)tmp);
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            FileUtils.deleteQuietly((File)tmp);
            return string;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getShpCoordinates(InputStream stream, String properties, boolean tolerateExp) {
        block9: {
            String string;
            if (this.isNull((Object)stream)) {
                throw new RuntimeException("stream is null");
            }
            if (stream.available() <= 0) break block9;
            File tmp = new File(System.getProperty("java.io.tmpdir").concat("TEMP_" + System.currentTimeMillis()));
            try {
                FileOutputStream output = new FileOutputStream(tmp);
                try {
                    IOUtils.copyLarge((InputStream)stream, (OutputStream)output, (long)0L, (long)stream.available(), (byte[])new byte[stream.available()]);
                    output.close();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
                string = this.getShpCoordinates(tmp, properties, tolerateExp);
            }
            catch (Throwable throwable) {
                try {
                    FileUtils.deleteQuietly((File)tmp);
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            FileUtils.deleteQuietly((File)tmp);
            return string;
        }
        return null;
    }

    public String getShpCoordinates(String filePath, String properties, boolean tolerateExp) {
        File file = new File(filePath);
        if (file.isFile()) {
            return this.getShpCoordinates(file, properties, tolerateExp);
        }
        return "";
    }

    public String insertShpCoordinates(String filePath, String properties, String layerName, String dataSource, boolean tolerateExp) throws Exception {
        File file = new File(filePath);
        long date = System.currentTimeMillis();
        if (file.isFile()) {
            Map result = this.gisManager.getGeoService().insertShpCoordinates(file, properties, layerName, dataSource, tolerateExp);
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (this.isNull((Object)result) || !((Boolean)result.get("success")).booleanValue()) {
                map.put("success", false);
                map.put("result", result.get("result"));
            } else {
                String outPath = System.getProperty("java.io.tmpdir").concat("\\TMP_" + System.currentTimeMillis());
                this.logger.info("\u63d2\u5165\u6570\u636e\u6210\u529f\uff0c\u5c06\u7ed3\u679c\u5199\u5165\u6587\u4ef6:" + outPath + "\uff01");
                FileOutputStream out = new FileOutputStream(outPath);
                BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
                bw.write((String)result.get("result"));
                bw.flush();
                this.logger.info("\u6210\u529f\u5199\u5165\u6570\u636e\uff0c\u7ed3\u679c\u5199\u5165" + outPath + "\uff0c\u603b\u8017\u65f6\uff1a" + (System.currentTimeMillis() - date) + "ms");
                map.put("success", true);
                map.put("result", outPath);
            }
            return JSON.toJSONString(map);
        }
        1 map = new /* Unavailable Anonymous Inner Class!! */;
        return JSON.toJSONString((Object)map);
    }

    public File exportToShp(String geoJson) throws Exception {
        return this.gisManager.getGeoService().exportToShp(geoJson);
    }

    public File exportToShp(String layerName, String where, String geometry, String[] outFields, String dataSource) throws Exception {
        return this.gisManager.getGeoService().exportToShp(layerName, where, geometry, outFields, dataSource);
    }

    public String getDwgCoordinates(String dwgFile, String gpUrl, String properties) throws Exception {
        assert (dwgFile != null);
        assert (gpUrl != null);
        Map propertyMap = (Map)JSON.parseObject((String)properties, Map.class);
        if (this.isNull((Object)propertyMap)) {
            this.logger.info("properties is null");
        }
        if (!gpUrl.endsWith("/execute")) {
            gpUrl = gpUrl.concat("/execute");
        }
        DefaultHttpClient httpclient = new DefaultHttpClient();
        HttpPost httpRequest = new HttpPost(gpUrl);
        ArrayList<BasicNameValuePair> params = new ArrayList<BasicNameValuePair>();
        params.add(new BasicNameValuePair("input_cad_file", dwgFile));
        params.add(new BasicNameValuePair("f", "json"));
        try {
            UrlEncodedFormEntity httpentity = new UrlEncodedFormEntity(params, "UTF-8");
            httpRequest.setEntity((HttpEntity)httpentity);
            HttpResponse httpResponse = httpclient.execute((HttpUriRequest)httpRequest);
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                String responseBody = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
                this.logger.info("[\u8c03\u7528gp\u670d\u52a1\u8fd4\u56de\u7ed3\u679c:]" + responseBody);
                Map map = (Map)JSON.parseObject((String)responseBody, Map.class);
                List results = (List)map.get("results");
                List list = (List)((Map)results.get(0)).get("value");
                ArrayList features = new ArrayList();
                LinkedHashMap<String, Object> featureCollection = new LinkedHashMap<String, Object>();
                for (Map item : list) {
                    List polygons = (List)item.get("features");
                    for (Map polygon : polygons) {
                        LinkedHashMap<String, Object> feature = new LinkedHashMap<String, Object>();
                        LinkedHashMap<String, Object> geometry = new LinkedHashMap<String, Object>();
                        HashMap proMap = new HashMap();
                        geometry.put("type", "Polygon");
                        Map geo = MapUtils.getMap((Map)polygon, (Object)GEOMETRY);
                        List rings = (List)geo.get("rings");
                        geometry.put("coordinates", rings);
                        feature.put("type", "Feature");
                        feature.put(GEOMETRY, geometry);
                        if (!this.isNull((Object)propertyMap)) {
                            proMap.putAll(propertyMap);
                            feature.put("properties", proMap);
                        }
                        features.add(feature);
                    }
                    featureCollection.put("type", "FeatureCollection");
                    featureCollection.put("features", features);
                    this.logger.info(JSON.toJSONString(featureCollection));
                }
                return JSON.toJSONString(featureCollection);
            }
            this.logger.error("\u8c03\u7528gp\u670d\u52a1\u5f02\u5e38");
            return null;
        }
        catch (ClientProtocolException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e.getMessage());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

