/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.core.support.hibernate.UUIDHexGenerator;
import cn.gtmap.onemap.platform.Constant;
import cn.gtmap.onemap.platform.dao.SpatialDao;
import cn.gtmap.onemap.platform.dao.impl.ArcSDEDaoImpl;
import cn.gtmap.onemap.platform.dao.impl.OracleSpatialDaoImpl;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.FileStore;
import cn.gtmap.onemap.platform.entity.LayerRegion;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.entity.dict.Item;
import cn.gtmap.onemap.platform.event.GISDaoException;
import cn.gtmap.onemap.platform.event.GeometryServiceException;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.AgsGeoemtryService;
import cn.gtmap.onemap.platform.service.FileStoreService;
import cn.gtmap.onemap.platform.service.GISService;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.service.TemplateService;
import cn.gtmap.onemap.platform.service.WebMapService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.service.impl.GISServiceImpl;
import cn.gtmap.onemap.platform.support.spring.ApplicationContextHelper;
import cn.gtmap.onemap.platform.utils.AnalysisUtils;
import cn.gtmap.onemap.platform.utils.AppPropertyUtils;
import cn.gtmap.onemap.platform.utils.ArrayUtils;
import cn.gtmap.onemap.platform.utils.EnumUtils;
import cn.gtmap.onemap.platform.utils.HttpRequest;
import cn.gtmap.onemap.platform.utils.Utils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.esri.sde.sdk.client.SeLayer;
import com.gtis.config.AppConfig;
import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.map.AbstractHashedMap;
import org.apache.commons.collections.map.HashedMap;
import org.apache.commons.collections.map.MultiKeyMap;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.xfire.client.Client;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.Geometries;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
public class GISServiceImpl
extends BaseLogger
implements GISService {
    private final String SE_SHAPE_FIELD = "SHAPE";
    private final String SE_SHAPE_AREA = "SHAPE_AREA";
    private final String OG_PRO_PERFIX = "OG_PRO_";
    private final String SEARCH_LAYERS = "layers";
    private final String EXPORT_TYPE_GH = "gh";
    private final String EXPORT_TYPE_XZ = "xz";
    private final String ANALYSIS_FTL_DIR = "analysis/template/";
    private final String TPL_SUFFIX = ".ftl";
    private final String ANALSYIS_DEFAULT_TPL = "default.ftl";
    private static final String LAYER_MIDDLE_FIX_E = "_E_";
    private static final String LAYER_MIDDLE_FIX_H = "_H_";
    static final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
    private String DLMC = "DLMC";
    private String DLBM = "DLBM";
    private String[] GDDLBM = new String[]{"011", "012", "013"};
    private Map<String, String> GDMAP = new /* Unavailable Anonymous Inner Class!! */;
    private String[] KTZYDDLBM = new String[]{"021", "022", "023", "031", "033", "042", "114"};
    private Map<String, String> KTZMAP = new /* Unavailable Anonymous Inner Class!! */;
    private String KTZYDDLBZ = "K";
    private String[] JBNTBHTB = new String[]{this.DLMC, this.DLBM, "DLBZ"};
    private SpatialDao spatialDao;
    @Autowired
    private GeometryService geometryService;
    @Autowired
    private AgsGeoemtryService agsGeoemtryService;
    @Autowired
    private WebMapService webMapService;
    @Autowired
    private FileStoreService fileStoreService;
    @Autowired
    private TemplateService templateService;
    private Map searchConfig;
    private Map exportConfig;
    private Map analysisSet;
    private Map<String, ?> analysisFieldsMap;
    private Map<String, ?> analysisAliasMap;
    private String insertDateField;
    private String insertRegionField;
    private boolean createDateAuto = false;
    private boolean regionCodeAuto = false;

    public void setSearchConfig(Resource path) {
        try {
            this.searchConfig = (Map)JSON.parseObject((String)IOUtils.toString((URI)path.getURI(), (String)"utf-8"), Map.class);
        }
        catch (IOException e) {
            this.logger.error(" search config can't found ");
        }
    }

    public void setExportConfig(Resource path) {
        try {
            this.exportConfig = (Map)JSON.parseObject((String)IOUtils.toString((URI)path.getURI(), (String)"utf-8"), Map.class);
        }
        catch (IOException e) {
            this.logger.error(" export config can't found ");
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
    }

    public void setAnalysisSet(Resource path) {
        try {
            this.analysisSet = (Map)JSON.parseObject((String)IOUtils.toString((URI)path.getURI(), (String)"utf-8"), Map.class);
            if (this.analysisSet.containsKey("analysis-fields-mapping")) {
                this.analysisFieldsMap = (Map)this.analysisSet.get("analysis-fields-mapping");
            }
            if (this.analysisSet.containsKey("analysis-alias-mapping")) {
                this.analysisAliasMap = (Map)this.analysisSet.get("analysis-alias-mapping");
            }
        }
        catch (IOException e) {
            this.logger.error("gis analysis set not found!");
        }
    }

    public void initialize(Constant.SpatialType type) {
        switch (4.$SwitchMap$cn$gtmap$onemap$platform$Constant$SpatialType[type.ordinal()]) {
            case 1: {
                this.spatialDao = (SpatialDao)ApplicationContextHelper.createBean(ArcSDEDaoImpl.class);
                break;
            }
            case 2: {
                this.spatialDao = (SpatialDao)ApplicationContextHelper.createBean(OracleSpatialDaoImpl.class);
            }
        }
        this.insertDateField = this.isNull(AppPropertyUtils.getAppEnv((String)"insert.date.field")) ? null : String.valueOf(AppPropertyUtils.getAppEnv((String)"insert.date.field")).trim();
        this.createDateAuto = this.isNull(AppPropertyUtils.getAppEnv((String)"insert.create.date")) ? false : Boolean.valueOf(String.valueOf(AppPropertyUtils.getAppEnv((String)"insert.create.date")));
        this.insertRegionField = this.isNull(AppPropertyUtils.getAppEnv((String)"insert.region.field")) ? null : String.valueOf(AppPropertyUtils.getAppEnv((String)"insert.region.field")).trim();
        this.regionCodeAuto = this.isNull(AppPropertyUtils.getAppEnv((String)"insert.create.regioncode")) ? false : Boolean.valueOf(String.valueOf(AppPropertyUtils.getAppEnv((String)"insert.create.regioncode")));
    }

    public List<?> query(String layerName, String where, String[] columns, boolean returnGeometry, String dataSource) {
        Assert.notNull((Object)layerName, (String)this.getMessage("layer.name.notnull", new Object[0]));
        Assert.notNull((Object)where, (String)this.getMessage("query.where.notnull", new Object[0]));
        List result = null;
        try {
            result = this.spatialDao.query(layerName, where, columns, returnGeometry, dataSource);
        }
        catch (Exception e) {
            this.logger.info(this.getMessage("query.result.null", new Object[]{layerName}), (Object)e.getLocalizedMessage());
        }
        return result;
    }

    public List<?> query(String layerName, String wkt, String[] columns, String dataSource) {
        Assert.notNull((Object)layerName, (String)this.getMessage("layer.name.notnull", new Object[0]));
        Assert.notNull((Object)wkt, (String)this.getMessage("query.geometry.notnull", new Object[0]));
        return this.spatialDao.query(layerName, wkt, columns, dataSource);
    }

    public List<?> query(String layerName, Geometry geometry, String[] columns, String dataSource) {
        return this.query(layerName, geometry.toText(), columns, dataSource);
    }

    public List<?> query(String layerName, SimpleFeature feature, String[] columns, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        if (sourceCRS == null) {
            CoordinateReferenceSystem coordinateReferenceSystem = sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
        }
        if (sourceCRS != null && !sourceCRS.equals(layerCRS)) {
            geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
        }
        return this.query(layerName, geometry.toText(), columns, dataSource);
    }

    public List<?> intersect(String layerName, String wktPlygon, String[] returnFields, String dataSource) {
        Assert.notNull((Object)layerName, (String)this.getMessage("layer.name.notnull", new Object[0]));
        return this.spatialDao.intersect(layerName, wktPlygon, returnFields, dataSource);
    }

    public List<?> intersect(String layerName, Polygon polygon, String[] returnFields, String dataSource) {
        return this.intersect(layerName, polygon.toText(), returnFields, dataSource);
    }

    public List<?> intersect(String layerName, Geometry geometry, CoordinateReferenceSystem sourceCRS, String[] outFields, String dataSource) {
        Assert.notNull((Object)geometry, (String)this.getMessage("geometry.notnull", new Object[0]));
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        if (sourceCRS == null) {
            CoordinateReferenceSystem coordinateReferenceSystem = sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
        }
        if (sourceCRS != null) {
            geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
        }
        ArrayList result = new ArrayList();
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                try {
                    Geometry geo = geometry.getGeometryN(i);
                    result.addAll(this.intersect(layerName, geo.toText(), outFields, dataSource));
                    this.addGeoProperty2List(result, geo);
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getLocalizedMessage());
                }
            }
        } else {
            result.addAll(this.intersect(layerName, geometry.toText(), outFields, dataSource));
            this.addGeoProperty2List(result, geometry);
        }
        if (sourceCRS != null) {
            for (Map item : result) {
                Geometry geo = this.geometryService.readWKT((String)item.get("SHAPE"));
                item.put("SHAPE", this.geometryService.project(geo, layerCRS, sourceCRS).toText());
            }
        }
        return result;
    }

    public List<?> intersect(String layerName, Geometry geometry, String[] outFields, String dataSource) {
        ArrayList results = new ArrayList();
        CoordinateReferenceSystem sourceCRS = null;
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
        String regionField = null;
        if (layerCRS instanceof GeographicCRS) {
            LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
            if (!this.isNull((Object)layerRegion.getSourceLayerCRS())) {
                sourceCRS = layerRegion.getSourceLayerCRS();
            } else if (!this.isNull((Object)layerRegion.getRegionField())) {
                regionField = layerRegion.getRegionField();
                if (!this.checkFieldInLayer(regionField, layerName, dataSource)) {
                    throw new RuntimeException(this.getMessage("field.not.in.layer", new Object[]{regionField, layerName}));
                }
                if (!this.isNull((Object)outFields) && !ArrayUtils.contains((String[])outFields, (String)regionField, (boolean)true)) {
                    outFields = ArrayUtils.add2Arrays((String[])outFields, (String)regionField);
                }
            }
        }
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                try {
                    Geometry geo = geometry.getGeometryN(i);
                    List queryResults = this.query(layerName, geo, outFields, dataSource);
                    if (layerCRS instanceof GeographicCRS) {
                        if (this.isNull((Object)sourceCRS) && queryResults.size() > 0) {
                            sourceCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                        }
                        geo = this.geometryService.project(geo, layerCRS, this.isNull((Object)sourceCRS) ? layerCRS : sourceCRS);
                    }
                    HashMap<String, Object> result = null;
                    for (int j = 0; j < queryResults.size(); ++j) {
                        Map map = (Map)queryResults.get(j);
                        Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                        if (layerCRS instanceof GeographicCRS) {
                            geo1 = this.geometryService.project(geo1, layerCRS, sourceCRS);
                        }
                        Geometry geometryResult = null;
                        try {
                            if (this.isNull((Object)sourceCRS)) {
                                sourceCRS = layerCRS;
                            }
                            geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), geo.toText(), this.isNull((Object)sourceCRS) ? null : sourceCRS.toWKT()));
                        }
                        catch (Exception e) {
                            if (!geo.isValid() || !geo.isSimple()) {
                                this.logger.error(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                                geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(geo);
                            }
                            this.logger.error("intersection error:", (Object)e.getMessage());
                        }
                        if (geometryResult.isEmpty()) continue;
                        result = new HashMap<String, Object>();
                        result.putAll(map);
                        result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                        if (layerCRS instanceof GeographicCRS) {
                            try {
                                geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                            }
                            catch (GeometryServiceException e) {
                                geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                                geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                            }
                        }
                        result.put("SHAPE", geometryResult.toText());
                        results.add(result);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getLocalizedMessage());
                }
            }
        } else {
            List queryResults = this.query(layerName, geometry, outFields, dataSource);
            if (layerCRS instanceof GeographicCRS) {
                if (this.isNull((Object)sourceCRS) && queryResults.size() > 0) {
                    sourceCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                }
                geometry = this.geometryService.project(geometry, layerCRS, this.isNull((Object)sourceCRS) ? layerCRS : sourceCRS);
            }
            HashMap<String, Object> result = null;
            for (int j = 0; j < queryResults.size(); ++j) {
                Map map = (Map)queryResults.get(j);
                Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                if (layerCRS instanceof GeographicCRS) {
                    geo1 = this.geometryService.project(geo1, layerCRS, sourceCRS);
                }
                Geometry geometryResult = null;
                try {
                    if (this.isNull((Object)sourceCRS)) {
                        sourceCRS = layerCRS;
                    }
                    geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), geometry.toText(), sourceCRS.toWKT()));
                }
                catch (Exception e) {
                    if (!geometry.isValid() || !geometry.isSimple()) {
                        this.logger.error(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                        geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(geometry);
                    }
                    this.logger.error("intersection error", (Object)e.getMessage());
                }
                if (geometryResult.isEmpty()) continue;
                result = new HashMap<String, Object>();
                result.putAll(map);
                result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                if (layerCRS instanceof GeographicCRS) {
                    try {
                        geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                    }
                    catch (GeometryServiceException e) {
                        geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                        geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                    }
                }
                result.put("SHAPE", geometryResult.toText());
                results.add(result);
            }
        }
        return results;
    }

    public List<?> difference(String layerName, Geometry geometry, String[] outFields, String dataSource) {
        try {
            ArrayList results = new ArrayList();
            ArrayList<Geometry> diffGeos = new ArrayList<Geometry>();
            CoordinateReferenceSystem sourceCRS = null;
            CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
            sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
            String regionField = null;
            if (layerCRS instanceof GeographicCRS) {
                LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
                if (!this.isNull((Object)layerRegion.getSourceLayerCRS())) {
                    sourceCRS = layerRegion.getSourceLayerCRS();
                } else if (!this.isNull((Object)layerRegion.getRegionField())) {
                    regionField = layerRegion.getRegionField();
                    if (!this.checkFieldInLayer(regionField, layerName, dataSource)) {
                        throw new RuntimeException(this.getMessage("field.not.in.layer", new Object[]{regionField, layerName}));
                    }
                    if (!this.isNull((Object)outFields) && !ArrayUtils.contains((String[])outFields, (String)regionField, (boolean)true)) {
                        outFields = ArrayUtils.add2Arrays((String[])outFields, (String)regionField);
                    }
                }
            }
            if (geometry instanceof Geometry) {
                List queryResults = this.query(layerName, geometry, outFields, dataSource);
                if (layerCRS instanceof GeographicCRS) {
                    if (this.isNull((Object)sourceCRS) && queryResults.size() > 0) {
                        sourceCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                    }
                    geometry = this.geometryService.project(geometry, layerCRS, this.isNull((Object)sourceCRS) ? layerCRS : sourceCRS);
                }
                HashMap<String, Object> result = null;
                if (!this.isNull((Object)queryResults) && queryResults.size() > 0) {
                    for (int j = 0; j < queryResults.size(); ++j) {
                        Map map = (Map)queryResults.get(j);
                        Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                        if (layerCRS instanceof GeographicCRS) {
                            geo1 = this.geometryService.project(geo1, layerCRS, sourceCRS);
                        }
                        ArrayList<Geometry> others = new ArrayList<Geometry>();
                        if (this.isGeometryCollection(geo1)) {
                            others.addAll(this.decomposeGC((GeometryCollection)geo1));
                        } else {
                            others.add(geo1);
                        }
                        for (Geometry _geo : others) {
                            Geometry geometryResult = geometry.difference(_geo);
                            if (this.isNull((Object)geometryResult) || geometryResult.isEmpty()) continue;
                            diffGeos.add(geometryResult);
                            result = new HashMap<String, Object>();
                            result.putAll(map);
                            result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                            if (layerCRS instanceof GeographicCRS) {
                                try {
                                    geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                                }
                                catch (GeometryServiceException e) {
                                    geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                                    geometryResult = this.geometryService.project(geometryResult, sourceCRS, layerCRS);
                                }
                            }
                            result.put("SHAPE", geometryResult.toText());
                            result.put("OG_SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geo1.toText()));
                            results.add(result);
                        }
                    }
                } else {
                    diffGeos.add(geometry);
                }
                if (results.size() > 0) {
                    ArrayList<Geometry> _list = new ArrayList<Geometry>();
                    if (results.size() > 1) {
                        Geometry dGeo;
                        ArrayList<Geometry> filterList = new ArrayList<Geometry>();
                        for (Geometry g : diffGeos) {
                            if (this.isGeometryCollection(g)) continue;
                            filterList.add(g);
                        }
                        if (filterList.size() > 0 && (dGeo = this.getDuplicatedGeo(filterList, this.getLayerCRS(layerName, dataSource))).isEmpty()) {
                            results.clear();
                            return results;
                        }
                    }
                    for (Geometry _g : diffGeos) {
                        if (this.isGeometryCollection(_g)) {
                            _list.addAll(this.decomposeGC((GeometryCollection)_g));
                            continue;
                        }
                        _list.add(_g);
                    }
                    Geometry duplicatedGeo = this.getDuplicatedGeo(_list, this.getLayerCRS(layerName, dataSource));
                    if (!duplicatedGeo.isEmpty()) {
                        results.clear();
                        HashMap<String, Object> tmp = new HashMap<String, Object>();
                        tmp.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(duplicatedGeo.toText()));
                        tmp.put("SHAPE", duplicatedGeo.toText());
                        results.add(tmp);
                    }
                } else if (diffGeos.size() > 0) {
                    HashMap<String, Object> tmp = new HashMap<String, Object>();
                    tmp.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(((Geometry)diffGeos.get(0)).toText()));
                    tmp.put("SHAPE", ((Geometry)diffGeos.get(0)).toText());
                    results.add(tmp);
                }
            } else {
                throw new RuntimeException("only support geometry!");
            }
            return results;
        }
        catch (RuntimeException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    public List<?> intersectByGeoJSON(String layerName, String geoJson, String[] outField, String dataSource) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJson);
        CoordinateReferenceSystem sourceCRS = null;
        List results = null;
        if (geo instanceof Geometry) {
            Geometry geometry = (Geometry)geo;
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            sourceCRS = geometry.getSRID() != 0 ? this.geometryService.getCRSBySRID(String.valueOf(geometry.getSRID())) : null;
            results = this.intersect(layerName, geometry, sourceCRS, outField, dataSource);
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            results = this.addFeaturePros2List(this.intersectBySimpleFeature(layerName, feature, outField, dataSource), feature);
        } else if (geo instanceof FeatureCollection) {
            FeatureCollection collection = (FeatureCollection)geo;
            results = new ArrayList();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                results.addAll(this.addFeaturePros2List(this.intersectBySimpleFeature(layerName, feature, outField, dataSource), feature));
            }
        }
        return results;
    }

    public List<?> intersect4(String layerName, String geoJson, String[] outField, String dataSource) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJson);
        CoordinateReferenceSystem sourceCrs = null;
        CoordinateReferenceSystem layerCrs = this.spatialDao.getLayerCRS(layerName, dataSource);
        List results = null;
        if (geo instanceof Geometry) {
            Geometry geometry = (Geometry)geo;
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            results = this.bufferIntersect(layerName, geometry, layerCrs, outField, dataSource);
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem();
            this.setFeaturePros2Geo(feature, geometry);
            results = this.addFeaturePros2List(this.bufferIntersect(layerName, geometry, sourceCrs, outField, dataSource), feature);
        } else if (geo instanceof FeatureCollection) {
            results = new ArrayList();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (!geometry.isValid()) {
                    geometry = this.createValidGeometry(geometry);
                }
                sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem();
                this.setFeaturePros2Geo(feature, geometry);
                results.addAll(this.addFeaturePros2List(this.bufferIntersect(layerName, geometry, sourceCrs, outField, dataSource), feature));
            }
        }
        return results;
    }

    public List<?> bufferIntersect(String layerName, Geometry sourceGeometry, CoordinateReferenceSystem sourceCRS, String[] outFields, String dataSource) {
        ArrayList results = new ArrayList();
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        String regionField = null;
        if (layerCRS instanceof GeographicCRS) {
            LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
            if (!this.isNull((Object)layerRegion.getSourceLayerCRS())) {
                sourceCRS = layerRegion.getSourceLayerCRS();
            } else if (!this.isNull((Object)layerRegion.getRegionField())) {
                regionField = layerRegion.getRegionField();
                if (!this.checkFieldInLayer(regionField, layerName, dataSource)) {
                    throw new RuntimeException(this.getMessage("field.not.in.layer", new Object[]{regionField, layerName}));
                }
                if (!this.isNull((Object)outFields) && !ArrayUtils.contains((String[])outFields, (String)regionField, (boolean)true)) {
                    outFields = ArrayUtils.add2Arrays((String[])outFields, (String)regionField);
                }
            }
        }
        if (sourceGeometry instanceof GeometryCollection) {
            for (int i = 0; i < sourceGeometry.getNumGeometries(); ++i) {
                try {
                    Geometry beforeGeo = sourceGeometry.getGeometryN(i);
                    Geometry afterGeometry = null;
                    afterGeometry = !this.isNull((Object)layerCRS) ? this.geometryService.project(beforeGeo, sourceCRS, layerCRS) : beforeGeo;
                    Geometry tmpGeo = afterGeometry.buffer(0.002);
                    List queryResults = this.query(layerName, tmpGeo, outFields, dataSource);
                    CoordinateReferenceSystem tmpProjectedCRS = null;
                    if (sourceCRS instanceof GeographicCRS && layerCRS instanceof GeographicCRS) {
                        if (queryResults.size() > 0) {
                            tmpProjectedCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                        }
                        beforeGeo = this.geometryService.project(beforeGeo, layerCRS, this.isNull(tmpProjectedCRS) ? layerCRS : tmpProjectedCRS);
                    }
                    HashMap<String, Object> result = null;
                    for (int j = 0; j < queryResults.size(); ++j) {
                        Map map = (Map)queryResults.get(j);
                        Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                        if (layerCRS instanceof GeographicCRS) {
                            geo1 = this.geometryService.project(geo1, layerCRS, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS);
                        }
                        Geometry geometryResult = null;
                        try {
                            geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), beforeGeo.toText(), sourceCRS.toWKT()));
                        }
                        catch (Exception e) {
                            this.logger.error(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                            geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(beforeGeo);
                        }
                        if (geometryResult.isEmpty()) continue;
                        result = new HashMap<String, Object>();
                        result.putAll(map);
                        result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                        if (layerCRS instanceof GeographicCRS) {
                            try {
                                geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                            }
                            catch (GeometryServiceException e) {
                                geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                                geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                            }
                        }
                        result.put("SHAPE", geometryResult.toText());
                        result.put("OG_SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geo1.toText()));
                        results.add(result);
                    }
                    continue;
                }
                catch (Exception e) {
                    this.logger.error(e.getLocalizedMessage());
                }
            }
        } else {
            Geometry afterGeometry = null;
            afterGeometry = !this.isNull((Object)layerCRS) ? this.geometryService.project(sourceGeometry, sourceCRS, layerCRS) : sourceGeometry;
            Geometry tmpGeo = afterGeometry.buffer(0.002);
            List queryResults = this.query(layerName, tmpGeo, outFields, dataSource);
            CoordinateReferenceSystem tmpProjectedCRS = null;
            if (sourceCRS instanceof GeographicCRS && layerCRS instanceof GeographicCRS) {
                if (queryResults.size() > 0) {
                    tmpProjectedCRS = this.geometryService.getCRSByRegionCode(String.valueOf(((Map)queryResults.get(0)).get(regionField)));
                }
                sourceGeometry = this.geometryService.project(sourceGeometry, layerCRS, this.isNull(tmpProjectedCRS) ? layerCRS : tmpProjectedCRS);
            }
            HashMap<String, Object> result = null;
            for (int j = 0; j < queryResults.size(); ++j) {
                Map map = (Map)queryResults.get(j);
                Geometry geo1 = this.geometryService.readWKT(map.get("SHAPE").toString());
                if (layerCRS instanceof GeographicCRS) {
                    geo1 = this.geometryService.project(geo1, layerCRS, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS);
                }
                Geometry geometryResult = null;
                try {
                    geometryResult = this.geometryService.readWKT(this.agsGeoemtryService.intersection(geo1.toText(), sourceGeometry.toText(), sourceCRS.toWKT()));
                }
                catch (Exception e) {
                    this.logger.error(" geometry is invalid,[{}]", (Object)e.getLocalizedMessage());
                    geometryResult = this.geometryService.forceSimplify(geo1, this.geometryService.getSimplifyTolerance()).intersection(sourceGeometry);
                }
                if (geometryResult.isEmpty()) continue;
                result = new HashMap<String, Object>();
                result.putAll(map);
                result.put("SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geometryResult.toText()));
                if (layerCRS instanceof GeographicCRS) {
                    try {
                        geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                    }
                    catch (GeometryServiceException e) {
                        geometryResult = this.geometryService.simplify(geometryResult, this.geometryService.getSimplifyTolerance());
                        geometryResult = this.geometryService.project(geometryResult, this.isNull((Object)tmpProjectedCRS) ? sourceCRS : tmpProjectedCRS, layerCRS);
                    }
                }
                result.put("SHAPE", geometryResult.toText());
                result.put("OG_SHAPE_AREA", this.agsGeoemtryService.getGeometryArea(geo1.toText()));
                results.add(result);
            }
        }
        return results;
    }

    private List<?> intersectBySimpleFeature(String layerName, SimpleFeature feature, String[] outField, String dataSource) {
        CoordinateReferenceSystem sourceCRS = null;
        Geometry geometry = (Geometry)feature.getDefaultGeometry();
        if (!geometry.isValid()) {
            geometry = this.createValidGeometry(geometry);
        }
        this.setFeaturePros2Geo(feature, geometry);
        try {
            sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
            return this.intersect(layerName, geometry, sourceCRS, outField, dataSource);
        }
        catch (Exception e) {
            this.logger.error("intersect analysis - feature json crs not define [{}]", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public List<?> intersect2(String layerName, String geoJson, String[] outField, String dataSource) {
        List results = this.intersectByGeoJSON(layerName, geoJson, outField, dataSource);
        return results;
    }

    public List<?> intersect3(String layerName, String geoJson, String[] outField, String dataSource) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJson);
        CoordinateReferenceSystem sourceCrs = null;
        CoordinateReferenceSystem layerCrs = this.spatialDao.getLayerCRS(layerName, dataSource);
        List results = null;
        if (geo instanceof Geometry) {
            Geometry geometry = (Geometry)geo;
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            results = this.intersect(layerName, geometry, outField, dataSource);
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (!geometry.isValid() && !this.isNull((Object)this.geometryService.validGeometry(geometry))) {
                geometry = this.createValidGeometry(geometry);
            }
            if (!(this.isNull((Object)(sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem())) || this.isNull((Object)layerCrs) || sourceCrs.equals(layerCrs))) {
                geometry = this.geometryService.project(geometry, sourceCrs, layerCrs);
            }
            this.setFeaturePros2Geo(feature, geometry);
            results = this.addFeaturePros2List(this.intersect(layerName, geometry, outField, dataSource), feature);
        } else if (geo instanceof FeatureCollection) {
            results = new ArrayList();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (!geometry.isValid() && !this.isNull((Object)this.geometryService.validGeometry(geometry))) {
                    geometry = this.createValidGeometry(geometry);
                }
                if (!(this.isNull((Object)(sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem())) || this.isNull((Object)layerCrs) || sourceCrs.equals(layerCrs))) {
                    geometry = this.geometryService.project(geometry, sourceCrs, layerCrs);
                }
                this.setFeaturePros2Geo(feature, geometry);
                results.addAll(this.addFeaturePros2List(this.intersect(layerName, geometry, outField, dataSource), feature));
            }
        }
        return results;
    }

    public List<?> differenceByGeoJson(String layerName, String geoJson, String[] outFields, String dataSource) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJson);
        CoordinateReferenceSystem sourceCrs = null;
        CoordinateReferenceSystem layerCrs = this.spatialDao.getLayerCRS(layerName, dataSource);
        List results = null;
        if (geo instanceof Geometry) {
            Geometry geometry = (Geometry)geo;
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            results = this.difference(layerName, geometry, outFields, dataSource);
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (!geometry.isValid()) {
                geometry = this.createValidGeometry(geometry);
            }
            if (!(this.isNull((Object)(sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem())) || this.isNull((Object)layerCrs) || sourceCrs.equals(layerCrs))) {
                geometry = this.geometryService.project(geometry, sourceCrs, layerCrs);
            }
            this.setFeaturePros2Geo(feature, geometry);
            results = this.addFeaturePros2List(this.difference(layerName, geometry, outFields, dataSource), feature);
        } else if (geo instanceof FeatureCollection) {
            results = new ArrayList();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (!geometry.isValid()) {
                    geometry = this.createValidGeometry(geometry);
                }
                if (!(this.isNull((Object)(sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem())) || this.isNull((Object)layerCrs) || sourceCrs.equals(layerCrs))) {
                    geometry = this.geometryService.project(geometry, sourceCrs, layerCrs);
                }
                this.setFeaturePros2Geo(feature, geometry);
                results.addAll(this.addFeaturePros2List(this.difference(layerName, geometry, outFields, dataSource), feature));
            }
        }
        return results;
    }

    public Geometry createValidGeometry(Geometry geometry) {
        try {
            if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                GeometryFactory factory = geometry.getFactory();
                ArrayList<Polygon> polygons = new ArrayList<Polygon>();
                Polygon exteriorPolygon = new Polygon((LinearRing)polygon.getExteriorRing(), null, factory);
                polygons.add(exteriorPolygon);
                for (int i = 0; i < polygon.getNumInteriorRing(); ++i) {
                    LinearRing interiorRing = (LinearRing)polygon.getInteriorRingN(i);
                    Polygon interiorPolygon = new Polygon(interiorRing, null, factory);
                    polygons.add(interiorPolygon);
                }
                ArrayList<Polygon> newPolygons = new ArrayList<Polygon>();
                ArrayList excludePolygons = new ArrayList();
                for (Polygon temp : polygons) {
                    if (excludePolygons.contains(temp = this.getPolygonWithHoles(polygons, excludePolygons, temp))) continue;
                    newPolygons.add(temp);
                }
                return new MultiPolygon(newPolygons.toArray(new Polygon[0]), factory);
            }
            if (geometry instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                ArrayList<Polygon> polygonList = new ArrayList<Polygon>();
                for (int j = 0; j < multiPolygon.getNumGeometries(); ++j) {
                    Polygon polygon = (Polygon)multiPolygon.getGeometryN(j);
                    if (!polygon.isValid()) {
                        MultiPolygon tempMultiPolygon = (MultiPolygon)this.createValidGeometry((Geometry)polygon);
                        for (int k = 0; k < tempMultiPolygon.getNumGeometries(); ++k) {
                            polygonList.add((Polygon)tempMultiPolygon.getGeometryN(k));
                        }
                        continue;
                    }
                    polygonList.add(polygon);
                }
                return new MultiPolygon(polygonList.toArray(new Polygon[0]), multiPolygon.getFactory());
            }
            this.logger.info("geometryType has not been supported yet");
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return null;
    }

    private Polygon getPolygonWithHoles(List<Polygon> srcPolygons, List<Polygon> excludePolygons, Polygon polygon) {
        ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
        for (Polygon item : srcPolygons) {
            if (polygon.equals((Geometry)item) || excludePolygons.contains(polygon) || !polygon.contains((Geometry)item)) continue;
            holes.add((LinearRing)item.getExteriorRing());
            excludePolygons.add(item);
        }
        if (holes.size() > 0) {
            return new Polygon((LinearRing)polygon.getExteriorRing(), holes.toArray(new LinearRing[0]), polygon.getFactory());
        }
        return polygon;
    }

    private List addFeaturePros2List(List<Map> value, SimpleFeature feature) {
        for (Map item : value) {
            for (Property p : feature.getProperties()) {
                if (p.getName().getLocalPart().equals("geometry") || p.getName().getLocalPart().equals("crs")) continue;
                item.put("OG_PRO_".concat(p.getName().getLocalPart()), p.getValue());
            }
        }
        return value;
    }

    public int insertRows(String layerName, List<Map<String, Object>> rows, String dataSource) {
        LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
        ArrayList<Map<String, Object>> regionRows = new ArrayList<Map<String, Object>>();
        int result = 0;
        if (!this.isNull((Object)layerRegion.getRegionField())) {
            int valid = 0;
            for (Map<String, Object> columns : rows) {
                boolean contains = false;
                for (Map.Entry<String, Object> entry : columns.entrySet()) {
                    if (!layerRegion.getRegionField().equalsIgnoreCase(entry.getKey())) continue;
                    contains = true;
                    if (this.geometryService.containsRegionValue(String.valueOf(entry.getValue()))) {
                        regionRows.add(columns);
                        break;
                    }
                    this.logger.warn(this.getMessage("insert.region.value.not.exist", new Object[]{layerName, layerRegion.getRegionField(), String.valueOf(entry.getValue())}));
                    ++valid;
                    break;
                }
                if (contains) continue;
                throw new RuntimeException(this.getMessage("insert.region.field.not.null", new Object[]{layerName, layerRegion.getRegionField()}));
            }
            if (regionRows.size() > 0) {
                this.logger.info("\u8df3\u8fc7" + valid + "\u6761\u975e\u6cd5\u6570\u636e\uff0c\u5b9e\u9645\u51c6\u5907\u63d2\u5165" + regionRows.size() + "\u6761\u6570\u636e\uff01");
                result = this.spatialDao.insertRows(layerName, regionRows, dataSource);
                this.logger.info("\u63d2\u5165" + result + "\u6761\u6570\u636e\uff01");
            } else {
                this.logger.warn("\u8df3\u8fc7" + valid + "\u6761\u975e\u6cd5\u6570\u636e\uff0c\u5b9e\u9645\u51c6\u5907\u63d2\u5165" + regionRows.size() + "\u6761\u6570\u636e\uff01");
            }
        }
        return result;
    }

    public String insert(String layerName, Map<String, Object> columns, String dataSource) {
        LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
        if (!this.isNull((Object)layerRegion.getRegionField())) {
            boolean contains = false;
            for (Map.Entry<String, Object> entry : columns.entrySet()) {
                if (!layerRegion.getRegionField().equalsIgnoreCase(entry.getKey())) continue;
                if (this.geometryService.containsRegionValue(String.valueOf(entry.getValue()))) {
                    contains = true;
                    break;
                }
                throw new RuntimeException(this.getMessage("insert.region.value.not.exist", new Object[]{layerName, layerRegion.getRegionField(), String.valueOf(entry.getValue())}));
            }
            if (!contains) {
                throw new RuntimeException(this.getMessage("insert.region.field.not.null", new Object[]{layerName, layerRegion.getRegionField()}));
            }
        }
        return this.spatialDao.insert(layerName, columns, dataSource);
    }

    public String insert(String layerName, String geoJSON, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
        try {
            if (geo instanceof FeatureCollection) {
                Map columns = null;
                SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureIterator.next();
                    CoordinateReferenceSystem sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                    columns = this.geometryService.simpleFeature2Map(feature);
                    for (Map.Entry entry : columns.entrySet()) {
                        if (!(entry.getValue() instanceof Geometry)) continue;
                        Geometry geometry = (Geometry)entry.getValue();
                        if (layerCRS != null && sourceCRS != null) {
                            geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                        }
                        columns.put("SHAPE", geometry.toText());
                        columns.remove(entry.getKey());
                    }
                    if (featureIterator.hasNext()) {
                        this.insert(layerName, columns, dataSource);
                        continue;
                    }
                    return this.insert(layerName, columns, dataSource);
                }
            }
        }
        catch (Exception e) {
            this.logger.info(this.getMessage("insert.sde.false", new Object[0]), (Object)e.getLocalizedMessage());
        }
        return this.insert(layerName, this.geoJSON2Map(geoJSON, layerCRS), dataSource);
    }

    public String insert2(String layerName, String geoJSON, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
        if (geo instanceof FeatureCollection) {
            LinkedHashMap<String, Object> resultFc = new LinkedHashMap<String, Object>();
            resultFc.put("type", "FeatureCollection");
            ArrayList<LinkedHashMap> resultFeatures = new ArrayList<LinkedHashMap>();
            Map columns = null;
            SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
            SimpleFeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
                LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                JSONObject properties = (JSONObject)featureMap.get("properties");
                if (this.isNull((Object)sourceCRS)) {
                    sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                }
                columns = this.geometryService.simpleFeature2Map(feature);
                for (String key : columns.keySet()) {
                    if (!(columns.get(key) instanceof Geometry)) continue;
                    Geometry geometry = (Geometry)columns.get(key);
                    if (layerCRS != null && sourceCRS != null) {
                        geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                    }
                    columns.put("SHAPE", geometry.toText());
                    columns.remove(key);
                    break;
                }
                if (this.createDateAuto) {
                    if (this.isNull((Object)this.insertDateField)) {
                        this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                        throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                    }
                    columns.put(this.insertDateField, new Date());
                    properties.put(this.insertDateField, (Object)sdf.format(new Date()));
                }
                if (this.regionCodeAuto) {
                    if (this.isNull((Object)this.insertRegionField)) {
                        throw new RuntimeException(this.getMessage("insert.region.field.null", new Object[0]));
                    }
                    String regionValue = this.findXzqdm(feature, String.valueOf(AppPropertyUtils.getAppEnv((String)"insert.region.layer")));
                    if (!this.isNull((Object)regionValue)) {
                        List<String> rFields = Arrays.asList(this.insertRegionField.split(","));
                        for (String f : rFields) {
                            columns.put(f, regionValue);
                            properties.put(f, (Object)regionValue);
                        }
                    }
                }
                String objectId = this.insert(layerName, columns, dataSource);
                properties.put("OBJECTID", (Object)objectId);
                resultFeatures.add(featureMap);
            }
            resultFc.put("features", resultFeatures);
            return JSON.toJSONString(resultFc);
        }
        if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
            JSONObject properties = (JSONObject)featureMap.get("properties");
            Map columns = this.geoJSON2Map(geoJSON, layerCRS);
            if (this.createDateAuto) {
                if (this.isNull((Object)this.insertDateField)) {
                    this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                    throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                }
                columns.put(this.insertDateField, new Date());
                properties.put(this.insertDateField, (Object)sdf.format(new Date()));
            }
            if (this.regionCodeAuto) {
                if (this.isNull((Object)this.insertRegionField)) {
                    throw new RuntimeException(this.getMessage("insert.region.field.null", new Object[0]));
                }
                String regionValue = this.findXzqdm(feature, String.valueOf(AppPropertyUtils.getAppEnv((String)"insert.region.layer")));
                if (!this.isNull((Object)regionValue)) {
                    List<String> rFields = Arrays.asList(this.insertRegionField.split(","));
                    for (String f : rFields) {
                        columns.put(f, regionValue);
                        properties.put(f, (Object)regionValue);
                    }
                }
            }
            String objectId = this.insert(layerName, columns, dataSource);
            properties.put("OBJECTID", (Object)objectId);
            return JSON.toJSONString((Object)featureMap);
        }
        return null;
    }

    public String insert2(String layerName, String geoJSON, boolean check, String dataSource) {
        if (check) {
            CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
            Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
            if (geo instanceof FeatureCollection) {
                LinkedHashMap<String, Object> resultFc = new LinkedHashMap<String, Object>();
                resultFc.put("type", "FeatureCollection");
                ArrayList<LinkedHashMap> resultFeatures = new ArrayList<LinkedHashMap>();
                Map columns = null;
                SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureIterator.next();
                    List list = this.query(layerName, feature, null, dataSource);
                    if (list.size() > 0) {
                        this.logger.error(this.getMessage("insert.check.fail", new Object[]{this.geometryService.toFeatureJSON((Object)feature)}));
                        if (featureIterator.hasNext()) continue;
                        throw new GISDaoException(GISDaoException.Method.INSERT, this.getMessage("insert.check.fail", new Object[]{this.geometryService.toFeatureJSON((Object)feature)}), GISDaoException.Type.ARC_SDE);
                    }
                    this.logger.debug("[insert-- start getting sourceCRS...]");
                    CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
                    LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                    JSONObject properties = (JSONObject)featureMap.get("properties");
                    if (this.isNull((Object)sourceCRS)) {
                        sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                    }
                    if (this.isNull((Object)sourceCRS)) {
                        this.logger.debug("[insert sourceCRS:]null");
                    } else {
                        this.logger.debug("[insert sourceCRS:]" + sourceCRS.toWKT());
                    }
                    columns = this.geometryService.simpleFeature2Map(feature);
                    try {
                        for (String key : columns.keySet()) {
                            if (!(columns.get(key) instanceof Geometry)) continue;
                            Geometry geometry = (Geometry)columns.get(key);
                            if (layerCRS != null && sourceCRS != null) {
                                geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                            }
                            columns.put("SHAPE", geometry.toText());
                            columns.remove(key);
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(e.getLocalizedMessage());
                        throw new RuntimeException(e.getLocalizedMessage());
                    }
                    if (this.createDateAuto) {
                        if (this.isNull((Object)this.insertDateField)) {
                            this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                            throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                        }
                        columns.put(this.insertDateField, new Date());
                        properties.put(this.insertDateField, (Object)sdf.format(new Date()));
                    }
                    if (this.regionCodeAuto) {
                        if (this.isNull((Object)this.insertRegionField)) {
                            throw new RuntimeException(this.getMessage("insert.region.field.null", new Object[0]));
                        }
                        String regionValue = this.findXzqdm(feature, String.valueOf(AppPropertyUtils.getAppEnv((String)"insert.region.layer")));
                        if (this.isNotNull((Object)regionValue)) {
                            List<String> rFields = Arrays.asList(this.insertRegionField.split(","));
                            for (String f : rFields) {
                                columns.put(f, regionValue);
                                properties.put(f, (Object)regionValue);
                            }
                        } else {
                            this.logger.error(this.getMessage("insert.region.value.null", new Object[0]));
                            throw new RuntimeException(this.getMessage("insert.region.value.null", new Object[0]));
                        }
                    }
                    String objectId = this.insert(layerName, columns, dataSource);
                    properties.put("OBJECTID", (Object)objectId);
                    resultFeatures.add(featureMap);
                }
                resultFc.put("features", resultFeatures);
                return JSON.toJSONString(resultFc);
            }
            if (geo instanceof SimpleFeature) {
                SimpleFeature feature = (SimpleFeature)geo;
                List list = this.query(layerName, feature, null, dataSource);
                if (list.size() > 0) {
                    this.logger.error("insert.check.fail", (Object)geoJSON);
                    throw new GISDaoException(GISDaoException.Method.INSERT, this.getMessage("insert.check.fail", new Object[]{geoJSON}), GISDaoException.Type.ARC_SDE);
                }
                LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                JSONObject properties = (JSONObject)featureMap.get("properties");
                Map columns = this.geoJSON2Map(geoJSON, layerCRS);
                if (this.createDateAuto) {
                    if (this.isNull((Object)this.insertDateField)) {
                        this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                        throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                    }
                    columns.put(this.insertDateField, new Date());
                    properties.put(this.insertDateField, (Object)sdf.format(new Date()));
                }
                if (this.regionCodeAuto) {
                    if (this.isNull((Object)this.insertRegionField)) {
                        throw new RuntimeException(this.getMessage("insert.region.field.null", new Object[0]));
                    }
                    String regionValue = this.findXzqdm(feature, String.valueOf(AppPropertyUtils.getAppEnv((String)"insert.region.layer")));
                    if (!this.isNull((Object)regionValue)) {
                        List<String> rFields = Arrays.asList(this.insertRegionField.split(","));
                        for (String f : rFields) {
                            columns.put(f, regionValue);
                            properties.put(f, (Object)regionValue);
                        }
                    } else {
                        this.logger.error(this.getMessage("insert.region.value.null", new Object[0]));
                        throw new RuntimeException(this.getMessage("insert.region.value.null", new Object[0]));
                    }
                }
                String objectId = this.insert(layerName, columns, dataSource);
                properties.put("OBJECTID", (Object)objectId);
                return JSON.toJSONString((Object)featureMap);
            }
        } else {
            return this.insert2(layerName, geoJSON, dataSource);
        }
        return null;
    }

    @Deprecated
    public String insert3(String layerName, String geoJSON, boolean createAt, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
        if (geo instanceof FeatureCollection) {
            LinkedHashMap<String, Object> resultFc = new LinkedHashMap<String, Object>();
            resultFc.put("type", "FeatureCollection");
            ArrayList<LinkedHashMap> resultFeatures = new ArrayList<LinkedHashMap>();
            Map columns = null;
            SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
            SimpleFeatureIterator featureIterator = featureCollection.features();
            while (featureIterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)featureIterator.next();
                CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
                if (this.isNull((Object)sourceCRS)) {
                    sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                }
                columns = this.geometryService.simpleFeature2Map(feature);
                for (String key : columns.keySet()) {
                    if (!(columns.get(key) instanceof Geometry)) continue;
                    Geometry geometry = (Geometry)columns.get(key);
                    if (layerCRS != null && sourceCRS != null) {
                        geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                    }
                    columns.put("SHAPE", geometry.toText());
                    columns.remove(key);
                    break;
                }
                if (createAt) {
                    if (this.isNull((Object)this.insertDateField)) {
                        this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                        throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                    }
                    columns.put(this.insertDateField, new Date());
                }
                String objectId = this.insert(layerName, columns, dataSource);
                LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                JSONObject properties = (JSONObject)featureMap.get("properties");
                properties.put("OBJECTID", (Object)objectId);
                resultFeatures.add(featureMap);
            }
            resultFc.put("features", resultFeatures);
            return JSON.toJSONString(resultFc);
        }
        if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
            JSONObject properties = (JSONObject)featureMap.get("properties");
            Map columns = this.geoJSON2Map(geoJSON, layerCRS);
            if (createAt) {
                if (this.isNull((Object)this.insertDateField)) {
                    this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                    throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                }
                columns.put(this.insertDateField, new Date());
            }
            String objectId = this.insert(layerName, columns, dataSource);
            properties.put("OBJECTID", (Object)objectId);
            return JSON.toJSONString((Object)featureMap);
        }
        return null;
    }

    public String insert3(String layerName, String geoJSON, boolean check, boolean createAt, String dataSource) {
        if (this.isNull((Object)check)) {
            check = false;
        }
        if (this.isNull((Object)createAt)) {
            createAt = false;
        }
        if (check) {
            CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
            Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
            if (geo instanceof FeatureCollection) {
                LinkedHashMap<String, Object> resultFc = new LinkedHashMap<String, Object>();
                resultFc.put("type", "FeatureCollection");
                ArrayList<LinkedHashMap> resultFeatures = new ArrayList<LinkedHashMap>();
                Map columns = null;
                SimpleFeatureCollection featureCollection = (SimpleFeatureCollection)geo;
                SimpleFeatureIterator featureIterator = featureCollection.features();
                while (featureIterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)featureIterator.next();
                    List list = this.query(layerName, feature, null, dataSource);
                    if (list.size() > 0) {
                        this.logger.error(this.getMessage("insert.check.fail", new Object[]{this.geometryService.toFeatureJSON((Object)feature)}));
                        if (featureIterator.hasNext()) continue;
                        throw new GISDaoException(GISDaoException.Method.INSERT, this.getMessage("insert.check.fail", new Object[]{this.geometryService.toFeatureJSON((Object)feature)}), GISDaoException.Type.ARC_SDE);
                    }
                    CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
                    if (this.isNull((Object)sourceCRS)) {
                        sourceCRS = this.geometryService.readFeatureJSONCRS(this.geometryService.toFeatureJSON((Object)feature));
                    }
                    if (this.isNull((Object)sourceCRS)) {
                        this.logger.debug("[insert sourceCRS:]null");
                    }
                    columns = this.geometryService.simpleFeature2Map(feature);
                    try {
                        for (String key : columns.keySet()) {
                            if (!(columns.get(key) instanceof Geometry)) continue;
                            Geometry geometry = (Geometry)columns.get(key);
                            if (layerCRS != null && sourceCRS != null) {
                                geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
                            }
                            columns.put("SHAPE", geometry.toText());
                            columns.remove(key);
                            break;
                        }
                    }
                    catch (Exception e) {
                        this.logger.error(this.getMessage("insert.shape.error", new Object[]{e.getLocalizedMessage()}));
                        throw new RuntimeException(e.getLocalizedMessage());
                    }
                    if (createAt) {
                        if (this.isNull((Object)this.insertDateField)) {
                            this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                            throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                        }
                        columns.put(this.insertDateField, new Date());
                    }
                    String objectId = this.insert(layerName, columns, dataSource);
                    LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                    JSONObject properties = (JSONObject)featureMap.get("properties");
                    properties.put("OBJECTID", (Object)objectId);
                    resultFeatures.add(featureMap);
                }
                resultFc.put("features", resultFeatures);
                return JSON.toJSONString(resultFc);
            }
            if (geo instanceof SimpleFeature) {
                SimpleFeature feature = (SimpleFeature)geo;
                List list = this.query(layerName, feature, null, dataSource);
                if (list.size() > 0) {
                    this.logger.error("insert.check.fail", (Object)geoJSON);
                    throw new GISDaoException(GISDaoException.Method.INSERT, this.getMessage("insert.check.fail", new Object[]{geoJSON}), GISDaoException.Type.ARC_SDE);
                }
                LinkedHashMap featureMap = (LinkedHashMap)JSON.parseObject((String)this.geometryService.toFeatureJSON((Object)feature), LinkedHashMap.class);
                JSONObject properties = (JSONObject)featureMap.get("properties");
                Map columns = this.geoJSON2Map(geoJSON, layerCRS);
                if (createAt) {
                    if (this.isNull((Object)this.insertDateField)) {
                        this.logger.error(this.getMessage("insert.createAt.field.null", new Object[0]));
                        throw new RuntimeException(this.getMessage("insert.createAt.field.null", new Object[0]));
                    }
                    columns.put(this.insertDateField, new Date());
                }
                String objectId = this.insert(layerName, columns, dataSource);
                properties.put("OBJECTID", (Object)objectId);
                return JSON.toJSONString((Object)featureMap);
            }
        } else {
            return this.insert3(layerName, geoJSON, createAt, dataSource);
        }
        return null;
    }

    public boolean update(String layerName, String primaryKey, Map<String, Object> columns, String dataSource) {
        return this.spatialDao.update(layerName, primaryKey, columns, dataSource);
    }

    public boolean update(String layerName, String primaryKey, String geoJSON, String dataSource) {
        CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
        return this.update(layerName, primaryKey, this.geoJSON2Map(geoJSON, layerCRS), dataSource);
    }

    public boolean delete(String layerName, String primaryKey, String dataSource) {
        return this.spatialDao.delete(layerName, primaryKey, dataSource);
    }

    public List<Map> djAnalysis(String geometry, List analysisLayers, String dataSource, Map unit) {
        if (this.isNull((Object)analysisLayers)) {
            throw new RuntimeException("no analysis Layers");
        }
        if (this.isNull((Object)geometry)) {
            throw new JSONMessageException("geometry is null");
        }
        if (this.isNull((Object)unit)) {
            throw new JSONMessageException("unit is null");
        }
        List results = null;
        Object geo = this.geometryService.readUnTypeGeoJSON(geometry);
        if (geo instanceof FeatureCollection) {
            results = new ArrayList<Map>();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Map map = this.singleDjAnalysis(feature, analysisLayers, dataSource);
                map.put("title", feature.getAttribute("title"));
                results.add(map);
            }
        } else if (geo instanceof SimpleFeature) {
            results = new ArrayList();
            results.add(this.singleDjAnalysis((SimpleFeature)geo, analysisLayers, dataSource));
        }
        if (results != null) {
            results = this.mergeResults(results, unit);
        }
        return results;
    }

    public List<Map> mergeResults(List results, Map unit) {
        HashMap<String, Object> rMap = new HashMap<String, Object>();
        double conv = UNITS.access$000((UNITS)UNITS.ACRES);
        DecimalFormat df_dj = new DecimalFormat("0.0000");
        if (!this.isNull((Object)unit)) {
            df_dj.applyPattern(MapUtils.getString((Map)unit, (Object)"format", (String)"0.0"));
            String ualias = MapUtils.getString((Map)unit, (Object)"alias");
            for (UNITS us : UNITS.values()) {
                if (!UNITS.access$100((UNITS)us).equals(ualias)) continue;
                conv = UNITS.access$000((UNITS)us);
                break;
            }
        }
        for (int i = 0; i < results.size(); ++i) {
            Map map = (Map)results.get(i);
            Map areasMap = (Map)map.get("JBNT");
            Map gdAreasMap = (Map)areasMap.get("gdmap");
            if (!rMap.containsKey("gdmap")) {
                rMap.put("gdmap", gdAreasMap);
            } else {
                Map gdold = (Map)rMap.get("gdmap");
                for (Map.Entry entry : gdAreasMap.entrySet()) {
                    gdold.put(entry.getKey(), (Double)gdold.get(entry.getKey()) + (Double)entry.getValue());
                }
                rMap.put("gdmap", gdold);
            }
            Map kAreasMap = (Map)areasMap.get("ktmap");
            if (!rMap.containsKey("ktmap")) {
                rMap.put("ktmap", kAreasMap);
                continue;
            }
            Map gdold = (Map)rMap.get("ktmap");
            for (Map.Entry entry : kAreasMap.entrySet()) {
                gdold.put(entry.getKey(), (Double)gdold.get(entry.getKey()) + (Double)entry.getValue());
            }
            rMap.put("ktmap", gdold);
        }
        Map gdAreasMap = (Map)rMap.get("gdmap");
        Iterator iter = gdAreasMap.entrySet().iterator();
        Double gdtotal = 0.0;
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            Double val = Double.parseDouble(df_dj.format(entry.getValue()));
            gdtotal = gdtotal + val;
            gdAreasMap.put(entry.getKey(), val == 0.0 ? "" : df_dj.format(val));
        }
        gdAreasMap.put("total", gdtotal == 0.0 ? "" : df_dj.format(gdtotal));
        rMap.put("gdmap", gdAreasMap);
        Map kAreasMap = (Map)rMap.get("ktmap");
        Iterator iter1 = kAreasMap.entrySet().iterator();
        Double ktotal = 0.0;
        while (iter1.hasNext()) {
            Map.Entry entry;
            entry = iter1.next();
            Double val = Double.parseDouble(df_dj.format(entry.getValue()));
            ktotal = ktotal + val;
            kAreasMap.put(entry.getKey(), val == 0.0 ? "" : df_dj.format(val));
        }
        kAreasMap.put("total", ktotal == 0.0 ? "" : df_dj.format(ktotal));
        rMap.put("ktmap", kAreasMap);
        rMap.put("total", ktotal + gdtotal == 0.0 ? "" : df_dj.format(ktotal + gdtotal));
        ArrayList<Map> result = new ArrayList<Map>();
        result.add(rMap);
        return result;
    }

    public Map singleDjAnalysis(SimpleFeature feature, List analysisLayers, String dataSource) {
        HashMap<String, Object> analysisMap = new HashMap<String, Object>();
        String jbntLyr = null;
        for (int i = 0; i < analysisLayers.size(); ++i) {
            Map layer = (Map)analysisLayers.get(i);
            String lyrId = layer.get("fid").toString();
            if (lyrId.toLowerCase().equals("jbnt")) {
                jbntLyr = String.valueOf(layer.get("layerName"));
                continue;
            }
            String lyrName = (String)layer.get("layerName");
            String outFields = layer.get("fields").toString();
            String[] fields = "*".equals(outFields) ? null : outFields.split(",");
            List analysisList = this.intersectBySimpleFeature(lyrName, feature, fields, dataSource);
            analysisMap.put(lyrId.toUpperCase(), analysisList);
            this.logger.debug("[" + lyrId.toUpperCase() + "]\u5206\u6790\u7ed3\u679c\u6570:" + analysisList.size());
        }
        if (this.isNotNull(jbntLyr)) {
            analysisMap.put("jbnt".toUpperCase(), this.jbntdjAnalysis(jbntLyr, feature, this.JBNTBHTB, dataSource));
        }
        return analysisMap;
    }

    public Map jbntdjAnalysis(String layerName, SimpleFeature feature, String[] fields, String dataSource) {
        int i;
        if (StringUtils.isBlank((String)layerName)) {
            throw new RuntimeException(this.getMessage("analysis.jbntdj.params.error", new Object[]{"\u57fa\u672c\u519c\u7530\u4fdd\u62a4\u56fe\u6591\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a\uff01"}));
        }
        List jbntList = this.intersectBySimpleFeature(layerName, feature, fields, dataSource);
        HashMap<String, Double> gdAreasMap = new HashMap<String, Double>();
        HashMap<String, Double> kAreasMap = new HashMap<String, Double>();
        HashMap<String, Double> oAreasMap = new HashMap<String, Double>();
        for (i = 0; i < this.GDDLBM.length; ++i) {
            gdAreasMap.put(this.GDDLBM[i], 0.0);
        }
        for (i = 0; i < this.KTZYDDLBM.length; ++i) {
            kAreasMap.put(this.KTZYDDLBM[i], 0.0);
        }
        for (i = 0; i < jbntList.size(); ++i) {
            HashMap analyMap = (HashMap)jbntList.get(i);
            Double SHAPE_AREA = MapUtils.getDouble((Map)analyMap, (Object)"SHAPE_AREA");
            if (SHAPE_AREA == null || !(SHAPE_AREA > 0.0)) continue;
            String dlmc = MapUtils.getString((Map)analyMap, (Object)this.DLMC);
            String dlbm = MapUtils.getString((Map)analyMap, (Object)this.DLBM);
            String dlbz = MapUtils.getString((Map)analyMap, (Object)"DLBZ");
            String key = dlbm + "_" + dlbz;
            if (ArrayUtils.contains((String[])this.GDDLBM, (String)dlbm, (boolean)false) && !StringUtils.equalsIgnoreCase((String)dlbz, (String)this.KTZYDDLBZ)) {
                if (gdAreasMap.containsKey(dlbm)) {
                    SHAPE_AREA = SHAPE_AREA + (Double)gdAreasMap.get(dlbm);
                }
                gdAreasMap.put(dlbm, SHAPE_AREA);
                continue;
            }
            if (ArrayUtils.contains((String[])this.KTZYDDLBM, (String)dlbm, (boolean)false) && StringUtils.equalsIgnoreCase((String)dlbz, (String)this.KTZYDDLBZ)) {
                if (kAreasMap.containsKey(dlbm)) {
                    SHAPE_AREA = SHAPE_AREA + (Double)kAreasMap.get(dlbm);
                }
                kAreasMap.put(dlbm, SHAPE_AREA);
                continue;
            }
            if (oAreasMap.containsKey(key)) {
                SHAPE_AREA = SHAPE_AREA + (Double)oAreasMap.get(key);
            }
            oAreasMap.put(key, SHAPE_AREA);
        }
        HashMap<String, HashMap<String, Double>> rMap = new HashMap<String, HashMap<String, Double>>();
        rMap.put("gdmap", gdAreasMap);
        rMap.put("ktmap", kAreasMap);
        rMap.put("omap", oAreasMap);
        return rMap;
    }

    public List<Map> hcAnalysisByArea(String geometry, List analysisLayers, String dataSource) {
        if (this.isNull((Object)geometry)) {
            throw new JSONMessageException("geometry is null");
        }
        if (this.isNull((Object)analysisLayers)) {
            throw new RuntimeException("no analysis Layers");
        }
        if (this.isNull((Object)dataSource)) {
            throw new JSONMessageException("dataSource is null");
        }
        ArrayList results = null;
        Object geo = this.geometryService.readUnTypeGeoJSON(geometry);
        if (geo instanceof FeatureCollection) {
            results = new ArrayList<Map>();
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            while (iterator.hasNext()) {
                SimpleFeature feature = (SimpleFeature)iterator.next();
                Map map = this.singleHcAnalysisByArea(feature, analysisLayers, dataSource);
                map.put("title", feature.getAttribute("title"));
                results.add(map);
            }
        } else if (geo instanceof SimpleFeature) {
            results = new ArrayList();
            results.add(this.singleHcAnalysisByArea((SimpleFeature)geo, analysisLayers, dataSource));
        }
        return results;
    }

    public Map singleHcAnalysisByArea(SimpleFeature feature, List analysisLayers, String dataSource) {
        3 analysisMap = new /* Unavailable Anonymous Inner Class!! */;
        double hfPercent = 0.0;
        String jbntLyr = null;
        for (int i = 0; i < analysisLayers.size(); ++i) {
            Map layer = (Map)analysisLayers.get(i);
            String lyrId = layer.get("fid").toString();
            if (lyrId.toLowerCase().equals("jbnt")) {
                jbntLyr = String.valueOf(layer.get("layerName"));
                continue;
            }
            boolean hf = (Boolean)layer.get("hf");
            String lyrName = layer.get("layerName").toString();
            String outFields = layer.get("fields").toString();
            String[] fields = "*".equals(outFields) ? null : outFields.split(",");
            List analysisList = this.intersectBySimpleFeature(lyrName, feature, fields, dataSource);
            double percent = 0.0;
            double mj = 0.0;
            if (analysisList.size() > 0) {
                for (int j = 0; j < analysisList.size(); ++j) {
                    Map map = (Map)analysisList.get(j);
                    double se_area = Double.parseDouble(map.get("SHAPE_AREA").toString());
                    double input_area = Double.parseDouble(map.get("IN_SHAPE_AREA").toString());
                    percent += se_area / input_area;
                    mj += se_area;
                }
            }
            analysisMap.put(hf ? "hfydmj" : "wfydmj", Double.parseDouble(analysisMap.get(hf ? "hfydmj" : "wfydmj").toString()) + mj);
            analysisMap.put(hf ? "hfydper" : "wfydper", Double.parseDouble(analysisMap.get(hf ? "hfydper" : "wfydper").toString()) + mj);
            analysisMap.put(lyrId + "ydmj", analysisMap.containsKey(lyrId + "ydmj") ? Double.parseDouble(analysisMap.get(lyrId + "ydmj").toString()) + mj : mj);
            analysisMap.put(lyrId + "ydper", analysisMap.containsKey(lyrId + "ydper") ? Double.parseDouble(analysisMap.get(lyrId + "ydper").toString()) + percent : percent);
        }
        if (this.isNotNull(jbntLyr)) {
            analysisMap.put("jbnt".toUpperCase(), this.jbntdjAnalysis(jbntLyr, feature, this.JBNTBHTB, dataSource));
        }
        return analysisMap;
    }

    public List<Map> jctbAnalysis(String geometry, List analysisLayers, String dataSource, Map unit) {
        if (this.isNull((Object)analysisLayers)) {
            throw new RuntimeException("no analysis Layers");
        }
        if (this.isNull((Object)geometry)) {
            throw new JSONMessageException("geometry is null");
        }
        if (this.isNull((Object)unit)) {
            throw new JSONMessageException("unit is null");
        }
        ArrayList results = null;
        try {
            Object geo = this.geometryService.readUnTypeGeoJSON(geometry);
            if (geo instanceof FeatureCollection) {
                results = new ArrayList<Map>();
                FeatureIterator iterator = ((FeatureCollection)geo).features();
                while (iterator.hasNext()) {
                    SimpleFeature feature = (SimpleFeature)iterator.next();
                    Map map = this.singleJctbAnalysis(feature, analysisLayers, dataSource, unit);
                    results.add(map);
                }
            } else if (geo instanceof SimpleFeature) {
                results = new ArrayList();
                results.add(this.singleJctbAnalysis((SimpleFeature)geo, analysisLayers, dataSource, unit));
            }
        }
        catch (GeometryServiceException e) {
            throw new GeometryServiceException(GeometryServiceException.ExceptionType.GEOJSON_PARSE_EXCEPTION, e.getLocalizedMessage());
        }
        catch (NoSuchElementException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return results;
    }

    public Map singleJctbAnalysis(SimpleFeature feature, List analysisLayers, String dataSource, Map unit) {
        HashMap<String, Object> result = null;
        double conv = UNITS.access$000((UNITS)UNITS.ACRES);
        HashMap<String, List> analysisMap = new HashMap<String, List>();
        DecimalFormat df_jctb = new DecimalFormat("0.0");
        if (!this.isNull((Object)unit)) {
            df_jctb.applyPattern(MapUtils.getString((Map)unit, (Object)"format", (String)"0.0"));
            String ualias = MapUtils.getString((Map)unit, (Object)"alias");
            for (UNITS us : UNITS.values()) {
                if (!UNITS.access$100((UNITS)us).equals(ualias)) continue;
                conv = UNITS.access$000((UNITS)us);
                break;
            }
        }
        try {
            String dltbLyr = null;
            String xzdwLyr = null;
            String bpLyr = null;
            CoordinateReferenceSystem crs = null;
            for (int i = 0; i < analysisLayers.size(); ++i) {
                String[] fields;
                Map layer = (Map)analysisLayers.get(i);
                String lyrId = layer.get("fid").toString();
                if (lyrId.equals("dltb")) {
                    dltbLyr = String.valueOf(layer.get("layerName"));
                    continue;
                }
                if (lyrId.equals("xzdw")) {
                    xzdwLyr = String.valueOf(layer.get("layerName"));
                    continue;
                }
                if (lyrId.equals("bpdk")) {
                    bpLyr = MapUtils.getString((Map)layer, (Object)"layerName");
                }
                String lyrName = (String)layer.get("layerName");
                String outFields = layer.get("fields").toString();
                String[] stringArray = fields = "*".equals(outFields) ? null : outFields.split(",");
                if (this.isNull(crs)) {
                    crs = this.getLayerCRS(lyrName, dataSource);
                }
                List analysisList = this.intersect3(lyrName, this.geometryService.toFeatureJSON((Object)feature), fields, dataSource);
                analysisMap.put(lyrId.toUpperCase(), analysisList);
                if (analysisList != null) {
                    this.logger.debug("[" + lyrId.toUpperCase() + "]\u5206\u6790\u7ed3\u679c\u6570:" + analysisList.size());
                    continue;
                }
                this.logger.debug("[" + lyrId.toUpperCase() + "]\u6ca1\u6709\u5206\u6790\u7ed3\u679c");
            }
            Map tdlyxzMap = this.tdlyxzAnalysis2(dltbLyr, xzdwLyr, this.geometryService.toFeatureJSON((Object)feature), dataSource);
            Map tdlyxzAnalysisArea = (Map)tdlyxzMap.get("analysisArea");
            List tdlyxzAnalysisDetail = new ArrayList();
            if (tdlyxzMap.containsKey("analysisAreaDetail") && tdlyxzMap.get("analysisAreaDetail") != null) {
                tdlyxzAnalysisDetail = (List)tdlyxzMap.get("analysisAreaDetail");
            }
            ArrayList bpList = analysisMap.containsKey(JCTB.BPDK.name()) ? (List)analysisMap.get(JCTB.BPDK.name()) : new ArrayList();
            ArrayList gdList = analysisMap.containsKey(JCTB.GDDK.name()) ? (List)analysisMap.get(JCTB.GDDK.name()) : new ArrayList();
            ArrayList jsydgzqList = analysisMap.containsKey(JCTB.JSYDGZQ.name()) ? (List)analysisMap.get(JCTB.JSYDGZQ.name()) : new ArrayList();
            ArrayList tdytqList = analysisMap.containsKey(JCTB.TDYTQ.name()) ? (List)analysisMap.get(JCTB.TDYTQ.name()) : new ArrayList();
            ArrayList ssnydList = analysisMap.containsKey(JCTB.SSNYD.name()) ? (List)analysisMap.get(JCTB.SSNYD.name()) : new ArrayList();
            ArrayList lsydList = analysisMap.containsKey(JCTB.LSYD.name()) ? (List)analysisMap.get(JCTB.LSYD.name()) : new ArrayList();
            ArrayList yxjsList = analysisMap.containsKey(JCTB.YXJS.name()) ? (List)analysisMap.get(JCTB.YXJS.name()) : new ArrayList();
            ArrayList ytjjsList = analysisMap.containsKey(JCTB.YTJJS.name()) ? (List)analysisMap.get(JCTB.YTJJS.name()) : new ArrayList();
            ArrayList byxjsList = analysisMap.containsKey(JCTB.BYXJS.name()) ? (List)analysisMap.get(JCTB.BYXJS.name()) : new ArrayList();
            ArrayList jbntList = analysisMap.containsKey(JCTB.JBNT.name()) ? (List)analysisMap.get(JCTB.JBNT.name()) : new ArrayList();
            double lsydBpArea = this.getIntersectArea(lsydList, bpLyr, dataSource) * conv;
            double ssnydBpArea = this.getIntersectArea(ssnydList, bpLyr, dataSource) * conv;
            result = new HashMap<String, Object>();
            for (Property p : feature.getProperties()) {
                if (p.getName().getLocalPart().equals("geometry") || p.getName().getLocalPart().equals("crs")) continue;
                result.put("OG_PRO_".concat(p.getName().getLocalPart()), p.getValue());
            }
            Geometry simpleGeo = this.geometryService.simplify((Geometry)feature.getDefaultGeometry(), this.geometryService.getSimplifyTolerance());
            result.put("OG_PRO_".concat("SHAPE"), this.geometryService.toGeoJSON(simpleGeo));
            double geoArea = MapUtils.getDoubleValue(result, (Object)"OG_PRO_".concat("JCMJ"), (double)0.0) * 666.6666667 * conv;
            if (geoArea == 0.0) {
                geoArea = this.geometryService.getGeoArea((Object)feature, null) * conv;
            }
            result.put("OG_PRO_".concat("JCMJ"), df_jctb.format(geoArea));
            result.put(JTag.JC_GD_AREA.name(), df_jctb.format((MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u6c34\u7530", (Double)0.0) + MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u6c34\u6d47\u5730", (Double)0.0) + MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u65f1\u5730", (Double)0.0)) * conv));
            result.put(JTag.BP_AREA.name(), df_jctb.format(this.getAreaByList(bpList, true, conv, crs)));
            result.put(JTag.BP_GD_AREA.name(), df_jctb.format(this.getGdArea(bpList, dltbLyr, xzdwLyr, dataSource) * conv));
            result.put(JTag.YG_AREA.name(), df_jctb.format(this.getAreaByList(gdList, true, conv, crs)));
            result.put(JTag.WG_AREA.name(), df_jctb.format(geoArea - MapUtils.getDouble(result, (Object)JTag.YG_AREA.name(), (Double)0.0) < 0.0 ? 0.0 : geoArea - MapUtils.getDouble(result, (Object)JTag.YG_AREA.name(), (Double)0.0)));
            result.put(JTag.WPYJ_AREA.name(), df_jctb.format(geoArea - MapUtils.getDouble(result, (Object)JTag.BP_AREA.name(), (Double)0.0) < 0.0 ? 0.0 : geoArea - MapUtils.getDouble(result, (Object)JTag.BP_AREA.name(), (Double)0.0)));
            result.put(JTag.WPYJ_GD_AREA.name(), df_jctb.format(MapUtils.getDouble(result, (Object)JTag.JC_GD_AREA.name(), (Double)0.0) - MapUtils.getDouble(result, (Object)JTag.BP_GD_AREA.name(), (Double)0.0) < 0.0 ? 0.0 : MapUtils.getDouble(result, (Object)JTag.JC_GD_AREA.name(), (Double)0.0) - MapUtils.getDouble(result, (Object)JTag.BP_GD_AREA.name(), (Double)0.0)));
            result.put(JTag.YXJSQ_AREA.name(), df_jctb.format(this.getAreaByField(jsydgzqList, "GZQLXDM", "010", conv)));
            result.put(JTag.JBNT_AREA.name(), df_jctb.format(this.getAreaByField(tdytqList, "TDYTQLXDM", "010", conv)));
            result.put(JTag.YBNTQ_AREA.name(), df_jctb.format(this.getAreaByField(tdytqList, "TDYTQLXDM", "020", conv)));
            result.put(JTag.PCMC.name(), this.getStrValueByField(bpList, "PCJC"));
            result.put(JTag.NZYPW.name(), this.getStrValueByField(bpList, "PZWH"));
            result.put(JTag.GDBH.name(), this.getStrValueByField(gdList, "XMBH"));
            result.put(JTag.LSYD_AREA.name(), df_jctb.format(this.getAreaByList(lsydList, false, conv, crs) - lsydBpArea));
            result.put(JTag.LSYD_GD_AREA.name(), df_jctb.format(this.getGdArea(lsydList, dltbLyr, xzdwLyr, dataSource) * conv));
            result.put(JTag.SSNYD_AREA.name(), df_jctb.format(this.getAreaByList(ssnydList, false, conv, crs) - ssnydBpArea));
            result.put(JTag.SSSNYD_GD_AREA.name(), df_jctb.format(this.getGdArea(ssnydList, dltbLyr, xzdwLyr, dataSource) * conv));
            result.put(JTag.LSYD_BH.name(), this.getStrValueByField(lsydList, "BH"));
            result.put(JTag.SSNYD_BH.name(), this.getStrValueByField(ssnydList, "BH"));
            result.put(JTagMAS.YXJS_AREA.name(), df_jctb.format(this.getAreaByList(yxjsList, true, conv, crs)));
            result.put(JTagMAS.YTJJS_AREA.name(), df_jctb.format(this.getAreaByList(ytjjsList, true, conv, crs)));
            result.put(JTagMAS.BYXJS_AREA.name(), df_jctb.format(this.getAreaByList(byxjsList, true, conv, crs)));
            result.put(JTagMAS.JBNT_MAS_AREA.name(), df_jctb.format(this.getAreaByList(jbntList, true, conv, crs)));
            result.put(JTagMAS.NYD_AREA.name(), df_jctb.format(this.getAreaByField(tdlyxzAnalysisDetail, "DLBM", "011,012,013,021,022,023,031,032,033,041,042,104,114,117,122,123", "CCMJ", conv)));
            result.put(JTagMAS.GD_AREA.name(), df_jctb.format(this.getAreaByField(tdlyxzAnalysisDetail, "DLBM", "011,012,013", "CCMJ", conv)));
            result.put(JTagMAS.JSYD_AREA.name(), df_jctb.format(this.getAreaByField(tdlyxzAnalysisDetail, "DLBM", "051,052,053,054,061,062,063,071,072,081,082,083,084,085,086,087,088,091,092,093,094,095,101,102,103,105,106,107,113,118,121,201,202,203,204,205", "CCMJ", conv)));
            result.put(JTagMAS.WLYD_AREA.name(), df_jctb.format(this.getAreaByField(tdlyxzAnalysisDetail, "DLBM", "111,112,115,116,119,043,124,125,126,127", "CCMJ", conv)));
            result.put(JTagMAS.PCMC_MAS.name(), this.getStrValueByField(bpList, new String[]{"PWSJ", "PWBH", "XMMC"}, "-"));
            result.put(JTagMAS.NZYPW_MAS.name(), this.getStrValueByField(bpList, "PZWH"));
            result.put(JTagMAS.HPDH_MAS.name(), this.getStrValueByField(bpList, "DAH"));
            result.put(JTagMAS.GDBH_MAS.name(), this.getStrValueByField(gdList, "CRBH"));
            result.put(JTagMAS.GDDH_MAS.name(), this.getStrValueByField(gdList, "DAH"));
            result.put(JTagMAS.XMMC_MAS.name(), this.getStrValueByField(gdList, "XMMC"));
            result.put(JTagMAS.YDDW_MAS.name(), this.getStrValueByField(gdList, "YDDW"));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return result;
    }

    public Map tdlyxzAnalysis(String dltbLayerName, String xzdwLayerName, String geometry, String[] outFields, String dataSource) {
        Assert.notNull((Object)geometry, (String)this.getMessage("geometry.notnull", new Object[0]));
        HashMap<String, Double> analysisResult = new HashMap<String, Double>();
        HashMap<String, Double> analysisTemp = new HashMap<String, Double>();
        String[] dltbOutFields = ArrayUtils.add2Arrays((String[])outFields, (String[])new String[]{"DLMC", "ZLDWDM", "TBBH"});
        List results = this.intersectByGeoJSON(dltbLayerName, geometry, dltbOutFields, dataSource);
        for (Map result : results) {
            String dlmc;
            Double area = Double.parseDouble(String.valueOf(result.get("SHAPE_AREA")));
            if (!(area > 0.4)) continue;
            analysisResult.put(dlmc, (analysisResult.containsKey(dlmc = String.valueOf(result.get("DLMC"))) ? (Double)analysisResult.get(dlmc) : 0.0) + area);
            analysisTemp.put(String.valueOf(result.get("ZLDWDM")) + String.valueOf(result.get("TBBH")), area);
        }
        String[] xzdwOutFields = ArrayUtils.add2Arrays((String[])outFields, (String[])new String[]{"DLMC", "KD", "KCTBDWDM2", "KCTBDWDM1", "KCTBBH1", "KCTBBH2"});
        List xzResults = this.intersectByGeoJSON(xzdwLayerName, geometry, xzdwOutFields, dataSource);
        for (Map result : xzResults) {
            Double length = Double.parseDouble(String.valueOf(result.get("SHAPE_AREA")));
            if (!(length > 0.08)) continue;
            String dlmc = String.valueOf(result.get("DLMC"));
            Double kd = Double.parseDouble(String.valueOf(result.get("KD")));
            analysisResult.put(dlmc, (analysisResult.containsKey(dlmc) ? (Double)analysisResult.get(dlmc) : 0.0) + length * kd);
            String where = "ZLDWDM='" + result.get("KCTBDWDM1") + "' and TBBH='" + result.get("KCTBBH1") + "'";
            List temps = new ArrayList();
            try {
                temps = this.query(dltbLayerName, where, ArrayUtils.add2Arrays((String[])outFields, (String[])new String[]{"DLMC"}), true, dataSource);
            }
            catch (Exception e) {
                this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
            }
            String kctb1Key = String.valueOf(result.get("KCTBDWDM1")) + String.valueOf(result.get("KCTBBH1"));
            if (StringUtils.isBlank((String)((String)result.get("KCTBDWDM2")))) {
                for (Map temp : temps) {
                    String tmpDlmc = String.valueOf(temp.get("DLMC"));
                    analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length * kd);
                    analysisTemp.put(kctb1Key, (Double)analysisTemp.get(kctb1Key) - length * kd);
                }
                continue;
            }
            Tag tag = Tag.NO;
            String tmpDlmc = "";
            String tmpDlmc1 = "";
            Double tmpXzdwKd = 0.0;
            String tmpXzdwKctbdwdm1 = "";
            String tmpXzdwKctbbh1 = "";
            for (Map tmp : temps) {
                tmpDlmc = String.valueOf(tmp.get("DLMC"));
                if (analysisTemp.containsKey(kctb1Key)) {
                    Double tmpValue = (Double)analysisTemp.get(kctb1Key);
                    if (tmpValue - length / 2.0 * kd > 0.0) {
                        analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length / 2.0 * kd);
                        tmpXzdwKd = length / 2.0 * kd;
                        tmpDlmc1 = tmpDlmc;
                        tmpXzdwKctbbh1 = String.valueOf(result.get("KCTBBH1"));
                        tmpXzdwKctbdwdm1 = String.valueOf(result.get("KCTBDWDM1"));
                        analysisTemp.put(tmpXzdwKctbdwdm1 + tmpXzdwKctbbh1, tmpValue - length / 2.0 * kd);
                        continue;
                    }
                    tag = Tag.YES;
                    continue;
                }
                tag = Tag.YES;
            }
            where = "ZLDWDM='" + result.get("KCTBDWDM2") + "' and TBBH='" + result.get("KCTBBH2") + "'";
            try {
                temps = this.query(dltbLayerName, where, new String[]{"DLMC"}, true, dataSource);
            }
            catch (Exception e) {
                this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                temps.clear();
            }
            String kctb2Key = String.valueOf(result.get("KCTBDWDM2")) + String.valueOf(result.get("KCTBBH2"));
            for (Map tmp : temps) {
                tmpDlmc = String.valueOf(tmp.get("DLMC"));
                if (analysisTemp.containsKey(kctb2Key)) {
                    Double tmpValue = (Double)analysisTemp.get(kctb2Key);
                    if (tmpValue - length / 2.0 * kd > 0.0) {
                        if (!Tag.YES.equals((Object)tag)) {
                            analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length / 2.0 * kd);
                            analysisTemp.put(kctb2Key, tmpValue - length * kd);
                            continue;
                        }
                        analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - length / 2.0 * kd);
                        analysisTemp.put(kctb2Key, tmpValue - length * kd);
                        continue;
                    }
                    tmpDlmc = tmpDlmc1;
                    analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - tmpXzdwKd);
                    analysisTemp.put(kctb1Key, (Double)analysisTemp.get(kctb1Key) - tmpXzdwKd);
                    continue;
                }
                tmpDlmc = tmpDlmc1;
                analysisResult.put(tmpDlmc, (Double)analysisResult.get(tmpDlmc) - tmpXzdwKd);
                analysisTemp.put(kctb1Key, (Double)analysisTemp.get(kctb1Key) - tmpXzdwKd);
            }
        }
        return analysisResult;
    }

    public Map tdlyxzAnalysis(String regionCode, String geometry, String dataSource) {
        regionCode = Utils.formatRegionCode((String)regionCode);
        String dltb = TDXZ.DLTB.name().concat("_H_").concat(regionCode);
        String xzdw = TDXZ.XZDW.name().concat("_H_").concat(regionCode);
        return this.tdlyxzAnalysis2(dltb, xzdw, geometry, dataSource);
    }

    public Map tdlyxzAnalysis2(String dltbLayerName, String xzdwLayerName, String geometry, String dataSource) {
        if (StringUtils.isBlank((String)dltbLayerName)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u5730\u7c7b\u56fe\u6591\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a\uff01"}));
        }
        if (StringUtils.isBlank((String)xzdwLayerName)) {
            this.logger.warn(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u7ebf\u72b6\u5730\u7269\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a,\u53ea\u4f1a\u5206\u6790\u5730\u7c7b\u56fe\u6591\u56fe\u5c42\uff01"}));
        }
        if (StringUtils.isBlank((String)geometry)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u5206\u6790\u5730\u5757\u5750\u6807\u4e3a\u7a7a\uff01"}));
        }
        boolean useWcf = AppConfig.getBooleanProperty((String)"analysis.useWcf");
        if (useWcf) {
            String wcfUrl = AppConfig.getProperty((String)"wcfUrl");
            String wcfMethod = AppConfig.getProperty((String)"wcfMethod");
            if (StringUtils.isBlank((String)wcfUrl)) {
                throw new RuntimeException(this.getMessage("analysis.wcf.url.null", new Object[0]));
            }
            if (StringUtils.isBlank((String)wcfMethod)) {
                throw new RuntimeException(this.getMessage("analysis.wcf.method.null", new Object[0]));
            }
            return this.tdlyxzAnalysisByWcf(geometry, dltbLayerName, xzdwLayerName, dataSource);
        }
        HashMap<String, Double> dlMap = new HashMap<String, Double>();
        HashMap<String, Double> bhMap = new HashMap<String, Double>();
        MultiKeyMap analysisDetailMap = MultiKeyMap.decorate((AbstractHashedMap)new HashedMap());
        String[] columns = new String[]{"DLMC"};
        List xzdwDltbResult = new ArrayList();
        List dltbAnalysisResult = new ArrayList();
        List xzdwAnalysisResult = new ArrayList();
        try {
            dltbAnalysisResult = this.intersect3(dltbLayerName, geometry, "OBJECTID;BSM;DLMC;ZLDWDM;TBBH;ZLDWMC;QSXZ;DLBM;TBMJ;QSDWDM;QSDWMC".split(";"), dataSource);
        }
        catch (Exception e) {
            this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
        }
        if (dltbAnalysisResult.size() > 0) {
            for (int i = 0; i < dltbAnalysisResult.size(); ++i) {
                Map<String, String> detailValue;
                Double tmpArea = Double.parseDouble(String.valueOf(((Map)dltbAnalysisResult.get(i)).get("SHAPE_AREA")));
                if (!(tmpArea > 0.4)) continue;
                if (dlMap.containsKey(((Map)dltbAnalysisResult.get(i)).get("DLMC"))) {
                    dlMap.put(String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(((Map)dltbAnalysisResult.get(i)).get("DLMC")) + tmpArea);
                } else {
                    dlMap.put(String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLMC")), tmpArea);
                }
                String tmpZldwdmTbbh = String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")) + String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH"));
                if (bhMap.containsKey(tmpZldwdmTbbh)) {
                    bhMap.put(tmpZldwdmTbbh, (Double)bhMap.get(tmpZldwdmTbbh) + tmpArea);
                } else {
                    bhMap.put(tmpZldwdmTbbh, tmpArea);
                }
                if (analysisDetailMap.containsKey((Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")), (Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")))) {
                    detailValue = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")), (Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")));
                    detailValue.put("CCMJ", (String)((Object)Double.valueOf(Double.valueOf(String.valueOf(detailValue.get("CCMJ"))) + tmpArea)));
                    continue;
                }
                detailValue = new HashMap<String, String>();
                detailValue.put("ZLDWDM", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")));
                detailValue.put("ZLDWMC", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWMC")));
                detailValue.put("TBBH", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")));
                detailValue.put("QSXZ", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("QSXZ")));
                detailValue.put("DLMC", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLMC")));
                detailValue.put("DLBM", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("DLBM")));
                detailValue.put("TBMJ", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBMJ")));
                detailValue.put("QSDWDM", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("QSDWDM")));
                detailValue.put("QSDWMC", String.valueOf(((Map)dltbAnalysisResult.get(i)).get("QSDWMC")));
                detailValue.put("CCMJ", (String)((Object)tmpArea));
                detailValue.put("SHAPE", MapUtils.getString((Map)((Map)dltbAnalysisResult.get(i)), (Object)"SHAPE"));
                analysisDetailMap.put((Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("ZLDWDM")), (Object)String.valueOf(((Map)dltbAnalysisResult.get(i)).get("TBBH")), detailValue);
            }
        }
        try {
            xzdwAnalysisResult = this.intersect3(xzdwLayerName, geometry, "OBJECTID;BSM;DLMC;KD;KCTBDWDM2;KCTBDWDM1;KCTBBH1;KCTBBH2;QSDWDM1;XZDWBH;QSXZ;DLBM;XZDWMJ;QSDWMC1".split(";"), dataSource);
        }
        catch (Exception e) {
            this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
        }
        if (xzdwAnalysisResult.size() > 0) {
            for (int i = 0; i < xzdwAnalysisResult.size(); ++i) {
                Map<String, String> detailValue;
                Map<String, Double> detailValue2;
                Double tmpValue;
                String tmpDlmcKey;
                Map<String, String> detailValue3;
                Double tmpLength = Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("SHAPE_AREA")));
                if (!(tmpLength > 0.08)) continue;
                if (dlMap.containsKey(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) {
                    dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) + tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                } else {
                    dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                }
                if (analysisDetailMap.containsKey((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")))) {
                    detailValue3 = (Map)analysisDetailMap.get((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                    detailValue3.put("CCMJ", (String)((Object)Double.valueOf(Double.valueOf(String.valueOf(detailValue3.get("CCMJ"))) + tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))))));
                } else {
                    detailValue3 = new HashMap<String, String>();
                    detailValue3.put("ZLDWDM", String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))));
                    detailValue3.put("ZLDWMC", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("")));
                    detailValue3.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                    detailValue3.put("QSXZ", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSXZ")));
                    detailValue3.put("DLMC", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")));
                    detailValue3.put("DLBM", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")));
                    detailValue3.put("TBMJ", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ")));
                    detailValue3.put("QSDWDM", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")));
                    detailValue3.put("QSDWMC", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWMC1")));
                    detailValue3.put("CCMJ", (String)((Object)Double.valueOf(tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))))));
                    detailValue3.put("SHAPE", MapUtils.getString((Map)((Map)xzdwAnalysisResult.get(i)), (Object)"SHAPE"));
                    analysisDetailMap.put((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), detailValue3);
                }
                if (StringUtils.isBlank((String)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"))) || String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")).equalsIgnoreCase("null")) {
                    String tmpWhereClause = "ZLDWDM='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1") + "' and TBBH='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1") + "'";
                    try {
                        xzdwDltbResult = this.query(dltbLayerName, tmpWhereClause, columns, true, dataSource);
                    }
                    catch (Exception e) {
                        this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                    }
                    Object tmpKey = String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"));
                    if (!this.isNull(xzdwDltbResult) && xzdwDltbResult.size() > 0 && bhMap.containsKey(tmpKey)) {
                        for (int j = 0; j < xzdwDltbResult.size(); ++j) {
                            HashMap<String, Double> detailValue4;
                            Double tmpCCMJ = 0.0;
                            if ((Double)bhMap.get(tmpKey) >= tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))) {
                                dlMap.put(String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                bhMap.put((String)tmpKey, (Double)bhMap.get(tmpKey) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                tmpCCMJ = tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")));
                            } else {
                                Double tmpKouchuMj = (Double)bhMap.get(tmpKey);
                                Double tmpSyMj = tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))) - tmpKouchuMj;
                                dlMap.put(String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC"))) - tmpKouchuMj);
                                bhMap.put((String)tmpKey, 0.0);
                                dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) - tmpSyMj);
                                tmpCCMJ = tmpKouchuMj;
                                Map detailValue5 = (Map)analysisDetailMap.get((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                                detailValue5.put("CCMJ", Double.valueOf(String.valueOf(detailValue5.get("CCMJ"))) - tmpSyMj);
                            }
                            if (analysisDetailMap.containsKey((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")))) {
                                detailValue4 = (HashMap<String, Double>)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                                detailValue4.put("CCMJ", Double.valueOf(String.valueOf(detailValue4.get("CCMJ"))) - tmpCCMJ);
                                continue;
                            }
                            this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"ERROR", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                            detailValue4 = new HashMap<String, Double>();
                            detailValue4.put("ZLDWDM", (Double)((Object)("error" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")))));
                            detailValue4.put("TBBH", (Double)((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"))));
                            analysisDetailMap.put((Object)("error" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue4);
                        }
                        continue;
                    }
                    dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                    Map detailValue6 = (Map)analysisDetailMap.get((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                    detailValue6.put("CCMJ", Double.valueOf(String.valueOf(detailValue6.get("CCMJ"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                    continue;
                }
                String kouchuTag = "no";
                double kouchuMj = 0.0;
                String kouchuDlmc = "";
                String kouchuZldwdm = "";
                String kouchuTbbh = "";
                String tmpWhereClause = "ZLDWDM='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1") + "' and TBBH='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1") + "'";
                try {
                    xzdwDltbResult = this.query(dltbLayerName, tmpWhereClause, columns, true, dataSource);
                }
                catch (Exception e) {
                    this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                }
                if (!this.isNull(xzdwDltbResult) && xzdwDltbResult.size() > 0) {
                    for (int j = 0; j < xzdwDltbResult.size(); ++j) {
                        tmpDlmcKey = String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC"));
                        if (bhMap.containsKey(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")))) {
                            tmpValue = (Double)bhMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                            if (tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))) > 0.0) {
                                dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                kouchuMj = tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")));
                                kouchuDlmc = tmpDlmcKey;
                                kouchuZldwdm = String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"));
                                kouchuTbbh = String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"));
                                bhMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                detailValue2 = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                                detailValue2.put("CCMJ", Double.valueOf(String.valueOf(detailValue2.get("CCMJ"))) - kouchuMj);
                                continue;
                            }
                            kouchuTag = "yes";
                            this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u9762\u79ef\u8fc7\u5c0f", 2, ((Map)xzdwAnalysisResult.get(i)).get("DLBM"), ((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")}));
                            detailValue2 = new HashMap<String, String>();
                            detailValue2.put("ZLDWDM", (Double)((Object)("error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")))));
                            detailValue2.put("TBBH", (Double)((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1"))));
                            detailValue2.put("TBMJ", tmpValue);
                            detailValue2.put("CCMJ", tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            analysisDetailMap.put((Object)("error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue2);
                            continue;
                        }
                        kouchuTag = "yes";
                        this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u6ca1\u6709\u5360\u7528", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                        detailValue = new HashMap<String, String>();
                        detailValue.put("ZLDWDM", "error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")));
                        detailValue.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                        analysisDetailMap.put((Object)("error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue);
                    }
                } else {
                    kouchuTag = "yes";
                    this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u6ca1\u6709\u627e\u5230", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                    HashMap<String, String> detailValue7 = new HashMap<String, String>();
                    detailValue7.put("ZLDWDM", "error,\u6ca1\u6709\u627e\u5230" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1")));
                    detailValue7.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")));
                    analysisDetailMap.put((Object)("error,\u6ca1\u6709\u627e\u5230" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH1")), detailValue7);
                }
                tmpWhereClause = "ZLDWDM='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2") + "' and TBBH='" + ((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2") + "'";
                try {
                    xzdwDltbResult = this.query(dltbLayerName, tmpWhereClause, columns, true, dataSource);
                }
                catch (Exception e) {
                    this.logger.error("tdlyxzAnalysis error [{}] ", (Object)e.getLocalizedMessage());
                }
                if (this.isNull(xzdwDltbResult) || xzdwDltbResult.size() <= 0) continue;
                for (int j = 0; j < xzdwDltbResult.size(); ++j) {
                    tmpDlmcKey = String.valueOf(((Map)xzdwDltbResult.get(j)).get("DLMC"));
                    if (bhMap.containsKey(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")))) {
                        Map detailValue8;
                        Map detailValue9;
                        Double tmpSyMj;
                        Double tmpKouchuMj;
                        Double tmpCCMJ;
                        tmpValue = (Double)bhMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                        if (tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))) > 0.0) {
                            if (!kouchuTag.equals("yes")) {
                                dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                detailValue2 = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                                detailValue2.put("CCMJ", Double.valueOf(String.valueOf(detailValue2.get("CCMJ"))) - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                bhMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), tmpValue - tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                continue;
                            }
                            tmpCCMJ = 0.0;
                            if (tmpValue >= tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))) {
                                dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                bhMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), tmpValue - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                                tmpCCMJ = tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")));
                            } else {
                                tmpKouchuMj = (Double)bhMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                                tmpSyMj = tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))) - tmpKouchuMj;
                                dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpKouchuMj);
                                bhMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), 0.0);
                                dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) - tmpSyMj);
                                tmpCCMJ = tmpKouchuMj;
                                detailValue9 = (Map)analysisDetailMap.get((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                                detailValue9.put("CCMJ", Double.valueOf(String.valueOf(detailValue9.get("CCMJ"))) - tmpSyMj);
                            }
                            detailValue8 = (Map)analysisDetailMap.get((Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                            detailValue8.put("CCMJ", Double.valueOf(String.valueOf(detailValue8.get("CCMJ"))) - tmpCCMJ);
                            continue;
                        }
                        if (StringUtils.isNotBlank((String)kouchuDlmc)) {
                            tmpCCMJ = 0.0;
                            try {
                                tmpDlmcKey = kouchuDlmc;
                                StringBuilder stringBuilder = new StringBuilder();
                                if ((Double)bhMap.get(stringBuilder.append(kouchuZldwdm).append(kouchuTbbh).toString()) >= kouchuMj) {
                                    dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - kouchuMj);
                                    bhMap.put(kouchuZldwdm + kouchuTbbh, (Double)bhMap.get(kouchuZldwdm + kouchuTbbh) - kouchuMj);
                                    tmpCCMJ = kouchuMj;
                                } else {
                                    tmpKouchuMj = (Double)bhMap.get(kouchuZldwdm + kouchuTbbh);
                                    tmpSyMj = kouchuMj - tmpKouchuMj;
                                    dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpKouchuMj);
                                    bhMap.put(kouchuZldwdm + kouchuTbbh, 0.0);
                                    dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) - tmpSyMj);
                                    tmpCCMJ = tmpKouchuMj;
                                    detailValue9 = (Map)analysisDetailMap.get((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                                    detailValue9.put("CCMJ", Double.valueOf(String.valueOf(detailValue9.get("CCMJ"))) - tmpSyMj);
                                }
                            }
                            catch (Exception ex) {
                                this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u9762\u79ef\u6263\u9664\u9519\u8bef\uff0c\u51fa\u73b0\u65e0\u6cd5\u6263\u9664\u60c5\u51b5\uff0c\u8bf7\u68c0\u67e5\uff0c\u8bf7\u7528\u5b9e\u5730\u52d8\u6d4b\u5750\u6807\u53e0\u52a0\u5230\u56fe\u5f62\u4e0a\uff01!", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                            }
                            detailValue8 = (Map)analysisDetailMap.get((Object)kouchuZldwdm, (Object)kouchuTbbh);
                            detailValue8.put("CCMJ", Double.valueOf(String.valueOf(detailValue8.get("CCMJ"))) - tmpCCMJ);
                            this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u9762\u79ef\u8fc7\u5c0f", 2, ((Map)xzdwAnalysisResult.get(i)).get("DLBM"), ((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")}));
                            HashMap<String, Object> detailValue1 = new HashMap<String, Object>();
                            detailValue1.put("ZLDWDM", "error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")));
                            detailValue1.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                            detailValue1.put("TBMJ", tmpValue);
                            detailValue1.put("CCMJ", tmpLength / 2.0 * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                            analysisDetailMap.put((Object)("error\u9762\u79ef\u8fc7\u5c0f" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), detailValue1);
                            continue;
                        }
                        dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                        detailValue2 = (Map)analysisDetailMap.get((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                        detailValue2.put("CCMJ", Double.valueOf(String.valueOf(detailValue2.get("CCMJ"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                        continue;
                    }
                    if (StringUtils.isNotBlank((String)kouchuDlmc)) {
                        Double tmpCCMJ = 0.0;
                        try {
                            tmpDlmcKey = kouchuDlmc;
                            StringBuilder stringBuilder = new StringBuilder();
                            if ((Double)bhMap.get(stringBuilder.append(kouchuZldwdm).append(kouchuTbbh).toString()) >= kouchuMj) {
                                dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - kouchuMj);
                                bhMap.put(kouchuZldwdm + kouchuTbbh, (Double)bhMap.get(kouchuZldwdm + kouchuTbbh) - kouchuMj);
                                tmpCCMJ = kouchuMj;
                            } else {
                                Double tmpKouchuMj = (Double)bhMap.get(kouchuZldwdm + kouchuTbbh);
                                Double tmpSyMj = kouchuMj - tmpKouchuMj;
                                dlMap.put(tmpDlmcKey, (Double)dlMap.get(tmpDlmcKey) - tmpKouchuMj);
                                bhMap.put(kouchuZldwdm + kouchuTbbh, 0.0);
                                dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) - tmpSyMj);
                                tmpCCMJ = tmpKouchuMj;
                                Map detailValue10 = (Map)analysisDetailMap.get((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                                detailValue10.put("CCMJ", Double.valueOf(String.valueOf(detailValue10.get("CCMJ"))) - tmpSyMj);
                            }
                        }
                        catch (Exception ex) {
                            this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u571f\u5730\u5229\u7528\u73b0\u72b6\u5e95\u56fe\u4e2d\u73b0\u72b6\u5730\u7269\u6263\u9664\u6709\u8bef\uff0c\u8bf7\u68c0\u67e5!", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                        }
                        detailValue2 = (Map)analysisDetailMap.get((Object)kouchuZldwdm, (Object)kouchuTbbh);
                        detailValue2.put("CCMJ", Double.valueOf(String.valueOf(detailValue2.get("CCMJ"))) - tmpCCMJ);
                        this.logger.error(this.getMessage("analysis.tdlyxz.kc.error", new Object[]{"\u6ca1\u6709\u5360\u7528", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")), String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLBM")), String.valueOf(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM1"), ((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"), ((Map)xzdwAnalysisResult.get(i)).get("XZDWMJ"), tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD")))}));
                        HashMap<String, String> detailValue1 = new HashMap<String, String>();
                        detailValue1.put("ZLDWDM", "error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2")));
                        detailValue1.put("TBBH", String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")));
                        analysisDetailMap.put((Object)("error\u6ca1\u6709\u5360\u7528" + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBDWDM2"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KCTBBH2")), detailValue1);
                        continue;
                    }
                    dlMap.put(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC")), (Double)dlMap.get(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("DLMC"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))));
                    detailValue = (Map)analysisDetailMap.get((Object)(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("QSDWDM1")) + String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH"))), (Object)String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("XZDWBH")));
                    detailValue.put("CCMJ", (String)((Object)Double.valueOf(Double.valueOf(String.valueOf(detailValue.get("CCMJ"))) - tmpLength * Double.parseDouble(String.valueOf(((Map)xzdwAnalysisResult.get(i)).get("KD"))))));
                }
            }
        }
        HashMap<String, Cloneable> resultMap = new HashMap<String, Cloneable>();
        resultMap.put("analysisArea", dlMap);
        ArrayList<Object> resultDetailList = new ArrayList<Object>();
        for (Object tmpKey : analysisDetailMap.keySet()) {
            if (!this.isNull(tmpKey) && tmpKey.toString().indexOf("error") > -1) continue;
            resultDetailList.add(analysisDetailMap.get(tmpKey));
        }
        resultMap.put("analysisAreaDetail", resultDetailList);
        return resultMap;
    }

    public Map tdlyxzAnalysisByWcf(String geometry, String dltbLayerName, String xzdwLayerName, String dataSource) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geometry);
        CoordinateReferenceSystem sourceCrs = null;
        CoordinateReferenceSystem layerCrs = this.spatialDao.getLayerCRS(dltbLayerName, dataSource);
        if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem();
            Geometry tmpGeo = (Geometry)feature.getDefaultGeometry();
            if (!tmpGeo.isValid() && !this.isNull((Object)this.geometryService.validGeometry(tmpGeo))) {
                throw new RuntimeException("\u56fe\u5f62\u4e0d\u662f\u6709\u6548\u56fe\u5f62:" + this.geometryService.validGeometry(tmpGeo).getMessage());
            }
        } else if (geo instanceof FeatureCollection) {
            FeatureIterator iterator = ((FeatureCollection)geo).features();
            SimpleFeature feature = (SimpleFeature)iterator.next();
            sourceCrs = feature.getFeatureType().getCoordinateReferenceSystem();
            Geometry tmpGeo = (Geometry)feature.getDefaultGeometry();
            if (!tmpGeo.isValid() && !this.isNull((Object)this.geometryService.validGeometry(tmpGeo))) {
                throw new RuntimeException("\u56fe\u5f62\u4e0d\u662f\u6709\u6548\u56fe\u5f62:" + this.geometryService.validGeometry(tmpGeo).getMessage());
            }
        }
        if (!(this.isNull(sourceCrs) || this.isNull((Object)layerCrs) || sourceCrs.equals(layerCrs))) {
            Object projectGeo = this.geometryService.project(geo, sourceCrs, layerCrs);
            geometry = this.geometryService.toFeatureJSON(projectGeo);
        }
        String wcfUrl = String.valueOf(AppPropertyUtils.getAppEnv((String)"wcfUrl"));
        String wcfMethod = String.valueOf(AppPropertyUtils.getAppEnv((String)"wcfMethod"));
        if (StringUtils.isBlank((String)dltbLayerName)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u5730\u7c7b\u56fe\u6591\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a\uff01"}));
        }
        if (StringUtils.isBlank((String)xzdwLayerName)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u7ebf\u72b6\u5730\u7269\u56fe\u5c42\u540d\u79f0\u4e3a\u7a7a\uff01"}));
        }
        if (StringUtils.isBlank((String)geometry)) {
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.params.error", new Object[]{"\u5206\u6790\u5730\u5757\u5750\u6807\u4e3a\u7a7a\uff01"}));
        }
        if (StringUtils.isBlank((String)wcfUrl)) {
            throw new RuntimeException(this.getMessage("tdlyxz.wcf.url.null", new Object[0]));
        }
        if (StringUtils.isBlank((String)wcfMethod)) {
            throw new RuntimeException(this.getMessage("tdlyxz.wcf.method.null", new Object[0]));
        }
        try {
            double area;
            Object[] objects;
            this.logger.debug("----\u542f\u7528webservice\u8fdb\u884c\u571f\u5730\u5229\u7528\u73b0\u72b6\u5206\u6790----");
            this.logger.debug("[wcf\u5730\u5740:]" + wcfUrl);
            Client client = new Client(new URL(wcfUrl));
            JSONObject params = new JSONObject();
            params.put(WCFTag.AnalyseGeoJSON.name(), (Object)geometry);
            params.put(WCFTag.TBLayerName.name(), (Object)dltbLayerName);
            params.put(WCFTag.XWLayerName.name(), (Object)xzdwLayerName);
            params.put(WCFTag.UseGlobalArea.name(), (Object)false);
            try {
                objects = client.invoke(wcfMethod, (Object[])new String[]{JSON.toJSONString((Object)params)});
            }
            catch (Exception e) {
                this.logger.error(this.getMessage("tdlyxz.wcf.error", new Object[]{e.getLocalizedMessage()}));
                throw new RuntimeException(this.getMessage("tdlyxz.wcf.error", new Object[]{e.getLocalizedMessage()}));
            }
            Map analysisMap = (Map)JSON.parseObject((String)String.valueOf(objects[0]), Map.class);
            if (!analysisMap.isEmpty()) {
                this.logger.debug("[wcf \u5206\u6790\u7ed3\u679c:]" + JSON.toJSONString((Object)analysisMap));
            }
            ArrayList features = new ArrayList();
            List summary = (List)MapUtils.getObject((Map)analysisMap, (Object)WCFTag.Summary.name());
            List detail = (List)MapUtils.getObject((Map)analysisMap, (Object)WCFTag.SummaryDetail.name());
            for (int i = 0; i < detail.size(); ++i) {
                features.addAll((Collection)((Map)detail.get(i)).get(WCFTag.SummaryTBs.name()));
                features.addAll((Collection)((Map)detail.get(i)).get(WCFTag.SummaryXWs.name()));
            }
            Map dlbmSummary = (Map)((Map)summary.get(0)).get("SummaryByDLDM");
            ArrayList detailList = new ArrayList();
            HashMap<EnumUtils.TDLYXZ, Double> analysisArea = new HashMap<EnumUtils.TDLYXZ, Double>();
            for (Map tmp : features) {
                Map geoMap;
                Geometry geoEntity;
                HashMap<String, Object> detailMap = new HashMap<String, Object>();
                area = MapUtils.getDoubleValue((Map)tmp, (Object)WCFTag.DLMJ.name(), (double)0.0);
                String zldwmc = MapUtils.getString((Map)tmp, (Object)WCFTag.ZLDWMC.name());
                String zldwdm = MapUtils.getString((Map)tmp, (Object)WCFTag.ZLDWDM.name());
                String qsdwdm = MapUtils.getString((Map)tmp, (Object)WCFTag.QSDWDM.name());
                String qsdwmc = MapUtils.getString((Map)tmp, (Object)WCFTag.QSDWMC.name());
                if (tmp.containsKey(WCFTag.geometry.name()) && !this.isNull((Object)(geoEntity = this.geometryService.readGeoJSON(JSON.toJSONString((Object)(geoMap = (Map)MapUtils.getObject((Map)tmp, (Object)WCFTag.geometry.name())))))) && !geoEntity.isEmpty() && geoEntity.isValid()) {
                    detailMap.put("SHAPE", geoEntity.toText());
                }
                if (area <= 0.0) continue;
                detailMap.put("CCMJ", area);
                detailMap.put("QSDWDM", qsdwdm);
                detailMap.put("QSDWMC", qsdwmc);
                detailMap.put("ZLDWDM", StringUtils.isBlank((String)zldwdm) ? qsdwdm : zldwdm);
                detailMap.put("ZLDWMC", StringUtils.isBlank((String)zldwmc) ? qsdwmc : zldwmc);
                detailMap.put("DLBM", MapUtils.getString((Map)tmp, (Object)WCFTag.DLBM.name()));
                if (tmp.containsKey(WCFTag.DLMC.name())) {
                    detailMap.put("DLMC", MapUtils.getString((Map)tmp, (Object)WCFTag.DLMC.name()));
                } else {
                    detailMap.put("DLMC", EnumUtils.findByDlbm((String)MapUtils.getString((Map)tmp, (Object)WCFTag.DLBM.name())));
                }
                detailMap.put("QSXZ", MapUtils.getString((Map)tmp, (Object)WCFTag.QSXZ.name()));
                detailList.add(detailMap);
            }
            for (Object key : dlbmSummary.keySet()) {
                String dlbm = String.valueOf(key).substring(4);
                area = MapUtils.getDouble((Map)dlbmSummary, (Object)key, (Double)0.0);
                if (area <= 0.0) continue;
                analysisArea.put(EnumUtils.findByDlbm((String)dlbm), area);
            }
            HashMap<String, Cloneable> result = new HashMap<String, Cloneable>();
            result.put("analysisAreaDetail", detailList);
            result.put("analysisArea", analysisArea);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public Map tdlyxzAnalysisByWcf(String geometry, String year, String datasSource) {
        String dltb = TDXZ.DLTB.name().concat("_H_").concat(year);
        String xzdw = TDXZ.XZDW.name().concat("_H_").concat(year);
        return this.tdlyxzAnalysisByWcf(geometry, dltb, xzdw, datasSource);
    }

    public String getDlmc(List<Map> list, String dm) {
        for (Map entry : list) {
            String dlbm = MapUtils.getString((Map)entry, (Object)"DLBM");
            if (!dlbm.equals(dm)) continue;
            return MapUtils.getString((Map)entry, (Object)"DLMC");
        }
        return dm;
    }

    public List<?> tdghscAnalysis(String layerType, String regionCode, String geometry, String[] outFields, String dataSource) {
        if (StringUtils.isBlank((String)layerType)) {
            throw new RuntimeException(this.getMessage("layer.type.notnull", new Object[0]));
        }
        String layerName = layerType.concat("_E_").concat(Utils.formatRegionCode((String)regionCode));
        SeLayer layer = this.spatialDao.detectLayer(layerName, dataSource);
        if (layer == null) {
            this.logger.error(this.getMessage("analysis.tdghsc.layer.not.found", new Object[]{layerName}));
            return null;
        }
        return this.intersect3(layerName, geometry, outFields, dataSource);
    }

    public Map tdghscAnalysis(String regionCode, String geometry, String[] outFields, String dataSource) {
        HashMap<String, List> result = new HashMap<String, List>();
        for (GHSC item : GHSC.values()) {
            result.put(GHSC.access$200((GHSC)item), this.tdghscAnalysis(item.name(), regionCode, geometry, outFields, dataSource));
        }
        return result;
    }

    public String tdghscAnalysis2(String layerType, String regionCode, String geometry, String[] outFields, String dataSource) {
        List result = this.tdghscAnalysis(layerType, regionCode, geometry, outFields, dataSource);
        FeatureCollection collection = this.geometryService.list2FeatureCollection(result, null, null);
        return this.geometryService.toFeatureJSON((Object)collection);
    }

    public Map tdghscAnalysis2(String regionCode, String geometry, String[] outFields, String dataSource) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (GHSC item : GHSC.values()) {
            result.put(GHSC.access$200((GHSC)item), this.tdghscAnalysis2(item.name(), regionCode, geometry, outFields, dataSource));
        }
        return result;
    }

    public Map tdghscResult(Map analysisResult) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        ArrayList detailList = new ArrayList();
        try {
            for (GHSC item : GHSC.values()) {
                ArrayList list = new ArrayList();
                HashMap<String, Object> total = new HashMap<String, Object>();
                HashMap ghMap = new HashMap();
                double totalArea = 0.0;
                JSONObject singleObj = JSON.parseObject((String)analysisResult.get(GHSC.access$200((GHSC)item)).toString());
                JSONArray features = JSON.parseArray((String)singleObj.get((Object)"features").toString());
                if (features == null || features.size() <= 0) continue;
                totalArea = this.getTotalArea(features);
                total.put("LXMC", "\u5730\u5757\u603b\u9762\u79ef");
                total.put("AREA", totalArea);
                list.add(total);
                switch (item.ordinal()) {
                    case 0: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.TDYTQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TDYTQLXDM", features, tDYTQ.getLxdm(), false);
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap<String, Object>();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap<String, String>();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TDYTQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TDYTQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                for (Object key : properties.keySet()) {
                                    if (!String.valueOf(key).startsWith("OG_PRO_")) continue;
                                    detailMap.put((String)key, (String)properties.get(key));
                                }
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            detailList.addAll(detail);
                            list.add(temp);
                            this.logger.debug(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 1: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.JSYDGZQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("GZQLXDM", features, tDYTQ.getLxdm(), true);
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("GZQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("GZQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                for (Object key : properties.keySet()) {
                                    if (!String.valueOf(key).startsWith("OG_PRO_")) continue;
                                    detailMap.put((String)key, (String)properties.get(key));
                                }
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            detailList.addAll(detail);
                            list.add(temp);
                            this.logger.debug(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 2: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.GHJBNTTZ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TZLXDM", features, tDYTQ.getLxdm(), false);
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TZLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TZLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                for (Object key : properties.keySet()) {
                                    if (!String.valueOf(key).startsWith("OG_PRO_")) continue;
                                    detailMap.put((String)key, (String)properties.get(key));
                                }
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            detailList.addAll(detail);
                            list.add(temp);
                            this.logger.debug(tDYTQ.name());
                        }
                        break;
                    }
                    case 3: {
                        Map properties;
                        JSONObject feature;
                        LinkedHashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.MZZDJSXM.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("XMLXDM", features, tDYTQ.getLxdm(), false);
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("XMLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("XMLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                for (Object key : properties.keySet()) {
                                    if (!String.valueOf(key).startsWith("OG_PRO_")) continue;
                                    detailMap.put((String)key, (String)properties.get(key));
                                }
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            detailList.addAll(detail);
                            list.add(temp);
                            this.logger.debug(tDYTQ.getLxdm());
                        }
                        break;
                    }
                }
                ghMap.put("info", list);
                resultMap.put(GHSC.access$200((GHSC)item), ghMap);
            }
            if (detailList.size() > 0) {
                resultMap.put("detail", JSON.toJSONString(detailList));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return resultMap;
    }

    public Map tdghscResult(String layerType, String analysisResult) {
        HashMap resultMap = new HashMap();
        try {
            JSONObject fc = JSON.parseObject((String)analysisResult);
            JSONArray features = (JSONArray)fc.get((Object)"features");
            ArrayList list = new ArrayList();
            HashMap<String, Object> total = new HashMap<String, Object>();
            HashMap ghMap = new HashMap();
            double totalArea = 0.0;
            totalArea = this.getTotalArea(features);
            total.put("LXMC", "\u5730\u5757\u603b\u9762\u79ef");
            total.put("AREA", totalArea);
            list.add(total);
            for (GHSC item : GHSC.values()) {
                if (!item.name().equals(layerType)) continue;
                switch (item.ordinal()) {
                    case 0: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.TDYTQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TDYTQLXDM", features, tDYTQ.getLxdm(), false);
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap<String, Object>();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new HashMap<String, String>();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TDYTQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TDYTQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.debug(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 1: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.JSYDGZQ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("GZQLXDM", features, tDYTQ.getLxdm(), true);
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("GZQLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("GZQLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.debug(tDYTQ.name() + area);
                        }
                        break;
                    }
                    case 2: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.GHJBNTTZ.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("TZLXDM", features, tDYTQ.getLxdm(), false);
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("TZLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("TZLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.debug(tDYTQ.name());
                        }
                        break;
                    }
                    case 3: {
                        Map properties;
                        JSONObject feature;
                        HashMap<String, String> detailMap;
                        int i;
                        HashMap<String, Object> temp;
                        double per;
                        double area;
                        ArrayList detail;
                        for (EnumUtils.TDYTQ tDYTQ : EnumUtils.MZZDJSXM.values()) {
                            detail = new ArrayList();
                            area = this.getAreaByLxdm("XMLXDM", features, tDYTQ.getLxdm(), false);
                            per = 0.0;
                            if (totalArea > 0.0) {
                                per = area / totalArea * 100.0;
                            }
                            temp = new HashMap();
                            temp.put("LXMC", tDYTQ.name());
                            temp.put("AREA", area);
                            temp.put("PER", per);
                            for (i = 0; i < features.size(); ++i) {
                                detailMap = new LinkedHashMap();
                                feature = (JSONObject)features.get(i);
                                properties = (Map)feature.get((Object)"properties");
                                if (!tDYTQ.getLxdm().equals(properties.get("XMLXDM"))) continue;
                                detailMap.put("\u7c7b\u578b\u540d\u79f0", tDYTQ.name());
                                detailMap.put("\u7c7b\u578b\u4ee3\u7801", (String)properties.get("XMLXDM"));
                                detailMap.put("\u5730\u5757\u9762\u79ef", (String)properties.get("OG_SHAPE_AREA"));
                                detailMap.put("\u6807\u8bc6\u7801", (String)properties.get("BSM"));
                                detailMap.put("\u9762\u79ef", (String)properties.get("SHAPE_AREA"));
                                detail.add(detailMap);
                            }
                            temp.put("detail", detail);
                            list.add(temp);
                            this.logger.debug(tDYTQ.getLxdm());
                        }
                        break;
                    }
                }
                ghMap.put("info", list);
                resultMap.put(GHSC.access$200((GHSC)item), ghMap);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return resultMap;
    }

    public LinkedHashMap tdghscExcelData(Map result) {
        LinkedHashMap map = new LinkedHashMap();
        for (Object key : result.keySet()) {
            if ("detail".equals(key)) continue;
            ArrayList list = new ArrayList();
            List keyList = (List)((Map)result.get(key)).get("info");
            for (int i = 1; i < keyList.size(); ++i) {
                Map temp = (Map)keyList.get(i);
                ArrayList<Object> tempList = new ArrayList<Object>();
                tempList.add(temp.get("LXMC"));
                tempList.add(Math.round(Double.valueOf(temp.get("AREA").toString())));
                list.add(tempList);
            }
            map.put(key, list);
        }
        return map;
    }

    public LinkedHashMap multiExcelData(Map<String, Map> data) {
        LinkedHashMap excelMap = new LinkedHashMap();
        DecimalFormat df = new DecimalFormat("0.####");
        for (String key : data.keySet()) {
            ArrayList<List> list = new ArrayList<List>();
            ArrayList headerList = new ArrayList();
            Map aMap = data.get(key);
            String alias = MapUtils.getString((Map)aMap, (Object)"alias");
            if (EnumUtils.MULTI_ANALYZE_TYPE.bp.name().equals(key.toString()) || EnumUtils.MULTI_ANALYZE_TYPE.gd.name().equals(key.toString())) {
                Map bpmap = (Map)aMap.get("result");
                List bpTotal = (List)bpmap.get("info");
                List bpDesc = (List)bpmap.get("detail");
                ArrayList list2 = new ArrayList();
                for (int i = 0; i < bpTotal.size(); ++i) {
                    Map temp1 = (Map)bpTotal.get(i);
                    ArrayList<Object> tempList = new ArrayList<Object>();
                    tempList.add(temp1.get("type"));
                    tempList.add(df.format(Double.valueOf(temp1.get("area").toString())));
                    tempList.add(df.format(Double.valueOf(temp1.get("area_gq").toString())));
                    tempList.add(df.format(Double.valueOf(temp1.get("area_m").toString())));
                    list.add(tempList);
                }
                if (bpDesc.size() > 0) {
                    Map headMap = (Map)bpDesc.get(0);
                    for (Object k : headMap.keySet()) {
                        headerList.add(k);
                    }
                    list2.add(headerList);
                    for (int i = 0; i < bpDesc.size(); ++i) {
                        Map temp2 = (Map)bpDesc.get(i);
                        ArrayList<String> tempList = new ArrayList<String>();
                        for (Object fieldkey : temp2.keySet()) {
                            Object value = temp2.get(fieldkey);
                            if (value instanceof Double) {
                                tempList.add(df.format(MapUtils.getDoubleValue((Map)temp2, fieldkey, (double)0.0)));
                                continue;
                            }
                            tempList.add((String)temp2.get(fieldkey));
                        }
                        list2.add(tempList);
                    }
                }
                if ("bp".equals(key.toString())) {
                    excelMap.put("\u62a5\u6279\u6c47\u603b", list);
                    excelMap.put("\u62a5\u6279\u8be6\u60c5", list2);
                    continue;
                }
                excelMap.put("\u4f9b\u5730\u6c47\u603b", list);
                excelMap.put("\u4f9b\u5730\u8be6\u60c5", list2);
                continue;
            }
            List keyList = new ArrayList();
            Object obj = aMap.get("result");
            if (obj instanceof Map) {
                keyList = (List)((Map)obj).get("detail");
            } else if (obj instanceof List) {
                keyList = (List)obj;
            }
            if (keyList.size() == 0) {
                return excelMap;
            }
            headerList.addAll(ArrayUtils.mapConvertList((Map)((Map)keyList.get(0)), (ArrayUtils.TYPE)ArrayUtils.TYPE.key));
            list.add(headerList);
            for (int i = 0; i < keyList.size(); ++i) {
                Map temp = (Map)keyList.get(i);
                list.add(ArrayUtils.mapConvertList((Map)temp, (ArrayUtils.TYPE)ArrayUtils.TYPE.value));
            }
            excelMap.put(alias, list);
        }
        return excelMap;
    }

    public List<Map> tdlyxzResult(Map analysisResult, String tpl, String unit) {
        ArrayList<Map> resultList = new ArrayList<Map>();
        double conv = 1.0;
        if (!this.isNull((Object)unit)) {
            if (unit.equalsIgnoreCase(UNITS.ACRES.name())) {
                conv = UNITS.access$000((UNITS)UNITS.ACRES);
            } else if (unit.equalsIgnoreCase(UNITS.HECTARE.name())) {
                conv = UNITS.access$000((UNITS)UNITS.HECTARE);
            }
        }
        try {
            List detailList;
            if (!(this.isNull((Object)analysisResult) || analysisResult.isEmpty() || this.isNull((Object)(detailList = (List)analysisResult.get("analysisAreaDetail"))) || detailList.size() <= 0)) {
                ArrayList dwdmList = new ArrayList();
                for (int i = 0; i < detailList.size(); ++i) {
                    HashMap<String, Object> temp = new HashMap<String, Object>();
                    ArrayList<Map> arrayList = new ArrayList<Map>();
                    boolean tag = false;
                    Map map = (Map)detailList.get(i);
                    String zldwdm = MapUtils.getString((Map)map, (Object)"ZLDWDM", (String)"");
                    String zldwmc = MapUtils.getString((Map)map, (Object)"ZLDWMC", (String)"");
                    String qsdwmc = MapUtils.getString((Map)map, (Object)"QSDWMC", (String)"");
                    String qsdwdm = MapUtils.getString((Map)map, (Object)"QSDWDM", (String)"");
                    String xzqdm = "";
                    xzqdm = zldwdm.length() > 12 ? zldwdm.substring(0, 12) : zldwdm;
                    if (xzqdm.indexOf("error") > -1) continue;
                    arrayList.add(map);
                    temp.put("xzqdm", xzqdm);
                    temp.put("xzqmc", zldwmc);
                    temp.put("detail", arrayList);
                    temp.put("qsdwmc", qsdwmc);
                    temp.put("qsdwdm", qsdwdm);
                    if (dwdmList.size() > 0) {
                        for (Map map2 : dwdmList) {
                            if (!map2.get("xzqdm").toString().equals(xzqdm)) continue;
                            List tempList = (List)map2.get("detail");
                            tempList.add(map);
                            map2.put("detail", tempList);
                            tag = true;
                        }
                    }
                    if (tag) continue;
                    dwdmList.add(temp);
                }
                List dictList = this.getTdlyxzDictList(tpl);
                for (Map map : dwdmList) {
                    Map dlList = ArrayUtils.listConvertMap((List)((List)map.get("detail")), (String)"DLBM");
                    ArrayList dlbms = new ArrayList();
                    for (Map.Entry entry : dlList.entrySet()) {
                        String key = String.valueOf(entry.getKey()).trim();
                        List maps = (List)entry.getValue();
                        HashMap<String, Object> dlMap = new HashMap<String, Object>();
                        dlMap.put("dlbm", key);
                        dlMap.put("area", this.getDouValueByField(maps, "CCMJ") * conv);
                        dlMap.put("area_jt", this.getSumByQueryField(maps, "QSXZ", Arrays.asList("30", "31", "32", "33", "34", "40"), "CCMJ") * conv);
                        dlMap.put("area_gy", this.getSumByQueryField(maps, "QSXZ", Arrays.asList("10", "20"), "CCMJ") * conv);
                        dlbms.add(dlMap);
                    }
                    HashMap<String, Object> resultMap = new HashMap<String, Object>();
                    resultMap.put("xzqmc", MapUtils.getString((Map)map, (Object)"xzqmc"));
                    resultMap.put("xzqdm", MapUtils.getString((Map)map, (Object)"xzqdm"));
                    resultMap.put("qsdwdm", MapUtils.getString((Map)map, (Object)"qsdwdm"));
                    resultMap.put("qsdwmc", MapUtils.getString((Map)map, (Object)"qsdwmc"));
                    resultMap.put("sumArea", this.getDouValueByField(dlbms, "area"));
                    resultMap.put("sumAreaJt", this.getDouValueByField(dlbms, "area_jt"));
                    resultMap.put("sumAreaGy", this.getDouValueByField(dlbms, "area_gy"));
                    resultMap.put("categoryA", AnalysisUtils.getTdlyCategoryByGrade(dlbms, (List)dictList, (AnalysisUtils.TDLYXZ_GRADE)AnalysisUtils.TDLYXZ_GRADE.valueOf((String)"A")));
                    resultMap.put("categoryB", AnalysisUtils.getTdlyCategoryByGrade(dlbms, (List)dictList, (AnalysisUtils.TDLYXZ_GRADE)AnalysisUtils.TDLYXZ_GRADE.valueOf((String)"B")).get(0));
                    resultList.add(resultMap);
                }
                HashMap<String, Object> totalMap = new HashMap<String, Object>();
                totalMap.put("xzqmc", "\u5408\u8ba1");
                totalMap.put("xzqdm", "\u5408\u8ba1");
                totalMap.put("qsdwdm", "\u5408\u8ba1");
                totalMap.put("qsdwmc", "\u5408\u8ba1");
                double d = 0.0;
                double sumJt = 0.0;
                double sumGy = 0.0;
                for (Map item : resultList) {
                    d += MapUtils.getDoubleValue((Map)item, (Object)"sumArea", (double)0.0);
                    sumJt += MapUtils.getDoubleValue((Map)item, (Object)"sumAreaJt", (double)0.0);
                    sumGy += MapUtils.getDoubleValue((Map)item, (Object)"sumAreaGy", (double)0.0);
                }
                totalMap.put("sumArea", d);
                totalMap.put("sumAreaJt", sumJt);
                totalMap.put("sumAreaGy", sumGy);
                totalMap.put("categoryA", this.getSumCategoryA(resultList));
                totalMap.put("categoryB", this.getSumCategoryB(resultList));
                resultList.add(totalMap);
            }
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("analysis.tdlyxz.parse.error", new Object[]{e.getLocalizedMessage()}));
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return resultList;
    }

    public Map tdlyxzReport(Map totalMap, Map report) {
        assert (totalMap != null);
        assert (report != null);
        try {
            HashMap<String, Double> result = new HashMap<String, Double>();
            Map sumB = (Map)totalMap.get("categoryB");
            double aSumArea = MapUtils.getDoubleValue((Map)totalMap, (Object)"sumArea", (double)0.0);
            double aNydArea = MapUtils.getDoubleValue((Map)sumB, (Object)"\u519c\u7528\u5730", (double)0.0);
            double aGdArea = MapUtils.getDoubleValue((Map)sumB, (Object)"01", (double)0.0);
            double aJsydArea = MapUtils.getDoubleValue((Map)sumB, (Object)"\u5efa\u8bbe\u7528\u5730", (double)0.0);
            double aWlydArea = MapUtils.getDoubleValue((Map)sumB, (Object)"\u672a\u5229\u7528\u5730", (double)0.0);
            double rSumArea = MapUtils.getDoubleValue((Map)report, (Object)"area", (double)0.0);
            double rNydArea = MapUtils.getDoubleValue((Map)report, (Object)"nydArea", (double)0.0);
            double rGdArea = MapUtils.getDoubleValue((Map)report, (Object)"gdArea", (double)0.0);
            double rJsydArea = MapUtils.getDoubleValue((Map)report, (Object)"jsydArea", (double)0.0);
            double rWlydArea = MapUtils.getDoubleValue((Map)report, (Object)"wlydArea", (double)0.0);
            result.put("rArea", rSumArea);
            result.put("rNydArea", rNydArea);
            result.put("rGdArea", rGdArea);
            result.put("rJsydArea", rJsydArea);
            result.put("rWlydArea", rWlydArea);
            result.put("sumResult", (rSumArea - aSumArea) * 10000.0);
            result.put("nydResult", (rNydArea - aNydArea) * 10000.0);
            result.put("gdResult", (rGdArea - aGdArea) * 10000.0);
            result.put("jsydResult", (rJsydArea - aJsydArea) * 10000.0);
            result.put("wlydResult", (rWlydArea - aWlydArea) * 10000.0);
            result.put("sumMistake", rSumArea - aSumArea == 0.0 ? 0.0 : (rSumArea - aSumArea) / rSumArea);
            result.put("nydMistake", rNydArea - aNydArea == 0.0 ? 0.0 : (rNydArea - aNydArea) / rNydArea);
            result.put("gdMistake", rGdArea - aGdArea == 0.0 ? 0.0 : (rGdArea - aGdArea) / rGdArea);
            result.put("jsydMistake", rJsydArea - aJsydArea == 0.0 ? 0.0 : (rJsydArea - aJsydArea) / rJsydArea);
            result.put("wlydMistake", rWlydArea - aWlydArea == 0.0 ? 0.0 : (rWlydArea - aWlydArea) / rWlydArea);
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public List<LinkedHashMap> analysisExcelData(List list) {
        ArrayList<LinkedHashMap> result = new ArrayList<LinkedHashMap>();
        for (int i = 0; i < list.size(); ++i) {
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            ArrayList<Object> headerList = new ArrayList<Object>();
            ArrayList dataList = new ArrayList();
            JSONObject obj = (JSONObject)list.get(i);
            JSONArray children = (JSONArray)obj.get((Object)"children");
            for (int j = 0; j < children.size(); ++j) {
                JSONArray child = (JSONArray)children.get(j);
                ArrayList<Object> temp = new ArrayList<Object>();
                for (int m = 0; m < child.size(); ++m) {
                    JSONObject field = (JSONObject)child.get(m);
                    if (j == 0) {
                        headerList.add(field.get((Object)"alias") == null ? field.get((Object)"name") : field.get((Object)"alias"));
                    }
                    if (field.get((Object)"value") instanceof BigDecimal) {
                        temp.add(this.processValue(Double.valueOf(((BigDecimal)field.get((Object)"value")).doubleValue()), 3));
                        continue;
                    }
                    temp.add(field.get((Object)"value"));
                }
                dataList.add(temp);
            }
            map.put("name", obj.get((Object)"alias"));
            map.put("header", headerList);
            map.put("data", dataList);
            result.add(map);
        }
        return result;
    }

    public List<LinkedHashMap> analysisExcelList(List list) {
        ArrayList<LinkedHashMap> result = new ArrayList<LinkedHashMap>();
        LinkedHashMap<String, Object> sheetMap = new LinkedHashMap<String, Object>();
        ArrayList<Object> headerList = new ArrayList<Object>();
        ArrayList dataList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            Map item = (Map)list.get(i);
            JSONArray children = (JSONArray)item.get("children");
            for (int j = 0; j < children.size(); ++j) {
                List child = (List)children.get(j);
                ArrayList<Object> temp = new ArrayList<Object>();
                for (int m = 0; m < child.size(); ++m) {
                    JSONObject field = (JSONObject)child.get(m);
                    if (i == 0 && j == 0) {
                        headerList.add(field.get((Object)"alias") == null ? field.get((Object)"name") : field.get((Object)"alias"));
                    }
                    if (field.get((Object)"value") instanceof BigDecimal) {
                        temp.add(this.processValue(Double.valueOf(((BigDecimal)field.get((Object)"value")).doubleValue()), 3));
                        continue;
                    }
                    temp.add(field.get((Object)"value"));
                }
                dataList.add(temp);
            }
        }
        sheetMap.put("name", "sheet1");
        sheetMap.put("header", headerList);
        sheetMap.put("data", dataList);
        result.add(sheetMap);
        return result;
    }

    public List<Map> gzqydExcelData(List list) {
        try {
            ArrayList<Map> result = new ArrayList<Map>();
            for (int i = 0; i < list.size(); ++i) {
                HashMap<String, Object> tempMap = new HashMap<String, Object>();
                ArrayList tempList = new ArrayList();
                Map item = (Map)list.get(0);
                List values = (List)item.get("value");
                for (Map value : values) {
                    ArrayList<Object> temp = new ArrayList<Object>(8);
                    temp.add(0, String.valueOf(value.get("OG_PRO_XZQMC")));
                    temp.add(1, String.valueOf(value.get("OG_PRO_REGIONCODE")));
                    temp.add(2, String.valueOf(value.get("OG_PRO_PRONAME")));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("011"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("012"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("020"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("030"))));
                    temp.add(3, Double.valueOf(String.valueOf(value.get("040"))));
                    tempList.add(temp);
                }
                tempMap.put("value", tempList);
                tempMap.put("type", (String)item.get("type"));
                result.add(tempMap);
            }
            return result;
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public List<Map> getSumCategoryA(List<Map> list) {
        assert (list != null);
        ArrayList result = null;
        if (list.size() > 0) {
            result = new ArrayList();
            List firstList = (List)list.get(0).get("categoryA");
            for (Map map : firstList) {
                HashMap temp = new HashMap();
                temp.put("dlbm", map.get("dlbm"));
                temp.put("dlmc", map.get("dlmc"));
                temp.put("area", 0);
                temp.put("area_jt", 0);
                temp.put("area_gy", 0);
                for (Map item : list) {
                    List groupList = (List)item.get("categoryA");
                    for (Map groupMap : groupList) {
                        if (!temp.get("dlmc").equals(groupMap.get("dlmc"))) continue;
                        temp.put("area", MapUtils.getDouble(temp, (Object)"area", (Double)0.0) + MapUtils.getDouble((Map)groupMap, (Object)"area", (Double)0.0));
                        temp.put("area_jt", MapUtils.getDoubleValue(temp, (Object)"area_jt", (double)0.0) + MapUtils.getDoubleValue((Map)groupMap, (Object)"area_jt", (double)0.0));
                        temp.put("area_gy", MapUtils.getDoubleValue(temp, (Object)"area_gy", (double)0.0) + MapUtils.getDoubleValue((Map)groupMap, (Object)"area_gy", (double)0.0));
                    }
                }
                result.add(temp);
            }
        }
        return result;
    }

    public Map getSumCategoryB(List<Map> list) {
        assert (list != null);
        HashMap result = null;
        if (list.size() > 0) {
            result = new HashMap();
            for (Map item : list) {
                Map categoryB = (Map)item.get("categoryB");
                for (Object key : categoryB.keySet()) {
                    result.put(key, MapUtils.getDouble(result, key, (Double)0.0) + MapUtils.getDouble((Map)categoryB, key, (Double)0.0));
                }
            }
        }
        return result;
    }

    public double processValue(Double value, int precision) {
        switch (precision) {
            case 1: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
            case 2: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
            case 3: {
                return (double)Math.round(value * 100.0) / 100.0;
            }
        }
        return Math.round(value * 100.0) / 100L;
    }

    public List search(String value, boolean returnGeometry) {
        if (this.searchConfig == null) {
            throw new RuntimeException(this.getMessage("search.config.not.found", new Object[0]));
        }
        ArrayList result = new ArrayList();
        List layers = (List)this.searchConfig.get("layers");
        for (Map layer : layers) {
            String name = (String)layer.get("layer");
            String[] fields = ((String)layer.get("fields")).split(",");
            String where = this.getWhereClause(fields, value);
            result.addAll(this.spatialDao.query(name, where, fields, returnGeometry, 10, null));
        }
        return result;
    }

    public InputStream exportMap(String where, String mapScale, int width, int height, String type) {
        ByteArrayInputStream inputStream;
        Graphics2D graphics2D;
        if (this.exportConfig == null) {
            this.logger.info("\u65e0\u914d\u7f6e\u4fe1\u606f");
            return null;
        }
        int bgWidth = width + 10;
        int bgHeight = height + 10;
        String imageSize = width + "," + height;
        double scale = 0.0;
        if (StringUtils.isNotBlank((String)mapScale)) {
            scale = Double.valueOf(mapScale);
        }
        ArrayList<BufferedImage> baseImages = new ArrayList<BufferedImage>();
        BufferedImage topImage = null;
        BufferedImage resultImage = new BufferedImage(width, height, 4);
        ReferencedEnvelope envelope = null;
        Map operaLayer = (Map)this.exportConfig.get("operaLayer");
        List ghLayers = (List)this.exportConfig.get("ghLayers");
        List xzLayers = (List)this.exportConfig.get("xzLayers");
        String layerName = (String)operaLayer.get("layerName");
        String dataSource = (String)operaLayer.get("dataSource");
        String url = (String)operaLayer.get("url");
        List list = this.query(layerName, where, null, true, dataSource);
        if (list.size() > 0) {
            BufferedImage tempImage2;
            FeatureCollection featureCollection = this.geometryService.list2FeatureCollection(list, null, null);
            envelope = featureCollection.getBounds();
            topImage = this.getExportImage((Envelope)envelope, url, imageSize, scale);
            if (type.equals("gh")) {
                for (Map item : ghLayers) {
                    tempImage2 = this.getExportImage((Envelope)envelope, (String)item.get("url"), bgWidth + "," + bgHeight, scale);
                    baseImages.add(tempImage2);
                }
            } else if (type.equals("xz")) {
                for (Map item : xzLayers) {
                    tempImage2 = this.getExportImage((Envelope)envelope, (String)item.get("url"), bgWidth + "," + bgHeight, scale);
                    baseImages.add(tempImage2);
                }
            } else {
                this.logger.error("type is not found");
            }
            graphics2D = resultImage.createGraphics();
            resultImage = graphics2D.getDeviceConfiguration().createCompatibleImage(width, height, 3);
            graphics2D.dispose();
            graphics2D = resultImage.createGraphics();
            if (baseImages.size() > 0) {
                for (BufferedImage tempImage2 : baseImages) {
                    graphics2D.drawImage(tempImage2, 0, 0, tempImage2.getWidth(), tempImage2.getHeight(), null);
                }
            }
        } else {
            this.logger.info("\u672a\u67e5\u8be2\u5230\u5730\u5757!");
            return null;
        }
        graphics2D.drawImage(topImage, 0, 0, topImage.getWidth(), topImage.getHeight(), null);
        graphics2D.dispose();
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)resultImage, "png", out);
            inputStream = new ByteArrayInputStream(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return inputStream;
    }

    public Map ghscxgData(List<Map> data, List<Map> fields) {
        HashMap result = new HashMap();
        ArrayList<Map> showResult = new ArrayList<Map>();
        HashMap excelResult = new HashMap();
        ArrayList sheet = new ArrayList();
        try {
            ArrayList<Object> headerList = new ArrayList<Object>();
            ArrayList dataList = new ArrayList();
            for (int i = 0; i < fields.size(); ++i) {
                headerList.add(fields.get(i).get("alias"));
            }
            for (Map map : data) {
                ArrayList<Object> list = new ArrayList<Object>();
                for (Map f : fields) {
                    String type;
                    if (f.containsKey("type") && (type = (String)f.get("type")).toLowerCase().equals("date")) {
                        String val = MapUtils.getString((Map)map, f.get("name"));
                        if (val.indexOf("T") > 0) {
                            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'");
                            Date date = simpleDateFormat.parse(val);
                            map.put(f.get("name"), sdf.format(date));
                        } else {
                            map.put(f.get("name"), DateFormat.getDateInstance().format(val));
                        }
                    }
                    list.add(this.isNull(map.get(f.get("name"))) ? "" : map.get(f.get("name")));
                }
                list.add(0, data.indexOf(map) + 1);
                double area = MapUtils.getDouble((Map)map, (Object)"SHAPE_AREA");
                list.add(area);
                list.add(area * 1.0E-4);
                showResult.add(map);
                dataList.add(list);
            }
            headerList.add(0, "ID");
            headerList.add("\u91cd\u53e0\u9762\u79ef\uff08\u5e73\u65b9\u7c73\uff09");
            headerList.add("\u91cd\u53e0\u9762\u79ef\uff08\u516c\u9877\uff09");
            excelResult.put("header", headerList);
            excelResult.put("data", dataList);
            sheet.add(excelResult);
            result.put("excel", sheet);
            result.put("result", showResult);
            return result;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public LinkedHashMap<String, Object> multiAnalyze(List<Map> multiParams, String geometry, String level, String tpl) {
        if (this.isNull(multiParams)) {
            throw new RuntimeException("params cannot be null");
        }
        if (this.isNull((Object)geometry)) {
            throw new RuntimeException("geometry cannot be null");
        }
        LinkedHashMap<String, Object> analysisResult = new LinkedHashMap<String, Object>();
        try {
            HashMap<String, String> layerMap = new HashMap<String, String>();
            for (Map paraMap : multiParams) {
                FeatureCollection fc;
                String[] fields;
                Map map;
                String funid = MapUtils.getString((Map)paraMap, (Object)"funid");
                Boolean isOpen = MapUtils.getBoolean((Map)paraMap, (Object)"visible", (Boolean)false);
                String alias = paraMap.containsKey("alias") ? MapUtils.getString((Map)paraMap, (Object)"alias") : MapUtils.getString((Map)this.analysisAliasMap, (Object)funid);
                String condition = MapUtils.getString((Map)paraMap, (Object)"condition", null);
                if (paraMap.containsKey("layerName")) {
                    layerMap.put(funid, MapUtils.getString((Map)paraMap, (Object)"layerName"));
                }
                if (!isOpen.booleanValue()) continue;
                String dataSource = MapUtils.getString((Map)paraMap, (Object)"dataSource");
                HashMap<String, Object> singleResult = new HashMap<String, Object>();
                singleResult.put("alias", alias);
                if (EnumUtils.MULTI_ANALYZE_TYPE.xz.name().equals(funid)) {
                    map = new HashMap();
                    String dltb = MapUtils.getString((Map)paraMap, (Object)"dltb");
                    String xzdw = MapUtils.getString((Map)paraMap, (Object)"xzdw");
                    Boolean exportable = MapUtils.getBoolean((Map)paraMap, (Object)"exportable", (Boolean)false);
                    List<Map> xzResult = new ArrayList();
                    if (EnumUtils.MULTI_ANALYZE_LEVEL.mas.name().equalsIgnoreCase(level)) {
                        Object analysisGeo = this.geometryService.readUnTypeGeoJSON(geometry);
                        if (analysisGeo instanceof SimpleFeature) {
                            map = this.tdlyxzAnalysis2(dltb, xzdw, geometry, dataSource);
                            Map rMap = this.processTdlyxzResultMas(map, tpl);
                            rMap.put("xzqmc", "\u5730\u57571");
                            xzResult.add(rMap);
                        } else if (analysisGeo instanceof FeatureCollection) {
                            FeatureIterator iterator = ((FeatureCollection)analysisGeo).features();
                            int i = 0;
                            while (iterator.hasNext()) {
                                SimpleFeature feature = (SimpleFeature)iterator.next();
                                map = this.tdlyxzAnalysis2(dltb, xzdw, this.geometryService.toFeatureJSON((Object)feature), dataSource);
                                Map rMap = this.processTdlyxzResultMas(map, tpl);
                                rMap.put("xzqmc", "\u5730\u5757".concat(Integer.toString(++i)));
                                xzResult.add(rMap);
                            }
                        }
                        if (this.isNotNull(xzResult) && xzResult.size() > 1) {
                            HashMap<String, Object> totalMap = new HashMap<String, Object>();
                            totalMap.put("xzqmc", "\u5408\u8ba1");
                            double sumArea = 0.0;
                            double sumJt = 0.0;
                            double sumGy = 0.0;
                            for (Map map2 : xzResult) {
                                sumArea += MapUtils.getDoubleValue((Map)map2, (Object)"sumArea", (double)0.0);
                                sumJt += MapUtils.getDoubleValue((Map)map2, (Object)"sumAreaJt", (double)0.0);
                                sumGy += MapUtils.getDoubleValue((Map)map2, (Object)"sumAreaGy", (double)0.0);
                            }
                            totalMap.put("sumArea", sumArea);
                            totalMap.put("sumAreaJt", sumJt);
                            totalMap.put("sumAreaGy", sumGy);
                            totalMap.put("categoryA", this.getSumCategoryA(xzResult));
                            totalMap.put("categoryB", this.getSumCategoryB(xzResult));
                            xzResult.add(totalMap);
                        }
                    } else {
                        map = this.tdlyxzAnalysis2(dltb, xzdw, geometry, dataSource);
                        xzResult = this.tdlyxzResult(map, tpl, null);
                    }
                    if (exportable.booleanValue() && !this.isNull((Object)dltb)) {
                        FeatureCollection featureCollection;
                        File shpFile;
                        List detail = (List)map.get("analysisAreaDetail");
                        ArrayList<Map> exportData = new ArrayList<Map>();
                        for (Map item : detail) {
                            String wkt = MapUtils.getString((Map)item, (Object)"SHAPE");
                            if (this.geometryService.readWKT(wkt) instanceof MultiLineString) continue;
                            exportData.add(item);
                        }
                        if (exportData.size() > 0 && (shpFile = this.geometryService.exportToShp(this.geometryService.toFeatureJSON((Object)(featureCollection = this.geometryService.list2FeatureCollection(exportData, null, null))), this.getLayerCRS(dltb, dataSource))).exists()) {
                            FileStore fileStore = this.fileStoreService.save3(shpFile, UUIDHexGenerator.generate());
                            singleResult.put("shpId", fileStore.getId());
                        }
                    }
                    singleResult.put("result", xzResult);
                    singleResult.put("unit", null);
                    singleResult.put("totalResult", xzResult.size() > 0 ? (Map)xzResult.get(xzResult.size() - 1) : new HashMap());
                    HashMap<String, Object> excelMap = new HashMap<String, Object>();
                    excelMap.put("result", xzResult);
                    excelMap.put("unit", "SQUARE");
                    singleResult.put("resultStr", JSON.toJSONString(excelMap));
                    analysisResult.put(funid, singleResult);
                    continue;
                }
                if (EnumUtils.MULTI_ANALYZE_TYPE.gh.name().equals(funid)) {
                    map = new HashMap();
                    String regionCode = "";
                    String layerType = MapUtils.getString((Map)paraMap, (Object)"layerType");
                    String outFields = this.isNull((Object)MapUtils.getString((Map)paraMap, (Object)"outFields")) ? "*" : MapUtils.getString((Map)paraMap, (Object)"outFields");
                    String[] fields2 = "*".equals(outFields) ? null : outFields.split(",");
                    String year = MapUtils.getString((Map)paraMap, (Object)"year");
                    if (StringUtils.isNotBlank((String)year)) {
                        regionCode = year;
                    }
                    if (StringUtils.isNotBlank((String)layerType)) {
                        String tdghResult = this.tdghscAnalysis2(layerType, regionCode, geometry, fields2, dataSource);
                        map = this.tdghscResult(layerType, tdghResult);
                    } else {
                        Map analysisMap = this.tdghscAnalysis2(regionCode, geometry, fields2, dataSource);
                        map = this.tdghscResult(analysisMap);
                    }
                    singleResult.put("result", map);
                    singleResult.put("excelData", JSON.toJSONString((Object)this.tdghscExcelData(map)));
                    analysisResult.put(funid, singleResult);
                    continue;
                }
                if (EnumUtils.MULTI_ANALYZE_TYPE.sgbwm.name().equals(funid)) {
                    String lyr = MapUtils.getString((Map)paraMap, (Object)"layerName");
                    ArrayList<String> lyrsForDiff = new ArrayList<String>();
                    String _zd = MapUtils.getString(layerMap, (Object)EnumUtils.WZ_ANALYZE_TYPE.zd.name(), (String)"");
                    String _gd = MapUtils.getString(layerMap, (Object)EnumUtils.WZ_ANALYZE_TYPE.gd.name(), (String)"");
                    String _zhd = MapUtils.getString(layerMap, (Object)EnumUtils.WZ_ANALYZE_TYPE.zhd.name(), (String)"");
                    if (StringUtils.isNotBlank((String)_zd)) {
                        lyrsForDiff.add(_zd);
                    }
                    if (StringUtils.isNotBlank((String)_gd)) {
                        lyrsForDiff.add(_gd);
                    }
                    if (StringUtils.isNotBlank((String)_zhd)) {
                        lyrsForDiff.add(_zhd);
                    }
                    if (lyrsForDiff.size() > 0) {
                        String outFields;
                        String[] fields3;
                        List intersectResult;
                        String geometryNew = this.getDifferenceGeo(geometry, dataSource, lyrsForDiff, lyr);
                        if (!this.isNotNull((Object)geometryNew) || (intersectResult = this.intersect3(lyr, geometryNew, fields3 = "*".equals(outFields = this.isNull((Object)MapUtils.getString((Map)paraMap, (Object)"returnFields")) ? "*" : MapUtils.getString((Map)paraMap, (Object)"returnFields")) ? null : outFields.split(","), dataSource)).size() <= 0) continue;
                        List sgbwmResult = this.multiAnalyResult(funid, lyr, fields3, intersectResult);
                        singleResult.put("result", sgbwmResult);
                        analysisResult.put(funid, singleResult);
                        continue;
                    }
                    String outFields = this.isNull((Object)MapUtils.getString((Map)paraMap, (Object)"returnFields")) ? "*" : MapUtils.getString((Map)paraMap, (Object)"returnFields");
                    String[] fields4 = "*".equals(outFields) ? null : outFields.split(",");
                    List intersectResult = this.intersect3(lyr, geometry, fields4, dataSource);
                    if (intersectResult.size() <= 0) continue;
                    List sgbwmResult = this.multiAnalyResult(funid, lyr, fields4, intersectResult);
                    ArrayList<Map> _result = new ArrayList<Map>();
                    for (Map item : sgbwmResult) {
                        _result.add(this.createConvertedMap(item, new String[0]));
                    }
                    singleResult.put("result", _result);
                    analysisResult.put(funid, singleResult);
                    continue;
                }
                if (EnumUtils.MULTI_ANALYZE_TYPE.tdlygh.name().equalsIgnoreCase(funid) && EnumUtils.MULTI_ANALYZE_LEVEL.mas.name().equalsIgnoreCase(level)) {
                    FileStore fileStore;
                    FeatureCollection featureCollection;
                    File shpFile;
                    String bfhghLyr;
                    String ytjLyr;
                    String fhghLyr;
                    List<String> tdlyghLayers = Arrays.asList(MapUtils.getString((Map)paraMap, (Object)"layerName", (String)"").split(","));
                    String criticalLyr = tdlyghLayers.get(0);
                    String[] fields5 = new String[]{"OBJECTID"};
                    double geoArea = this.geometryService.getGeoArea(this.geometryService.readUnTypeGeoJSON(geometry), this.getLayerCRS(criticalLyr, dataSource));
                    List criticalResult = this.intersect3(criticalLyr, geometry, fields5, dataSource);
                    HashMap<String, Serializable> result = new HashMap<String, Serializable>();
                    if (this.isNotNull((Object)criticalResult) && criticalResult.size() > 0) {
                        fhghLyr = tdlyghLayers.get(1);
                        ytjLyr = tdlyghLayers.get(2);
                        bfhghLyr = tdlyghLayers.get(3);
                        fields5 = ArrayUtils.add2Arrays((String[])fields5, (String)"SFHRJBNT");
                    } else {
                        fhghLyr = tdlyghLayers.get(4);
                        ytjLyr = tdlyghLayers.get(5);
                        bfhghLyr = tdlyghLayers.get(6);
                    }
                    fields5 = ArrayUtils.add2Arrays((String[])fields5, (String[])new String[]{"SHAPE", this.DLBM, this.DLMC});
                    List fhghIntersect = this.intersect3(fhghLyr, geometry, fields5, dataSource);
                    List bfhghIntersect = this.intersect3(bfhghLyr, geometry, fields5, dataSource);
                    List ytjIntersect = this.intersect3(ytjLyr, geometry, fields5, dataSource);
                    HashMap<String, Object> fhghMap = new HashMap<String, Object>();
                    HashMap<String, Object> bfhghMap = new HashMap<String, Object>();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    fhghMap.put("detail", fhghIntersect);
                    fhghMap.put("total", this.processTdlyghForMas(fhghIntersect));
                    bfhghMap.put("detail", bfhghIntersect);
                    bfhghMap.put("total", this.processTdlyghForMas(bfhghIntersect));
                    hashMap.put("detail", ytjIntersect);
                    hashMap.put("total", this.processTdlyghForMas(ytjIntersect));
                    if (bfhghIntersect.size() > 0 && (shpFile = this.geometryService.exportToShp(this.geometryService.toFeatureJSON((Object)(featureCollection = this.geometryService.list2FeatureCollection(bfhghIntersect, null, null))), this.getLayerCRS(bfhghLyr, dataSource))).exists()) {
                        fileStore = this.fileStoreService.save3(shpFile, UUIDHexGenerator.generate());
                        bfhghMap.put("shpId", fileStore.getId());
                    }
                    if (ytjIntersect.size() > 0 && (shpFile = this.geometryService.exportToShp(this.geometryService.toFeatureJSON((Object)(featureCollection = this.geometryService.list2FeatureCollection(ytjIntersect, null, null))), this.getLayerCRS(ytjLyr, dataSource))).exists()) {
                        fileStore = this.fileStoreService.save3(shpFile, UUIDHexGenerator.generate());
                        hashMap.put("shpId", fileStore.getId());
                    }
                    result.put("fhgh", fhghMap);
                    result.put("bfhgh", bfhghMap);
                    result.put("ytj", hashMap);
                    result.put("geoArea", Double.valueOf(geoArea));
                    singleResult.put("result", result);
                    analysisResult.put(funid, singleResult);
                    continue;
                }
                Boolean exportable = MapUtils.getBoolean((Map)paraMap, (Object)"exportable", (Boolean)false);
                String outFields = this.isNull((Object)MapUtils.getString((Map)paraMap, (Object)"returnFields")) ? "*" : MapUtils.getString((Map)paraMap, (Object)"returnFields");
                String[] stringArray = fields = "*".equals(outFields) ? null : outFields.split(",");
                if (EnumUtils.MULTI_ANALYZE_LEVEL.valueOf((String)level) == EnumUtils.MULTI_ANALYZE_LEVEL.mas && !ArrayUtils.contains((String[])fields, (String)"SHAPE", (boolean)true)) {
                    fields = ArrayUtils.add2Arrays((String[])fields, (String)"SHAPE");
                }
                String hyperlink = MapUtils.getString((Map)paraMap, (Object)"hyperlink");
                List<String> layers = Arrays.asList(MapUtils.getString((Map)paraMap, (Object)"layerName", (String)"").split(","));
                ArrayList multiLists = new ArrayList();
                ArrayList<Map> multiHyperlinks = new ArrayList<Map>();
                ArrayList<Map> detailList = new ArrayList<Map>();
                ArrayList iGeos = new ArrayList();
                ArrayList hyperLinkHolders = new ArrayList();
                if (!this.isNull((Object)hyperlink)) {
                    List<String> hls = Arrays.asList(hyperlink.split(","));
                    for (String hl : hls) {
                        String[] nameUrl = hl.split("\\|");
                        HashMap<String, String> tmp = new HashMap<String, String>();
                        tmp.put("key", nameUrl[0]);
                        tmp.put("url", nameUrl[1]);
                        hyperLinkHolders.add(tmp);
                    }
                }
                List intersectResult = new ArrayList();
                ArrayList<Map> multiHyper = new ArrayList<Map>();
                for (String layerName : layers) {
                    String key;
                    intersectResult = this.intersect3(layerName, geometry, fields, dataSource);
                    if (EnumUtils.MULTI_ANALYZE_LEVEL.valueOf((String)level) == EnumUtils.MULTI_ANALYZE_LEVEL.mas && StringUtils.isNotBlank((String)condition)) {
                        Map cMap = AnalysisUtils.parseAnalysisCondition((String)condition);
                        String string = MapUtils.getString((Map)cMap, (Object)"operator");
                        key = MapUtils.getString((Map)cMap, (Object)"key");
                        String value = MapUtils.getString((Map)cMap, (Object)"value");
                        for (Map map2 : intersectResult) {
                            Object _val = map2.get(key);
                            if (!"=".equals(string) || _val.equals(value)) continue;
                            intersectResult.remove(map2);
                        }
                    }
                    if (EnumUtils.MULTI_ANALYZE_LEVEL.wuzhong.name().equalsIgnoreCase(level)) {
                        ArrayList<String> lyrsForDiff = new ArrayList<String>();
                        if (EnumUtils.WZ_ANALYZE_TYPE.gd.name().equalsIgnoreCase(funid)) {
                            String string = MapUtils.getString(layerMap, (Object)EnumUtils.WZ_ANALYZE_TYPE.zd.name(), (String)"");
                            if (StringUtils.isNotBlank((String)string)) {
                                lyrsForDiff.addAll(Arrays.asList(string.split(",")));
                            }
                        } else if (EnumUtils.WZ_ANALYZE_TYPE.zhd.name().equalsIgnoreCase(funid)) {
                            lyrsForDiff.addAll(Arrays.asList(MapUtils.getString(layerMap, (Object)EnumUtils.WZ_ANALYZE_TYPE.zd.name(), (String)"").split(",")));
                        }
                        if (lyrsForDiff.size() > 0) {
                            for (Map i : intersectResult) {
                                double newArea = this.getDifferenceArea(this.geometryService.readWKT(MapUtils.getString((Map)i, (Object)"SHAPE")), dataSource, lyrsForDiff);
                                i.put("SHAPE_AREA", newArea);
                            }
                        }
                    }
                    if (intersectResult.size() > 0) {
                        List multiResult = this.multiAnalyResult(funid, layerName, fields, intersectResult);
                        multiLists.addAll(multiResult);
                        for (Map item : intersectResult) {
                            HashMap temp = new HashMap();
                            temp.putAll(item);
                            iGeos.add(temp);
                        }
                    }
                    for (Map map3 : hyperLinkHolders) {
                        key = MapUtils.getString((Map)map3, (Object)"key");
                        String url = MapUtils.getString((Map)map3, (Object)"url");
                        ArrayList<Map> values = new ArrayList<Map>();
                        for (Map r : intersectResult) {
                            if (!r.containsKey(key)) continue;
                            values.add(Utils.updateMap(r.get(key), (Object)Utils.replaceHolder((String)"{", (String)"}", (String)url, (Map)r), null));
                        }
                        multiHyper.add(Utils.updateMap((Object)key, values, null));
                    }
                }
                for (Map item : multiHyper) {
                    multiHyperlinks.add(this.createConvertedMap(item, new String[]{"GQ", "M"}));
                }
                double geoArea = this.geometryService.getGeoArea(this.geometryService.readUnTypeGeoJSON(geometry), null);
                if (EnumUtils.MULTI_ANALYZE_TYPE.bp.name().equals(funid) || EnumUtils.MULTI_ANALYZE_TYPE.gd.name().equals(funid)) {
                    HashMap bpResult = new HashMap();
                    HashMap<String, Object> hashMap = new HashMap<String, Object>();
                    HashMap<String, Object> bpResult2 = new HashMap<String, Object>();
                    HashMap<String, Object> bpResult3 = new HashMap<String, Object>();
                    double bpArea = this.getDouValueByField(intersectResult, "SHAPE_AREA");
                    ArrayList<HashMap<String, Object>> infoList = new ArrayList<HashMap<String, Object>>();
                    hashMap.put("type", EnumUtils.MULTI_ANALYZE_TYPE.bp.name().equals(funid) ? "\u5df2\u62a5" : "\u5df2\u4f9b");
                    hashMap.put("area", bpArea);
                    hashMap.put("area_gq", bpArea * UNITS.access$000((UNITS)UNITS.HECTARE));
                    hashMap.put("area_m", bpArea * UNITS.access$000((UNITS)UNITS.ACRES));
                    infoList.add(hashMap);
                    bpResult2.put("type", EnumUtils.MULTI_ANALYZE_TYPE.bp.name().equals(funid) ? "\u672a\u62a5" : "\u672a\u4f9b");
                    bpResult2.put("area", geoArea - bpArea);
                    bpResult2.put("area_gq", (geoArea - bpArea) * UNITS.access$000((UNITS)UNITS.HECTARE));
                    bpResult2.put("area_m", (geoArea - bpArea) * UNITS.access$000((UNITS)UNITS.ACRES));
                    infoList.add(bpResult2);
                    bpResult3.put("type", "\u5408\u8ba1");
                    bpResult3.put("area", geoArea);
                    bpResult3.put("area_gq", geoArea * UNITS.access$000((UNITS)UNITS.HECTARE));
                    bpResult3.put("area_m", geoArea * UNITS.access$000((UNITS)UNITS.ACRES));
                    infoList.add(bpResult3);
                    bpResult.put("info", infoList);
                    for (Map item : multiLists) {
                        detailList.add(this.createConvertedMap(item, new String[]{"GQ", "M"}));
                    }
                    bpResult.put("detail", detailList);
                    singleResult.put("result", bpResult);
                } else {
                    String dataUrl = MapUtils.getString((Map)paraMap, (Object)"dataUrl");
                    for (Map item : multiLists) {
                        if (this.isNull((Object)dataUrl)) {
                            detailList.add(this.createConvertedMap(item, new String[]{"GQ", "M"}));
                            continue;
                        }
                        String data = HttpRequest.sendRequest2((String)Utils.urlReplaceHolder((String)dataUrl, (Map)item), null);
                        if (!this.isNull((Object)data)) {
                            item.putAll((Map)JSON.parseObject((String)data, Map.class));
                        }
                        detailList.add(this.createConvertedMap(item, new String[]{"GQ", "M"}));
                    }
                    singleResult.put("result", detailList);
                    if (EnumUtils.MULTI_ANALYZE_LEVEL.mas.equals((Object)EnumUtils.MULTI_ANALYZE_LEVEL.valueOf((String)level))) {
                        HashMap<String, Number> hashMap = new HashMap<String, Number>();
                        String areaAlias = this.findAnalysisFieldAlias("SHAPE_AREA");
                        double coverArea = this.getDouValueByField(detailList, areaAlias);
                        hashMap.put("coverArea", coverArea);
                        hashMap.put("unCoverArea", geoArea - coverArea);
                        hashMap.put("count", detailList.size());
                        if (!hashMap.isEmpty()) {
                            singleResult.put("stat", hashMap);
                        }
                    }
                }
                singleResult.put("hyperlinks", multiHyperlinks);
                singleResult.put("layer", layers);
                if (iGeos.size() > 0 && this.isNotNull((Object)(fc = this.geometryService.list2FeatureCollection(iGeos, this.geometryService.getLayerCRS(layers.get(0), dataSource), null)))) {
                    singleResult.put("geojson", this.geometryService.toFeatureJSON((Object)fc));
                }
                if (exportable.booleanValue() && intersectResult.size() > 0) {
                    FeatureCollection featureCollection = this.geometryService.list2FeatureCollection(intersectResult, null, null);
                    File file = this.geometryService.exportToShp(this.getLayerCRS(layers.get(0), dataSource), new String[]{geometry, this.geometryService.toFeatureJSON((Object)featureCollection)});
                    if (file.exists()) {
                        FileStore fileStore = this.fileStoreService.save3(file, UUIDHexGenerator.generate());
                        singleResult.put("shpId", fileStore.getId());
                    }
                }
                HashMap<String, HashMap<String, Object>> _temp = new HashMap<String, HashMap<String, Object>>();
                _temp.put(funid, singleResult);
                for (Object res : _temp.keySet()) {
                    Map _r = (Map)_temp.get(res);
                    _r.put("excelData", JSON.toJSONString((Object)this.multiExcelData(_temp)));
                }
                analysisResult.putAll(_temp);
            }
            if (!analysisResult.isEmpty()) {
                for (String key : analysisResult.keySet()) {
                    Map result = (Map)analysisResult.get(key);
                    result.put("level", level);
                    String analysisTpl = this.renderAnalysisTpl(result, key);
                    result.put("tpl", analysisTpl);
                }
                this.generateSummaryReport(analysisResult);
            }
            return analysisResult;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private Map processTdlyxzResultMas(Map analysisMap, String tpl) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (analysisMap != null && !analysisMap.isEmpty()) {
            Map analysisArea = (Map)analysisMap.get("analysisArea");
            List detailList = (List)analysisMap.get("analysisAreaDetail");
            if (!this.isNull((Object)detailList) && detailList.size() > 0) {
                List dictList = this.getTdlyxzDictList(tpl);
                Map dlList = ArrayUtils.listConvertMap((List)detailList, (String)"DLBM");
                ArrayList dlbms = new ArrayList();
                for (Map.Entry entry : dlList.entrySet()) {
                    String key = String.valueOf(entry.getKey()).trim();
                    List maps = (List)entry.getValue();
                    HashMap<String, Object> dlMap = new HashMap<String, Object>();
                    dlMap.put("dlbm", key);
                    dlMap.put("area", this.getDouValueByField(maps, "CCMJ"));
                    dlMap.put("area_jt", this.getSumByQueryField(maps, "QSXZ", Arrays.asList("30", "31", "32", "33", "34", "40"), "CCMJ"));
                    dlMap.put("area_gy", this.getSumByQueryField(maps, "QSXZ", Arrays.asList("10", "20"), "CCMJ"));
                    dlbms.add(dlMap);
                }
                result.put("sumArea", this.getDouValueByField(dlbms, "area"));
                result.put("sumAreaJt", this.getDouValueByField(dlbms, "area_jt"));
                result.put("sumAreaGy", this.getDouValueByField(dlbms, "area_gy"));
                result.put("categoryA", AnalysisUtils.getTdlyCategoryByGrade(dlbms, (List)dictList, (AnalysisUtils.TDLYXZ_GRADE)AnalysisUtils.TDLYXZ_GRADE.valueOf((String)"A")));
                result.put("categoryB", AnalysisUtils.getTdlyCategoryByGrade(dlbms, (List)dictList, (AnalysisUtils.TDLYXZ_GRADE)AnalysisUtils.TDLYXZ_GRADE.valueOf((String)"B")).get(0));
            }
        }
        return result;
    }

    private Map processTdlyghForMas(List<Map<String, Object>> analysisDetail) {
        HashMap<String, Double> total = new HashMap<String, Double>();
        double areaUnused = 0.0;
        double areaJsyd = 0.0;
        double areaNyd = 0.0;
        double areaJbnt = 0.0;
        double sumArea = 0.0;
        for (Map<String, Object> item : analysisDetail) {
            String dlbm = MapUtils.getString(item, (Object)this.DLBM);
            if (dlbm.length() == 2) {
                dlbm = dlbm.concat("0");
            }
            double area = MapUtils.getDoubleValue(item, (Object)"SHAPE_AREA", (double)0.0);
            sumArea += area;
            if (item.containsKey("SFHRJBNT") && "1".equals(MapUtils.getString(item, (Object)"SFHRJBNT"))) {
                areaJbnt += area;
                continue;
            }
            if (EnumUtils.TDLYXZ_THREE_TYPE.FARM.isContained(dlbm)) {
                areaNyd += area;
                continue;
            }
            if (EnumUtils.TDLYXZ_THREE_TYPE.BUILD.isContained(dlbm)) {
                areaJsyd += area;
                continue;
            }
            areaUnused += area;
        }
        total.put("unused", areaUnused);
        total.put("jsyd", areaJsyd);
        total.put("nyd", areaNyd);
        total.put("jbnt", areaJbnt);
        total.put("sum", sumArea);
        return total;
    }

    private void generateSummaryReport(LinkedHashMap<String, Object> map) {
        DecimalFormat df = new DecimalFormat("#.####");
        String areaAlias = this.findAnalysisFieldAlias("SHAPE_AREA");
        if (this.isNotNull(map) && !map.isEmpty()) {
            for (String key : map.keySet()) {
                Map item = (Map)map.get(key);
                HashMap<String, Object> summary = new HashMap<String, Object>();
                String alias = MapUtils.getString((Map)item, (Object)"alias");
                summary.put("alias", alias.substring(0, alias.length() - 2));
                List analysisList = new ArrayList();
                Map analysisMap = new HashMap();
                if (item.get("result") instanceof Map) {
                    analysisMap = (Map)item.get("result");
                } else if (item.get("result") instanceof List) {
                    analysisList = (List)item.get("result");
                }
                try {
                    switch (4.$SwitchMap$cn$gtmap$onemap$platform$utils$EnumUtils$MULTI_ANALYZE_TYPE[EnumUtils.MULTI_ANALYZE_TYPE.valueOf((String)key).ordinal()]) {
                        case 1: {
                            Map totalResult = (Map)item.get("totalResult");
                            List categoryA = (List)totalResult.get("categoryA");
                            summary.put("total", MapUtils.getDoubleValue((Map)totalResult, (Object)"sumArea", (double)0.0));
                            for (Map _m : categoryA) {
                                String dlmc = MapUtils.getString((Map)_m, (Object)"dlmc");
                                String area = df.format(MapUtils.getDoubleValue((Map)_m, (Object)"area", (double)0.0));
                                if ("\u519c\u7528\u5730".equals(dlmc)) {
                                    summary.put("nyd", area);
                                    continue;
                                }
                                if ("\u5efa\u8bbe\u7528\u5730".equals(dlmc)) {
                                    summary.put("jsyd", area);
                                    continue;
                                }
                                if (!"\u672a\u5229\u7528\u5730".equals(dlmc)) continue;
                                summary.put("wlyd", area);
                            }
                            break;
                        }
                        case 2: {
                            List info = (List)analysisMap.get("info");
                            summary.put("yb", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(0)), (Object)"area", (double)0.0)));
                            summary.put("wb", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(1)), (Object)"area", (double)0.0)));
                            summary.put("total", MapUtils.getDoubleValue((Map)((Map)info.get(2)), (Object)"area", (double)0.0));
                            break;
                        }
                        case 3: {
                            List info = (List)analysisMap.get("info");
                            summary.put("yg", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(0)), (Object)"area", (double)0.0)));
                            summary.put("wg", df.format(MapUtils.getDoubleValue((Map)((Map)info.get(1)), (Object)"area", (double)0.0)));
                            summary.put("total", MapUtils.getDoubleValue((Map)((Map)info.get(2)), (Object)"area", (double)0.0));
                            break;
                        }
                        case 4: 
                        case 5: {
                            summary.put("total", analysisList.size());
                            break;
                        }
                        case 6: {
                            Map fhghMap = (Map)analysisMap.get("fhgh");
                            Map bfhghMap = (Map)analysisMap.get("bfhgh");
                            Map ytjMap = (Map)analysisMap.get("ytj");
                            summary.put("fhgh", ((Map)fhghMap.get("total")).get("sum"));
                            summary.put("bfhgh", ((Map)bfhghMap.get("total")).get("sum"));
                            summary.put("ytj", ((Map)ytjMap.get("total")).get("sum"));
                            summary.put("total", MapUtils.getDoubleValue(summary, (Object)"fhgh", (double)0.0) + MapUtils.getDoubleValue(summary, (Object)"bfhgh", (double)0.0) + MapUtils.getDoubleValue(summary, (Object)"ytj", (double)0.0));
                            break;
                        }
                        default: {
                            double total = 0.0;
                            for (Map _m : analysisList) {
                                if (!_m.containsKey(areaAlias)) continue;
                                total += MapUtils.getDoubleValue((Map)_m, (Object)areaAlias, (double)0.0);
                            }
                            summary.put("total", total);
                        }
                    }
                }
                catch (Exception e) {
                    double total = 0.0;
                    for (Map _m : analysisList) {
                        if (!_m.containsKey(areaAlias)) continue;
                        total += MapUtils.getDoubleValue((Map)_m, (Object)areaAlias, (double)0.0);
                    }
                    summary.put("total", total);
                }
                item.put("summary", summary);
            }
        }
    }

    private String findAnalysisFieldAlias(String key) {
        List values;
        if (this.isNotNull((Object)this.analysisFieldsMap) && !this.analysisFieldsMap.isEmpty() && this.isNotNull((Object)(values = this.getAnalysisFieldAlias(key))) && values.size() > 0) {
            return (String)values.get(values.size() - 1);
        }
        return key;
    }

    private String renderAnalysisTpl(Map data, String tplName) {
        try {
            HashMap<String, Map> map = new HashMap<String, Map>();
            map.put("tplData", data);
            List tpls = this.templateService.listTplNames("analysis/template/");
            if (!this.isNull((Object)tpls) && tpls.size() > 0) {
                if (tpls.contains(tplName.concat(".ftl"))) {
                    return this.templateService.getTemplate(map, "analysis/template/".concat(tplName.concat(".ftl")));
                }
                if (tpls.contains("default.ftl")) {
                    return this.templateService.getTemplate(map, "analysis/template/".concat("default.ftl"));
                }
            }
            return this.getMessage("template.not.exist", new Object[]{tplName.concat(".ftl")});
        }
        catch (Exception e) {
            this.logger.error("render analysis tpl error:" + e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private String getDifferenceGeo(String geometry, String dataSource, List<String> layerNames, String targetLayer) {
        ArrayList<Geometry> dfGeos = new ArrayList<Geometry>();
        for (String lyr : layerNames) {
            List dfResult = this.differenceByGeoJson(lyr, geometry, new String[]{"SHAPE"}, dataSource);
            if (this.isNull((Object)dfResult) || this.isNotNull((Object)dfResult) && dfResult.size() == 0) {
                return null;
            }
            for (Map tmp : dfResult) {
                dfGeos.add(this.geometryService.readWKT(MapUtils.getString((Map)tmp, (Object)"SHAPE")));
            }
        }
        ArrayList<Geometry> list = new ArrayList<Geometry>();
        for (Geometry _g : dfGeos) {
            if (this.isGeometryCollection(_g)) {
                list.addAll(this.decomposeGC((GeometryCollection)_g));
                continue;
            }
            list.add(_g);
        }
        Geometry lastGeo = this.getDuplicatedGeo(list, this.getLayerCRS(targetLayer, dataSource));
        if (!this.isNull((Object)lastGeo) && !lastGeo.isEmpty() && lastGeo.isValid()) {
            return this.geometryService.toGeoJSON(lastGeo);
        }
        return null;
    }

    private double getDifferenceArea(Geometry geometry, String dataSource, List<String> layerNames) {
        try {
            ArrayList<Geometry> geos = new ArrayList<Geometry>();
            ArrayList list = new ArrayList();
            double totArea = 0.0;
            for (String layerName : layerNames) {
                list.addAll(this.difference(layerName, geometry, null, dataSource));
            }
            if (!this.isNull(list) && list.size() > 0) {
                for (Map map : list) {
                    geos.add(this.geometryService.readWKT(MapUtils.getString((Map)map, (Object)"SHAPE")));
                }
            }
            if (geos.size() > 1) {
                ArrayList<Geometry> _list = new ArrayList<Geometry>();
                for (Geometry _g : geos) {
                    if (this.isGeometryCollection(_g)) {
                        _list.addAll(this.decomposeGC((GeometryCollection)_g));
                        continue;
                    }
                    _list.add(_g);
                }
                Geometry duplicatedGeo = this.getDuplicatedGeo(_list, null);
                if (!this.isNull((Object)duplicatedGeo) && !duplicatedGeo.isEmpty()) {
                    totArea = this.getAreaByGeometry((Object)duplicatedGeo, 1.0);
                }
            } else {
                for (Map map : list) {
                    totArea += this.getAreaByGeometry((Object)this.geometryService.readWKT(MapUtils.getString((Map)map, (Object)"SHAPE")), 1.0);
                }
            }
            return totArea;
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<?> multiAnalyResult(String funid, String layerName, String[] fields, List<?> multiResult) {
        try {
            if (multiResult.size() < 1) {
                return null;
            }
            List<Object> rf = new ArrayList();
            if (fields != null) {
                rf = Arrays.asList(fields);
            }
            ArrayList multiLists = new ArrayList();
            if (EnumUtils.MULTI_ANALYZE_TYPE.sgbwm.name().equals(funid)) {
                Map xzqMap = ArrayUtils.listConvertMap(multiResult, (String)"SSQY");
                for (Map.Entry entry : xzqMap.entrySet()) {
                    void var11_17;
                    String xzqdm = (String)entry.getKey();
                    String string = "";
                    String village = "";
                    double totalArea = 0.0;
                    List value = (List)entry.getValue();
                    LinkedHashMap<String, Object> multiItem = new LinkedHashMap<String, Object>();
                    if (!this.isNotNull((Object)xzqdm)) continue;
                    switch (xzqdm.length()) {
                        case 9: {
                            String string2 = xzqdm;
                            break;
                        }
                        case 12: {
                            String string3 = xzqdm.substring(0, 9);
                            village = xzqdm;
                        }
                    }
                    multiItem.put("town", var11_17);
                    multiItem.put("village", village);
                    Map lbMap = ArrayUtils.listConvertMap((List)value, (String)"SGBWMLB");
                    for (Map.Entry _e : lbMap.entrySet()) {
                        String lb = (String)_e.getKey();
                        double area = this.getAreaByList((List)_e.getValue(), false, 1.0, null);
                        multiItem.put(lb, area);
                        totalArea += area;
                    }
                    multiItem.put("total", totalArea);
                    multiLists.add(multiItem);
                }
            } else {
                for (int i = 0; i < multiResult.size(); ++i) {
                    Map getMap = (Map)multiResult.get(i);
                    LinkedHashMap setMap = new LinkedHashMap();
                    for (String string : rf) {
                        if (!getMap.containsKey(string)) continue;
                        setMap.put(string, getMap.get(string));
                    }
                    double area = MapUtils.getDoubleValue((Map)getMap, (Object)"SHAPE_AREA", (double)0.0);
                    String wkt = MapUtils.getString((Map)getMap, (Object)"SHAPE");
                    Geometry geo = this.geometryService.readWKT(wkt);
                    if (geo instanceof Polygon || geo instanceof MultiPolygon) {
                        setMap.put("SHAPE_AREA", area);
                    }
                    if (setMap.containsKey("SHAPE")) {
                        setMap.put("SHAPE", this.geometryService.toGeoJSON(geo));
                    }
                    setMap.put("GQ", area * UNITS.access$000((UNITS)UNITS.HECTARE));
                    setMap.put("M", area * UNITS.access$000((UNITS)UNITS.ACRES));
                    if ("SDE.CKQ".equals(layerName.toUpperCase())) {
                        setMap.put("KCTYPE", "\u91c7\u77ff\u6743");
                    } else if ("SDE.TKQ".equals(layerName.toUpperCase())) {
                        setMap.put("KCTYPE", "\u63a2\u77ff\u6743");
                    }
                    multiLists.add(setMap);
                }
            }
            return multiLists;
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("analysis.multi.result.error", new Object[]{e.getLocalizedMessage()}));
            return null;
        }
    }

    public CoordinateReferenceSystem getLayerCRS(String layerName, String dataSource) {
        try {
            return this.spatialDao.getLayerCRS(layerName, dataSource);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public Map createConvertedMap(Map map, String ... excludeFields) {
        if (this.isNull((Object)this.analysisFieldsMap)) {
            throw new RuntimeException("analysis fields map not found");
        }
        assert (map != null);
        try {
            HashMap result = map instanceof LinkedHashMap ? new LinkedHashMap() : new HashMap();
            Iterator i$ = map.entrySet().iterator();
            while (i$.hasNext()) {
                Map.Entry object;
                Map.Entry entry = object = i$.next();
                String key = entry.getKey().toString();
                boolean contains = false;
                if (!this.isNull((Object)excludeFields)) {
                    for (int i = 0; i < excludeFields.length; ++i) {
                        if (!key.equals(excludeFields[i])) continue;
                        contains = true;
                        break;
                    }
                }
                if (contains) continue;
                List aliases = this.getAnalysisFieldAlias(key);
                if (aliases.size() > 0) {
                    key = (String)aliases.get(aliases.size() - 1);
                }
                result.put(key, entry.getValue());
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public String findXzqdm(SimpleFeature feature, String layerName) {
        assert (feature != null);
        assert (layerName != null);
        String dataSource = null;
        Point center = null;
        try {
            Map map;
            List list;
            if (layerName.contains(".")) {
                String[] array = layerName.split("\\.");
                dataSource = array[0] != null ? array[0].toLowerCase() : null;
            }
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            CoordinateReferenceSystem layerCRS = this.spatialDao.getLayerCRS(layerName, dataSource);
            CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
            if (this.isNull((Object)sourceCRS)) {
                this.logger.error("source crs is null");
            }
            if (!(this.isNull((Object)sourceCRS) || this.isNull((Object)layerCRS) || layerCRS.equals(sourceCRS))) {
                geometry = this.geometryService.project(geometry, sourceCRS, layerCRS);
            }
            if (!this.isNull((Object)(list = this.intersect(layerName, (Geometry)(center = this.geometryService.getGeometryCentre(geometry)), null, dataSource))) && list.size() > 0 && (map = (Map)list.get(0)).containsKey("XZQDM")) {
                return MapUtils.getString((Map)map, (Object)"XZQDM");
            }
            return null;
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("xzqdm.find.error", new Object[]{e.getMessage(), layerName, this.isNull(center) ? null : center.toText()}));
        }
    }

    private List<String> getAnalysisFieldAlias(String key) {
        ArrayList<String> fields = new ArrayList<String>();
        for (Map.Entry property : this.analysisFieldsMap.entrySet()) {
            if (!Pattern.compile(property.getKey().toString()).matcher(key).matches()) continue;
            fields.add(property.getValue().toString());
        }
        return fields;
    }

    public double getAreaByList(List<Map> list, boolean removeDuplicated, double conv, CoordinateReferenceSystem crs) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        double area = 0.0;
        double duplicatedArea = 0.0;
        ArrayList<Geometry> geos = new ArrayList<Geometry>();
        try {
            for (Map map : list) {
                String wktPolygon = MapUtils.getString((Map)map, (Object)"SHAPE");
                geos.add(this.geometryService.readWKT(wktPolygon));
                double value = MapUtils.getDoubleValue((Map)map, (Object)"SHAPE_AREA", (double)0.0);
                area += value;
            }
        }
        catch (GeometryServiceException e) {
            throw new RuntimeException(e.getMessage());
        }
        if (geos.size() > 1 && removeDuplicated) {
            ArrayList<Geometry> _list = new ArrayList<Geometry>();
            for (Geometry _g : geos) {
                if (this.isGeometryCollection(_g)) {
                    _list.addAll(this.decomposeGC((GeometryCollection)_g));
                    continue;
                }
                _list.add(_g);
            }
            Geometry duplicatedGeo = this.getDuplicatedGeo(_list, crs);
            if (duplicatedGeo != null && !duplicatedGeo.isEmpty()) {
                duplicatedArea = duplicatedGeo.getArea();
            }
        }
        return (area - duplicatedArea) * conv;
    }

    public Geometry getDuplicatedGeo(List<Geometry> geos, CoordinateReferenceSystem crs) {
        try {
            if (!this.isNull(geos) && geos.size() > 0) {
                Geometry geo0 = geos.get(0);
                geos.remove(0);
                if (geos.size() == 0) {
                    return geo0;
                }
                if (this.isNull((Object)crs)) {
                    return geo0.intersection(this.getDuplicatedGeo(geos, null));
                }
                return this.geometryService.readWKT(this.agsGeoemtryService.intersection(this.getDuplicatedGeo(geos, crs).toText(), geo0.toText(), crs.toWKT()));
            }
            return null;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    private boolean isGeometryCollection(Geometry g) {
        return "com.vividsolutions.jts.geom.GeometryCollection".equals(g.getClass().getName());
    }

    public List<Geometry> decomposeGC(GeometryCollection geometryCollection) {
        assert (geometryCollection != null);
        try {
            ArrayList<Geometry> list = new ArrayList<Geometry>();
            for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                Geometry singleGeo = geometryCollection.getGeometryN(i);
                if (singleGeo instanceof GeometryCollection) {
                    list.addAll(this.decomposeGC((GeometryCollection)singleGeo));
                    continue;
                }
                if (!this.isNotNull((Object)singleGeo) || singleGeo.isEmpty() || !singleGeo.isSimple()) continue;
                list.add(singleGeo);
            }
            return list;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    @Deprecated
    public double getAreaByFeature(SimpleFeature feature, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        double area = 0.0;
        try {
            CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
            CoordinateReferenceSystem targetCrs = this.geometryService.parseUndefineSR("2364");
            Geometry geometry = (Geometry)feature.getDefaultGeometry();
            if (sourceCRS != null && sourceCRS instanceof GeographicCRS) {
                geometry = this.geometryService.project((Geometry)feature.getDefaultGeometry(), sourceCRS, targetCrs);
            }
            area = this.isPolygon(geometry) ? geometry.getArea() : geometry.getLength();
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return area * conv;
    }

    public double getAreaByField(List<Map> list, String field, String value, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        assert (field != null);
        assert (value != null);
        double area = 0.0;
        List<String> array = Arrays.asList(value.split(","));
        for (Map map : list) {
            if (!array.contains(map.get(field))) continue;
            area += ((Double)map.get("SHAPE_AREA")).doubleValue();
        }
        return area * conv;
    }

    public double getAreaByField(List<Map> list, String field, String value, String areaField, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        assert (field != null);
        assert (value != null);
        double area = 0.0;
        List<String> array = Arrays.asList(value.split(","));
        for (Map map : list) {
            if (!array.contains(map.get(field))) continue;
            area += ((Double)map.get(areaField)).doubleValue();
        }
        return area * conv;
    }

    public String getStrValueByField(List<Map> list, String field) {
        StringBuilder sb = new StringBuilder();
        assert (field != null);
        for (Map map : list) {
            if (!map.containsKey(field)) continue;
            if (StringUtils.isNotBlank((String)sb.toString())) {
                sb.append(",");
            }
            if (this.isNull(map.get(field))) continue;
            sb.append(map.get(field));
        }
        return sb.toString();
    }

    public String getStrValueByField(List<Map> list, String[] fields, String hyphen) {
        StringBuilder sb = new StringBuilder();
        assert (fields != null);
        List<String> array = Arrays.asList(fields);
        for (Map map : list) {
            if (StringUtils.isNotBlank((String)sb.toString())) {
                sb.append(",");
            }
            for (String f : array) {
                if (!map.containsKey(f) || this.isNull(map.get(f))) continue;
                if (array.indexOf(f) != 0) {
                    sb.append(hyphen);
                }
                sb.append(map.get(f));
            }
        }
        return sb.toString();
    }

    public double getDouValueByField(List list, String field) {
        double value = 0.0;
        assert (field != null);
        for (Object _item : list) {
            Map map = (Map)_item;
            if (this.isNull(map.get(field))) continue;
            value += MapUtils.getDoubleValue((Map)map, (Object)field, (double)0.0);
        }
        return value;
    }

    public double getSumByQueryField(List<Map> list, String queryField, List queryValue, String sumField) {
        double result = 0.0;
        assert (queryField != null);
        assert (queryValue != null);
        for (Map map : list) {
            if (!queryValue.contains(MapUtils.getString((Map)map, (Object)queryField))) continue;
            result += MapUtils.getDoubleValue((Map)map, (Object)sumField, (double)0.0);
        }
        return result;
    }

    private BufferedImage getExportImage(Envelope envelope, String url, String imageSize, double mapScale) {
        BufferedImage image = null;
        String bbox = "bbox=" + envelope.getMinX() + "," + envelope.getMinY() + "," + envelope.getMaxX() + "," + envelope.getMaxY();
        String size = "size=" + imageSize;
        StringBuilder exportUrl = new StringBuilder();
        exportUrl.append(url);
        exportUrl.append("/export?");
        exportUrl.append(bbox);
        exportUrl.append("&");
        exportUrl.append(size);
        exportUrl.append("&");
        exportUrl.append("&");
        if (mapScale > 0.0) {
            exportUrl.append("mapScale=" + mapScale);
        }
        exportUrl.append("&");
        exportUrl.append("transparent=true&");
        exportUrl.append("format=png&");
        exportUrl.append("f=image");
        HttpClient httpClient = new HttpClient();
        GetMethod getMethod = new GetMethod(exportUrl.toString());
        try {
            httpClient.executeMethod((HttpMethod)getMethod);
            ByteArrayInputStream inputStream = new ByteArrayInputStream(getMethod.getResponseBody());
            if (((InputStream)inputStream).available() > 0) {
                image = ImageIO.read(inputStream);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return image;
    }

    private double getTotalArea(JSONArray features) {
        double area = 0.0;
        for (int i = 0; i < features.size(); ++i) {
            JSONObject object = (JSONObject)features.get(i);
            JSONObject property = (JSONObject)object.get((Object)"properties");
            area += Double.parseDouble(property.get((Object)"SHAPE_AREA").toString());
        }
        return area;
    }

    private double getAreaByLxdm(String field, JSONArray features, String lxdm, boolean fuzzyMatch) {
        double area = 0.0;
        for (int i = 0; i < features.size(); ++i) {
            boolean matched;
            JSONObject object = (JSONObject)features.get(i);
            JSONObject property = (JSONObject)object.get((Object)"properties");
            if (property.get((Object)field) == null) {
                return 0.0;
            }
            String val = String.valueOf(property.get((Object)field));
            boolean bl = fuzzyMatch ? val.equals(lxdm) || val.startsWith(lxdm.substring(0, 2)) : (matched = val.equals(lxdm));
            if (!matched) continue;
            area += Double.parseDouble(property.get((Object)"SHAPE_AREA").toString());
        }
        return area;
    }

    private String getWhereClause(String[] fields, String keyword) {
        String or = " or ";
        StringBuilder b = new StringBuilder();
        for (String field : fields) {
            b.append(field);
            b.append(" like '");
            b.append(keyword);
            b.append("%'");
            b.append(or);
        }
        b.delete(b.length() - or.length(), b.length());
        return b.toString();
    }

    private Map<String, Object> geoJSON2Map(String geoJSON, CoordinateReferenceSystem targetCRS) {
        Object geo = this.geometryService.readUnTypeGeoJSON(geoJSON);
        Map<String, Object> columns = null;
        if (geo instanceof Geometry) {
            columns = new HashMap<String, Object>();
            columns.put("SHAPE", ((Geometry)geo).toText());
        } else if (geo instanceof SimpleFeature) {
            SimpleFeature feature = (SimpleFeature)geo;
            CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
            if (this.isNull((Object)sourceCRS)) {
                sourceCRS = this.geometryService.readFeatureJSONCRS(geoJSON);
            }
            columns = this.geometryService.simpleFeature2Map(feature);
            try {
                for (String key : columns.keySet()) {
                    if (!(columns.get(key) instanceof Geometry)) continue;
                    Geometry geometry = (Geometry)columns.get(key);
                    if (targetCRS != null && sourceCRS != null) {
                        geometry = this.geometryService.project(geometry, sourceCRS, targetCRS);
                    }
                    columns.put("SHAPE", geometry.toText());
                    columns.remove(key);
                }
            }
            catch (Exception e) {
                this.logger.error(e.getLocalizedMessage());
                throw new RuntimeException(e.getLocalizedMessage());
            }
        } else {
            if (geo instanceof GeometryCollection) {
                throw new RuntimeException("current omp version don't support GeometryCollection ");
            }
            if (geo instanceof FeatureCollection) {
                throw new RuntimeException("current omp version don't support FeatureCollection ");
            }
            throw new RuntimeException(this.getMessage("geometry.undefined", new Object[0]));
        }
        return columns;
    }

    private Geometry setFeaturePros2Geo(SimpleFeature feature, Geometry geometry) {
        HashMap<String, Object> map = null;
        if (geometry instanceof GeometryCollection) {
            for (int i = 0; i < geometry.getNumGeometries(); ++i) {
                Geometry geo = geometry.getGeometryN(i);
                map = new HashMap();
                for (Property p : feature.getProperties()) {
                    if (p.getName().equals((Object)"geometry")) continue;
                    map.put(p.getName().getLocalPart(), p.getValue());
                }
                geo.setUserData(map);
            }
        } else {
            map = new HashMap<String, Object>();
            for (Property p : feature.getProperties()) {
                if (p.getName().getLocalPart().equals("geometry")) continue;
                map.put(p.getName().getLocalPart(), p.getValue());
            }
            geometry.setUserData(map);
        }
        return geometry;
    }

    private List<?> addGeoProperty2List(List<Map<String, Object>> list, Geometry geometry) {
        if (geometry.getUserData() == null) {
            return list;
        }
        for (Map<String, Object> item : list) {
            Map pros = (Map)geometry.getUserData();
            for (Map.Entry entry : pros.entrySet()) {
                item.put("G_".concat((String)entry.getKey()), entry.getValue());
            }
        }
        return list;
    }

    private List<Map> getTdlyxzDictList(String tpl) {
        ArrayList<Map> groupList = new ArrayList<Map>();
        Configuration configuration = this.webMapService.getConfig(tpl);
        List dicts = configuration.getDicts();
        for (Dict dict : dicts) {
            if (!dict.getName().toString().equals("tdlyxz")) continue;
            List dictItems = dict.getDictItems();
            for (Item item : dictItems) {
                HashMap<String, Object> temp = new HashMap<String, Object>();
                temp.put("dlbm", item.getName());
                temp.put("dlmc", item.getValue());
                temp.put("area", 0);
                temp.put("jtArea", 0);
                temp.put("gyArea", 0);
                groupList.add(temp);
            }
        }
        if (groupList.size() == 0) {
            throw new RuntimeException(this.getMessage("get.dict.error", new Object[]{tpl}));
        }
        return groupList;
    }

    private boolean checkFieldInLayer(String field, String layerName, String dataSource) {
        return ArrayUtils.contains((String[])this.spatialDao.getLayerColumns(layerName, dataSource), (String)field, (boolean)true);
    }

    private boolean isPolygon(Geometry geometry) {
        String geometryType = geometry.getGeometryType();
        if (geometryType.equals(Geometries.POLYGON.getName()) || geometryType.equals(Geometries.MULTIPOLYGON.getName())) {
            return true;
        }
        if (geometryType.equals(Geometries.LINESTRING.getName()) || geometryType.equals(Geometries.MULTILINESTRING.getName())) {
            return false;
        }
        if (geometryType.equals(Geometries.GEOMETRYCOLLECTION.getName())) {
            return geometry.getArea() > 0.0;
        }
        return false;
    }

    public double getIntersectArea(List<Map> list, String layerName, String dataSource) {
        double area = 0.0;
        try {
            for (Map map : list) {
                String wktPolygon = MapUtils.getString((Map)map, (Object)"SHAPE");
                List intersectResult = this.intersect(layerName, wktPolygon, null, dataSource);
                if (this.isNull((Object)intersectResult) || intersectResult.size() <= 0) continue;
                area += this.getAreaByList(intersectResult, false, 1.0, this.getLayerCRS(layerName, dataSource));
            }
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return area;
    }

    public double getGdArea(List<Map> list, String dltb, String xzdw, String dataSource) {
        double area = 0.0;
        try {
            for (Map map : list) {
                String wktPolygon = String.valueOf(map.get("SHAPE"));
                Map tdlyxzMap = this.tdlyxzAnalysis2(dltb, xzdw, this.geometryService.toGeoJSON(this.geometryService.readWKT(wktPolygon)), dataSource);
                Map tdlyxzAnalysisArea = (Map)tdlyxzMap.get("analysisArea");
                area += MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u6c34\u7530", (Double)0.0) + MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u6c34\u6d47\u5730", (Double)0.0) + MapUtils.getDouble((Map)tdlyxzAnalysisArea, (Object)"\u65f1\u5730", (Double)0.0);
            }
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return area;
    }

    public double getAreaByGeometry(Object geo, double conv) {
        if (this.isNull((Object)conv)) {
            conv = 1.0;
        }
        double area = 0.0;
        try {
            SimpleFeature feature = null;
            CoordinateReferenceSystem targetCrs = this.geometryService.parseUndefineSR("2364");
            if (geo instanceof SimpleFeature) {
                feature = (SimpleFeature)geo;
                CoordinateReferenceSystem sourceCRS = feature.getFeatureType().getCoordinateReferenceSystem();
                Geometry geometry = (Geometry)feature.getDefaultGeometry();
                if (sourceCRS != null && sourceCRS instanceof GeographicCRS) {
                    geometry = this.geometryService.project((Geometry)feature.getDefaultGeometry(), sourceCRS, targetCrs);
                }
                area = this.isPolygon(geometry) ? geometry.getArea() : geometry.getLength();
            } else if (geo instanceof FeatureCollection) {
                FeatureIterator iterator = ((FeatureCollection)geo).features();
                while (iterator.hasNext()) {
                    feature = (SimpleFeature)iterator.next();
                    area += this.getAreaByGeometry((Object)feature, conv);
                }
            } else if (geo instanceof Geometry) {
                Geometry temp = (Geometry)geo;
                CoordinateReferenceSystem sCrs = this.geometryService.getCrsByCoordXD(temp.getCentroid().getX());
                Geometry geometry = sCrs != null && sCrs instanceof GeographicCRS ? this.geometryService.project(temp, sCrs, targetCrs) : temp;
                area = this.isPolygon(geometry) ? geometry.getArea() : geometry.getLength();
            } else if (geo instanceof GeometryCollection) {
                GeometryCollection geometryCollection = (GeometryCollection)geo;
                for (int i = 0; i < geometryCollection.getNumGeometries(); ++i) {
                    Geometry geometry = geometryCollection.getGeometryN(i);
                    if (!this.isPolygon(geometry)) continue;
                    area += this.getAreaByGeometry((Object)geometry, conv);
                }
            }
        }
        catch (GeometryServiceException e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return area * conv;
    }
}

