/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.dao.FileStoreDao;
import cn.gtmap.onemap.platform.entity.FileStore;
import cn.gtmap.onemap.platform.service.FileStoreService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.utils.FilesUtils;
import com.gtis.generic.util.ImageUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.FileCleanerCleanup;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.io.FileUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

public class FileStoreServiceImpl
extends BaseLogger
implements FileStoreService {
    private static final String EGOV_HOME = "${egov.conf}";
    private static final int THRESHOLD = 0xA00000;
    private static final String THUMB_SUFFIX = "_thumb";
    @Autowired
    private FileStoreDao fileStoreDao;
    private Resource baseLocation;
    private Resource location;
    private Resource tempFile;
    private long maxSize;

    public FileStore get(String id) {
        return (FileStore)this.fileStoreDao.findOne((Serializable)((Object)id));
    }

    public FileStore save(HttpServletRequest request, String parentId) {
        Assert.notNull((Object)parentId, (String)this.getMessage("file.parentId.notnull", new Object[0]));
        FileStore fileStore = null;
        try {
            List fileItems = this.parseRequest(request);
            for (FileItem item : fileItems) {
                if (item.isFormField()) continue;
                DiskFileItem diskFileItem = (DiskFileItem)item;
                File newFile = this.getNewFile(item.getName());
                if (diskFileItem.isInMemory()) {
                    FileUtils.copyInputStreamToFile((InputStream)diskFileItem.getInputStream(), (File)newFile);
                } else {
                    File tmpFile = diskFileItem.getStoreLocation();
                    FileUtils.copyFile((File)tmpFile, (File)newFile, (boolean)true);
                }
                this.createThumb(newFile);
                fileStore = this.save2DB(newFile, parentId, diskFileItem);
                this.logger.debug(this.getMessage("file.upload.success", new Object[]{item.getName()}));
            }
        }
        catch (FileUploadException e) {
            this.logger.error(this.getMessage("file.upload.error", new Object[]{e.getLocalizedMessage()}));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return fileStore;
    }

    public FileStore save2(MultipartHttpServletRequest request, String parentId) {
        Iterator iterator = request.getFileNames();
        FileStore fileStore = null;
        while (iterator.hasNext()) {
            MultipartFile file = request.getFile((String)iterator.next());
            String fileName = file.getOriginalFilename();
            this.logger.debug(" upload file : {0}", (Object)fileName);
            try {
                File newFile = this.getNewFile(fileName);
                FileUtils.copyInputStreamToFile((InputStream)file.getInputStream(), (File)newFile);
                this.createThumb(newFile);
                fileStore = this.save2DB2(newFile, parentId, fileName, (double)file.getSize());
                this.logger.debug(this.getMessage("file.upload.success", new Object[]{fileName}));
            }
            catch (IOException e) {
                this.logger.error(" save upload file error , detail info : [{0}]", (Object)e.getLocalizedMessage());
            }
        }
        return fileStore;
    }

    public FileStore save3(File file, String parentId) {
        Assert.notNull((Object)file);
        Assert.notNull((Object)parentId);
        FileStore fileStore = null;
        try {
            fileStore = this.save2DB2(file, parentId, file.getName(), (double)file.getTotalSpace());
            this.logger.debug(this.getMessage("file.upload.success", new Object[]{file.getName()}));
        }
        catch (Exception e) {
            this.logger.error(" save upload file error , detail info : [{0}]", (Object)e.getLocalizedMessage());
        }
        return fileStore;
    }

    @Transactional
    public FileStore save(FileStore fileStore) {
        return (FileStore)this.fileStoreDao.save((Object)fileStore);
    }

    @Transactional
    public boolean delete(String id) {
        this.fileStoreDao.delete((Serializable)((Object)id));
        return true;
    }

    @Transactional
    public boolean delete(FileStore fileStore) {
        this.fileStoreDao.delete((Object)fileStore);
        return true;
    }

    public String[] getFileIds(String parentId) {
        List files = this.fileStoreDao.findByParentId(parentId);
        if (files != null && files.size() > 0) {
            String[] ids = new String[files.size()];
            for (int i = 0; i < files.size(); ++i) {
                ids[i] = ((FileStore)files.get(i)).getId();
            }
            return ids;
        }
        return new String[0];
    }

    public File getFile(String id) throws IOException {
        Assert.notNull((Object)id, (String)this.getMessage("id.notnull", new Object[0]));
        FileStore fileStore = (FileStore)this.fileStoreDao.findOne((Serializable)((Object)id));
        return new File(this.getRealPath(fileStore.getPath()));
    }

    public List<File> getFiles(String parentId) throws IOException {
        Assert.notNull((Object)parentId);
        List fileStores = this.fileStoreDao.findByParentId(parentId);
        ArrayList<File> files = new ArrayList<File>();
        if (fileStores != null && fileStores.size() > 0) {
            for (FileStore fileStore : fileStores) {
                files.add(new File(this.getRealPath(fileStore.getPath())));
            }
        }
        return files;
    }

    public File getThumb(String id) throws IOException {
        Assert.notNull((Object)id, (String)this.getMessage("id.notnull", new Object[0]));
        FileStore fileStore = (FileStore)this.fileStoreDao.findOne((Serializable)((Object)id));
        String path = this.getRealPath(fileStore.getPath());
        File thumbFile = new File(this.getThumbPath(path));
        if (thumbFile.exists()) {
            return thumbFile;
        }
        return null;
    }

    private String getThumbPath(String path) {
        Assert.notNull((Object)path, (String)this.getMessage("path.notnull", new Object[0]));
        String suffix = path.substring(path.lastIndexOf("."), path.length());
        return path.replace(suffix, THUMB_SUFFIX.concat(suffix));
    }

    private List<FileItem> parseRequest(HttpServletRequest servletRequest) throws FileUploadException, IOException {
        boolean isM = ServletFileUpload.isMultipartContent((HttpServletRequest)servletRequest);
        DiskFileItemFactory fac = this.createDiskFileItemFactory(this.tempFile.getURI().getPath(), servletRequest);
        ServletFileUpload upload = new ServletFileUpload((FileItemFactory)fac);
        upload.setSizeMax(this.maxSize);
        return upload.parseRequest(servletRequest);
    }

    private DiskFileItemFactory createDiskFileItemFactory(String saveDir, HttpServletRequest request) {
        DiskFileItemFactory fac = new DiskFileItemFactory();
        fac.setSizeThreshold(0xA00000);
        if (saveDir != null) {
            fac.setRepository(new File(saveDir));
        }
        fac.setFileCleaningTracker(FileCleanerCleanup.getFileCleaningTracker((ServletContext)request.getSession().getServletContext()));
        return fac;
    }

    private File getNewFile(String name) {
        File file = null;
        try {
            String path = this.location.getURI().getPath();
            file = new File(path.concat("/" + name));
            if (file.exists()) {
                file = new File(path.concat("/" + this.reNameFile(name)));
            }
        }
        catch (IOException e) {
            this.logger.error(e.getLocalizedMessage());
        }
        return file;
    }

    private String reNameFile(String name) {
        if (name.lastIndexOf(".") > -1) {
            int index = name.lastIndexOf(".");
            String suffix = name.substring(index, name.length());
            return name.replace(suffix, "_" + System.currentTimeMillis() + suffix);
        }
        return name + "_" + System.currentTimeMillis();
    }

    private void createThumb(File file) {
        Assert.notNull((Object)file, (String)this.getMessage("file.notexist", new Object[0]));
        try {
            String path = file.getPath();
            String suffix = path.substring(path.lastIndexOf("."), path.length());
            String aPath = path.replace(suffix, THUMB_SUFFIX.concat(suffix));
            File aFile = new File(aPath);
            if (FilesUtils.isImage((File)file)) {
                ImageUtils.resizeImageWithMaxWidth((String)file.getPath(), (String)aFile.getPath(), (int)160);
            }
            this.logger.debug(this.getMessage("file.thumb.success", new Object[]{file.getPath()}));
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("file.thumb.fail", new Object[]{e.getLocalizedMessage()}));
        }
    }

    private FileStore save2DB(File file, String parentId, DiskFileItem itemInfo) {
        try {
            String path = this.getRealPath(file.getPath());
            FileStore fs = new FileStore();
            fs.setName(itemInfo.getName());
            fs.setPath(path);
            fs.setParentId(parentId);
            fs.setCreateTime(Calendar.getInstance().getTime());
            fs.setFileSize((double)itemInfo.getSize());
            return (FileStore)this.fileStoreDao.save((Object)fs);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("file.database.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    private FileStore save2DB2(File file, String parentId, String name, double size) {
        try {
            String path = this.getRealPath(file.getPath());
            FileStore fs = new FileStore();
            fs.setName(name);
            fs.setPath(path);
            fs.setParentId(parentId);
            fs.setCreateTime(Calendar.getInstance().getTime());
            fs.setFileSize(size);
            return (FileStore)this.fileStoreDao.save((Object)fs);
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("file.database.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    private String getRealPath(String path) throws IOException {
        return path.replace(EGOV_HOME, this.baseLocation.getFile().getPath());
    }

    public void setBaseLocation(Resource baseLocation) {
        this.baseLocation = baseLocation;
    }

    public void setLocation(Resource location) {
        this.location = location;
    }

    public void setTempFile(Resource tempFile) {
        this.tempFile = tempFile;
    }

    public void setMaxSize(long maxSize) {
        this.maxSize = maxSize;
    }
}

