/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.entity.Document;
import cn.gtmap.onemap.platform.service.DocumentService;
import cn.gtmap.onemap.platform.service.TemplateService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.service.impl.DocumentServiceImpl;
import cn.gtmap.onemap.platform.utils.AppPropertyUtils;
import de.innosystec.unrar.Archive;
import de.innosystec.unrar.exception.RarException;
import de.innosystec.unrar.rarfile.FileHeader;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.tools.zip.ZipEntry;
import org.apache.tools.zip.ZipFile;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class DocumentServiceImpl
extends BaseLogger
implements DocumentService {
    private static final String START_MARK = "[$]";
    private static final String ANALYSIS_EXCLE_DIR = "analysis/export/";
    private static final String ANALYSIS_FTL_DIR = "analysis/template/";
    private static final String TPL_SUFFIX = ".ftl";
    @Autowired
    private TemplateService templateService;
    private String location;
    private static final String EXTRA_MARK = "[@]";

    public List<List> readExcel(InputStream inputStream) {
        Assert.notNull((Object)inputStream, (String)this.getMessage("doc.is.not.null", new Object[0]));
        ArrayList<List> content = new ArrayList<List>();
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            Sheet sheet = workbook.getSheetAt(0);
            ArrayList<Object> item = null;
            for (Row row : sheet) {
                item = new ArrayList<Object>();
                for (Cell cell : row) {
                    switch (cell.getCellType()) {
                        case 1: {
                            item.add(cell.getStringCellValue());
                            break;
                        }
                        case 4: {
                            item.add(cell.getBooleanCellValue());
                            break;
                        }
                        case 0: {
                            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                                item.add(cell.getDateCellValue());
                                break;
                            }
                            item.add(cell.getNumericCellValue());
                            break;
                        }
                        case 2: {
                            item.add(cell.getCellFormula());
                            break;
                        }
                    }
                }
                content.add(item);
            }
            return content;
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.read.excle.error", new Object[]{e.getLocalizedMessage()}));
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(this.getMessage("doc.excle.format.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    public Document writeExcel(Map<String, List> data, String tplName) {
        if (this.isNull((Object)tplName)) {
            throw new RuntimeException(this.getMessage("doc.name.not.null", new Object[0]));
        }
        Workbook workbook = null;
        Document document = Document.getDocByName((String)tplName);
        Object in = null;
        try {
            workbook = WorkbookFactory.create((InputStream)this.getExcel(document));
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        if (!this.isNull((Object)workbook)) {
            for (Map.Entry<String, List> entry : data.entrySet()) {
                String sheetName = entry.getKey();
                List values = entry.getValue();
                Sheet sheet = workbook.getSheet(sheetName);
                if (this.isNull((Object)sheet)) {
                    throw new RuntimeException(this.getMessage("doc.sheet.null", new Object[]{sheetName}));
                }
                int rowIndex = -1;
                CellStyle cellStyle = null;
                for (Row row : sheet) {
                    Cell start = row.getCell(0);
                    if (this.isNull((Object)start) || !"[$]".equals(start.getStringCellValue())) continue;
                    rowIndex = start.getRowIndex();
                    cellStyle = start.getCellStyle();
                    break;
                }
                if (rowIndex == -1) {
                    throw new RuntimeException(this.getMessage("doc.start.position.not.set", new Object[0]));
                }
                Row row = null;
                Cell cell = null;
                for (int i = 0; i < values.size(); ++i) {
                    row = sheet.createRow(i + rowIndex);
                    List columns = (List)values.get(i);
                    for (int cIndex = 0; cIndex < columns.size(); ++cIndex) {
                        cell = row.createCell(cIndex);
                        cell.setCellStyle(cellStyle);
                        Object value = columns.get(cIndex);
                        if (value instanceof Integer) {
                            cell.setCellValue((double)((Integer)value).intValue());
                            continue;
                        }
                        if (value instanceof Double) {
                            cell.setCellValue(((Double)value).doubleValue());
                            continue;
                        }
                        cell.setCellValue(String.valueOf(value));
                    }
                }
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                workbook.write((OutputStream)out);
                document.setContent(out.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(this.getMessage("doc.out.stream.error", new Object[]{e.getLocalizedMessage()}));
            }
        }
        return document;
    }

    public Document writeExcel(List<Map> data) throws Exception {
        Document document = "old".equals(AppPropertyUtils.getAppEnv((String)"office.plugin.version")) ? new Document(Tag.result.name(), Document.Type.xls) : new Document(Tag.result.name(), Document.Type.xlsx);
        XSSFWorkbook workbook = new XSSFWorkbook();
        for (Map item : data) {
            String sheetName = this.isNull(item.get(Tag.name.name())) ? "Sheet" + data.indexOf(item) : String.valueOf(item.get(Tag.name.name()));
            Sheet sheet = workbook.createSheet(sheetName);
            Row row = sheet.createRow(0);
            List header = (List)item.get(Tag.header.name());
            for (int i = 0; i < header.size(); ++i) {
                Cell cell = row.createCell(i);
                cell.setCellValue((String)header.get(i));
            }
            List values = (List)item.get(Tag.data.name());
            for (int rowIndex = 0; rowIndex < values.size(); ++rowIndex) {
                row = sheet.createRow(rowIndex + 1);
                List value = (List)values.get(rowIndex);
                for (int colIndex = 0; colIndex < value.size(); ++colIndex) {
                    Cell cell = row.createCell(colIndex);
                    cell.setCellValue(String.valueOf(value.get(colIndex)));
                }
            }
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            document.setContent(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.out.stream.error", new Object[]{e.getLocalizedMessage()}));
        }
        return document;
    }

    public Document writeExcelGZQFX(List<Map> data, String tplName) throws Exception {
        if (this.isNull((Object)tplName)) {
            throw new RuntimeException(this.getMessage("doc.name.not.null", new Object[0]));
        }
        Workbook workbook = null;
        Document document = Document.getDocByName((String)tplName);
        Object in = null;
        try {
            workbook = WorkbookFactory.create((InputStream)this.getExcel(document));
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        if (!this.isNull((Object)workbook)) {
            Sheet sheet = workbook.getSheetAt(0);
            if (this.isNull((Object)sheet)) {
                throw new RuntimeException(this.getMessage("doc.sheet.null", new Object[0]));
            }
            CellStyle cellStyle = null;
            int rowIndex = -1;
            for (Row row : sheet) {
                Cell start = row.getCell(0);
                if (this.isNull((Object)start) || !"[$]".equals(start.getStringCellValue())) continue;
                rowIndex = start.getRowIndex();
                cellStyle = start.getCellStyle();
                break;
            }
            for (Map map : data) {
                String gzqType = String.valueOf(map.get("type"));
                List values = (List)map.get("value");
                if (rowIndex == -1) {
                    throw new RuntimeException(this.getMessage("doc.start.position.not.set", new Object[0]));
                }
                Row row = null;
                Cell cell = null;
                int mergeStartRowIndex = rowIndex;
                for (int i = 0; i < values.size(); ++i) {
                    row = sheet.createRow(i + rowIndex);
                    List columns = (List)values.get(i);
                    cell = row.createCell(0);
                    cell.setCellStyle(cellStyle);
                    cell.setCellValue(gzqType);
                    for (int cIndex = 0; cIndex < columns.size(); ++cIndex) {
                        cell = row.createCell(cIndex);
                        cell.setCellStyle(cellStyle);
                        Object value = columns.get(cIndex);
                        if (value instanceof Integer) {
                            cell.setCellValue((double)((Integer)value).intValue());
                            continue;
                        }
                        if (value instanceof Double) {
                            cell.setCellValue(((Double)value).doubleValue());
                            continue;
                        }
                        cell.setCellValue(String.valueOf(value));
                    }
                }
                sheet.addMergedRegion(new CellRangeAddress(mergeStartRowIndex, rowIndex += values.size(), 0, 0));
            }
            try {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                workbook.write((OutputStream)out);
                document.setContent(out.toByteArray());
            }
            catch (IOException e) {
                throw new RuntimeException(this.getMessage("doc.out.stream.error", new Object[]{e.getLocalizedMessage()}));
            }
        }
        return document;
    }

    public Document writeExcelJCTB(List data, String tplName, String extraParam) throws Exception {
        if (this.isNull((Object)tplName)) {
            throw new RuntimeException(this.getMessage("doc.name.not.null", new Object[0]));
        }
        Workbook workbook = null;
        Document document = Document.getDocByName((String)tplName);
        Object in = null;
        try {
            workbook = WorkbookFactory.create((InputStream)this.getExcel(document));
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        catch (InvalidFormatException e) {
            throw new RuntimeException(this.getMessage("doc.xls.format.error", new Object[]{tplName}));
        }
        if (!this.isNull((Object)workbook)) {
            Sheet sheet = workbook.getSheetAt(0);
            if (this.isNull((Object)sheet)) {
                throw new RuntimeException(this.getMessage("doc.sheet.null", new Object[0]));
            }
            CellStyle cellStyle = null;
            int rowIndex = -1;
            for (Row row : sheet) {
                Cell start = row.getCell(0);
                if (!this.isNull((Object)start) && start.getStringCellValue().contains("[@]")) {
                    start.setCellValue(start.getStringCellValue().replaceAll("\\[\\@\\]", extraParam));
                }
                if (this.isNull((Object)start) || !"[$]".equals(start.getStringCellValue())) continue;
                rowIndex = start.getRowIndex();
                cellStyle = start.getCellStyle();
                break;
            }
            if (rowIndex == -1) {
                throw new RuntimeException(this.getMessage("doc.start.position.not.set", new Object[0]));
            }
            for (int i = 0; i < data.size(); ++i) {
                List temp = (List)data.get(i);
                Row row = sheet.createRow(rowIndex);
                Cell cell = null;
                for (int j = 0; j < temp.size(); ++j) {
                    cell = row.createCell(j);
                    cell.setCellStyle(cellStyle);
                    Object value = temp.get(j);
                    if (value instanceof Integer) {
                        cell.setCellValue((double)((Integer)value).intValue());
                        continue;
                    }
                    if (value instanceof Double) {
                        cell.setCellValue(((Double)value).doubleValue());
                        continue;
                    }
                    cell.setCellValue(String.valueOf(value));
                }
                ++rowIndex;
            }
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            workbook.write((OutputStream)out);
            document.setContent(out.toByteArray());
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.out.stream.error", new Object[]{e.getLocalizedMessage()}));
        }
        return document;
    }

    public Document renderAnalysisExcel(Object data, String tplName, Document.Type type) throws Exception {
        Document document = Document.getDocByName((String)tplName);
        String content = this.templateService.getTemplate(data, "analysis/export/".concat(tplName));
        document.setContent(content.getBytes("utf-8"));
        document.setType(type);
        return document;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Document> readZip(InputStream inputStream) throws Exception {
        assert (inputStream != null) : this.getMessage("doc.zip.is.notnull", new Object[0]);
        ArrayList<Document> documents = new ArrayList<Document>();
        ZipInputStream zip = new ZipInputStream(inputStream);
        java.util.zip.ZipEntry entry = null;
        ByteArrayOutputStream bos = null;
        BufferedInputStream bufferedInputStream = null;
        try {
            if (inputStream.markSupported()) {
                inputStream.mark(inputStream.available());
            } else {
                bufferedInputStream = new BufferedInputStream(inputStream);
                bufferedInputStream.mark(inputStream.available());
            }
            try {
                entry = zip.getNextEntry();
            }
            catch (IllegalArgumentException e) {
                entry = zip.getNextEntry();
            }
            while (entry != null) {
                this.logger.debug(" zip entity name : {} ", (Object)entry.getName());
                try {
                    Document document = Document.getDocByName((String)entry.getName());
                    bos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)zip, (OutputStream)bos);
                    documents.add(document.setContent(bos.toByteArray()));
                    zip.closeEntry();
                    entry = zip.getNextEntry();
                }
                catch (IOException e) {
                    throw new RuntimeException(this.getMessage("doc.zip.entity.error", new Object[]{entry.getName(), e.getLocalizedMessage()}));
                    return documents;
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.zip.error", new Object[]{e.getLocalizedMessage()}));
        }
        finally {
            if (inputStream.markSupported()) {
                inputStream.reset();
            } else {
                bufferedInputStream.reset();
            }
        }
    }

    public List<Document> readZipFile(File file) {
        assert (file != null) : this.getMessage("doc.zip.is.notnull", new Object[0]);
        ArrayList<Document> documents = new ArrayList<Document>();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(file, "GBK");
            Enumeration enumeration = zipFile.getEntries();
            while (enumeration.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)enumeration.nextElement();
                String entryName = entry.getName().trim();
                if (!this.isSupportedType(entryName)) continue;
                Document document = Document.getDocByName((String)entry.getName());
                InputStream inputStream = null;
                try {
                    inputStream = zipFile.getInputStream(entry);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    IOUtils.copy((InputStream)inputStream, (OutputStream)bos);
                    document.setContent(bos.toByteArray());
                    documents.add(document);
                }
                catch (IOException e) {
                    throw new RuntimeException(this.getMessage("doc.zip.entity.error", new Object[]{entry.getName(), e.getLocalizedMessage()}));
                }
                finally {
                    IOUtils.closeQuietly((InputStream)inputStream);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.zip.error", new Object[]{e.getLocalizedMessage()}));
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
        return documents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> readZipIn(InputStream inputStream) throws Exception {
        List<Object> documents = new ArrayList<Document>();
        if (documents.size() == 0) {
            File tmp = new File(System.getProperty("java.io.tmpdir").concat("\\TEMP_" + System.currentTimeMillis()).concat(".zip"));
            try {
                FileOutputStream output = new FileOutputStream(tmp);
                try {
                    IOUtils.copyLarge((InputStream)inputStream, (OutputStream)output, (long)0L, (long)inputStream.available(), (byte[])new byte[inputStream.available()]);
                    output.close();
                }
                finally {
                    IOUtils.closeQuietly((OutputStream)output);
                }
                documents = this.readZipFile(tmp);
                if (documents.size() == 0) {
                    throw new RuntimeException(this.getMessage("zip.format.error", new Object[0]));
                }
            }
            finally {
                FileUtils.deleteQuietly((File)tmp);
            }
        }
        return documents;
    }

    public List<Document> readArchive(InputStream inputStream) {
        return null;
    }

    public List<Document> readArchiveFile(File file) {
        assert (file != null) : this.getMessage("doc.zip.is.notnull", new Object[0]);
        ArrayList<Document> documents = new ArrayList<Document>();
        Archive archive = null;
        try {
            archive = new Archive(file);
            FileHeader fileHeader = archive.nextFileHeader();
            while (!this.isNull((Object)fileHeader)) {
                String entryName = fileHeader.isUnicode() ? fileHeader.getFileNameW().trim() : fileHeader.getFileNameString().trim();
                if (!this.isSupportedType(entryName)) continue;
                try {
                    Document document = Document.getDocByName((String)entryName);
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    archive.extractFile(fileHeader, (OutputStream)bos);
                    document.setContent(bos.toByteArray());
                    documents.add(document);
                }
                catch (RarException e) {
                    this.logger.error(this.getMessage("doc.archive.entity.error", new Object[]{entryName, e.getLocalizedMessage()}));
                    throw new RuntimeException(this.getMessage("doc.archive.entity.error", new Object[]{entryName, e.getLocalizedMessage()}));
                }
                fileHeader = archive.nextFileHeader();
            }
            archive.close();
        }
        catch (RarException e) {
            this.logger.error(this.getMessage("doc.archive.error", new Object[]{e.getLocalizedMessage()}));
            throw new RuntimeException(this.getMessage("doc.archive.error", new Object[]{e.getLocalizedMessage()}));
        }
        catch (IOException e) {
            this.logger.error(this.getMessage("doc.archive.error", new Object[]{e.getLocalizedMessage()}));
            throw new RuntimeException(this.getMessage("doc.archive.error", new Object[]{e.getLocalizedMessage()}));
        }
        finally {
            try {
                if (!this.isNull((Object)archive)) {
                    archive.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return documents;
    }

    public Document renderExcel(Object data, String tplName) throws Exception {
        Document document = Document.getDocByName((String)tplName);
        String content = this.templateService.getTemplate(data, tplName);
        document.setContent(content.getBytes("utf-8"));
        document.setType(Document.Type.xls);
        return document;
    }

    private boolean isSupportedType(String name) {
        for (int i = 0; i < FileType.values().length; ++i) {
            String fileType = FileType.values()[i].name();
            if (!name.endsWith(fileType)) continue;
            return true;
        }
        return false;
    }

    private InputStream getExcel(Document doc) throws IOException {
        try {
            return this.getDocResorce(doc.getFileName()).getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(this.getMessage("doc.not.found", new Object[]{doc.getFileName()}));
        }
    }

    private Resource getDocResorce(String docName) throws MalformedURLException {
        return new UrlResource(this.location.concat(docName));
    }

    public void setLocation(String location) {
        this.location = location;
    }
}

