/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.entity.dict.Item;
import cn.gtmap.onemap.platform.service.DictService;
import cn.gtmap.onemap.platform.service.WebMapService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictServiceImpl
extends BaseLogger
implements DictService {
    @Autowired
    private WebMapService webMapService;
    private static final String ANLYSIS_PREFIX = "analysis_";

    public List<Map> getAnalysisDict(String tpl, String groupName) {
        ArrayList<Map> list = new ArrayList<Map>();
        String dictName = ANLYSIS_PREFIX + groupName.toLowerCase();
        Configuration configuration = this.webMapService.getConfig(tpl);
        List dicts = configuration.getDicts();
        for (Dict dict : dicts) {
            if (!dict.getName().equals(dictName)) continue;
            List dictItems = dict.getDictItems();
            for (Item item : dictItems) {
                HashMap<String, String> temp = new HashMap<String, String>();
                temp.put(item.getName(), item.getValue());
                list.add(temp);
            }
        }
        return list;
    }

    public Dict getDictByName(String tpl, String name) {
        Configuration configuration = this.webMapService.getConfig(tpl);
        List dicts = configuration.getDicts();
        for (Dict dict : dicts) {
            if (!dict.getName().trim().equals(name.trim())) continue;
            return dict;
        }
        return null;
    }
}

