/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.service.impl;

import cn.gtmap.onemap.model.Field;
import cn.gtmap.onemap.model.Layer;
import cn.gtmap.onemap.model.Map;
import cn.gtmap.onemap.model.MapGroup;
import cn.gtmap.onemap.model.MapQuery;
import cn.gtmap.onemap.platform.dao.GTPLDao;
import cn.gtmap.onemap.platform.dao.TplDao;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.ThematicMap;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.service.ConfigService;
import cn.gtmap.onemap.platform.service.ThematicMapService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.service.MetadataService;
import com.google.common.collect.Lists;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ConfigServiceImpl
extends BaseLogger
implements ConfigService {
    @Autowired
    private GTPLDao gtplDao;
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private TplDao tplDao;
    @Autowired
    private ThematicMapService thematicMapService;

    public List<java.util.Map> getThumbTplInfos() {
        ArrayList<java.util.Map> info = new ArrayList<java.util.Map>();
        Configuration configuration = null;
        for (String tplName : this.tplDao.getTplNames()) {
            try {
                configuration = this.getConfiguration(tplName);
                cn.gtmap.onemap.platform.entity.Service service = configuration.getMap().getBaseLayers().size() > 0 ? (cn.gtmap.onemap.platform.entity.Service)configuration.getMap().getBaseLayers().get(0) : (configuration.getMap().getOperationalLayers().size() > 0 ? (cn.gtmap.onemap.platform.entity.Service)configuration.getMap().getOperationalLayers().get(0) : null);
                HashMap<String, String> item = new HashMap<String, String>();
                item.put("tpl", tplName);
                item.put("name", configuration.getName());
                item.put("description", configuration.getDescription());
                item.put("createAt", configuration.getCreateAt());
                item.put("thumbnail", this.isNull((Object)service) || this.isNull((Object)service.getId()) ? null : "/oms/thumbnail/".concat(service.getId()));
                info.add(item);
            }
            catch (Exception e) {
                this.logger.error(e.getLocalizedMessage());
            }
        }
        return info;
    }

    public List<ThematicMap> getThematicMaps() {
        return this.thematicMapService.getAll();
    }

    public void deleteThematicMap(String id) {
        this.thematicMapService.delete(id);
    }

    public ThematicMap updateThematicMap(ThematicMap thematicMap) {
        return (ThematicMap)this.thematicMapService.update((Object)thematicMap);
    }

    public Configuration getConfiguration(String tplName) {
        return this.tplDao.getConfiguration(tplName);
    }

    public List getAllService(String tpl) {
        return this.tplDao.getAllServices(tpl);
    }

    public List<java.util.Map> getLayerFields(String mapId, String layerName) {
        Layer layer = this.metadataService.getLayerByName(mapId, layerName);
        List fieldList = this.metadataService.getFields(layer.getId());
        ArrayList<java.util.Map> list = new ArrayList<java.util.Map>();
        for (Field field : fieldList) {
            HashMap<String, String> temp = new HashMap<String, String>();
            temp.put("name", field.getName());
            temp.put("alias", field.getAlias());
            temp.put("type", (String)field.getType());
            list.add(temp);
        }
        return list;
    }

    public List<java.util.Map> getLayersByService(cn.gtmap.onemap.platform.entity.Service service) {
        ArrayList<java.util.Map> list = new ArrayList<java.util.Map>();
        List layers = this.metadataService.getLayers(service.getId());
        for (int i = 0; i < layers.size(); ++i) {
            Layer layer = (Layer)layers.get(i);
            List fields = this.getLayerFields(service.getId(), layer.getName());
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("serviceId", service.getId());
            temp.put("layerName", layer.getName());
            temp.put("layerIndex", layer.getIndex());
            temp.put("layerUrl", service.getUrl() + "/" + layer.getIndex());
            temp.put("fields", fields);
            list.add(temp);
        }
        return list;
    }

    public List<java.util.Map> getLayers(String tplName) {
        ArrayList<java.util.Map> list = new ArrayList<java.util.Map>();
        List services = this.getAllService(tplName);
        for (cn.gtmap.onemap.platform.entity.Service service : services) {
            List layers = this.metadataService.getLayers(service.getId());
            HashMap<String, Object> temp = new HashMap<String, Object>();
            temp.put("id", service.getId());
            temp.put("name", service.getName());
            temp.put("alias", service.getAlias());
            temp.put("group", service.getGroup());
            temp.put("category", service.getCategory());
            temp.put("url", service.getUrl());
            temp.put("layers", layers);
            list.add(temp);
        }
        return list;
    }

    public Configuration createTpl(String tplName) {
        return this.tplDao.createTpl(tplName);
    }

    public Configuration createTpl(String tpl, String name, String description, String thematicMap, String parentTpl) {
        Configuration configuration = this.createTpl(tpl);
        configuration.setName(name);
        configuration.setDescription(description);
        configuration.setThematicMap(thematicMap);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        configuration.setCreateAt(dateFormat.format(new Date()));
        if (!this.isNull((Object)parentTpl)) {
            Configuration pConfiguration = this.getConfiguration(parentTpl);
            configuration.setCoordinateVisible(pConfiguration.isCoordinateVisible());
            configuration.setLogoVisible(pConfiguration.isLogoVisible());
            configuration.setLogo(pConfiguration.getLogo());
            configuration.setDicts(pConfiguration.getDicts());
            configuration.setWidgets(pConfiguration.getWidgets());
            configuration.setDefaultRegionCode(pConfiguration.getDefaultRegionCode());
            configuration.setDefaultYear(pConfiguration.getDefaultYear());
            configuration.setGeometryService(pConfiguration.getGeometryService());
            configuration.setWidgetContainer(pConfiguration.getWidgetContainer());
            configuration.setMap(pConfiguration.getMap());
            configuration.setPrintService(pConfiguration.getPrintService());
            configuration.setTitle(pConfiguration.getTitle());
        }
        return this.tplDao.saveConfiguration(tpl, configuration);
    }

    public void deleteTpl(String tplName) {
        this.tplDao.deleteTpl(tplName);
    }

    public List<cn.gtmap.onemap.platform.entity.Service> saveAllServices(String tplName, List<cn.gtmap.onemap.platform.entity.Service> services) {
        return this.tplDao.saveAllServices(tplName, services);
    }

    public cn.gtmap.onemap.platform.entity.Service insertService(String tplName, cn.gtmap.onemap.platform.entity.Service service) {
        return this.tplDao.saveOrUpateService(tplName, service);
    }

    public cn.gtmap.onemap.platform.entity.Service updateService(String tplName, cn.gtmap.onemap.platform.entity.Service service) {
        return this.tplDao.saveOrUpateService(tplName, service);
    }

    public void deleteServices(String tplName, String[] serviceIds) {
        this.tplDao.deleteServices(tplName, serviceIds);
    }

    public List<cn.gtmap.onemap.platform.entity.Service> getServicesByIds(String tplName, String[] serviceIds) {
        return this.tplDao.getServicesByIds(tplName, serviceIds);
    }

    public List<cn.gtmap.onemap.platform.entity.Service> saveBaseLayers(String tplName, List<cn.gtmap.onemap.platform.entity.Service> services) {
        return this.tplDao.saveBaseLayers(tplName, services);
    }

    public void deleteBaseLayer(String tplName, String[] serviceIds) {
        this.tplDao.deleteBaseLayer(tplName, serviceIds);
    }

    public java.util.Map<String, ?> getWidgetCollection(String tplName) {
        Configuration configuration = this.getConfiguration(tplName);
        HashMap collection = new HashMap();
        collection.put("dockWidgets", configuration.getWidgets());
        collection.put("widgets", configuration.getWidgetContainer().getWidgets());
        collection.put("widgetsGroup", configuration.getWidgetContainer().getWidgetsGroup());
        if (configuration.getMap().getBaseLayers().size() > 0) {
            collection.put("baseLayer", configuration.getMap().getBaseLayers());
        } else if (configuration.getMap().getOperationalLayers().size() > 0) {
            collection.put("baseLayer", configuration.getMap().getOperationalLayers().get(0));
        }
        return collection;
    }

    public List<Configuration.Widget> getAllDockWidgets(String tplName) {
        return this.getConfiguration(tplName).getWidgets();
    }

    public List<Configuration.Widget> getAllWidgets(String tplName) {
        return this.getConfiguration(tplName).getWidgetContainer().getWidgets();
    }

    public List<Configuration.WidgetsGroup> getAllWidgetGroups(String tplName) {
        return this.getConfiguration(tplName).getWidgetContainer().getWidgetsGroup();
    }

    public Configuration.Widget updateDockWidget(String tplName, Configuration.Widget widget) {
        return this.tplDao.saveOrUpdateDockWidget(tplName, widget);
    }

    public void deleteDockWidget(String tplName, Configuration.Widget widget) {
        this.tplDao.deleteDockWidget(tplName, widget);
    }

    public Configuration.Widget insertWidget(String tplName, Configuration.Widget widget) {
        return this.tplDao.saveOrUpdateWidget(tplName, widget);
    }

    public Configuration.Widget updateWidget(String tplName, Configuration.Widget widget) {
        return this.tplDao.saveOrUpdateWidget(tplName, widget);
    }

    public void deleteWidget(String tplName, Configuration.Widget widget) {
        this.tplDao.deleteWidget(tplName, widget);
    }

    public Configuration.WidgetsGroup insertWidgetGroup(String tplName, Configuration.WidgetsGroup widgetsGroup, Configuration.Widget widget) {
        return this.tplDao.saveOrUpdateWidgetGroup(tplName, widgetsGroup, widget);
    }

    public Configuration.WidgetsGroup updateWidgetGroup(String tplName, Configuration.WidgetsGroup widgetsGroup, Configuration.Widget widget) {
        return this.tplDao.saveOrUpdateWidgetGroup(tplName, widgetsGroup, widget);
    }

    public void deleteWidgetsGroup(String tplName, Configuration.WidgetsGroup widgetsGroup, Configuration.Widget widget) {
        this.tplDao.deleteWidgetsGroup(tplName, widgetsGroup, widget);
    }

    public java.util.Map updateMapInitExtent(String tplName, java.util.Map extent) {
        return this.tplDao.updateMapInitExtent(tplName, extent);
    }

    public double updateDefaultScale(String tplName, double scale) {
        return this.tplDao.updateDefaultScale(tplName, scale);
    }

    public List updateMapLods(String tplName, List lods) {
        return this.tplDao.updateMapLods(tplName, lods);
    }

    public Configuration getGlobalConfiguration(String tplName) {
        Configuration configuration = this.getConfiguration(tplName);
        configuration.setWidgets(null);
        configuration.setWidgetContainer(null);
        configuration.getMap().setBaseLayers(null);
        configuration.getMap().setOperationalLayers(null);
        return configuration;
    }

    public Configuration updateGlobalConfiguration(String tplName, Configuration configuration) {
        return this.tplDao.updateGlobalConfiguration(tplName, configuration);
    }

    public java.util.Map getAllSevices() {
        List mapGroups = this.metadataService.getAllMapGroups();
        ArrayList groupsList = new ArrayList();
        LinkedHashMap<String, List> result = new LinkedHashMap<String, List>();
        result.put("default", this.getServicesByGroupId(null));
        for (MapGroup mapGroup : mapGroups) {
            HashMap<String, String> temp = new HashMap<String, String>();
            temp.put("id", mapGroup.getId());
            temp.put("name", mapGroup.getName());
            temp.put("services", null);
            groupsList.add(temp);
        }
        result.put("groups", groupsList);
        return result;
    }

    public List getServicesByGroupId(String groupId) {
        try {
            List maps = this.metadataService.findMaps(null, MapQuery.query((String)groupId), null).getContent();
            ArrayList services = Lists.newArrayList();
            for (Map map : maps) {
                services.add(cn.gtmap.onemap.platform.entity.Service.fromMap((Map)map, (java.util.Map)this.metadataService.getServices(map.getId()), (String)groupId));
            }
            return services;
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public List getServicesWithClassify() {
        List mapGroupList = this.metadataService.getChildrenMapGroups(null, true);
        return this.organizeGroups(mapGroupList);
    }

    public List organizeGroups(List<MapGroup> groups) {
        ArrayList list = new ArrayList();
        for (MapGroup group : groups) {
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("id", group.getId());
            item.put("name", group.getName());
            ArrayList children = new ArrayList();
            if (group.getChildren() != null && group.getChildren().size() > 0) {
                children.addAll(this.organizeGroups(group.getChildren()));
            }
            item.put("children", children.size() > 0 ? children : null);
            list.add(item);
        }
        return list;
    }

    public List<Configuration.Widget> getCommonWidgets() {
        return this.tplDao.getCommonWidgets();
    }

    public void deleteCommonWidget(String id) {
        this.tplDao.deleteCommonWidget(id);
    }

    public Configuration.Widget insertCommonWidget(Configuration.Widget widget) {
        return this.tplDao.insertCommonWidget(widget);
    }

    public List<Configuration.Widget> getPublicWidgets() {
        return this.tplDao.getPublicWidgets();
    }

    public void deletePublicWidget(String id) {
        this.tplDao.deletePublicWidgets(id);
    }

    public Configuration.Widget insertPublicWidget(Configuration.Widget widget) {
        return this.tplDao.insertPublicWidgets(widget);
    }

    public java.util.Map getSearchConfig() {
        return this.tplDao.getSearchConfig();
    }

    public void updateSearchConfig(String content) {
        this.tplDao.updateSearchConfig(content);
    }

    public Dict saveDict(String tplName, Dict dict) {
        return this.tplDao.saveOrUpdateDict(tplName, dict);
    }

    public void deleteDict(String tplName, String id) {
        this.tplDao.deleteDict(tplName, id);
    }

    public java.util.Map getAnalysizConfig() {
        return this.tplDao.getAnalysisConfig();
    }
}

