/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.dao.impl;

import cn.gtmap.onemap.platform.dao.GTPLDao;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.Function;
import cn.gtmap.onemap.platform.entity.Service;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.entity.dict.Item;
import cn.gtmap.onemap.platform.event.TemplateException;
import cn.gtmap.onemap.platform.service.TemplateService;
import cn.gtmap.onemap.platform.utils.DateUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.lang.reflect.InvocationTargetException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class GTPLDaoImpl
implements GTPLDao {
    @Autowired
    private TemplateService templateService;
    protected Logger logger = LoggerFactory.getLogger(this.getClass());

    public Configuration getConfigByTpl(String tpl) {
        String configContent = this.templateService.getTemplate(this.getConfigFileName(tpl));
        Configuration cg = (Configuration)JSON.parseObject((String)configContent, Configuration.class);
        return cg;
    }

    public void saveConfig(Configuration configuration, String tpl) {
        this.templateService.modify(this.getConfigFileName(tpl), JSON.toJSONString((Object)configuration, (boolean)true));
    }

    public String getConfig(String tpl) {
        return this.templateService.getTemplate(this.getConfigFileName(tpl));
    }

    public Service getServiceById(String serviceId, String tpl) {
        try {
            if (StringUtils.isBlank((String)serviceId)) {
                return null;
            }
            Configuration cg = this.getConfigByTpl(tpl);
            List services = cg.getMap().getOperationalLayers();
            for (Service service : services) {
                JSONObject serviceJson = (JSONObject)JSON.toJSON((Object)service);
                if (!serviceId.equals(serviceJson.get((Object)"id"))) continue;
                return service;
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636eID\u83b7\u53d6\u670d\u52a1\u5f02\u5e38", (Object)e.getLocalizedMessage());
        }
        return null;
    }

    public Dict getDictByName(String name, String tpl) {
        try {
            if (StringUtils.isBlank((String)name)) {
                return null;
            }
            Configuration cg = this.getConfigByTpl(tpl);
            List dicts = cg.getDicts();
            for (Dict dict : dicts) {
                if (!name.equals(dict.getName())) continue;
                return dict;
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u540d\u6b21\u83b7\u53d6\u5b57\u5178\u5f02\u5e38", (Object)e.getLocalizedMessage());
        }
        return null;
    }

    public Dict getDictById(String dictId, String tpl) {
        try {
            if (StringUtils.isBlank((String)dictId)) {
                return null;
            }
            Configuration cg = this.getConfigByTpl(tpl);
            List dicts = cg.getDicts();
            for (Dict dict : dicts) {
                if (!dictId.equals(dict.getId())) continue;
                return dict;
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636eID\u83b7\u53d6\u5b57\u5178\u5f02\u5e38", (Object)e.getLocalizedMessage());
        }
        return null;
    }

    public List<Service> getServices(Map<String, ?> condition, String tpl) {
        if (condition.isEmpty()) {
            return null;
        }
        ArrayList<Service> serviceList = new ArrayList<Service>();
        Configuration cg = this.getConfigByTpl(tpl);
        List services = cg.getMap().getOperationalLayers();
        List serviceIds = (List)condition.get("serviceIds");
        String xzdm = condition.get("xzdm").toString();
        int year = Integer.parseInt(condition.get("year").toString());
        try {
            for (int i = 0; i < services.size(); ++i) {
                boolean bool;
                Service service = (Service)services.get(i);
                boolean bl = bool = service.getYear() == year;
                if (StringUtils.isNotEmpty((String)xzdm)) {
                    boolean bl2 = bool = bool && service.getXzdm().indexOf(xzdm) > -1;
                }
                if (serviceIds != null) {
                    boolean bl3 = bool = bool && serviceIds.indexOf(service.getId()) > -1;
                }
                if (!bool) continue;
                serviceList.add(service);
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6240\u6709\u670d\u52a1\u5f02\u5e38", (Object)e.getLocalizedMessage());
        }
        return serviceList;
    }

    public List<Service> getServiceByKey(String key, String value, String tpl) {
        if (StringUtils.isBlank((String)key) || value == null) {
            return null;
        }
        ArrayList<Service> serviceList = new ArrayList<Service>();
        Configuration cg = this.getConfigByTpl(tpl);
        List services = cg.getMap().getOperationalLayers();
        try {
            for (Service service : services) {
                JSONObject jsonObject = (JSONObject)JSON.toJSON((Object)service);
                if (!jsonObject.containsKey((Object)key)) continue;
                if (key.equals("xzdm")) {
                    if (jsonObject.get((Object)key).toString().indexOf(value) == -1) continue;
                    serviceList.add(service);
                    continue;
                }
                if (!value.equals(jsonObject.get((Object)key))) continue;
                serviceList.add(service);
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u670d\u52a1\u5f02\u5e38", (Object)e.getLocalizedMessage());
        }
        return serviceList;
    }

    public List<Dict> getRegionCodeDicts(String tpl) {
        try {
            Configuration cg = this.getConfigByTpl(tpl);
            List dicts = cg.getDicts();
            ArrayList<Dict> regionCodes = new ArrayList<Dict>();
            for (Dict dict : dicts) {
                if (dict.getName().indexOf("regionCode_") == -1) continue;
                regionCodes.add(dict);
            }
            return regionCodes;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5b57\u5178\u884c\u653f\u533a\u4ee3\u7801\u5f02\u5e38", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public Dict getRegionCodeDict(String regionCode, String tpl, String year) {
        try {
            if (StringUtils.isBlank((String)year)) {
                return null;
            }
            if ("current".equals(year)) {
                year = DateUtils.getCurrentYear();
            }
            String dictName = "regionCode_".concat(year).concat("_").concat(regionCode);
            List dicts = this.getRegionCodeDicts(tpl);
            Dict tempDict = null;
            for (Dict dict : dicts) {
                if (!dict.getName().equals(dictName)) continue;
                tempDict = dict;
                break;
            }
            if (tempDict == null) {
                return this.getItemByRegionCode(regionCode, tpl);
            }
            return tempDict;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u6240\u6709\u5b57\u5178\u884c\u653f\u533a\u4ee3\u7801\u5f02\u5e38", (Object)e.getLocalizedMessage());
            return null;
        }
    }

    public Item getDictItemById(String dictId, String dictItemId, String tpl) {
        try {
            Dict dict = this.getDictById(dictId, tpl);
            List items = dict.getDictItems();
            for (Item item : items) {
                if (!dictItemId.equals(item.getId())) continue;
                return item;
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u5b57\u5178\u9879\u5f02\u5e38", (Object)e.getLocalizedMessage());
        }
        return null;
    }

    private Dict getItemByRegionCode(String regionCode, String tpl) {
        try {
            Item tempItem = null;
            block2: for (Dict dict : this.getRegionCodeDicts(tpl)) {
                for (Item item : dict.getDictItems()) {
                    if (!regionCode.equals(item.getName())) continue;
                    tempItem = item;
                    continue block2;
                }
            }
            if (tempItem != null) {
                Dict dict = new Dict();
                dict.setName(tempItem.getName());
                dict.setTitle(tempItem.getTitle());
                dict.setValue(tempItem.getValue());
                dict.setId(tempItem.getId());
                return dict;
            }
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u884c\u653f\u533a\u4ee3\u7801\u83b7\u53d6\u5b57\u5178\u5f02\u5e38", (Object)e.getLocalizedMessage());
        }
        return null;
    }

    public List<HashMap<String, Object>> getAllTpl() {
        String[] names = this.templateService.getFileNames("/tpls/");
        ArrayList<HashMap<String, Object>> configurations = new ArrayList<HashMap<String, Object>>();
        if (names != null && names.length > 0) {
            for (String name : names) {
                HashMap<String, String> hashMap = new HashMap<String, String>();
                Configuration cg = this.getConfigByTpl(name.replace(".json", ""));
                hashMap.put("tpl", name.replace(".json", ""));
                hashMap.put("configuration", (String)cg);
                configurations.add(hashMap);
            }
            return configurations;
        }
        return null;
    }

    public String createNewTpl(String tplName, String tplAlias, String description) throws TemplateException {
        if (StringUtils.isBlank((String)tplName)) {
            throw new RuntimeException("\u6a21\u7248\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a\uff01");
        }
        String standerContent = this.templateService.getTemplate("tpl.json", "utf-8");
        Configuration cg = (Configuration)JSON.parseObject((String)standerContent, Configuration.class);
        cg.setName(tplAlias);
        cg.setCreateAt(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        cg.setDescription(description);
        String[] tplNames = this.templateService.getFileNames("/tpls/");
        if (tplNames != null) {
            for (String tpl : tplNames) {
                if (!tplName.concat(".json").equalsIgnoreCase(tpl)) continue;
                throw new TemplateException(tplName.concat(".json"), TemplateException.Type.TPL_EXIST, "\u8be5\u6a21\u677f\u5df2\u5b58\u5728");
            }
        }
        this.saveConfig(cg, tplName);
        return "\u65b0\u5efa\u6a21\u677f\u6210\u529f";
    }

    public String deleteTpl(String tpl) {
        if (StringUtils.isBlank((String)tpl)) {
            throw new RuntimeException("tpl is null");
        }
        tpl = "/tpls/".concat(tpl.concat(".json"));
        this.templateService.deleteTpl(tpl);
        return "\u5220\u9664\u6a21\u677f\u6210\u529f";
    }

    public void updateService(String tpl, Service service) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        try {
            Configuration conf = this.getConfigByTpl(tpl);
            List services = conf.getMap().getOperationalLayers();
            for (Service item : services) {
                if (!service.getId().equals(item.getId())) continue;
                List functions = item.getFunctions();
                PropertyUtils.copyProperties((Object)item, (Object)service);
                item.setFunctions(functions);
                break;
            }
            this.saveConfig(conf, tpl);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
    }

    public void saveFunction(String tpl, String serviceId, Function function) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException {
        Configuration cg = this.getConfigByTpl(tpl);
        List services = cg.getMap().getOperationalLayers();
        for (Service service : services) {
            if (!service.getId().equals(serviceId)) continue;
            ArrayList<Function> funcs2 = service.getFunctions();
            boolean updated = false;
            if (funcs2 != null) {
                for (Function tempFunc : funcs2) {
                    if (tempFunc.getType() != function.getType()) continue;
                    PropertyUtils.copyProperties((Object)tempFunc, (Object)function);
                    updated = true;
                    break;
                }
            }
            if (updated) break;
            if (funcs2 == null) {
                funcs2 = new ArrayList<Function>();
            }
            funcs2.add(function);
            service.setFunctions(funcs2);
            break;
        }
        this.saveConfig(cg, tpl);
    }

    private String getConfigFileName(String tpl) {
        return "/tpls/".concat(tpl).concat(".json");
    }
}

