/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.dao.impl;

import cn.gtmap.onemap.platform.dao.SpatialDao;
import cn.gtmap.onemap.platform.entity.LayerRegion;
import cn.gtmap.onemap.platform.event.GISDaoException;
import cn.gtmap.onemap.platform.event.GeometryServiceException;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.service.impl.BaseLogger;
import cn.gtmap.onemap.platform.support.arcsde.SDEDataSource;
import cn.gtmap.onemap.platform.support.spring.DataBaseContextHolder;
import cn.gtmap.onemap.platform.utils.ArrayUtils;
import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeDelete;
import com.esri.sde.sdk.client.SeError;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeFilter;
import com.esri.sde.sdk.client.SeInsert;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeObjectId;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeQueryInfo;
import com.esri.sde.sdk.client.SeRegistration;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeShape;
import com.esri.sde.sdk.client.SeShapeFilter;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeState;
import com.esri.sde.sdk.client.SeTable;
import com.esri.sde.sdk.client.SeUpdate;
import com.esri.sde.sdk.client.SeVersion;
import com.esri.sde.sdk.client.SeXmlDoc;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.vividsolutions.jts.geom.Geometry;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class ArcSDEDaoImpl
extends BaseLogger
implements SpatialDao {
    protected static final String SE_OBJECTID_FIELD = "OBJECTID";
    protected static final String SE_SHAPE_FIELD = "SHAPE";
    protected static final String SE_SHAPE_AREA = "SHAPE_AREA";
    protected static final String OG_SHAPE_AREA = "OG_SHAPE_AREA";
    protected static final String INPUT_SHAPE_AREA = "IN_SHAPE_AREA";
    private static final int DEFAULT_LIMIT = 10;
    private static final String ARCSDE_DEFAULT_VERSION = "DEFAULT";
    private final Map<String, SeLayer> cacheLayers = new ConcurrentHashMap();
    private final Map<String, SeColumnDefinition[]> cacheTables = new ConcurrentHashMap();
    private final Map<String, CoordinateReferenceSystem> cacheCRS = new ConcurrentHashMap();
    @Resource(name="sdeDataSource")
    private SDEDataSource dataSource;
    @Autowired
    private GeometryService geometryService;

    public SDEDataSource getDataSource() {
        return this.dataSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoordinateReferenceSystem getLayerCRS(String layerName, String dataSource) throws GISDaoException {
        CoordinateReferenceSystem crs = (CoordinateReferenceSystem)this.cacheCRS.get(layerName);
        if (crs == null) {
            SeConnection connection = null;
            try {
                connection = this.getConnection(dataSource);
                crs = this.geometryService.getSeLayerCRS(this.getLayer(connection, layerName));
                this.cacheCRS.put(layerName, crs);
            }
            finally {
                this.returnConnection(connection, dataSource);
            }
        }
        return crs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PeCoordinateSystem getLayerCS(String layerName, String dataSource) {
        SeConnection connection = null;
        try {
            connection = this.getConnection(dataSource);
            PeCoordinateSystem peCoordinateSystem = this.getLayer(connection, layerName).getCoordRef().getCoordSys();
            return peCoordinateSystem;
        }
        finally {
            this.returnConnection(connection, dataSource);
        }
    }

    public SeLayer detectLayer(String layerName, String dbSource) {
        try {
            SeLayer layer = (SeLayer)this.cacheLayers.get(layerName);
            if (layer == null) {
                List layers = this.getLayers(dbSource);
                for (SeLayer lyr : layers) {
                    if (!lyr.getName().toUpperCase().equals(layerName.toUpperCase())) continue;
                    layer = lyr;
                    break;
                }
                if (layer != null) {
                    this.cacheLayers.put(layerName, layer);
                }
            }
            return layer;
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.DETECT_LAYER, e.getLocalizedMessage(), GISDaoException.Type.ARC_SDE);
        }
    }

    private SeConnection getConnection(String dataSource) throws GISDaoException {
        try {
            if (StringUtils.isNotBlank((String)dataSource)) {
                DataBaseContextHolder.setDataBaseType((String)dataSource);
            }
            return this.getDataSource().getSeConnection();
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.DS_CONNECTION, e.getSeError());
        }
        catch (Exception e) {
            throw new GISDaoException(GISDaoException.Method.DS_CONNECTION, e.getLocalizedMessage(), GISDaoException.Type.ARC_SDE);
        }
    }

    private void returnConnection(SeConnection connection, String dataSource) {
        try {
            if (!this.isNull((Object)dataSource)) {
                DataBaseContextHolder.setDataBaseType((String)dataSource);
            }
            this.getDataSource().returnSeConnection(connection);
        }
        catch (Exception e) {
            throw new GISDaoException(GISDaoException.Method.DS_RETURN, e.getLocalizedMessage(), GISDaoException.Type.ARC_SDE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> query(String layerName, String where, String[] columns, boolean returnGeometry, String dataSource) {
        SeConnection connection = this.getConnection(dataSource);
        try {
            if (columns == null) {
                columns = this.getLayerColumns(connection, layerName);
            }
            if (returnGeometry) {
                columns = ArrayUtils.contains((String[])columns, (String)SE_SHAPE_FIELD, (boolean)true) ? columns : ArrayUtils.add2Arrays((String[])columns, (String[])new String[]{SE_SHAPE_FIELD});
            }
            ArrayList<Map> results = null;
            Object vector = null;
            SeSqlConstruct sqlConstruct = new SeSqlConstruct(layerName, where);
            try {
                SeQueryInfo queryInfo = new SeQueryInfo();
                queryInfo.setQueryType(1);
                queryInfo.setColumns(columns);
                queryInfo.setConstruct(sqlConstruct);
                SeQuery query = new SeQuery(connection);
                query.prepareQueryInfo(queryInfo);
                query.execute();
                SeRow row = query.fetch();
                results = new ArrayList<Map>();
                Map m = null;
                boolean i = false;
                while (row != null) {
                    m = this.seRow2Map(row);
                    try {
                        if (returnGeometry) {
                            m.put(SE_SHAPE_FIELD, ((SeShape)m.get(SE_SHAPE_FIELD)).asText(Integer.MAX_VALUE));
                        }
                    }
                    catch (SeException e) {
                        m.put(SE_SHAPE_FIELD, "");
                        this.logger.error(this.getMessage("sde.seshapetowkt.error", new Object[]{GISDaoException.formateSeError((SeError)e.getSeError())}));
                    }
                    catch (Exception e) {
                        m.put(SE_SHAPE_FIELD, "");
                        this.logger.error(this.getMessage("sde.seshapetowkt.error", new Object[]{e.getLocalizedMessage()}));
                    }
                    results.add(m);
                    row = query.fetch();
                }
            }
            catch (SeException e) {
                throw new GISDaoException(GISDaoException.Method.QUERY, e.getSeError());
            }
            ArrayList<Map> arrayList = results;
            return arrayList;
        }
        finally {
            this.returnConnection(connection, dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<?> query(String layerName, String where, String[] columns, boolean returnGeometry, int limit, String dataSource) {
        SeConnection connection = this.getConnection(dataSource);
        try {
            if (columns == null) {
                columns = this.getLayerColumns(connection, layerName);
            }
            ArrayList<Map> results = null;
            SeSqlConstruct sqlConstruct = new SeSqlConstruct(layerName, where);
            try {
                SeQueryInfo queryInfo = new SeQueryInfo();
                queryInfo.setQueryType(1);
                queryInfo.setColumns(returnGeometry ? (ArrayUtils.contains((String[])columns, (String)SE_SHAPE_FIELD, (boolean)true) ? columns : ArrayUtils.add2Arrays((String[])columns, (String[])new String[]{SE_SHAPE_FIELD})) : columns);
                queryInfo.setConstruct(sqlConstruct);
                SeQuery query = new SeQuery(connection);
                query.prepareQueryInfo(queryInfo);
                query.execute();
                SeRow row = query.fetch();
                results = new ArrayList<Map>();
                int i = 0;
                if (limit < 1) {
                    limit = 10;
                }
                while (row != null && i < limit) {
                    Map m = this.seRow2Map(row);
                    try {
                        if (returnGeometry) {
                            m.put(SE_SHAPE_FIELD, ((SeShape)m.get(SE_SHAPE_FIELD)).asText(Integer.MAX_VALUE));
                        }
                    }
                    catch (SeException e) {
                        this.logger.error(this.getMessage("sde.seshapetowkt.error", new Object[]{GISDaoException.formateSeError((SeError)e.getSeError())}));
                    }
                    catch (Exception e) {
                        this.logger.error(this.getMessage("sde.seshapetowkt.error", new Object[]{e.getLocalizedMessage()}));
                    }
                    results.add(m);
                    row = query.fetch();
                    ++i;
                }
            }
            catch (SeException e) {
                throw new GISDaoException(GISDaoException.Method.QUERY, e.getSeError());
            }
            ArrayList<Map> arrayList = results;
            return arrayList;
        }
        finally {
            this.returnConnection(connection, dataSource);
        }
    }

    /*
     * Exception decompiling
     */
    public List<?> query(String layerName, String wkt, String[] columns, String dataSource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public SeQuery query2(String layerName, String where, String[] columns, boolean returnGeometry, String dataSource) {
        SeConnection connection = this.getConnection(dataSource);
        try {
            if (columns == null) {
                columns = this.getLayerColumns(connection, layerName);
            }
            SeSqlConstruct sqlConstruct = new SeSqlConstruct(layerName, where);
            try {
                SeQueryInfo queryInfo = new SeQueryInfo();
                queryInfo.setQueryType(1);
                queryInfo.setColumns(returnGeometry ? (ArrayUtils.contains((String[])columns, (String)SE_SHAPE_FIELD, (boolean)true) ? columns : ArrayUtils.add2Arrays((String[])columns, (String[])new String[]{SE_SHAPE_FIELD})) : columns);
                queryInfo.setConstruct(sqlConstruct);
                SeQuery query = new SeQuery(connection);
                query.prepareQueryInfo(queryInfo);
                query.execute();
                SeQuery seQuery = query;
                return seQuery;
            }
            catch (SeException e) {
                throw new GISDaoException(GISDaoException.Method.QUERY, e.getSeError());
            }
        }
        finally {
            this.returnConnection(connection, dataSource);
        }
    }

    public List<?> intersect(String layerName, String wktPlygon, String[] returnFields, String dataSource) {
        ArrayList results = new ArrayList();
        SeConnection connection = this.getConnection(dataSource);
        try {
            returnFields = returnFields == null ? this.getLayerColumns(connection, layerName) : ArrayUtils.add2Arrays((String[])returnFields, (String[])new String[]{SE_OBJECTID_FIELD, SE_SHAPE_FIELD});
            SeLayer layer = this.getLayer(connection, layerName);
            CoordinateReferenceSystem layerCRS = this.geometryService.getSeLayerCRS(layer);
            CoordinateReferenceSystem sourceCRS = null;
            String regionField = null;
            if (layerCRS instanceof GeographicCRS) {
                LayerRegion layerRegion = this.geometryService.getLayerRegion(layerName);
                if (!this.isNull((Object)layerRegion.getSourceLayerCRS())) {
                    sourceCRS = layerRegion.getSourceLayerCRS();
                } else if (!this.isNull((Object)layerRegion.getRegionField())) {
                    regionField = layerRegion.getRegionField();
                    if (!this.checkFieldInLayer(regionField, layerName, connection)) {
                        throw new RuntimeException(this.getMessage("field.not.in.layer", new Object[]{regionField, layerName}));
                    }
                    if (!ArrayUtils.contains((String[])returnFields, (String)regionField, (boolean)true)) {
                        returnFields = ArrayUtils.add2Arrays((String[])returnFields, (String)regionField);
                    }
                }
            }
            try {
                SeShape shape = new SeShape(layer.getCoordRef());
                shape.generateFromText(wktPlygon);
                List fResults = this.spatialQuery(connection, shape, layerName, returnFields);
                if (fResults.size() < 1) {
                    this.logger.info(this.getMessage("query.result.null", new Object[]{layerName}));
                }
                HashMap<String, Object> result = null;
                for (Map item : fResults) {
                    try {
                        SeShape[] shapes;
                        SeShape tShape = (SeShape)item.get(SE_SHAPE_FIELD);
                        if (tShape == null || (shapes = shape.intersect(tShape)) == null || shapes.length == 0) continue;
                        for (SeShape tmp : shapes) {
                            result = new HashMap<String, Object>();
                            result.putAll(item);
                            result.put(SE_SHAPE_FIELD, tmp.asText(Integer.MAX_VALUE));
                            if (layerCRS instanceof GeographicCRS) {
                                try {
                                    result.put(SE_SHAPE_AREA, this.getProjectArea(tmp, layerCRS, this.isNull((Object)regionField) ? sourceCRS : this.geometryService.getCRSByRegionCode(String.valueOf(item.get(regionField)))));
                                    result.put(OG_SHAPE_AREA, this.getProjectArea(tShape, layerCRS, this.isNull((Object)regionField) ? sourceCRS : this.geometryService.getCRSByRegionCode(String.valueOf(item.get(regionField)))));
                                    result.put(INPUT_SHAPE_AREA, this.getProjectArea(shape, layerCRS, this.isNull((Object)regionField) ? sourceCRS : this.geometryService.getCRSByRegionCode(String.valueOf(item.get(regionField)))));
                                }
                                catch (Exception e) {
                                    this.logger.error("ArcGISDao -- project error -- detail [{}]", (Object)e.getLocalizedMessage());
                                    result.put(SE_SHAPE_AREA, 0);
                                    result.put(OG_SHAPE_AREA, 0);
                                    result.put(INPUT_SHAPE_AREA, 0);
                                }
                            } else {
                                result.put(SE_SHAPE_AREA, this.isPolygon(tmp) ? tmp.getArea() : tmp.getLength());
                                result.put(OG_SHAPE_AREA, this.isPolygon(tShape) ? tShape.getArea() : tShape.getLength());
                                result.put(INPUT_SHAPE_AREA, this.isPolygon(shape) ? shape.getArea() : shape.getLength());
                            }
                            results.add(result);
                        }
                    }
                    catch (Exception e) {
                        this.logger.error("something was wrong [{}]", (Object)e.getLocalizedMessage());
                    }
                }
                ArrayList arrayList = results;
                return arrayList;
            }
            catch (SeException e) {
                throw new GISDaoException(GISDaoException.Method.INTERSECT, e.getSeError());
            }
        }
        finally {
            this.returnConnection(connection, dataSource);
        }
    }

    private double getProjectArea(SeShape shape, CoordinateReferenceSystem srcCRS, CoordinateReferenceSystem targetCRS) throws SeException {
        Geometry geo = this.geometryService.readWKT(shape.asText(Integer.MAX_VALUE));
        Geometry geo2 = null;
        try {
            geo2 = this.geometryService.project(geo, srcCRS, targetCRS);
        }
        catch (GeometryServiceException e) {
            this.logger.error(" project get area error -- " + e.getLocalizedMessage());
            geo = this.geometryService.simplify(geo, this.geometryService.getSimplifyTolerance());
            geo2 = this.geometryService.project(geo, srcCRS, targetCRS);
        }
        if (this.isPolygon(shape)) {
            return geo2.getArea();
        }
        return geo2.getLength();
    }

    public String insert(String layerName, Map<String, Object> columns, String dataSource) {
        SeConnection connection = this.getConnection(dataSource);
        try {
            String string;
            HashMap<String, Object> newColumns;
            block10: {
                SeLayer layer = this.getLayer(connection, layerName);
                try {
                    List<String> layerColumns = Arrays.asList(this.getLayerColumns(connection, layerName));
                    newColumns = new HashMap<String, Object>();
                    for (String key : columns.keySet()) {
                        boolean contains = false;
                        for (int i = 0; i < layerColumns.size(); ++i) {
                            if (!String.valueOf(layerColumns.get(i)).equalsIgnoreCase(key)) continue;
                            contains = true;
                            break;
                        }
                        if (contains) {
                            newColumns.put(key, columns.get(key));
                            continue;
                        }
                        this.logger.info("\u5f85\u63d2\u5165\u5b57\u6bb5\u300e" + key + " \u300f\u5728\u56fe\u5c42\u300e" + layerName + "\u300f\u4e2d\u4e0d\u5b58\u5728,\u5c06\u88ab\u5ffd\u7565...");
                    }
                    this.wktShape2SeShape(newColumns, layer);
                    if (!this.isLayerVersioned(connection, layer)) break block10;
                    string = this.insertByVersion(connection, layerName, newColumns);
                    return string;
                }
                catch (SeException e) {
                    throw new GISDaoException(GISDaoException.Method.INSERT, e.getSeError());
                }
            }
            string = this.insertByNoVersion(connection, layerName, newColumns);
            return string;
        }
        finally {
            this.returnConnection(connection, dataSource);
        }
    }

    public int insertRows(String layerName, List<Map<String, Object>> rows, String dataSource) {
        SeConnection connection = this.getConnection(dataSource);
        try {
            block11: {
                SeLayer layer = this.getLayer(connection, layerName);
                try {
                    List<String> layerColumns = Arrays.asList(this.getLayerColumns(connection, layerName));
                    HashMap newColumns = new HashMap();
                    ArrayList<String> noneKeys = new ArrayList<String>();
                    Map<String, Object> columns = rows.get(0);
                    for (String string : columns.keySet()) {
                        boolean contains = false;
                        for (int i = 0; i < layerColumns.size(); ++i) {
                            if (!String.valueOf(layerColumns.get(i)).equalsIgnoreCase(string)) continue;
                            contains = true;
                            break;
                        }
                        if (contains) continue;
                        this.logger.info("\u5f85\u63d2\u5165\u5b57\u6bb5\u300e" + string + " \u300f\u5728\u56fe\u5c42\u300e" + layerName + "\u300f\u4e2d\u4e0d\u5b58\u5728,\u5c06\u88ab\u5ffd\u7565...");
                        noneKeys.add(string);
                    }
                    for (Map map : rows) {
                        for (String ky : noneKeys) {
                            map.remove(ky);
                        }
                        this.wktShape2SeShape(map, layer);
                    }
                    if (!this.isLayerVersioned(connection, layer)) break block11;
                    int n = this.insertRowsByVersion(connection, layerName, rows);
                    return n;
                }
                catch (SeException e) {
                    throw new GISDaoException(GISDaoException.Method.INSERT, e.getSeError());
                }
            }
            int n = this.insertRowsByNoVersion(connection, layerName, rows);
            return n;
        }
        finally {
            this.returnConnection(connection, dataSource);
        }
    }

    public boolean update(String layerName, String primaryKey, Map<String, Object> columns, String dataSource) {
        SeConnection connection = this.getConnection(dataSource);
        try {
            block7: {
                SeLayer layer = this.getLayer(connection, layerName);
                try {
                    this.wktShape2SeShape(columns, layer);
                    if (!this.isLayerVersioned(connection, layer)) break block7;
                    boolean bl = this.updateByVersion(connection, layerName, columns, primaryKey);
                    return bl;
                }
                catch (SeException e) {
                    throw new GISDaoException(GISDaoException.Method.UPDATE, e.getSeError());
                }
            }
            boolean bl = this.updateByNoVersion(connection, layerName, columns, primaryKey);
            return bl;
        }
        finally {
            this.returnConnection(connection, dataSource);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateByVersion(SeConnection connection, String layerName, Map columns, String objectId) {
        SeVersion version = this.getDefaultVersion(connection);
        SeState newState = this.createNewState(connection, version);
        SeUpdate update = null;
        try {
            update = new SeUpdate(connection);
            try {
                connection.startTransaction();
                update.setState(newState.getId(), new SeObjectId(-1L), 0);
                update.toTable(layerName, this.getColumnNames(columns), "OBJECTID=" + objectId);
                SeRow row = update.getRowToSet();
                this.setRowColumnsValue(row, columns);
                update.execute();
                version.changeState(newState.getId());
                connection.commitTransaction();
                boolean bl = true;
                return bl;
            }
            catch (SeException e) {
                connection.rollbackTransaction();
                throw new GISDaoException(GISDaoException.Method.UPDATE, e.getSeError());
            }
            finally {
                update.close();
                this.closeState(newState);
            }
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.UPDATE, e.getSeError());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean updateByNoVersion(SeConnection connection, String layerName, Map columns, String objectId) {
        try {
            SeUpdate update = new SeUpdate(connection);
            try {
                connection.startTransaction();
                update.toTable(layerName, this.getColumnNames(columns), "OBJECTID=" + objectId);
                SeRow row = update.getRowToSet();
                this.setRowColumnsValue(row, columns);
                update.execute();
                connection.commitTransaction();
                boolean bl = true;
                return bl;
            }
            catch (SeException e) {
                connection.rollbackTransaction();
                throw new GISDaoException(GISDaoException.Method.UPDATE, e.getSeError());
            }
            finally {
                update.close();
            }
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.UPDATE, e.getSeError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean delete(String layerName, String primaryKey, String dataSource) {
        SeConnection connection = this.getConnection(dataSource);
        try {
            SeObjectId objectId = null;
            Assert.notNull((Object)primaryKey, (String)this.getMessage("sde.prikey.notnull", new Object[0]));
            objectId = new SeObjectId(Long.valueOf(primaryKey).longValue());
            if (this.isLayerVersioned(connection, this.getLayer(connection, layerName))) {
                boolean bl = this.deleteByVersion(connection, layerName, objectId);
                return bl;
            }
            boolean bl = this.deleteByNoVersion(connection, layerName, objectId);
            return bl;
        }
        finally {
            this.returnConnection(connection, dataSource);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getLayerColumns(String layerName, String dataSource) {
        SeConnection connection = null;
        try {
            connection = this.getConnection(dataSource);
            String[] stringArray = this.getLayerColumns(connection, layerName);
            return stringArray;
        }
        finally {
            this.returnConnection(connection, dataSource);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteByVersion(SeConnection connection, String layerName, SeObjectId objectId) {
        try {
            SeVersion version = this.getDefaultVersion(connection);
            SeState newState = this.createNewState(connection, version);
            SeDelete delete = new SeDelete(connection);
            try {
                connection.startTransaction();
                delete.setState(newState.getId(), new SeObjectId(-1L), 0);
                delete.byId(layerName, objectId);
                version.changeState(newState.getId());
                connection.commitTransaction();
                boolean bl = true;
                return bl;
            }
            catch (SeException e) {
                connection.rollbackTransaction();
                throw new GISDaoException(GISDaoException.Method.DELETE, e.getSeError());
            }
            finally {
                delete.close();
                this.closeState(newState);
            }
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.DELETE, e.getSeError());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean deleteByNoVersion(SeConnection connection, String layerName, SeObjectId objectId) {
        try {
            SeDelete delete = null;
            try {
                connection.startTransaction();
                delete = new SeDelete(connection);
                delete.byId(layerName, objectId);
                connection.commitTransaction();
                boolean bl = true;
                return bl;
            }
            catch (SeException e) {
                connection.rollbackTransaction();
                throw new GISDaoException(GISDaoException.Method.DELETE, e.getSeError());
            }
            finally {
                if (delete != null) {
                    delete.close();
                }
            }
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.DELETE, e.getSeError());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String insertByVersion(SeConnection connection, String layerName, Map<String, Object> columns) {
        try {
            SeVersion version = this.getDefaultVersion(connection);
            SeState newState = this.createNewState(connection, version);
            SeInsert insert = new SeInsert(connection);
            try {
                connection.startTransaction();
                insert.setState(newState.getId(), new SeObjectId(-1L), 0);
                insert.intoTable(layerName, this.getColumnNames(columns));
                SeRow row = insert.getRowToSet();
                this.setRowColumnsValue(row, columns);
                insert.execute();
                version.changeState(newState.getId());
                connection.commitTransaction();
                String string = String.valueOf(insert.lastInsertedRowId().longValue());
                return string;
            }
            catch (SeException e) {
                connection.rollbackTransaction();
                throw new GISDaoException(GISDaoException.Method.INSERT, e.getSeError());
            }
            finally {
                insert.close();
                this.closeState(newState);
            }
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.INSERT, e.getSeError());
        }
    }

    private int insertRowsByVersion(SeConnection connection, String layerName, List<Map<String, Object>> rows) {
        int pass = 0;
        try {
            SeVersion version = this.getDefaultVersion(connection);
            SeState newState = this.createNewState(connection, version);
            SeInsert insert = new SeInsert(connection);
            try {
                connection.startTransaction();
                insert.setState(newState.getId(), new SeObjectId(-1L), 0);
                insert.setWriteMode(true);
                insert.intoTable(layerName, this.getColumnNames(rows.get(0)));
                for (Map<String, Object> columns : rows) {
                    SeRow row = insert.getRowToSet();
                    this.setRowColumnsValue(row, columns);
                    insert.execute();
                    ++pass;
                }
                insert.flushBufferedWrites();
                version.changeState(newState.getId());
                connection.commitTransaction();
            }
            catch (SeException e) {
                connection.rollbackTransaction();
                throw new GISDaoException(GISDaoException.Method.INSERT, e.getSeError());
            }
            finally {
                insert.close();
                this.closeState(newState);
            }
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.INSERT, e.getSeError());
        }
        return pass;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String insertByNoVersion(SeConnection connection, String layerName, Map<String, Object> columns) {
        try {
            SeInsert insert = null;
            try {
                insert = new SeInsert(connection);
                connection.startTransaction();
                insert.intoTable(layerName, this.getColumnNames(columns));
                SeRow row = insert.getRowToSet();
                this.setRowColumnsValue(row, columns);
                insert.execute();
                connection.commitTransaction();
                String string = String.valueOf(insert.lastInsertedRowId().longValue());
                return string;
            }
            catch (SeException e) {
                connection.rollbackTransaction();
                throw new GISDaoException(GISDaoException.Method.INSERT, e.getSeError());
            }
            catch (Exception e) {
                connection.rollbackTransaction();
                throw new GISDaoException(GISDaoException.Method.INSERT, e.getLocalizedMessage(), GISDaoException.Type.ARC_SDE);
            }
            finally {
                if (insert != null) {
                    insert.close();
                }
            }
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.INSERT, e.getSeError());
        }
    }

    private int insertRowsByNoVersion(SeConnection connection, String layerName, List<Map<String, Object>> rows) {
        int passed = 0;
        try {
            SeInsert insert = null;
            try {
                insert = new SeInsert(connection);
                try {
                    connection.startTransaction();
                    insert.intoTable(layerName, this.getColumnNames(rows.get(0)));
                    insert.setWriteMode(true);
                    for (Map<String, Object> columns : rows) {
                        SeRow row = insert.getRowToSet();
                        this.setRowColumnsValue(row, columns);
                        insert.execute();
                        ++passed;
                    }
                    insert.flushBufferedWrites();
                    connection.commitTransaction();
                }
                catch (SeException e) {
                    connection.rollbackTransaction();
                    throw new GISDaoException(GISDaoException.Method.INSERT, e.getSeError());
                }
            }
            catch (SeException e) {
                throw new GISDaoException(GISDaoException.Method.INSERT, e.getSeError());
            }
            finally {
                if (insert != null) {
                    insert.close();
                }
            }
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.INSERT, e.getSeError());
        }
        return passed;
    }

    private List<Map<String, Object>> spatialQuery(SeConnection connection, SeShape shape, String layerName, String[] columns) {
        SeShapeFilter filter = new SeShapeFilter(layerName, SE_SHAPE_FIELD, shape, 6);
        SeFilter[] filters = new SeFilter[]{filter};
        SeQuery query = null;
        try {
            SeSqlConstruct sqlConstruct = new SeSqlConstruct(layerName);
            if (columns == null || columns != null && columns.length < 1) {
                columns = this.getLayerColumns(connection, layerName);
            }
            query = new SeQuery(connection, columns, sqlConstruct);
            query.prepareQuery();
            query.setSpatialConstraints((short)2, true, filters);
            query.execute();
            SeRow row = query.fetch();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while (row != null) {
                list.add(this.seRow2Map(row));
                row = query.fetch();
            }
            query.close();
            return list;
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.SPATIAL_QUERY, e.getSeError());
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getMessage());
        }
    }

    private SeVersion getDefaultVersion(SeConnection connection) {
        try {
            SeVersion version = null;
            try {
                version = new SeVersion(connection, ARCSDE_DEFAULT_VERSION);
            }
            catch (SeException e) {
                this.logger.error(this.getMessage("sde.default.version.error", new Object[]{GISDaoException.formateSeError((SeError)e.getSeError())}));
                version = connection.getVersionList("")[0];
            }
            return version;
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.SDE_VERSION, e.getSeError());
        }
    }

    private SeState createNewState(SeConnection connection, SeVersion version) {
        try {
            SeState oldState = null;
            SeState newState = null;
            oldState = new SeState(connection, version.getStateId());
            this.closeState(oldState);
            newState = new SeState(connection);
            newState.create(oldState.getId());
            return newState;
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.SDE_STATE, e.getSeError());
        }
    }

    private void closeState(SeState state) {
        if (state != null && state.isOpen()) {
            try {
                state.close();
            }
            catch (SeException e) {
                this.logger.error("state close error [[]]", (Object)e.getSeError());
            }
        }
    }

    private String[] getLayerColumns(SeConnection connection, String layerName) {
        String[] cols = null;
        try {
            String key = layerName;
            SeColumnDefinition[] colDefs = (SeColumnDefinition[])this.cacheTables.get(key);
            if (colDefs == null) {
                colDefs = new SeTable(connection, layerName).describe();
                this.cacheTables.put(key, colDefs);
            }
            cols = new String[colDefs.length];
            for (int i = 0; i < colDefs.length; ++i) {
                cols[i] = colDefs[i].getName();
            }
        }
        catch (SeException e) {
            this.logger.error(this.getMessage("sde.layer.columndef.error", new Object[]{layerName, e.getSeError().getErrDesc()}));
            throw new GISDaoException(GISDaoException.Method.GET_TABLE_COLUMNS, e.getSeError());
        }
        return cols;
    }

    private SeLayer getLayer(SeConnection connection, String layerName) {
        try {
            Assert.notNull((Object)layerName, (String)this.getMessage("sde.layername.notnull", new Object[0]));
            return new SeLayer(connection, layerName, SE_SHAPE_FIELD);
        }
        catch (SeException e) {
            this.logger.error(this.getMessage("sde.layer.not.found", new Object[]{layerName, connection.toString()}));
            throw new GISDaoException(GISDaoException.Method.GET_LAYER, e.getSeError());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<SeLayer> getLayers(String dbSource) throws SeException {
        SeConnection connection = this.getConnection(dbSource);
        try {
            Vector vector = connection.getLayers();
            return vector;
        }
        finally {
            this.returnConnection(connection, dbSource);
        }
    }

    private void setRowColumnsValue(SeRow row, Map<String, Object> columns) throws SeException {
        for (int i = 0; i < row.getNumColumns(); ++i) {
            SeColumnDefinition colDef = row.getColumnDef(i);
            try {
                int type = colDef.getType();
                if (SE_OBJECTID_FIELD.equalsIgnoreCase(colDef.getName())) continue;
                Object value = columns.get(colDef.getName());
                switch (type) {
                    case 5: {
                        row.setString(i, String.valueOf(value));
                        break;
                    }
                    case 14: {
                        row.setNString(i, String.valueOf(value));
                        break;
                    }
                    case 8: {
                        row.setShape(i, (SeShape)value);
                        break;
                    }
                    case 2: {
                        try {
                            row.setInteger(i, Integer.valueOf(String.valueOf(columns.get(colDef.getName()))));
                        }
                        catch (Exception e) {
                            row.setInteger(i, Integer.valueOf(0));
                        }
                        break;
                    }
                    case 11: {
                        try {
                            row.setInteger(i, Integer.valueOf(String.valueOf(columns.get(colDef.getName()))));
                        }
                        catch (Exception e) {
                            row.setInteger(i, null);
                        }
                        break;
                    }
                    case 1: {
                        try {
                            row.setShort(i, Short.valueOf(String.valueOf(columns.get(colDef.getName()))));
                        }
                        catch (Exception e) {
                            row.setShort(i, null);
                        }
                        break;
                    }
                    case 3: {
                        try {
                            row.setFloat(i, Float.valueOf(String.valueOf(columns.get(colDef.getName()))));
                        }
                        catch (Exception e) {
                            row.setFloat(i, Float.valueOf("0.0"));
                        }
                        break;
                    }
                    case 4: {
                        try {
                            row.setDouble(i, Double.valueOf(String.valueOf(columns.get(colDef.getName()))));
                        }
                        catch (Exception e) {
                            row.setDouble(i, Double.valueOf("0.0"));
                        }
                        break;
                    }
                    case 7: {
                        Calendar calendar = Calendar.getInstance();
                        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
                        Date date = null;
                        try {
                            if (value instanceof Date) {
                                date = (Date)value;
                            } else if (value instanceof String) {
                                date = sdf.parse((String)columns.get(colDef.getName()));
                            }
                            calendar.setTime(date);
                        }
                        catch (ParseException e) {
                            date = new Date();
                            calendar.setTime(date);
                        }
                        row.setTime(i, calendar);
                        break;
                    }
                    case 12: {
                        row.setUuid(i, (String)columns.get(colDef.getName()));
                        break;
                    }
                    case 13: {
                        row.setClob(i, new ByteArrayInputStream(((String)columns.get(colDef.getName())).getBytes()));
                        break;
                    }
                    case 15: {
                        row.setClob(i, new ByteArrayInputStream(((String)columns.get(colDef.getName())).getBytes()));
                        break;
                    }
                    case 10: {
                        SeXmlDoc xml = new SeXmlDoc();
                        xml.setText((String)columns.get(colDef.getName()));
                        row.setXml(i, xml);
                    }
                }
                continue;
            }
            catch (SeException e) {
                this.logger.error(this.getMessage("sde.serowsetvalue.error", new Object[]{colDef.getName(), GISDaoException.formateSeError((SeError)e.getSeError())}));
            }
        }
    }

    private Map seRow2Map(SeRow row) {
        if (row == null) {
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            int colCount = row.getNumColumns();
            SeColumnDefinition colDef = null;
            for (int i = 0; i < colCount; ++i) {
                colDef = row.getColumnDef(i);
                try {
                    int type = colDef.getType();
                    switch (type) {
                        case 5: {
                            map.put(colDef.getName(), row.getString(i));
                            break;
                        }
                        case 14: {
                            map.put(colDef.getName(), row.getNString(i));
                            break;
                        }
                        case 2: {
                            map.put(colDef.getName(), row.getInteger(i));
                            break;
                        }
                        case 8: {
                            try {
                                map.put(colDef.getName(), row.getShape(i));
                            }
                            catch (SeException e) {}
                            break;
                        }
                        case 7: {
                            map.put(colDef.getName(), row.getTime(i) != null ? row.getTime(i).getTime() : "");
                            break;
                        }
                        case 1: {
                            map.put(colDef.getName(), row.getShort(i));
                            break;
                        }
                        case 11: {
                            map.put(colDef.getName(), row.getLong(i));
                            break;
                        }
                        case 3: {
                            map.put(colDef.getName(), row.getFloat(i));
                            break;
                        }
                        case 4: {
                            map.put(colDef.getName(), row.getDouble(i));
                            break;
                        }
                        case 12: {
                            map.put(colDef.getName(), row.getUuid(i));
                            break;
                        }
                        case 13: {
                            try {
                                map.put(colDef.getName(), IOUtils.toString((InputStream)row.getClob(i), (String)"utf-8"));
                            }
                            catch (IOException e) {
                                this.logger.error(this.getMessage("sde.serow.read.error", new Object[]{colDef.getName(), e.getLocalizedMessage()}));
                            }
                            break;
                        }
                        case 15: {
                            try {
                                map.put(colDef.getName(), IOUtils.toString((InputStream)row.getNClob(i), (String)"utf-8"));
                            }
                            catch (IOException e) {
                                this.logger.error(this.getMessage("sde.serow.read.error", new Object[]{colDef.getName(), e.getLocalizedMessage()}));
                            }
                            break;
                        }
                        case 10: {
                            map.put(colDef.getName(), row.getXml(i) != null ? row.getXml(i).getText() : "");
                        }
                    }
                    continue;
                }
                catch (SeException e) {
                    this.logger.error(this.getMessage("sde.serowtomap.error", new Object[]{GISDaoException.formateSeError((SeError)e.getSeError())}));
                }
            }
        }
        catch (SeException e) {
            this.logger.error(this.getMessage("sde.serowtomap.error", new Object[]{GISDaoException.formateSeError((SeError)e.getSeError())}));
        }
        catch (Exception e) {
            this.logger.error(this.getMessage("sde.serowtomap.error", new Object[]{e.getLocalizedMessage()}));
        }
        return map;
    }

    private String[] getColumnNames(Map<String, ?> columns) {
        if (columns == null) {
            return new String[0];
        }
        ArrayList<String> names = new ArrayList<String>();
        for (String key : columns.keySet()) {
            if (key == null || SE_OBJECTID_FIELD.equalsIgnoreCase(String.valueOf(key))) continue;
            names.add(key);
        }
        return names.toArray(new String[names.size()]);
    }

    private Map wktShape2SeShape(Map columns, SeLayer layer) throws SeException {
        if (columns.containsKey(SE_SHAPE_FIELD) && columns.get(SE_SHAPE_FIELD) != null) {
            SeShape shape = new SeShape(layer.getCoordRef());
            shape.generateFromText((String)columns.get(SE_SHAPE_FIELD));
            columns.put(SE_SHAPE_FIELD, shape);
        }
        return columns;
    }

    private boolean isLayerVersioned(SeConnection connection, SeLayer layer) {
        try {
            Vector registers = connection.getRegisteredTables();
            for (Object item : registers) {
                SeRegistration registration = (SeRegistration)item;
                if (!registration.hasLayer() || !registration.isMultiVersion() || !registration.getTableName().equals(layer.getTableName())) continue;
                return true;
            }
        }
        catch (SeException e) {
            this.logger.error(this.getMessage("sde.layer.version.error", new Object[]{GISDaoException.formateSeError((SeError)e.getSeError())}));
        }
        return false;
    }

    private boolean isPolygon(SeShape shape) {
        try {
            return shape.getType() == 8 || shape.getType() == 264;
        }
        catch (SeException e) {
            return false;
        }
    }

    private boolean contains(String[] src, String des) {
        return ArrayUtils.contains((String[])src, (String)des, (boolean)false);
    }

    private boolean checkFieldInLayer(String field, String layerName, SeConnection connection) {
        return ArrayUtils.contains((String[])this.getLayerColumns(connection, layerName), (String)field, (boolean)true);
    }

    public Map multiRelations(Map jsonMap, String geometry, String dataSource) {
        HashMap mapList = new HashMap();
        ArrayList results = new ArrayList();
        SeConnection connection = this.getConnection(dataSource);
        String funid = "";
        String relationType = "";
        String[] returnFields = new String[]{};
        String layerName = "";
        String areaorlenType = "";
        String whereClouse = "";
        try {
            HashMap allresult = new HashMap();
            funid = (String)jsonMap.get("funid");
            relationType = (String)jsonMap.get("relationType");
            String layerNames = (String)jsonMap.get("layerName");
            String[] layers = layerNames.split(",");
            if (this.isNull((Object)layers) || layers.length < 1) {
                return null;
            }
            areaorlenType = (String)jsonMap.get("areaorlenType");
            whereClouse = (String)jsonMap.get("whereClouse");
            for (int n = 0; n < layers.length; ++n) {
                layerName = layers[n];
                returnFields = jsonMap.get("returnFields").toString().split(",");
                returnFields = returnFields == null ? this.getLayerColumns(connection, layerName) : ArrayUtils.add2Arrays((String[])returnFields, (String[])new String[]{SE_OBJECTID_FIELD, SE_SHAPE_FIELD});
                SeLayer layer = this.getLayer(connection, layerName);
                SeShape shape = new SeShape(layer.getCoordRef());
                shape.generateFromText(geometry);
                List fResults = null;
                boolean layerType = false;
                if (layer.isPoly() || layer.isLine()) {
                    fResults = this.spatialRelations(connection, "INTERSECT", shape, layerName, returnFields, areaorlenType, whereClouse);
                } else {
                    layerType = true;
                    fResults = this.spatialRelations(connection, "WITHIN", shape, layerName, returnFields, areaorlenType, whereClouse);
                }
                if (fResults.size() < 1) {
                    this.logger.info(this.getMessage("query.result.null", new Object[]{layerName}));
                }
                HashMap<String, Object> result = null;
                for (Map item : fResults) {
                    try {
                        SeShape tShape = (SeShape)item.get(SE_SHAPE_FIELD);
                        if (tShape == null) continue;
                        if (!layerType) {
                            SeShape[] shapes = shape.intersect(tShape);
                            if (shapes == null || shapes.length == 0) continue;
                            for (SeShape tmp : shapes) {
                                result = new HashMap();
                                result.putAll(item);
                                if ("SDE.CKQ".equals(layerName.toUpperCase())) {
                                    result.put("KCTYPE", "\u91c7\u77ff\u6743");
                                } else if ("SDE.TKQ".equals(layerName.toUpperCase())) {
                                    result.put("KCTYPE", "\u63a2\u77ff\u6743");
                                }
                                result.put(SE_SHAPE_AREA, this.isPolygon(tmp) ? tmp.getArea() : tmp.getLength());
                                if (layer.isPoly()) {
                                    result.put("GQ", tmp.getArea() * 1.0E-4);
                                    result.put("M", tmp.getArea() * 0.0015);
                                }
                                results.add(result);
                            }
                            continue;
                        }
                        result = new HashMap<String, Object>();
                        result.putAll(item);
                        results.add(result);
                    }
                    catch (Exception e) {
                        this.logger.error("something was wrong [{}]", (Object)e.getLocalizedMessage());
                    }
                }
            }
            allresult.put("result", results);
            mapList.put(funid, allresult);
            connection.close();
            return mapList;
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.QUERY, e.getSeError());
        }
    }

    private List<Map<String, Object>> spatialRelations(SeConnection connection, String relationType, SeShape shape, String layerName, String[] columns, String areaorlenType, String whereClouse) {
        SeShapeFilter filter = null;
        if (relationType.toUpperCase().equals("INTERSECT")) {
            filter = new SeShapeFilter(layerName, SE_SHAPE_FIELD, shape, 8);
        } else if (relationType.toUpperCase().equals("WITHIN")) {
            filter = new SeShapeFilter(layerName, SE_SHAPE_FIELD, shape, 7);
        } else {
            return null;
        }
        SeFilter[] filters = new SeFilter[]{filter};
        SeQuery query = null;
        try {
            SeSqlConstruct sqlConstruct = new SeSqlConstruct(layerName);
            if (columns == null || columns.length < 1) {
                columns = this.getLayerColumns(connection, layerName);
            }
            sqlConstruct.setWhere(whereClouse);
            query = new SeQuery(connection, columns, sqlConstruct);
            query.prepareQuery();
            query.setSpatialConstraints((short)2, true, filters);
            query.execute();
            SeRow row = query.fetch();
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            while (row != null) {
                list.add(this.seRow2Map(row));
                row = query.fetch();
            }
            query.close();
            return list;
        }
        catch (SeException e) {
            throw new GISDaoException(GISDaoException.Method.SPATIAL_QUERY, e.getSeError());
        }
    }
}

