/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller.portal;

import cn.gtmap.onemap.core.util.RequestUtils;
import cn.gtmap.onemap.model.ServiceType;
import cn.gtmap.onemap.platform.controller.CtrlUtil;
import cn.gtmap.onemap.platform.entity.Configuration;
import cn.gtmap.onemap.platform.entity.Service;
import cn.gtmap.onemap.platform.entity.TplType;
import cn.gtmap.onemap.platform.entity.dict.Dict;
import cn.gtmap.onemap.platform.entity.dict.Item;
import cn.gtmap.onemap.platform.service.MapService;
import cn.gtmap.onemap.platform.service.TplTypeService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import cn.gtmap.onemap.service.MetadataService;
import com.alibaba.fastjson.JSONArray;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/portal"})
public class TPLConfigController
extends BaseController {
    @Autowired
    private MetadataService metadataService;
    @Autowired
    private MapService mapService;
    @Autowired
    private TplTypeService tplTypeService;

    @RequestMapping(value={"/newtpl"}, method={RequestMethod.POST})
    public String newTpl(@RequestParam(value="filename") String filename, @RequestParam(value="tplname") String tplname, @RequestParam(value="description") String description, @RequestParam(value="typeId") String typeId) {
        this.mapService.createTplFile(filename, tplname, description);
        Configuration cg = this.mapService.getConfigByTpl(filename);
        cg.setTypeId(typeId);
        this.mapService.saveConfig(cg, filename);
        this.tplTypeService.updateTplAndTypeRelationShip(null, typeId, filename);
        return "redirect:/portal/tpls";
    }

    @RequestMapping(value={"/removetpl/{tpl}"})
    public String removeTpl(@PathVariable(value="tpl") String name) {
        TplType type;
        Configuration cg = this.mapService.getConfigByTpl(name);
        String typeId = cg.getTypeId();
        if (!StringUtils.isEmpty((String)typeId) && (type = this.tplTypeService.getTplType(typeId)) != null) {
            List tpls = (List)type.getAttribute("tpls", List.class, new ArrayList());
            tpls.remove(name);
            this.tplTypeService.saveTplType(type);
        }
        this.mapService.deleteTpl(name);
        return "redirect:/portal/tpls";
    }

    @RequestMapping(value={"/{tpl}/services"}, method={RequestMethod.GET})
    public String serviceList(@PathVariable String tpl, Model model) {
        JSONArray services = this.mapService.getAllService(tpl);
        Configuration cg = this.mapService.getConfigByTpl(tpl);
        model.addAttribute("services", (Object)services);
        model.addAttribute("tplName", (Object)cg.getName());
        model.addAttribute("tpl", (Object)tpl);
        model.addAttribute("config", (Object)cg);
        return "portal/service/service_config";
    }

    @RequestMapping(value={"/{tpl}/editservice/{serviceId}"})
    public String editService(Model model, @PathVariable String tpl, @PathVariable String serviceId) {
        Map types = this.metadataService.getServices(serviceId);
        HashSet<String> typeSet = new HashSet<String>();
        if (types != null) {
            for (ServiceType temp : types.keySet()) {
                typeSet.add(temp.getValue());
            }
        }
        model.addAttribute("typeSet", typeSet);
        model.addAttribute("service", (Object)this.mapService.getService(serviceId, tpl));
        model.addAttribute("tpl", (Object)tpl);
        return "/portal/service/edit";
    }

    @RequestMapping(value={"/{tpl}/saveservice/{serviceId}"}, method={RequestMethod.POST})
    public String saveService(Model model, @PathVariable String tpl, Service service, RedirectAttributes ra) {
        this.mapService.updateService(service, tpl);
        CtrlUtil.success((RedirectAttributes)ra);
        return "redirect:/portal/" + tpl + "/services";
    }

    @RequestMapping(value={"/{tpl}/allmap"})
    public String allMap(Model model, Pageable pagin, HttpServletRequest request, @PathVariable String tpl) {
        Page page = this.metadataService.getMaps(RequestUtils.getFilters((HttpServletRequest)request, (String)"Q_", (Model)model), pagin);
        List mapWithStatus = this.mapService.getFilterMaps(page, tpl);
        model.addAttribute("maps", (Object)mapWithStatus);
        model.addAttribute("page", (Object)page);
        model.addAttribute("groups", (Object)this.metadataService.getAllMapGroups());
        model.addAttribute("tpl", (Object)tpl);
        return "/portal/service/add-map/map-list";
    }

    @RequestMapping(value={"/{tpl}/services/save"}, method={RequestMethod.POST})
    public String saveServices(@PathVariable(value="tpl") String tpl, @RequestParam(value="mapsJson") String mapsJson, RedirectAttributes ra) {
        List services = JSONArray.parseArray((String)mapsJson, Service.class);
        this.mapService.modifyServices(services, tpl);
        CtrlUtil.success((RedirectAttributes)ra);
        return "redirect:/portal/" + tpl + "/services";
    }

    @RequestMapping(value={"/{tpl}/removemap/{id}"})
    public String deleteService(@PathVariable(value="tpl") String tpl, @PathVariable(value="id") String id, RedirectAttributes ra) {
        this.mapService.deleteService(id, tpl);
        CtrlUtil.success((RedirectAttributes)ra);
        return "redirect:/portal/" + tpl + "/services";
    }

    @RequestMapping(value={"/{tpl}/legend/{serviceId}"})
    public String legend(Model model, @PathVariable String tpl, @PathVariable String serviceId) {
        try {
            boolean visible = false;
            model.addAttribute("tpl", (Object)tpl);
            model.addAttribute("serviceId", (Object)serviceId);
            Configuration cg = this.mapService.getConfigByTpl(tpl);
            List widgets = cg.getWidgetContainer().getWidgets();
            block2: for (Configuration.Widget widget : widgets) {
                if (!widget.getLabel().equals("\u56fe\u4f8b") || widget.getConfig().isEmpty()) continue;
                List maps = (List)widget.getConfig().get("serviceIds");
                for (Map map : maps) {
                    if (!map.get("serviceId").equals(serviceId)) continue;
                    visible = true;
                    continue block2;
                }
            }
            model.addAttribute("visible", (Object)visible);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return "portal/service/legend-config";
    }

    @RequestMapping(value={"/{tpl}/savelegend/{serviceId}"}, method={RequestMethod.POST})
    public String saveLegend(@PathVariable(value="tpl") String tpl, RedirectAttributes ra, HttpServletRequest request) {
        this.mapService.saveLegendConfig(tpl, request.getParameter("serviceId"), request.getParameter("legendVisible"));
        CtrlUtil.success((RedirectAttributes)ra);
        return "redirect:/portal/" + tpl + "/services";
    }

    @RequestMapping(value={"/{tpl}/bindmap"}, method={RequestMethod.POST})
    public String bindMap(@PathVariable String tpl, HttpServletRequest request, RedirectAttributes ra) {
        String[] mapIds = request.getParameterValues("mapid");
        ArrayList<Service> services = new ArrayList<Service>();
        for (String mapId : mapIds) {
            Service service = this.mapService.mapToService(this.metadataService.getMap(mapId));
            services.add(service);
        }
        this.mapService.insertServices(services, tpl);
        CtrlUtil.success((RedirectAttributes)ra);
        return "redirect:/portal/" + tpl + "/services";
    }

    @RequestMapping(value={"/{tpl}/global"})
    public String showGl(@PathVariable String tpl, Model model) {
        Configuration cg = this.mapService.getConfigByTpl(tpl);
        model.addAttribute("config", (Object)cg);
        model.addAttribute("tplName", (Object)cg.getName());
        model.addAttribute("tpl", (Object)tpl);
        model.addAttribute("types", (Object)this.tplTypeService.queryAllTplType());
        return "/portal/global/gl_config";
    }

    @RequestMapping(value={"/{tpl}/savegl"}, method={RequestMethod.POST})
    public String saveGl(@PathVariable String tpl, Configuration config, RedirectAttributes ra, @RequestParam(value="name") String name, @RequestParam(value="oldTypeId") String oldTypeId, @RequestParam(value="baseLayerType") String baseLayerType, @RequestParam(value="baseLayerUrl") String baseLayerUrl) {
        if (StringUtils.isNotBlank((String)baseLayerType) && StringUtils.isNotBlank((String)baseLayerUrl)) {
            ArrayList<Service> baseLayers = new ArrayList<Service>();
            Service service = new Service();
            service.setUrl(baseLayerUrl);
            service.setType(baseLayerType);
            baseLayers.add(service);
            Configuration.Map map = new Configuration.Map();
            map.setBaseLayers(baseLayers);
            config.setMap(map);
        }
        this.mapService.modifyGlobal(config, tpl);
        Configuration cfg = this.mapService.getConfigByTpl(tpl);
        cfg.setName(name);
        this.mapService.saveConfig(cfg, tpl);
        this.tplTypeService.updateTplAndTypeRelationShip(oldTypeId, config.getTypeId(), tpl);
        CtrlUtil.success((RedirectAttributes)ra);
        return "redirect:/portal/" + tpl + "/global";
    }

    @RequestMapping(value={"/{tpl}/dicts"}, method={RequestMethod.GET})
    public String dictList(@PathVariable String tpl, Model model) {
        Configuration cg = this.mapService.getConfigByTpl(tpl);
        model.addAttribute("tplName", (Object)cg.getName());
        model.addAttribute("tpl", (Object)tpl);
        model.addAttribute("dicts", (Object)cg.getDicts());
        model.addAttribute("config", (Object)cg);
        return "portal/dict/list";
    }

    @RequestMapping(value={"/{tpl}/editdict"}, method={RequestMethod.GET})
    public String editDict(@PathVariable String tpl, @RequestParam(value="dictId", required=false) String dictId, Model model) {
        if (dictId == null) {
            model.addAttribute("dict", (Object)new Dict());
        } else {
            model.addAttribute("dict", (Object)this.mapService.getDict(dictId, tpl));
        }
        return "portal/dict/edit";
    }

    @RequestMapping(value={"/{tpl}/savedict"}, method={RequestMethod.POST})
    public String saveDict(@PathVariable(value="tpl") String tpl, Dict dict, RedirectAttributes ra) {
        this.mapService.updateDict(dict, tpl);
        CtrlUtil.success((RedirectAttributes)ra);
        return "redirect:/portal/" + tpl + "/dicts";
    }

    @RequestMapping(value={"/{tpl}/removedict/{dictId}"})
    public String removeDict(@PathVariable(value="tpl") String tpl, @PathVariable(value="dictId") String dictId, RedirectAttributes ra) {
        this.mapService.deleteDict(dictId, tpl);
        CtrlUtil.success((RedirectAttributes)ra);
        return "redirect:/portal/" + tpl + "/dicts";
    }

    @RequestMapping(value={"/{tpl}/subdicts/{dictId}"})
    public String subDicts(@PathVariable(value="tpl") String tpl, @PathVariable(value="dictId") String dictId, Model model) {
        Configuration cg = this.mapService.getConfigByTpl(tpl);
        model.addAttribute("config", (Object)cg);
        model.addAttribute("tplName", (Object)cg.getName());
        model.addAttribute("tpl", (Object)tpl);
        model.addAttribute("dict", (Object)this.mapService.getDict(dictId, tpl));
        model.addAttribute("subDicts", (Object)this.mapService.getAllDictItems(dictId, tpl));
        return "/portal/dict/sub-list";
    }

    @RequestMapping(value={"/{tpl}/savesubdict/{dictId}"}, method={RequestMethod.POST})
    public String saveSubDict(@PathVariable(value="tpl") String tpl, @PathVariable(value="dictId") String dictId, Item item, RedirectAttributes ra) {
        this.mapService.updateDictItem(dictId, item, tpl);
        CtrlUtil.success((RedirectAttributes)ra);
        return "redirect:/portal/" + tpl + "/subdicts/" + dictId;
    }

    @RequestMapping(value={"/{tpl}/editsubdict/{dictId}"}, method={RequestMethod.GET})
    public String editSubDict(@PathVariable String tpl, @PathVariable String dictId, @RequestParam(value="itemId", required=false) String itemId, Model model) {
        if (itemId != null) {
            model.addAttribute("item", (Object)this.mapService.getDictItem(dictId, itemId, tpl));
        } else {
            model.addAttribute("item", (Object)new Item());
        }
        model.addAttribute("tpl", (Object)tpl);
        model.addAttribute("dictId", (Object)dictId);
        return "portal/dict/sub-edit";
    }

    @RequestMapping(value={"/{tpl}/rmsubdict/{dictId}"})
    public String removeSubDict(@PathVariable(value="tpl") String tpl, @PathVariable(value="dictId") String dictId, @RequestParam(value="itemId", required=false) String itemId, RedirectAttributes ra) {
        this.mapService.deleteDictItem(dictId, itemId, tpl);
        CtrlUtil.success((RedirectAttributes)ra);
        return "redirect:/portal/" + tpl + "/subdicts/" + dictId;
    }

    @RequestMapping(value={"/tplTypes"}, method={RequestMethod.GET})
    public String tplTypes(Model model) {
        model.addAttribute("types", (Object)this.tplTypeService.queryAllTplType());
        return "portal/tplTypes";
    }

    @RequestMapping(value={"/tplType/edit"})
    public String editTplType(Model model, @RequestParam(value="typeId", required=false) String typeId) {
        if (StringUtils.isEmpty((String)typeId)) {
            model.addAttribute("tplType", (Object)new TplType());
        } else {
            model.addAttribute("tplType", (Object)this.tplTypeService.getTplType(typeId));
        }
        return "/portal/tplType/edit";
    }

    @RequestMapping(value={"/tplType/save"})
    public String saveTplType(Model model, TplType tplType) {
        if (!StringUtils.isEmpty((String)tplType.getId())) {
            tplType.setThumnail(this.tplTypeService.getTplType(tplType.getId()).getThumnail());
        }
        this.tplTypeService.saveTplType(tplType);
        return "redirect:/portal/tplTypes";
    }

    @RequestMapping(value={"/tplType/toggle"})
    public String toggleTplType(Model model, @RequestParam(value="typeId") String typeId) {
        TplType type;
        type.setEnabled(!(type = this.tplTypeService.getTplType(typeId)).isEnabled());
        this.tplTypeService.saveTplType(type);
        return "redirect:/portal/tplTypes";
    }

    @RequestMapping(value={"/tplType/uploadThumnail"})
    @ResponseBody
    public String uploadThumnail(Model model, @RequestParam(value="img") MultipartFile file, @RequestParam(value="typeId") String typeId) {
        TplType type = null;
        if (!file.isEmpty()) {
            type = this.tplTypeService.getTplType(typeId);
            try {
                type.setThumnail(file.getBytes());
            }
            catch (IOException e) {
                return e.getMessage();
            }
        } else {
            throw new RuntimeException("thumnail can not be empty!");
        }
        this.tplTypeService.saveTplType(type);
        return type.getId();
    }

    @RequestMapping(value={"/tplType/thumnail/{typeId}"})
    @ResponseBody
    public void tplThumnail(@PathVariable(value="typeId") String typeId, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        TplType type = this.tplTypeService.getTplType(typeId);
        byte[] thumnail = type.getThumnail();
        if (thumnail != null) {
            FileCopyUtils.copy((byte[])type.getThumnail(), (OutputStream)response.getOutputStream());
        } else {
            request.getRequestDispatcher("/static/img/zt/default.jpg").forward((ServletRequest)request, (ServletResponse)response);
        }
    }
}

