/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.platform.entity.Document;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.DocumentService;
import cn.gtmap.onemap.platform.service.TransitService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.net.URL;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.xfire.client.Client;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/transitService"})
public class TransitController
extends BaseController {
    @Autowired
    private DocumentService documentService;
    @Autowired
    private TransitService transitService;

    @RequestMapping(value={"/report/output"}, method={RequestMethod.GET, RequestMethod.POST})
    public void reportOutput(@RequestParam(value="dataSource") String dataSource, @RequestParam(value="rId", required=true) int rId, @RequestParam(value="queryCondition", defaultValue="1=1") String queryCondition, @RequestParam(value="layerName", required=true) String layerName, @RequestParam(value="fileName") String fileName, HttpServletResponse response) {
        try {
            Map map = this.transitService.generateReportDataFromSde(rId, layerName, queryCondition, dataSource, true);
            if (rId == 6) {
                this.sendFile((File)map.get("file"), response);
            } else {
                this.sendDocument(response, this.documentService.renderAnalysisExcel((Object)map, fileName, Document.Type.xls));
            }
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("doc.excel.export.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/report/view"})
    public String reportView(@RequestParam(value="dataSource") String dataSource, @RequestParam(value="rId", required=true) int rId, @RequestParam(value="queryCondition", defaultValue="1=1") String queryCondition, @RequestParam(value="layerName", required=true) String layerName, @RequestParam(value="fileName", required=true) String fileName, Model model) {
        try {
            Map map = this.transitService.generateReportDataFromSde(rId, layerName, queryCondition, dataSource, false);
            model.addAttribute("rId", (Object)rId);
            model.addAttribute("data", map.get("data"));
            model.addAttribute("layerName", (Object)layerName);
            model.addAttribute("queryCondition", (Object)queryCondition);
            model.addAttribute("dataSource", (Object)dataSource);
            model.addAttribute("fileName", (Object)fileName);
        }
        catch (Exception e) {
            throw new RuntimeException("report.view.error: " + e.getLocalizedMessage());
        }
        return "transit/report";
    }

    @RequestMapping(value={"/wcf"})
    public String wcf() {
        return "wcf";
    }

    @RequestMapping(value={"/wcf/result"})
    @ResponseBody
    public Map wcfResult(@RequestParam(value="dltb", required=false) String dltb, @RequestParam(value="xzdw", required=false) String xzdw, @RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="wcfUrl", required=true) String wcfUrl, @RequestParam(value="wcfMethod", required=true) String wcfMethod) {
        try {
            Object[] objects;
            Client client = new Client(new URL(wcfUrl));
            JSONObject params = new JSONObject();
            params.put("AnalyseGeoJSON", (Object)geometry);
            params.put("TBLayerName", (Object)dltb);
            params.put("XWLayerName", (Object)xzdw);
            try {
                objects = client.invoke(wcfMethod, (Object[])new String[]{JSON.toJSONString((Object)params)});
            }
            catch (Exception e) {
                this.logger.error(this.getMessage("tdlyxz.wcf.error", new Object[]{e.getLocalizedMessage()}));
                throw new RuntimeException(this.getMessage("tdlyxz.wcf.error", new Object[]{e.getLocalizedMessage()}));
            }
            Map analysisMap = (Map)JSON.parseObject((String)String.valueOf(objects[0]), Map.class);
            return this.result((Object)analysisMap);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }
}

