/*
 * Decompiled with CFR 0.152.
 */
package cn.gtmap.onemap.platform.controller;

import cn.gtmap.onemap.core.support.hibernate.UUIDHexGenerator;
import cn.gtmap.onemap.platform.controller.GeometryController;
import cn.gtmap.onemap.platform.entity.Document;
import cn.gtmap.onemap.platform.entity.FileStore;
import cn.gtmap.onemap.platform.event.JSONMessageException;
import cn.gtmap.onemap.platform.service.BMarkService;
import cn.gtmap.onemap.platform.service.DictService;
import cn.gtmap.onemap.platform.service.DocumentService;
import cn.gtmap.onemap.platform.service.FileStoreService;
import cn.gtmap.onemap.platform.service.GISManager;
import cn.gtmap.onemap.platform.service.GeometryService;
import cn.gtmap.onemap.platform.support.spring.BaseController;
import cn.gtmap.onemap.platform.utils.EnumUtils;
import com.alibaba.fastjson.JSON;
import com.vividsolutions.jts.geom.Geometry;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/geometryService"})
public class GeometryController
extends BaseController {
    @Autowired
    private GISManager gisManager;
    @Autowired
    private BMarkService bMarkService;
    @Autowired
    private DictService dictService;
    @Autowired
    private GeometryService geometryService;
    @Autowired
    private DocumentService documentService;
    @Autowired
    private FileStoreService fileStoreService;

    @RequestMapping(value={"/intersect"})
    @ResponseBody
    public List intersect(@RequestParam(value="layerName") String layerName, @RequestParam(value="wkt") String wkt, @RequestParam(value="returnFields") String returnFields, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource) {
        try {
            return this.gisManager.getGISService().intersect(layerName, wkt, returnFields.split(","), dataSource);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/query"})
    @ResponseBody
    public Map query(@RequestParam(value="layerName") String layerName, @RequestParam(value="where", required=false) String where, @RequestParam(value="geometry", required=false) String geometry, @RequestParam(value="outFields", defaultValue="*") String outFields, @RequestParam(value="returnGeometry", defaultValue="true") boolean returnGeometry, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            this.logger.debug("[query]:" + geometry);
            String[] fields = "*".equals(outFields) ? null : outFields.split(",");
            List result = null;
            if (StringUtils.isNotBlank((String)where)) {
                result = this.gisManager.getGISService().query(layerName, where, fields, returnGeometry, dataSource);
            } else if (StringUtils.isNotBlank((String)geometry)) {
                result = this.gisManager.getGISService().query(layerName, this.gisManager.getGeoService().readGeoJSON(geometry), fields, dataSource);
            } else {
                throw new RuntimeException(this.getMessage("query.condition.missing", new Object[0]));
            }
            FeatureCollection collection = this.gisManager.getGeoService().list2FeatureCollection(result, null, null);
            this.logger.debug("[query result]:" + this.gisManager.getGeoService().toFeatureJSON((Object)collection));
            return this.result((Object)this.gisManager.getGeoService().toFeatureJSON((Object)collection));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/insert"})
    @ResponseBody
    public Map insert(@RequestParam(value="layerName") String layerName, @RequestParam(value="geometry", required=false) String geometry, @RequestParam(value="check", required=false) Boolean check, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            this.logger.debug("[insert]:" + geometry);
            return this.result((Object)this.gisManager.getGISService().insert2(layerName, geometry, check.booleanValue(), dataSource));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/insert2"})
    @ResponseBody
    public Map insert2(@RequestParam(value="layerName") String layerName, @RequestParam(value="geometry", required=false) String geometry, @RequestParam(value="check", required=false) Boolean check, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            this.logger.debug("[insert]:" + geometry);
            return this.result((Object)this.gisManager.getGISService().insert3(layerName, geometry, check.booleanValue(), true, dataSource));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/update"})
    @ResponseBody
    public Map update(@RequestParam(value="layerName") String layerName, @RequestParam(value="primaryKey", required=true) String primaryKey, @RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            this.logger.debug("[update]:" + geometry);
            return this.result((Object)this.gisManager.getGISService().update(layerName, primaryKey, geometry, dataSource));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/delete"})
    @ResponseBody
    public Map delete(@RequestParam(value="layerName") String layerName, @RequestParam(value="primaryKey", required=true) String primaryKey, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            this.logger.debug("[delete]:" + primaryKey);
            return this.result((Object)this.gisManager.getGISService().delete(layerName, primaryKey, dataSource));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/intersect"})
    @ResponseBody
    public Map intersect2(@RequestParam(value="layerName") String layerName, @RequestParam(value="geometry") String geometry, @RequestParam(value="outFields", defaultValue="*") String outFields, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource) {
        try {
            this.logger.debug("[intersect]:" + geometry);
            String[] fields = "*".equals(outFields) ? null : outFields.split(",");
            List results = this.gisManager.getGISService().intersect3(layerName, geometry, fields, dataSource);
            FeatureCollection collection = this.geometryService.list2FeatureCollection(results, null, null);
            return this.result((Object)this.geometryService.toFeatureJSON((Object)collection));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/analysis/tdlyxz"})
    @ResponseBody
    public Map tdlyxzAnalysis(@RequestParam(value="dltb", required=false) String dltb, @RequestParam(value="xzdw", required=false) String xzdw, @RequestParam(value="regionCode", required=false) String regionCode, @RequestParam(value="year", required=false) String year, @RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource) {
        try {
            if (StringUtils.isNotBlank((String)year)) {
                regionCode = year;
            }
            if (StringUtils.isNotBlank((String)regionCode)) {
                return this.result((Object)this.gisManager.getGISService().tdlyxzAnalysis(regionCode, geometry, dataSource));
            }
            if (StringUtils.isNotBlank((String)dltb) && StringUtils.isNotBlank((String)xzdw)) {
                return this.result((Object)this.gisManager.getGISService().tdlyxzAnalysis2(dltb, xzdw, geometry, dataSource));
            }
            throw new RuntimeException(this.getMessage("analysis.tdlyxz.param.error", new Object[0]));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/analysis/tdghsc"})
    @ResponseBody
    public Map tdghscAnalysis(@RequestParam(value="layerType", defaultValue="") String layerType, @RequestParam(value="regionCode", required=false) String regionCode, @RequestParam(value="year", defaultValue="2020") String year, @RequestParam(value="geometry") String geometry, @RequestParam(value="outFields", defaultValue="*") String outFields, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource) {
        try {
            String[] fields;
            String[] stringArray = fields = "*".equals(outFields) ? null : outFields.split(",");
            if (StringUtils.isNotBlank((String)year)) {
                regionCode = year;
            }
            if (StringUtils.isNotBlank((String)layerType)) {
                return this.result((Object)this.gisManager.getGISService().tdghscAnalysis2(layerType, regionCode, geometry, fields, dataSource));
            }
            return this.result((Object)this.gisManager.getGISService().tdghscAnalysis2(regionCode, geometry, fields, dataSource));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/project"})
    @ResponseBody
    public void project(@RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="inSR", required=true) String inSR, @RequestParam(value="outSR", required=true) String outSR, HttpServletResponse response) {
        block4: {
            try {
                Object geo = this.gisManager.getGeoService().readUnTypeGeoJSON(geometry);
                CoordinateReferenceSystem in = this.gisManager.getGeoService().parseUndefineSR(inSR);
                CoordinateReferenceSystem out = this.gisManager.getGeoService().parseUndefineSR(outSR);
                if (geo instanceof Geometry) {
                    Geometry g = this.gisManager.getGeoService().project((Geometry)geo, in, out);
                    this.result((Object)this.gisManager.getGeoService().toGeoJSON(g), response);
                    break block4;
                }
                if (geo instanceof FeatureCollection || geo instanceof SimpleFeature) {
                    Object feature = this.gisManager.getGeoService().project(geo, in, out);
                    this.result((Object)this.gisManager.getGeoService().toFeatureJSON(feature), response);
                    break block4;
                }
                throw new RuntimeException("geometry don't support");
            }
            catch (Exception e) {
                throw new JSONMessageException(e.getLocalizedMessage());
            }
        }
    }

    @RequestMapping(value={"/analysis/hub"})
    public String analysisHub(HttpServletRequest request, Model model) {
        model.addAttribute("type", request.getSession().getAttribute("type"));
        model.addAttribute("title", request.getSession().getAttribute("title"));
        model.addAttribute("params", request.getSession().getAttribute("params"));
        model.addAttribute("geometry", request.getSession().getAttribute("geometry"));
        return "analysis/hub";
    }

    @RequestMapping(value={"/analysis/tdghsc"})
    public String tdghscAnalysis(@RequestParam(value="layerType", defaultValue="") String layerType, @RequestParam(value="regionCode", required=false) String regionCode, @RequestParam(value="year", defaultValue="2020") String year, @RequestParam(value="geometry") String geometry, @RequestParam(value="outFields", defaultValue="*") String outFields, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource, Model model) {
        try {
            String[] fields;
            this.logger.debug("[tdghsc]:" + geometry);
            String[] stringArray = fields = "*".equals(outFields) ? null : outFields.split(",");
            if (StringUtils.isNotBlank((String)year)) {
                regionCode = year;
            }
            Map result = new HashMap();
            if (StringUtils.isNotBlank((String)layerType)) {
                String analysisResult = this.gisManager.getGISService().tdghscAnalysis2(layerType, regionCode, geometry, fields, dataSource);
                result = this.gisManager.getGISService().tdghscResult(layerType, analysisResult);
            } else {
                Map analysisMap = this.gisManager.getGISService().tdghscAnalysis2(regionCode, geometry, fields, dataSource);
                result = this.gisManager.getGISService().tdghscResult(analysisMap);
            }
            model.addAttribute("result", result);
            model.addAttribute("excelData", (Object)JSON.toJSONString((Object)this.gisManager.getGISService().tdghscExcelData(result)));
            return "analysis/tdghsc";
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/analysis/tdlyxz"})
    public String tdlyxzAnalysis(@RequestParam(value="dltb", required=false) String dltb, @RequestParam(value="xzdw", required=false) String xzdw, @RequestParam(value="regionCode", required=false) String regionCode, @RequestParam(value="year", required=false) String year, @RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource, @RequestParam(value="unit", defaultValue="SQUARE", required=false) String unit, @RequestParam(value="tpl", required=true) String tpl, @RequestParam(value="report", required=false) String report, @RequestParam(value="exportable", required=false, defaultValue="false") Boolean exportable, Model model) {
        try {
            Map map;
            this.logger.debug("[tdlyxz geometry]:" + geometry);
            if (StringUtils.isNotBlank((String)year)) {
                regionCode = year;
            }
            if (StringUtils.isNotBlank((String)regionCode)) {
                map = this.gisManager.getGISService().tdlyxzAnalysis(regionCode, geometry, dataSource);
            } else if (StringUtils.isNotBlank((String)dltb) && StringUtils.isNotBlank((String)xzdw)) {
                map = this.gisManager.getGISService().tdlyxzAnalysis2(dltb, xzdw, geometry, dataSource);
            } else {
                throw new RuntimeException(this.getMessage("analysis.tdlyxz.param.error", new Object[0]));
            }
            this.logger.debug("[tdlyxz result]:" + JSON.toJSONString((Object)map));
            if (exportable.booleanValue() && !this.isNull((Object)dltb) && !this.isNull((Object)map) && map.containsKey("analysisAreaDetail") && map.get("analysisAreaDetail") != null) {
                List detail = (List)map.get("analysisAreaDetail");
                FeatureCollection featureCollection = this.gisManager.getGeoService().list2FeatureCollection(detail, null, null);
                File shpFile = this.gisManager.getGeoService().exportToShp(this.gisManager.getGeoService().toFeatureJSON((Object)featureCollection), this.gisManager.getGISService().getLayerCRS(dltb, dataSource));
                if (shpFile.exists()) {
                    FileStore fileStore = this.fileStoreService.save3(shpFile, UUIDHexGenerator.generate());
                    model.addAttribute("shpId", (Object)fileStore.getId());
                }
            }
            List result = this.gisManager.getGISService().tdlyxzResult(map, tpl, unit);
            model.addAttribute("result", (Object)result);
            model.addAttribute("unit", (Object)unit);
            model.addAttribute("exportable", (Object)exportable);
            model.addAttribute("resultStr", (Object)JSON.toJSONString((Object)model.asMap()));
            model.addAttribute("ogGeo", (Object)geometry);
            if (StringUtils.isNotBlank((String)report) && result.size() > 0) {
                model.addAttribute("totalResult", result.get(result.size() - 1));
                Map reportMap = this.gisManager.getGISService().tdlyxzReport((Map)result.get(result.size() - 1), (Map)JSON.parseObject((String)report, Map.class));
                model.addAttribute("report", (Object)reportMap);
                HashMap<String, Object> xlsMap = new HashMap<String, Object>();
                xlsMap.put("report", reportMap);
                xlsMap.put("totalResult", result.get(result.size() - 1));
                xlsMap.put("unit", unit);
                model.addAttribute("reportXls", (Object)JSON.toJSONString(xlsMap));
            }
            return "analysis/tdlyxz";
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/analysis/dj"})
    public String djAnalysis(@RequestParam(value="geometry") String geometry, @RequestParam(value="analysisLayers") String analysisLayers, @RequestParam(value="unit", required=true) String unit, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource, @RequestParam(value="template", defaultValue="result-dj", required=false) String template, Model model) {
        try {
            if (StringUtils.isNotBlank((String)analysisLayers)) {
                List layers = (List)JSON.parseObject((String)analysisLayers, List.class);
                Map areaUnit = (Map)JSON.parseObject((String)unit, Map.class);
                List result = this.gisManager.getGISService().djAnalysis(geometry, layers, dataSource, areaUnit);
                model.addAttribute("unit", (Object)areaUnit);
                model.addAttribute("results", (Object)result);
                return "analysis/".concat(template);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return null;
    }

    @RequestMapping(value={"/analysis/wpjchc"})
    public String wpjchcAnalysis(@RequestParam(value="dataSource", required=false) String dataSource, @RequestParam(value="wpjctb", required=false) String wpjctb, @RequestParam(value="bpdk", required=false) String bpdk, @RequestParam(value="gddk", required=false) String gddk, @RequestParam(value="wfyd", required=false) String wfyd, @RequestParam(value="template", required=false, defaultValue="result-wpjc") String template, Model model) {
        return "";
    }

    @RequestMapping(value={"/analysis/jctb"})
    public String jctbAnalysis(@RequestParam(value="year") String year, @RequestParam(value="geometry") String geometry, @RequestParam(value="analysisLayers") String analysisLayers, @RequestParam(value="unit", required=true) String unit, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource, @RequestParam(value="template", defaultValue="result-jctb", required=false) String template, Model model) {
        try {
            if (StringUtils.isNotBlank((String)analysisLayers)) {
                List layers = (List)JSON.parseObject((String)analysisLayers, List.class);
                Map areaUnit = (Map)JSON.parseObject((String)unit, Map.class);
                List result = this.gisManager.getGISService().jctbAnalysis(geometry, layers, dataSource, areaUnit);
                ArrayList xlsData = new ArrayList();
                for (Map item : result) {
                    HashMap tmp = new HashMap();
                    for (Object k : item.keySet()) {
                        if (k.equals("OG_PRO_SHAPE")) continue;
                        tmp.put(k, item.get(k));
                    }
                    xlsData.add(tmp);
                }
                model.addAttribute("year", (Object)year);
                model.addAttribute("result", (Object)result);
                model.addAttribute("unit", (Object)areaUnit);
                HashMap<String, Object> xlsMap = new HashMap<String, Object>();
                xlsMap.put("year", year);
                xlsMap.put("unit", areaUnit);
                xlsMap.put("xlsData", xlsData);
                model.addAttribute("resultStr", (Object)JSON.toJSONString(xlsMap));
                return "analysis/".concat(template);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new RuntimeException(e.getLocalizedMessage());
        }
        return null;
    }

    @Deprecated
    @RequestMapping(value={"/analysis/ghscxg"}, method={RequestMethod.POST})
    public String ghModifyAnalysis(@RequestParam(value="layerName") String layerName, @RequestParam(value="geometry") String geometry, @RequestParam(value="outFields", defaultValue="*") String outFields, @RequestParam(value="showFields", defaultValue="*") String showFields, @RequestParam(value="dataSource", defaultValue="", required=false) String dataSource, Model model) {
        try {
            this.logger.debug("[analysis]:" + geometry);
            String[] fields = "*".equals(outFields) ? null : outFields.split(",");
            List results = this.gisManager.getGISService().intersect3(layerName, geometry, fields, dataSource);
            Map map = this.gisManager.getGISService().ghscxgData(results, (List)JSON.parseObject((String)showFields, List.class));
            model.addAttribute("showFields", JSON.parseObject((String)showFields, List.class));
            model.addAttribute("results", map.get("result"));
            model.addAttribute("excelData", (Object)JSON.toJSONString(map.get("excel")));
            return "analysis/result-ghscxg";
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/analysis/multiAnalysis"}, method={RequestMethod.POST, RequestMethod.GET})
    public String multiAnalysis(@RequestParam(value="jsonParams") String jsonParams, @RequestParam(value="geometry") String geometry, @RequestParam(value="tpl") String tpl, @RequestParam(value="level", defaultValue="standard") String level, @RequestParam(value="link", required=false) String link, Model model) {
        try {
            List jsonValues = (List)JSON.parseObject((String)jsonParams, List.class);
            LinkedHashMap analysisResult = this.gisManager.getGISService().multiAnalyze(jsonValues, geometry, level, tpl);
            model.addAttribute("result", (Object)analysisResult);
            model.addAttribute("geometry", (Object)geometry);
            HashMap<String, Cloneable> mapData = new HashMap<String, Cloneable>();
            HashMap summaryData = new HashMap();
            for (Map.Entry entry : analysisResult.entrySet()) {
                Map value = (Map)entry.getValue();
                if ("mas".equals(level)) {
                    ArrayList nList;
                    Object r = value.get("result");
                    if (r instanceof Map) {
                        Map analysisMap = (Map)r;
                        HashMap nMap = new HashMap();
                        nList = new ArrayList();
                        nMap.put("info", analysisMap.get("info"));
                        if (analysisMap.containsKey("detail")) {
                            List detail = (List)analysisMap.get("detail");
                            for (Map _d : detail) {
                                HashMap item = new HashMap();
                                for (Object o : _d.keySet()) {
                                    String k = String.valueOf(o);
                                    if (k == "SHAPE") continue;
                                    item.put(o, _d.get(o));
                                }
                                nList.add(item);
                            }
                            nMap.put("detail", nList);
                            mapData.put(String.valueOf(entry.getKey()), nMap);
                        }
                    } else if (r instanceof List) {
                        List analysisList = (List)r;
                        nList = new ArrayList();
                        for (Map _m : analysisList) {
                            HashMap nItem = new HashMap();
                            for (Object _k : _m.keySet()) {
                                String key = String.valueOf(_k);
                                if (key == "SHAPE") continue;
                                nItem.put(_k, _m.get(_k));
                            }
                            nList.add(nItem);
                        }
                        mapData.put(String.valueOf(entry.getKey()), nList);
                    }
                } else {
                    mapData.put(String.valueOf(entry.getKey()), (Cloneable)value.get("result"));
                }
                summaryData.put(String.valueOf(entry.getKey()), value.get("summary"));
            }
            double ogArea = this.gisManager.getGeoService().getGeoArea(this.gisManager.getGeoService().readUnTypeGeoJSON(geometry), null);
            if (!this.isNull((Object)link)) {
                model.addAttribute("linkData", (Object)JSON.toJSONString(mapData));
                model.addAttribute("link", (Object)link);
                model.addAttribute("ogArea", (Object)ogArea);
                model.addAttribute("ogGeo", (Object)geometry);
                model.addAttribute("tpl", (Object)tpl);
                HashMap<String, String> geoMap = new HashMap<String, String>();
                for (Map.Entry entry : analysisResult.entrySet()) {
                    Map map = (Map)entry.getValue();
                    geoMap.put(MapUtils.getString((Map)map, (Object)"alias"), MapUtils.getString((Map)map, (Object)"geojson"));
                }
                model.addAttribute("geo", (Object)JSON.toJSONString((Object)JSON.toJSONString(geoMap)));
                return "analysis/result-multi-link";
            }
            switch (1.$SwitchMap$cn$gtmap$onemap$platform$utils$EnumUtils$MULTI_ANALYZE_LEVEL[EnumUtils.MULTI_ANALYZE_LEVEL.valueOf((String)level).ordinal()]) {
                case 1: {
                    if (mapData.isEmpty()) break;
                    model.addAttribute("xlsData", (Object)JSON.toJSONString(mapData));
                    break;
                }
                case 2: {
                    if (!mapData.isEmpty()) {
                        model.addAttribute("xlsData", (Object)JSON.toJSONString(mapData));
                    }
                    if (!summaryData.isEmpty()) {
                        HashMap<String, Serializable> tmp = new HashMap<String, Serializable>();
                        tmp.put("result", summaryData);
                        tmp.put("ogArea", Double.valueOf(ogArea));
                        model.addAttribute("summaryData", (Object)JSON.toJSONString(tmp));
                    }
                    model.addAttribute("ogArea", (Object)this.gisManager.getGeoService().getGeoArea(this.gisManager.getGeoService().readUnTypeGeoJSON(geometry), null));
                    model.addAttribute("tpl", (Object)tpl);
                }
            }
            return "analysis/result-multi-".concat(level);
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/analysis/result/common"}, method={RequestMethod.POST})
    public String groupedAnalysisResult(@RequestParam(value="data") String data, @RequestParam(value="general", required=false) String general, Model model) {
        if (StringUtils.isNotBlank((String)data)) {
            if (StringUtils.isNotBlank((String)general)) {
                model.addAttribute("general", JSON.parseObject((String)general, Map.class));
            }
            List result = (List)JSON.parseObject((String)data, List.class);
            model.addAttribute("info", (Object)result);
            model.addAttribute("excelData", (Object)JSON.toJSONString((Object)this.gisManager.getGISService().analysisExcelData(result)));
            model.addAttribute("excelList", (Object)JSON.toJSONString((Object)this.gisManager.getGISService().analysisExcelList(result)));
        }
        return "analysis/result-grouped";
    }

    @RequestMapping(value={"/analysis/result/gzqyd"}, method={RequestMethod.POST})
    public String commonAnalysisResult(@RequestParam(value="data") String data, Model model) {
        if (StringUtils.isNotBlank((String)data)) {
            List result = (List)JSON.parseObject((String)data, List.class);
            model.addAttribute("result", (Object)result);
            model.addAttribute("excelData", (Object)JSON.toJSONString((Object)this.gisManager.getGISService().gzqydExcelData(result)));
        }
        return "analysis/result-gzqyd";
    }

    @RequestMapping(value={"/analysis/result/ghscxg"}, method={RequestMethod.POST, RequestMethod.GET})
    public String ghModifyAnalysisResult(@RequestParam(value="data") String data, @RequestParam(value="showFields", defaultValue="*") String showFields, Model model) {
        try {
            this.logger.debug("[ghscxg analysis data]:" + data);
            List results = (List)JSON.parseObject((String)data, List.class);
            Map map = this.gisManager.getGISService().ghscxgData(results, (List)JSON.parseObject((String)showFields, List.class));
            model.addAttribute("showFields", JSON.parseObject((String)showFields, List.class));
            model.addAttribute("results", map.get("result"));
            model.addAttribute("excelData", (Object)JSON.toJSONString(map.get("excel")));
            return "analysis/result-ghscxg";
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/analysis/dict/fetch"})
    @ResponseBody
    public List getAnalysisDict(@RequestParam(value="tpl", required=true) String tpl, @RequestParam(value="groupName", required=true) String groupName) {
        return this.dictService.getAnalysisDict(tpl, groupName);
    }

    @RequestMapping(value={"/export/excel"})
    public void export2Excel(@RequestParam(value="data") String data, @RequestParam(value="fileName", required=false) String fileName, HttpServletResponse response) {
        try {
            Document document = null;
            if (this.isNull((Object)fileName)) {
                document = this.documentService.writeExcel((List)JSON.parseObject((String)data, List.class));
                this.sendFile((InputStream)new ByteArrayInputStream(document.getContent()), response, document.getFileName());
            } else {
                document = this.documentService.writeExcel((Map)JSON.parseObject((String)data, Map.class), fileName);
                this.sendFile((InputStream)new ByteArrayInputStream(document.getContent()), response, document.getFileName());
            }
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("doc.excel.export.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/export/analysis"})
    public void exportDocument(@RequestParam(value="data") String data, @RequestParam(value="fileName", required=true) String fileName, @RequestParam(value="fileType", defaultValue="xls") String fileType, HttpServletResponse response) {
        try {
            this.sendDocument(response, this.documentService.renderAnalysisExcel(JSON.parseObject((String)data, Map.class), fileName, Document.Type.valueOf((String)fileType)));
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("doc.excel.export.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/export/shp"})
    public void exportShp(@RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="sr", required=false) String sr, HttpServletResponse response) {
        try {
            File shpFile = !this.isNull((Object)sr) ? this.gisManager.getGeoService().exportToShp(geometry, this.gisManager.getGeoService().parseUndefineSR(sr)) : this.gisManager.getGeoService().exportToShp(geometry);
            if (!shpFile.exists()) {
                throw new RuntimeException(this.getMessage("shp.export.error", new Object[]{"file not found"}));
            }
            this.sendStream((InputStream)new FileInputStream(shpFile), response, shpFile.getName());
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/rest/export/dwg"})
    @ResponseBody
    public Map exportDwg(@RequestParam(value="shpUrl", required=true) String shpUrl, @RequestParam(value="gpUrl", required=true) String gpUrl) {
        try {
            return this.result((Object)this.gisManager.getGeoService().convertShpToDwg(shpUrl, gpUrl));
        }
        catch (Exception e) {
            throw new RuntimeException(this.getMessage("dwg.export.error", new Object[]{e.getMessage()}));
        }
    }

    @RequestMapping(value={"/rest/export/shp"})
    @ResponseBody
    public String exportShpRest(@RequestParam(value="geometry", required=true) String geometry, @RequestParam(value="sr", required=false) String sr) {
        try {
            File shpFile = !this.isNull((Object)sr) ? this.gisManager.getGeoService().exportToShp(geometry, this.gisManager.getGeoService().parseUndefineSR(sr)) : this.gisManager.getGeoService().exportToShp(geometry);
            if (shpFile.exists()) {
                FileStore fileStore = this.fileStoreService.save3(shpFile, UUIDHexGenerator.generate());
                return fileStore.getId();
            }
            throw new RuntimeException(this.getMessage("shp.export.error", new Object[]{"file not found"}));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/export/excel/gzqyd"})
    public void export2ExcelGZQ(@RequestParam(value="data") String data, @RequestParam(value="fileName", required=true) String fileName, HttpServletResponse response) {
        try {
            Document document = null;
            document = this.documentService.writeExcelGZQFX((List)JSON.parseObject((String)data, List.class), fileName);
            this.sendFile((InputStream)new ByteArrayInputStream(document.getContent()), response, document.getFileName());
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("doc.excel.export.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/excel/upload"})
    @ResponseBody
    public void xlsUpload(@RequestParam(value="file") MultipartFile file, HttpServletResponse response) {
        try {
            this.result((Object)this.gisManager.getGeoService().getExcelCoordinates(file.getInputStream()), response);
        }
        catch (Exception e) {
            this.error(this.getMessage("excel.upload.error", new Object[]{file.getOriginalFilename(), e.getLocalizedMessage()}), response);
        }
    }

    @RequestMapping(value={"/zip/upload"})
    @ResponseBody
    public void zipUpload(@RequestParam(value="file") MultipartFile file, HttpServletResponse response) {
        try {
            this.result(this.gisManager.getGeoService().getZipCoordinates(file.getInputStream()), response);
        }
        catch (Exception e) {
            this.error(this.getMessage("zip.coord.get.error", new Object[]{e.getLocalizedMessage()}), response);
        }
    }

    @RequestMapping(value={"/bj/upload"})
    @ResponseBody
    public void bjUpload(@RequestParam(value="file") MultipartFile file, HttpServletResponse response) {
        try {
            this.result((Object)this.gisManager.getGeoService().getBJCoordinates(file.getInputStream()), response);
        }
        catch (Exception e) {
            this.error(this.getMessage("bj.upload.error", new Object[]{file.getOriginalFilename(), e.getLocalizedMessage()}), response);
        }
    }

    @RequestMapping(value={"/shp/upload"})
    @ResponseBody
    public void shpUpload(@RequestParam(value="file", required=false) MultipartFile file, HttpServletResponse response) {
        try {
            this.result((Object)this.gisManager.getGeoService().getShpCoordinates(file.getInputStream()), response);
        }
        catch (Exception e) {
            this.error(this.getMessage("shp.upload.error", new Object[]{file.getOriginalFilename(), e.getLocalizedMessage()}), response);
        }
    }

    @RequestMapping(value={"/shp/file/upload"})
    @ResponseBody
    public Map shpZipUpload(@RequestParam(value="file", required=true) String filePath, @RequestParam(value="properties", required=false) String properties, @RequestParam(value="layerName") String layerName, @RequestParam(value="check", required=false, defaultValue="true") Boolean check, @RequestParam(value="dataSource", defaultValue="") String dataSource) {
        try {
            File zipFile = new File(filePath);
            if (zipFile.exists()) {
                String geometry = this.gisManager.getGeoService().getShpCoordinates(zipFile, properties);
                return this.result((Object)this.gisManager.getGISService().insert2(layerName, geometry, check.booleanValue(), dataSource));
            }
            throw new JSONMessageException(this.getMessage("shp.zipfile.exist.error", new Object[]{filePath}));
        }
        catch (Exception e) {
            this.logger.error(e.getLocalizedMessage());
            throw new JSONMessageException(this.getMessage("shp.upload.error", new Object[]{filePath, e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/geo/area"})
    @ResponseBody
    public double geoArea(@RequestParam(value="geometry") String geometry, @RequestParam(value="crs", required=false, defaultValue="4610") String crs) {
        try {
            return this.geometryService.getGeoArea(this.geometryService.readUnTypeGeoJSON(geometry), this.geometryService.parseUndefineSR(crs));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/json/format"})
    @ResponseBody
    public String formatJSON(@RequestParam(value="json") String json, @RequestParam(value="pretty", defaultValue="true") boolean pretty) {
        try {
            return JSON.toJSONString((Object)JSON.parseObject((String)json), (boolean)pretty);
        }
        catch (Exception e) {
            throw new JSONMessageException(this.getMessage("json.format.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/crs/wkt"})
    @ResponseBody
    public Map crsToWkt(@RequestParam(value="sr", required=true) String sr) {
        try {
            CoordinateReferenceSystem in = this.gisManager.getGeoService().parseUndefineSR(sr);
            return this.result((Object)in.toWKT());
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @Deprecated
    @RequestMapping(value={"/jsoneditor"})
    public String jsonEditor() {
        return "jsoneditor";
    }

    @Deprecated
    @RequestMapping(value={"/rest/export/map"})
    @ResponseBody
    public void exportMap(@RequestParam(value="where", required=true) String where, @RequestParam(value="scale", required=false) String scale, @RequestParam(value="width", defaultValue="800") int width, @RequestParam(value="height", defaultValue="600") int height, @RequestParam(value="type", required=true) String type, HttpServletResponse response) {
        try {
            InputStream inputStream = this.gisManager.getGISService().exportMap(where, scale, width, height, type);
            this.sendFile(inputStream, response, String.valueOf(System.currentTimeMillis()));
        }
        catch (IOException e) {
            throw new JSONMessageException(this.getMessage("map.export.error", new Object[]{e.getLocalizedMessage()}));
        }
    }

    @RequestMapping(value={"/bmark"})
    public String boundaryMark(@RequestParam(value="id", required=false) String id, @RequestParam(value="type", required=false) String type, @RequestParam(value="btype", defaultValue="bmi") String btype, Model model) {
        model.addAttribute("id", (Object)id);
        model.addAttribute("btype", (Object)btype);
        model.addAttribute("type", (Object)type);
        return "geo/bmark";
    }

    @RequestMapping(value={"/bmark/coords"})
    @ResponseBody
    public List bMarkUpload(@RequestParam(value="fileData", required=true) MultipartFile file, @RequestParam(value="fileType", defaultValue="xls") String fileType) {
        try {
            return this.bMarkService.getCoordsByFile(file.getInputStream(), BMarkService.Type.getType((String)fileType));
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/bmark/gen"}, method={RequestMethod.POST})
    @ResponseBody
    public boolean generateShape(@RequestParam(value="id", required=false) String id, @RequestParam(value="coords", required=false) String coords, @RequestParam(value="type", required=false) String type) {
        try {
            return this.bMarkService.insert(id, (List)JSON.parseObject((String)coords, List.class), type);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }

    @RequestMapping(value={"/bmark/dks"})
    @ResponseBody
    public List getBMarkDKById(@RequestParam(value="key", required=false) String key, @RequestParam(value="type", required=true) String type) {
        try {
            return this.bMarkService.query(key, type);
        }
        catch (Exception e) {
            throw new JSONMessageException(e.getLocalizedMessage());
        }
    }
}

